/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import oracle.opatch.IOPatchSession;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.cas.CASBranchServices;
import oracle.opatch.opatchlogger.OLogger;

public class AttachSession
implements IOPatchSession {
    private boolean hasOUI = false;

    public boolean isOUIBased() {
        return this.hasOUI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String oracleHome) {
        if (OPatchEnv.isHelp()) {
            if (this.helpPresent()) {
                this.displayHelp();
            }
            return;
        }
        OLogger.println(MessageFormat.format("AttachSession process on cas_repo \"{0}\"... ", oracleHome));
        try {
            OPatchOverCAS.INSTANCE.initializeCAS(oracleHome);
            CASBranchServices cas = new CASBranchServices();
            cas.attachMain();
            OLogger.println(MessageFormat.format("Attached CAS data store for oracle home \"{0}\". ", oracleHome));
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            OPatchOverCAS.INSTANCE.cleanupCAS();
            throw throwable;
        }
    }

    public boolean helpPresent() {
        return true;
    }

    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        String helpFile = "";
        helpFile = "attach_help.txt";
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.log(OLogger.INFO, helpM.toString());
            br.close();
            is.close();
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFile});
            OLogger.println(msg);
        }
    }
}

