/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.helper.helper10205;

import java.io.File;
import java.util.ArrayList;
import oracle.ops.mgmt.security.NullSecurityManager;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.helper.CVUHelperConstants;
import oracle.ops.verification.helper.helper10205.CommandLineOption;

public abstract class CVUHelper
implements CVUHelperConstants {
    private static String CV = "cv";
    private static String LOG = "log";
    private static String[] m_args;
    private static String TRACE_CVUHELPER_FNAME;
    private ArrayList m_cmdLineOptList = null;

    public CVUHelper() {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager((SecurityManager)new NullSecurityManager());
            Trace.out((String)"Security manager is set");
        }
        this.m_cmdLineOptList = new ArrayList();
    }

    public void addCommandLineOption(String key, int numberOfArgs, String methodName, String usageInfo) {
        CommandLineOption cmdOpt = new CommandLineOption(key, numberOfArgs, methodName, usageInfo);
        this.m_cmdLineOptList.add(cmdOpt);
    }

    private void displayUsage() {
        this.displayUsageOption(null);
    }

    private void displayUsageOption(String message) {
        String invalidCommand = "Invalid commandline argument: " + message;
        String usageString = "USAGE:" + VerificationConstants.LSEP;
        for (int i = 0; i < this.m_cmdLineOptList.size(); ++i) {
            CommandLineOption cmdOpt = (CommandLineOption)this.m_cmdLineOptList.get(i);
            String curOpt = cmdOpt.getKey();
            String usageInfo = cmdOpt.getUsageInfo();
            usageString = usageString + "    " + curOpt + "  : " + usageInfo + VerificationConstants.LSEP;
        }
        if (message != null && message.trim().length() > 0) {
            usageString = invalidCommand + VerificationConstants.LSEP + usageString;
        }
        this.displayExecutionError(usageString);
    }

    private void displayUsage(String curOpt) {
        String usageInfo = null;
        String usageString = "Incorrect arguments to option " + curOpt + VerificationConstants.LSEP + "USAGE:" + VerificationConstants.LSEP;
        for (int i = 0; i < this.m_cmdLineOptList.size(); ++i) {
            CommandLineOption cmdOpt = (CommandLineOption)this.m_cmdLineOptList.get(i);
            if (!curOpt.equalsIgnoreCase(cmdOpt.getKey())) continue;
            usageInfo = cmdOpt.getUsageInfo();
            break;
        }
        if (usageInfo == null) {
            this.displayExecutionError("Incorrect commandline option : " + curOpt);
            return;
        }
        usageString = usageString + "    " + curOpt + "  : " + usageInfo;
        this.displayErrorResult(usageString);
    }

    public String parseArguments(String[] args) {
        boolean argsOK = false;
        boolean found = false;
        String methodName = null;
        int numberOfArgs = -1;
        String curOpt = null;
        if (args.length < 1) {
            this.displayUsage();
            return null;
        }
        Trace.out((String)"more than one arg found");
        for (int i = 0; i < this.m_cmdLineOptList.size(); ++i) {
            CommandLineOption cmdOpt = (CommandLineOption)this.m_cmdLineOptList.get(i);
            curOpt = cmdOpt.getKey();
            if (!curOpt.equalsIgnoreCase(args[0])) continue;
            found = true;
            methodName = cmdOpt.getMethodName();
            numberOfArgs = cmdOpt.getNumberOfArgs();
            String usageInfo = cmdOpt.getUsageInfo();
            break;
        }
        if (found) {
            if (numberOfArgs != 1 && args.length != numberOfArgs) {
                Trace.out((String)"incorrect number of arguments");
                this.displayUsage(args[0]);
                this.displayVRESStatus(2);
                this.displayExecutionErrorStatus();
                return null;
            }
        } else {
            Trace.out((String)"option not supported");
            this.displayUsageOption(args[0]);
            return null;
        }
        return methodName;
    }

    public void displaySuccessResult(String rslt) {
        System.out.println("<CVH_OUT>");
        System.out.println(rslt);
        System.out.println("</CVH_OUT>");
    }

    public void displaySuccessResult(String rslt, int status) {
        this.displaySuccessResult(rslt);
        this.displayVRESStatus(status);
    }

    public void displayWarningResult(String warning) {
        System.out.println("<CVH_WMSG>");
        System.out.println(warning);
        System.out.println("</CVH_WMSG>");
    }

    public void displayWarningResult(String warning, int status) {
        this.displayWarningResult(warning);
        this.displayVRESStatus(status);
    }

    public void displayErrorResult(String errMsg) {
        System.out.println("<CVH_EMSG>");
        System.out.println(errMsg);
        System.out.println("</CVH_EMSG>");
    }

    public void displayErrorResult(String errMsg, int status) {
        this.displayErrorResult(errMsg);
        this.displayVRESStatus(status);
    }

    public void displayVRESStatus(int status) {
        System.out.println("<CVH_VRES>" + status + "</CVH_VRES>");
    }

    public void displayExecutionError(String errMsg) {
        System.out.println("<CVH_EMSG>");
        System.out.println(errMsg);
        System.out.println("</CVH_EMSG>");
        System.out.println("<CVH_ERES>2</CVH_ERES>");
    }

    public void displayExecutionErrorStatus() {
        System.out.println("<CVH_ERES>2</CVH_ERES>");
    }

    public void displayExecutionSuccess() {
        System.out.println("<CVH_ERES>0</CVH_ERES>");
    }

    public static void setupTracing() {
        int tracingLvl;
        boolean bAppend;
        String traceFileName;
        String traceProp = System.getProperty("TRACING.ENABLED");
        String traceLvl = System.getProperty("TRACING.LEVEL");
        boolean tracetostdout = false;
        boolean saveTraceState = false;
        if (traceProp != null && traceProp.equalsIgnoreCase("false")) {
            Trace.setSavePreviousLog((boolean)false);
            return;
        }
        System.setProperty("TRACING.ENABLED", "true");
        if (!tracetostdout) {
            saveTraceState = Trace.isTraceEnabled();
            Trace.traceEnabled((boolean)false);
        }
        if ((traceFileName = CVUHelper.getTraceFile()) == null) {
            Trace.traceEnabled((boolean)false);
            return;
        }
        boolean bSavePreviousLog = CVUHelper.isCVUTestEnv();
        boolean bl = bAppend = !bSavePreviousLog;
        if (!tracetostdout) {
            Trace.traceEnabled((boolean)saveTraceState);
            if (saveTraceState) {
                Trace.enableDebugTracing();
            }
        }
        Trace.setSavePreviousLog((boolean)bSavePreviousLog);
        if (traceLvl != null) {
            try {
                tracingLvl = Integer.parseInt(traceLvl);
            }
            catch (NumberFormatException e) {
                tracingLvl = 2;
            }
        } else {
            tracingLvl = 2;
        }
        Trace.setMaxLogOutputSize((int)100);
        Trace.setMaxLogOutputFiles((int)4);
        boolean conRes = Trace.configure((boolean)false, (boolean)tracetostdout, (boolean)true, (boolean)true, (String)traceFileName, (boolean)true);
        Trace.out((String)("Trace.configure returns " + conRes));
        Trace.setTraceLevel((int)tracingLvl);
        Trace.out((String)("tracing is on at level " + tracingLvl + " to file " + traceFileName));
    }

    private static String getTraceFile() {
        File logDir;
        String logDirStr = System.getProperty("CV_HOME") + VerificationConstants.FSEP + CV + VerificationConstants.FSEP + LOG;
        String prop = System.getProperty("CV_TRACELOC");
        if (prop != null && prop.trim().length() > 0) {
            logDirStr = prop;
        }
        if (!(logDir = new File(logDirStr)).exists() && !logDir.mkdirs()) {
            return null;
        }
        if (!logDir.canWrite()) {
            return null;
        }
        return logDirStr + VerificationConstants.FSEP + TRACE_CVUHELPER_FNAME;
    }

    public static boolean isCVUTestEnv() {
        String sysprop = System.getProperty("CVU_TEST_ENV");
        return Boolean.valueOf(sysprop);
    }

    static {
        TRACE_CVUHELPER_FNAME = "cvuhelper.log";
    }
}

