/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.driver;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.OracleHomeType;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.base.driver.common.SetupMode;
import oracle.install.commons.base.util.cli.CommandLineArgumentHandler;
import oracle.install.commons.bean.BeanStoreUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.Version;
import oracle.install.commons.util.exception.ExceptionHandler;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.config.client.CMANHelper;
import oracle.install.config.client.SchedulerAgentHelper;
import oracle.install.config.common.MTSHelper;
import oracle.install.config.common.NETCAHelperV2;
import oracle.install.driver.oui.ConfigHelper;
import oracle.install.driver.oui.ConfigJob;
import oracle.install.driver.oui.Configurable;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.driver.oui.OUIInstallDriver;
import oracle.install.driver.oui.PrepareConfigJobEx;
import oracle.install.driver.oui.RootScriptJob;
import oracle.install.driver.oui.SessionDetails;
import oracle.install.driver.oui.SetupJob;
import oracle.install.driver.oui.config.ConfigAssistantParams;
import oracle.install.driver.oui.config.ConfigClient;
import oracle.install.ivw.client.bean.ClientInstallSettings;
import oracle.install.ivw.client.bean.ClientSetupBean;
import oracle.install.ivw.client.driver.ClientConfigToolsDriver;
import oracle.install.ivw.client.resource.ClientDialogLabelResID;
import oracle.install.ivw.common.bean.AutoUpdatesInstallSettings;
import oracle.install.ivw.common.bean.CentralInventorySettings;
import oracle.install.ivw.common.bean.OracleSetupBean;
import oracle.install.ivw.common.bean.WindowsSecureOptionSettings;
import oracle.install.ivw.common.resource.AutoUpdatesManagerException;
import oracle.install.ivw.common.resource.PatchDownloadType;
import oracle.install.ivw.common.util.autoupdates.ApplyUpdatesJob;
import oracle.install.ivw.common.util.autoupdates.AutoUpdatesExceptionHandler;
import oracle.install.ivw.common.util.autoupdates.PostApplyUpdatesJob;
import oracle.install.ivw.common.util.autoupdates.PreApplyUpdatesJob;
import oracle.install.ivw.common.util.autoupdates.UpdateManager;
import oracle.install.ivw.common.util.autoupdates.UpdatesHelper;
import oracle.install.library.crs.WinCRSInfo;
import oracle.install.library.util.FileInfo;
import oracle.install.library.util.InstallConstants;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InstallHelper;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.OFAWrapper;
import oracle.install.library.util.PlatformInfo;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;

public class ClientSetupDriver
extends OUIInstallDriver<ClientSetupBean> {
    private static final String OUI_VAR_MAPPING_FILE = "/oracle/install/ivw/client/resource/clientoui_map.properties";
    private static Logger logger = Logger.getLogger(ClientSetupDriver.class.getName());
    private static final String ORACLE_RDBMS_SCHEDULER = "oracle.rdbms.scheduler";
    ClientInstallSettings installSettings;

    public ClientSetupDriver() {
        this.setupBean = new ClientSetupBean();
    }

    public ClientSetupBean getSetupBean() {
        return (ClientSetupBean)((Object)this.setupBean);
    }

    public void load() throws SetupDriverException {
        super.load();
        ExceptionManager.getInstance().addExceptionHandler(AutoUpdatesManagerException.class, (ExceptionHandler)new AutoUpdatesExceptionHandler());
        boolean invFound = false;
        InventoryInfo invInfo = InventoryInfo.getInstance();
        invFound = invInfo.isInventoryExist();
        this.installSettings = ((ClientSetupBean)((Object)this.setupBean)).getClientInstallSettings();
        CentralInventorySettings cenInv = ((ClientSetupBean)((Object)this.setupBean)).getCentralInventory();
        logger.log(Level.INFO, "Inventory exists: " + invFound);
        if (invFound) {
            cenInv.setGroupOwnership(invInfo.getUnixGroupName());
        }
        this.installSettings.setProductDescriptorLocation(System.getProperty("oracle.installer.sourceLoc"));
        String hostName = null;
        String oracleHostname = InstallHelper.getValueAlt((String)"ORACLE_HOSTNAME");
        hostName = oracleHostname != null ? oracleHostname : MachineInfo.getInstance().getFullHostName();
        ((ClientSetupBean)((Object)this.setupBean)).setOracleHostName(hostName);
        try {
            String absPath = new File(System.getProperty("oracle.installer.sourceLoc")).getAbsolutePath();
            String parentDir = new File(absPath).getParent();
            String string = System.getProperty("oracle.installer.scratchPath");
        }
        catch (Exception e) {
            throw new SetupDriverException((Throwable)e);
        }
    }

    protected CompositeJob prepareJob() throws SetupDriverException {
        CompositeJob installJob;
        block12: {
            String[] components;
            ClientSetupJob clientSetupJob;
            block14: {
                block13: {
                    CommandLineArgumentHandler cmdLineArgumentHandler = CommandLineArgumentHandler.getInstance();
                    if (cmdLineArgumentHandler != null && cmdLineArgumentHandler.isArgumentPassed("executeConfigTools")) {
                        ClientConfigToolsDriver clientConfigToolsDriver = new ClientConfigToolsDriver((ClientSetupBean)((Object)this.setupBean));
                        return clientConfigToolsDriver.prepareJob();
                    }
                    installJob = new CompositeJob();
                    clientSetupJob = null;
                    PlatformInfo platInfo = PlatformInfo.getInstance();
                    boolean multinodeSetup = false;
                    AutoUpdatesInstallSettings autoUpdatesSettings = ((ClientSetupBean)((Object)this.setupBean)).getAutoUpdatesInstallSettings();
                    boolean applyAutoUpdates = autoUpdatesSettings.isApplyUpdates();
                    logger.log(Level.INFO, "Is multi node install {0}", multinodeSetup);
                    clientSetupJob = new ClientSetupJob(multinodeSetup);
                    installJob.add((Job)clientSetupJob);
                    boolean supressConfig = this.installSettings.getInternalInstallType() == ClientInstallSettings.InstallType.InstantClient.name() || this.isConfigDisabled();
                    String topAggrId = null;
                    String[] topLevelComponent = (String[])clientSetupJob.getSessionDetails().getVariableMap().get("TOPLEVEL_COMPONENT");
                    if (topLevelComponent != null) {
                        topAggrId = topLevelComponent[0];
                    }
                    ClientPrepareConfigJob prepareConfigJob = new ClientPrepareConfigJob("Prepare Client Config", 0.2f, ((ClientSetupBean)((Object)this.setupBean)).getClientInstallSettings().getOracleHome(), topAggrId);
                    installJob.add((Job)prepareConfigJob);
                    logger.log(Level.INFO, "In ClientSetupDriver: Applyautoupdates: " + applyAutoUpdates + " SetupMode: " + this.getSetupMode() + " downloadtype: " + autoUpdatesSettings.getDownloadType());
                    if (this.installSettings.getInternalInstallType() != ClientInstallSettings.InstallType.InstantClient.name() && applyAutoUpdates || this.getSetupMode() == SetupMode.SILENT && autoUpdatesSettings.getDownloadType() != PatchDownloadType.SKIP_UPDATES) {
                        PostApplyUpdatesJob postApplyUpdatesJob;
                        ArrayList cpuUpdatesList;
                        UpdateManager updateManager = UpdateManager.getInstance();
                        ArrayList allOneOffPatchesList = new ArrayList();
                        ArrayList oneOffsList = updateManager.getOneOffList();
                        if (oneOffsList != null && oneOffsList.size() > 0) {
                            allOneOffPatchesList.addAll(oneOffsList);
                        }
                        if ((cpuUpdatesList = updateManager.getAllCPU()) != null && cpuUpdatesList.size() > 0) {
                            allOneOffPatchesList.addAll(cpuUpdatesList);
                        }
                        String downloadLocation = ((ClientSetupBean)((Object)this.setupBean)).getAutoUpdatesInstallSettings().getPatchDownloadLocation();
                        PreApplyUpdatesJob preApplyUpdatesJob = UpdatesHelper.getInstance().addPreApplyUpdatesJob(downloadLocation, clientSetupJob.getSessionDetails().getVariableMap(), (String[])null);
                        if (preApplyUpdatesJob != null) {
                            installJob.add((Job)preApplyUpdatesJob);
                        }
                        if (allOneOffPatchesList != null && allOneOffPatchesList.size() > 0 || updateManager.getOPatchUpdate() != null && updateManager.getOPatchUpdate().getPatchBugNumber() != -1) {
                            ApplyUpdatesJob applyUpdatesJob = new ApplyUpdatesJob(allOneOffPatchesList, clientSetupJob.getSessionDetails().getVariableMap());
                            applyUpdatesJob.setRetryEnabled(true);
                            if (autoUpdatesSettings.getPatchDownloadLocation() != null && autoUpdatesSettings.getPatchDownloadLocation().length() > 0) {
                                applyUpdatesJob.setDownloadLoc(autoUpdatesSettings.getPatchDownloadLocation());
                            }
                            installJob.add((Job)applyUpdatesJob);
                        }
                        if ((postApplyUpdatesJob = UpdatesHelper.getInstance().addPostApplyUpdatesJob(downloadLocation, clientSetupJob.getSessionDetails().getVariableMap(), (String[])null)) != null) {
                            installJob.add((Job)postApplyUpdatesJob);
                        }
                    }
                    if (!supressConfig) {
                        installJob.add((Job)new ClientConfigJob(((ClientSetupBean)((Object)this.setupBean)).getClientInstallSettings().getOracleHome(), topAggrId));
                    }
                    if (platInfo.isWindows()) break block12;
                    Application.getInstance();
                    if (Application.isCommandLineSwitchEnabled((String)"-suppressRootMessage")) break block12;
                    if (!OiiiInstallAreaControl.isCleanMachine()) break block13;
                    installJob.add((Job)new RootScriptJob((SetupJob)clientSetupJob));
                    break block12;
                }
                if (!this.installSettings.isUpgrading()) break block14;
                Version version = InventoryInfo.getInstance().getCompVersion(ORACLE_RDBMS_SCHEDULER, this.installSettings.getOracleHome());
                if (version == null || version.compareTo(InstallConstants.VERSION) > 0) break block12;
                installJob.add((Job)new RootScriptJob((SetupJob)clientSetupJob));
                break block12;
            }
            if (this.installSettings.getInstallType() == ClientInstallSettings.InstallType.Custom && (components = this.installSettings.getCustomComponents()) != null) {
                for (String component : components) {
                    if (!component.startsWith(ORACLE_RDBMS_SCHEDULER) && !component.startsWith("oracle.network.listener") && !component.startsWith("oracle.network.cman")) continue;
                    installJob.add((Job)new RootScriptJob((SetupJob)clientSetupJob));
                    break;
                }
            }
        }
        return installJob;
    }

    private SessionDetails getClientDetails(boolean multinodeSetup) throws SetupDriverException {
        SessionDetails sessionDetails = null;
        try {
            HashMap<String, Object> source = new HashMap<String, Object>();
            BeanStoreUtils.storeAsStringMap(source, (Object[])new Object[]{((ClientSetupBean)((Object)this.setupBean)).getClientInstallSettings(), ((ClientSetupBean)((Object)this.setupBean)).getCentralInventory(), ((ClientSetupBean)((Object)this.setupBean)).getAutoUpdatesInstallSettings(), ((ClientSetupBean)((Object)this.setupBean)).getWindowsSecureOptionSettings()});
            this.populateBridgeMap(source);
            HashMap submitClientMap = DriverHelper.transform(source, (String)OUI_VAR_MAPPING_FILE);
            ConfigHelper.populateConfigMap((Map)submitClientMap);
            String version = InstallConstants.VERSION.toString();
            submitClientMap.put("TOPLEVEL_COMPONENT", new String[]{"oracle.client", version});
            submitClientMap.put("COMPONENT_LANGUAGES", ((ClientSetupBean)((Object)this.setupBean)).getLanguages());
            submitClientMap.put("SELECTED_LANGUAGES", ((ClientSetupBean)((Object)this.setupBean)).getLanguages());
            if (InventoryInfo.getInstance().isInventoryExist()) {
                logger.info("Removing Inventory location and unix group name oui property from the submitHashmap as inventory is already available on the system");
                submitClientMap.remove("INVENTORY_LOCATION");
                submitClientMap.remove("UNIX_GROUP_NAME");
            }
            submitClientMap.put("oracle_install_ClientHomeType", oracle.install.ivw.common.bean.OracleHomeType.Client.toString());
            submitClientMap.put("oracle_install_HomeType", oracle.install.ivw.common.bean.OracleHomeType.Database.toString());
            if (PlatformInfo.getInstance().isWindows()) {
                String[] customComponentsList;
                String oracle_base = ((ClientSetupBean)((Object)this.setupBean)).getClientInstallSettings().getOracleBase();
                submitClientMap.put("oracle_install_isExistingBase", OFAWrapper.getInstance().isExistingBase(oracle_base));
                WindowsSecureOptionSettings winSecurityBean = ((ClientSetupBean)((Object)this.setupBean)).getWindowsSecureOptionSettings();
                submitClientMap.put("oracle_install_ClientHomeType", OracleHomeType.Client.toString());
                if (winSecurityBean.isDeclineOption()) {
                    logger.log(Level.INFO, "ClientSetupDriver: decline option is selected");
                    submitClientMap.put("oracle_install_OracleHomeUserName", Credentials.BuiltinUser.LOCALSERVICE.toString());
                    submitClientMap.put("oracle_install_IsOracleServiceUserExists", true);
                }
                ClientInstallSettings clientInstallSettings = ((ClientSetupBean)((Object)this.setupBean)).getClientInstallSettings();
                ClientInstallSettings.InstallType installType = clientInstallSettings.getInstallType();
                boolean launchScAgent = false;
                if (installType == ClientInstallSettings.InstallType.Custom && ClientSetupDriver.isComponentSelected(customComponentsList = clientInstallSettings.getCustomComponents(), ORACLE_RDBMS_SCHEDULER) && !WinCRSInfo.regKeyExistsOnLocalNode((String)"HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\OracleSchedulerExecutionAgent")) {
                    launchScAgent = true;
                }
                submitClientMap.put("oracle_install_LaunchSchedulerAgent", launchScAgent);
            } else {
                submitClientMap.put("oracle_install_LaunchSchedulerAgent", false);
            }
            if (PlatformInfo.getInstance().isWindows()) {
                System.setProperty("oracle.installer.skipACLSetting", "true");
                logger.log(Level.INFO, "oracle.installer.skipACLSetting= " + System.getProperty("oracle.installer.skipACLSetting"));
            }
            String globalPropLocation = System.getProperty("oracle.installer.startup_location");
            logger.log(Level.INFO, "globalPropLocation CURRENT= " + globalPropLocation);
            globalPropLocation = globalPropLocation + "/../stage/globalvariables/globalvar.xml";
            System.setProperty("oracle.install.tb.globalvarpath", globalPropLocation);
            logger.log(Level.INFO, "globalpropLocation= " + globalPropLocation);
            logger.log(Level.INFO, "oracle.install.tb.globalvarpath= " + System.getProperty("oracle.install.tb.globalvarpath"));
            logger.log(Level.INFO, "Setting value of oracle.installer.force to true to prevent OUI to perform valilddations on the Summary page");
            System.setProperty("oracle.installer.force", "true");
            logger.log(Level.INFO, "VALUE of oracle.installer.force=" + System.getProperty("oracle.installer.force"));
            String home = ((ClientSetupBean)((Object)this.setupBean)).getClientInstallSettings().getOracleHome();
            boolean upgrade = ((ClientSetupBean)((Object)this.setupBean)).getClientInstallSettings().isUpgrading();
            boolean installOnExistingHome = InventoryInfo.getInstance().isHomeWithLocationExist(home);
            if (home != null && !upgrade && installOnExistingHome) {
                logger.log(Level.INFO, "Setting value of oracle.installer.fastcopy to false to supress fastcopy as we are installing on existing home.");
                System.setProperty("oracle.installer.fastcopy", "false");
                logger.log(Level.INFO, "VALUE of oracle.installer.fastcopy=" + System.getProperty("oracle.installer.fastcopy"));
            }
            sessionDetails = new SessionDetails("client", submitClientMap);
        }
        catch (Exception e) {
            throw new SetupDriverException((Throwable)e);
        }
        return sessionDetails;
    }

    public static boolean isComponentSelected(String[] components, String component) {
        if (null != components && components.length > 0 && null != component && component.length() > 0) {
            for (String comp : components) {
                String compName = comp.split(":")[0];
                if (!compName.equalsIgnoreCase(component)) continue;
                return true;
            }
        }
        return false;
    }

    private ConfigAssistantParams getNetcaParams(Configurable configJob) {
        String ORACLE_NETWORK_ASO = "oracle.network.aso";
        String ORACLE_NETWORK_CMAN = "oracle.network.cman";
        String ORACLE_NETWORK_LISTENER = "oracle.network.listener";
        ClientInstallSettings clientInstallSettings = ((ClientSetupBean)((Object)this.setupBean)).getClientInstallSettings();
        String insCompValue = null;
        String insTypeValue = null;
        String responseFileValue = null;
        String oracleHomeValue = clientInstallSettings.getOracleHome();
        boolean silentFlag = true;
        ClientInstallSettings.InstallType installType = clientInstallSettings.getInstallType();
        if (installType == ClientInstallSettings.InstallType.Administrator) {
            insCompValue = "client,oraclenet,ano";
        } else if (installType == ClientInstallSettings.InstallType.Custom) {
            insCompValue = "client,oraclenet";
            String[] customComponentsList = clientInstallSettings.getCustomComponents();
            if (ClientSetupDriver.isComponentSelected(customComponentsList, "oracle.network.cman") || ClientSetupDriver.isComponentSelected(customComponentsList, "oracle.network.listener")) {
                insCompValue = insCompValue + ",server";
            }
            if (ClientSetupDriver.isComponentSelected(customComponentsList, "oracle.network.aso")) {
                insCompValue = insCompValue + ",ano";
            }
        }
        ConfigAssistantParams configParams = NETCAHelperV2.constructClientConfigParams((Configurable)configJob, (String)oracleHomeValue, (WindowsSecureOptionSettings)((ClientSetupBean)((Object)this.setupBean)).getWindowsSecureOptionSettings(), (String)insCompValue, insTypeValue, responseFileValue, (boolean)silentFlag);
        return configParams;
    }

    public SessionDetails getSessionDetails(SetupJob.OUISetupMode setupMode) throws SetupDriverException {
        return this.getClientDetails(false);
    }

    public void setup() throws SetupDriverException {
        File file;
        this.installSettings = ((ClientSetupBean)((Object)this.setupBean)).getClientInstallSettings();
        if (!PlatformInfo.getInstance().isWindows() && this.installSettings.isUpgrading() && !this.installSettings.getInternalInstallType().equalsIgnoreCase(ClientInstallSettings.InstallType.InstantClient.name()) && (file = new File(this.installSettings.getOracleHome(), "jdk")).exists()) {
            try {
                int retCode = FileInfo.getInstance().changePermission(file, "0755", true);
                logger.log(Level.INFO, "Return code of changing permission of jdk directory:" + retCode);
            }
            catch (InstallException e) {
                logger.log(Level.WARNING, "Exception occured while changing the permission of jdk directory", e);
            }
        }
        super.setup();
    }

    private void populateBridgeMap(Map<String, Object> bridgeMap) {
    }

    class ClientPrepareConfigJob
    extends PrepareConfigJobEx {
        public ClientPrepareConfigJob(Object id, float weightage, String oracleHome, String aggCfgID) {
            PlatformInfo platformInfo;
            super(id, weightage, oracleHome, aggCfgID);
            if (((ClientSetupBean)((Object)ClientSetupDriver.this.setupBean)).getClientInstallSettings().getLaunchNETCA()) {
                ConfigAssistantParams netcaParams = ClientSetupDriver.this.getNetcaParams((Configurable)this);
                ConfigClient.getConfigClient().addConfigAssistantParams(netcaParams);
            }
            if (PlatformInfo.getInstance().isWindows()) {
                ConfigAssistantParams cmanParams = CMANHelper.constructConfigParams((Configurable)this, (OracleSetupBean)ClientSetupDriver.this.setupBean);
                ConfigClient.getConfigClient().addConfigAssistantParams(cmanParams);
            }
            if ((platformInfo = PlatformInfo.getInstance()).isWindows()) {
                ConfigAssistantParams mtsParams = MTSHelper.constructConfigParams((Configurable)this, (OracleSetupBean)((OracleSetupBean)ClientSetupDriver.this.setupBean));
                ConfigClient.getConfigClient().addConfigAssistantParams(mtsParams);
                ConfigAssistantParams schedulerAgentParams = SchedulerAgentHelper.constructConfigParams((Configurable)this, (OracleSetupBean)ClientSetupDriver.this.setupBean);
                ConfigClient.getConfigClient().addConfigAssistantParams(schedulerAgentParams);
            }
        }
    }

    class ClientConfigJob
    extends ConfigJob {
        public ClientConfigJob(String oracleHome, String aggCfgID) {
            PlatformInfo platformInfo;
            super((Object)"Config", 0.2f, oracleHome, aggCfgID);
            this.setDescription(Application.getInstance().getString(ResourceURL.resURL((String)ClientDialogLabelResID.class.getName(), (String)"configJob.description"), "Oracle Client Configuration", new Object[0]));
            if (((ClientSetupBean)((Object)ClientSetupDriver.this.setupBean)).getClientInstallSettings().getLaunchNETCA()) {
                ConfigAssistantParams netcaParams = ClientSetupDriver.this.getNetcaParams((Configurable)this);
                ConfigClient.getConfigClient().addConfigAssistantParams(netcaParams);
            }
            if (PlatformInfo.getInstance().isWindows()) {
                ConfigAssistantParams cmanParams = CMANHelper.constructConfigParams((Configurable)this, (OracleSetupBean)ClientSetupDriver.this.setupBean);
                ConfigClient.getConfigClient().addConfigAssistantParams(cmanParams);
            }
            if ((platformInfo = PlatformInfo.getInstance()).isWindows()) {
                ConfigAssistantParams mtsParams = MTSHelper.constructConfigParams((Configurable)this, (OracleSetupBean)((OracleSetupBean)ClientSetupDriver.this.setupBean));
                ConfigClient.getConfigClient().addConfigAssistantParams(mtsParams);
                ConfigAssistantParams schedulerAgentParams = SchedulerAgentHelper.constructConfigParams((Configurable)this, (OracleSetupBean)ClientSetupDriver.this.setupBean);
                ConfigClient.getConfigClient().addConfigAssistantParams(schedulerAgentParams);
            }
        }
    }

    class ClientSetupJob
    extends SetupJob {
        public ClientSetupJob() throws SetupDriverException {
            this(false);
        }

        public ClientSetupJob(boolean multinodeSetup) throws SetupDriverException {
            super((Object)"InstallClient", Application.getInstance().getString(ResourceURL.resURL((String)ClientDialogLabelResID.class.getName(), (String)"setup.description"), "Oracle Client Installation", new Object[0]), 0.8f, ClientSetupDriver.this.getClientDetails(multinodeSetup), multinodeSetup);
        }
    }
}

