/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.config.client;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.install.driver.oui.config.ConfigAssistantParams;
import oracle.install.driver.oui.config.ConfigClient;
import oracle.install.driver.oui.config.GenericInternalPlugIn;
import oracle.sysman.emCfg.common.IInternalPlugInContext;

public class SchedulerAgentInternalPlugIn
extends GenericInternalPlugIn {
    private static Logger logger = Logger.getLogger(SchedulerAgentInternalPlugIn.class.getName());
    public static final Map<String, String> secretParamRegexMap = new LinkedHashMap<String, String>();
    public static final String WIN_SERVICE_USER_PASSWORD_FLAG = "-winServiceUserPassword";

    public SchedulerAgentInternalPlugIn(IInternalPlugInContext context) {
        super(context);
    }

    public boolean invoke(String actionID, int stepIndex, int selfIndex, String[] args) throws Throwable {
        ConfigClient configClient = null;
        ConfigAssistantParams configAssistantParams = null;
        List arguments = null;
        if (args != null && args.length >= 2) {
            Integer retCode;
            File executable = new File(args[0].trim());
            String toolName = args[1];
            configClient = ConfigClient.getConfigClient();
            String[] argsList = this.processArgs(args);
            this.parseAggregateArgs(configClient, argsList, secretParamRegexMap);
            configAssistantParams = configClient.getConfigAssistantParams(toolName);
            arguments = configAssistantParams.getArguments();
            if (arguments != null) {
                logger.info("SchedulerAgentInternalPlugIn: ... adding </ouiinternal>");
                arguments.add("-ouiinternal");
            }
            if ((retCode = this.invoke(executable, toolName)) == null) {
                return false;
            }
            return retCode == 0;
        }
        return false;
    }

    public String[] processArgs(String[] args) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (String arg : args) {
            String[] flagAndValues = arg.split("[\\s]+[/]");
            for (int i = 0; i < flagAndValues.length; ++i) {
                int index;
                String flagValue;
                String string = flagValue = flagAndValues[i] == null ? null : flagAndValues[i].trim();
                if (flagValue == null) continue;
                if (i > 0 && flagValue.length() > 0) {
                    flagValue = "/" + flagValue;
                }
                if ((index = flagValue.indexOf(" ")) != -1) {
                    arguments.add(flagValue.substring(0, index).trim());
                    arguments.add(flagValue.substring(index).trim());
                    continue;
                }
                arguments.add(flagValue.trim());
            }
        }
        return arguments.toArray(new String[0]);
    }

    static {
        secretParamRegexMap.put(WIN_SERVICE_USER_PASSWORD_FLAG, ".*password.*");
    }
}

