/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiil.OiilAction;
import oracle.sysman.oii.oiil.OiilActionCloneCapable;
import oracle.sysman.oii.oiil.OiilActionException;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilCommitException;
import oracle.sysman.oii.oiil.OiilDeinstallException;
import oracle.sysman.oii.oiil.OiilUndoException;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class NtCreateSymLnk
implements OiilAction,
OiilActionCloneCapable {
    public String getDescription(Vector inputs) {
        return "Creates Symbolic Link Name, if successful: " + this.retItem(inputs, "LinkName");
    }

    public void cloneAction(Vector inputs, Vector outLogObjects) throws OiilActionException {
        this.installAction(inputs, outLogObjects);
    }

    public void installAction(Vector inputs, Vector outLogObjects) throws OiilActionException {
        String[] TotDisk = null;
        String[] TotPart = null;
        String Token = "|";
        int DiskNo = 0;
        int PartNo = 0;
        int Cntr = 0;
        int vdskCntr = 0;
        CrSymLnk nativeObj = new CrSymLnk();
        String LnkName = this.retItem(inputs, "LinkName");
        String DiskNumber = this.retItem(inputs, "DiskNumber");
        String PartitionNumber = this.retItem(inputs, "PartitionNumber");
        try {
            StringTokenizer DnTok = new StringTokenizer(DiskNumber, Token);
            StringTokenizer PnTok = new StringTokenizer(PartitionNumber, Token);
            if (DnTok == null) {
                String ExString = "Error retrieving Disk Number";
                throw new OiilActionException("DiskNoException", ExString);
            }
            DiskNo = DnTok.countTokens();
            if (PnTok == null) {
                String ExString = "Error retrieving partition number";
                throw new OiilActionException("PartNoException", ExString);
            }
            PartNo = PnTok.countTokens();
            if (DiskNo != 0 && PartNo != 0) {
                TotDisk = new String[DiskNo];
                TotPart = new String[PartNo];
                while (DnTok.hasMoreTokens()) {
                    TotDisk[Cntr++] = DnTok.nextToken();
                }
                Cntr = 0;
                while (PnTok.hasMoreTokens()) {
                    TotPart[Cntr++] = PnTok.nextToken();
                }
            }
            if (DiskNo != PartNo) {
                String ExString = "Disk number and partition number should be same.";
                throw new OiilActionException("DiskAndPartNoNotEqualException", ExString);
            }
            for (Cntr = 0; Cntr < DiskNo; ++Cntr) {
                vdskCntr = Cntr + 1;
                String LnkName_modified = DiskNo == 1 && !LnkName.startsWith("votedsk") ? LnkName : LnkName + vdskCntr;
                boolean returnVal = nativeObj.createLink(LnkName_modified, TotDisk[Cntr], TotPart[Cntr]);
                if (returnVal) continue;
                String ExString = "Cannot assign Link Name to this partition";
                throw new OiilActionException("LinkNameNotAssignedException", ExString);
            }
        }
        catch (OiilActionException oiilActionException) {
            // empty catch block
        }
    }

    public void deinstallAction(Vector inputs, Vector inLogObjects) throws OiilDeinstallException {
    }

    public void saveAndInstallAction(Vector inputs, Vector outLogObjects, Vector outBackupObjects) throws OiilActionException {
    }

    public void saveAndDeinstallAction(Vector inputs, Vector inLogObjects, Vector outLogObjects, Vector outBackupObjects) throws OiilDeinstallException {
    }

    public void undoInstallAction(Vector inputs, Vector inLogObjects, Vector inBackupObjects) throws OiilUndoException {
    }

    public void undoDeinstallAction(Vector inputs, Vector inLogObjects, Vector inBackupObjects, Vector outLogObjects) throws OiilUndoException {
    }

    public void commitInstallAction(Vector inputs, Vector inLogObjects, Vector inBackupObjects, Vector outLogObjects) throws OiilCommitException {
    }

    public void commitDeinstallAction(Vector inputs, Vector inLogObjects, Vector inBackupObjects) throws OiilCommitException {
    }

    private String retItem(Vector inputs, String param) {
        int pos = OiixVectorOps.vectIndexOf((Vector)inputs, (Object)param);
        if (pos == -1) {
            return null;
        }
        OiilActionInputElement aie = (OiilActionInputElement)inputs.elementAt(pos);
        return (String)aie.getObject();
    }
}

