/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.File;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.cluster.credentials.ASMProperties;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.GNSProperties;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StringUtils;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.message.Content;
import oracle.install.commons.util.message.ContentType;
import oracle.install.commons.util.message.PlainContent;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.resource.StringResourceBundle;
import oracle.install.library.util.InstallException;
import org.w3c.dom.Document;

public class WrapfileUtil {
    private static final Logger logger = Logger.getLogger(WrapfileUtil.class.getName());
    private static WrapfileUtil instance;
    private ClusterwareInfo clusterwareInfo = null;

    private WrapfileUtil() {
        if (this.clusterwareInfo == null) {
            this.clusterwareInfo = new ClusterwareInfo();
        }
    }

    public static WrapfileUtil getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (WrapfileUtil)(proxyFactory = ProxyFactory.getInstance()).createProxy(WrapfileUtil.class)) == null) {
            instance = new WrapfileUtil();
        }
        return instance;
    }

    public Wrapfile getWrapfileObj(String sWrapfile) throws InstallException {
        return new Wrapfile(sWrapfile);
    }

    public ASMWrapfile getASMWrapfileObj(String sWrapfile) throws InstallException {
        return new ASMWrapfile(sWrapfile);
    }

    public GNSWrapfile getGNSWrapfileObj(String sWrapfile) throws InstallException {
        return new GNSWrapfile(sWrapfile);
    }

    public class ASMWrapfile
    extends Wrapfile {
        ASMProperties props;

        public ASMWrapfile(String sWrapFile) throws InstallException {
            super(sWrapFile, WrapfileType.ASM);
            this.validate();
        }

        public String getASMClusterName() throws InstallException {
            try {
                return this.props.getASMClusterName();
            }
            catch (CredentialsException ce) {
                throw new InstallException((Throwable)ce, (ErrorCode)CommonErrorCode.ASMWRAPFILE_GET_ASMCLUSTERNAME_EXCEPTION, new Object[0]);
            }
        }

        public String getASMClientClusterName() throws InstallException {
            try {
                return this.props.getClientClusterNames();
            }
            catch (CredentialsException ce) {
                throw new InstallException((Throwable)ce, (ErrorCode)CommonErrorCode.ASMWRAPFILE_GET_CLIENTCLUSTERNAME_EXCEPTION, new Object[0]);
            }
        }

        @Override
        public void validate() throws InstallException {
            super.validate();
            try {
                String kfodPath = System.getProperty("oracle.install.asm.util.kfod.PATH");
                String asmCredsFile = this.getPath();
                boolean isPreGIInst = true;
                logger.info("KFOD path: " + kfodPath);
                logger.info("ASM Credentials file: " + asmCredsFile);
                this.props = WrapfileUtil.this.clusterwareInfo.getASMProperties(kfodPath, asmCredsFile, isPreGIInst);
            }
            catch (oracle.cluster.install.InstallException e) {
                InstallException ie = new InstallException((Throwable)e, (ErrorCode)CommonErrorCode.ASMWRAPFILE_GET_ASMPROPERTIES_EXCEPTION, new Object[0]);
                String message = e.getMessage();
                if (message != null && !message.isEmpty()) {
                    Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());
                    PlainContent content = new PlainContent();
                    content.setContentType(ContentType.HTML);
                    content.setTitle(resource.getString("ErrorMessage.extraDetails.message", "Additional Information:", new Object[0]));
                    content.setContent(StringUtils.textToHtml((String)message) + "<br>");
                    ie.getErrorInfo().setExtraDetails((Content)content);
                }
                throw ie;
            }
        }
    }

    public class GNSWrapfile
    extends Wrapfile {
        private GNSProperties props;

        public GNSWrapfile(String sWrapFile) throws InstallException {
            super(sWrapFile, WrapfileType.GNS);
            this.validate();
        }

        public String getGNSServerDiscoveryAddress(String clustername) throws InstallException {
            try {
                if (this.props != null) {
                    return this.props.getGNSSubDomain(clustername);
                }
            }
            catch (CredentialsException ce) {
                throw new InstallException((Throwable)ce, (ErrorCode)CommonErrorCode.GNSWRAPFILE_GET_GNSSUBDOMAIN_EXCEPTION, new Object[0]);
            }
            return null;
        }

        @Override
        public void validate() throws InstallException {
            super.validate();
            try {
                this.props = WrapfileUtil.this.clusterwareInfo.getGNSProperties(this.getPath());
            }
            catch (oracle.cluster.install.InstallException ce) {
                throw new InstallException((Throwable)ce, (ErrorCode)CommonErrorCode.GNSWRAPFILE_GET_GNSPROPERTIES_EXCEPTION, new Object[0]);
            }
        }
    }

    public class Wrapfile {
        private String path;
        private WrapfileType type;

        public Wrapfile(String filePath, WrapfileType fileType) throws InstallException {
            this.path = filePath;
            this.type = fileType;
            this.validate();
        }

        public Wrapfile(String filePath) throws InstallException {
            this(filePath, WrapfileType.DEFAULT);
        }

        public String getPath() {
            return this.path;
        }

        public WrapfileType getType() {
            return this.type;
        }

        public void validate() throws InstallException {
            if (this.path == null || this.path.trim().length() == 0) {
                throw new InstallException((ErrorCode)CommonErrorCode.INSTALL_COMMON_WRAPFILE_PATH_EMPTY, this.type.toString());
            }
            File oFile = new File(this.path.trim());
            if (!oFile.exists()) {
                throw new InstallException((ErrorCode)CommonErrorCode.INSTALL_COMMON_WRAPFILE_NOT_EXIST, this.type.toString());
            }
            if (!oFile.isFile()) {
                throw new InstallException((ErrorCode)CommonErrorCode.INSTALL_COMMON_WRAPFILE_NOT_FILE, this.type.toString());
            }
            if (!oFile.canRead()) {
                throw new InstallException((ErrorCode)CommonErrorCode.INSTALL_COMMON_WRAPFILE_NOT_READ, this.type.toString());
            }
            DocumentBuilderFactory documentfactory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder documentbuilder = documentfactory.newDocumentBuilder();
                Document document = documentbuilder.parse(oFile);
            }
            catch (Exception e) {
                throw new InstallException((ErrorCode)CommonErrorCode.INSTALL_COMMON_WRAPFILE_NOT_WELL_FORMED, this.type.toString());
            }
        }
    }

    public static enum WrapfileType {
        DEFAULT,
        ASM,
        GNS;

    }
}

