/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResultSet;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.message.Content;
import oracle.install.driver.oui.etc.UnhandledDriverException;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.cvu.CVUHelper;

public class NetworkInterfaceInfo {
    private static Logger logger = Logger.getLogger(NetworkInterfaceInfo.class.getName());

    public static boolean checkInterfaceConnectionAcrossNodes(String interfaceName, List<String> nodeList, String subnet, Severity[] severity, String[] beaninterfaceList) {
        VerificationResultSet resultSet = null;
        try {
            CVUHelper clusterVerification = CVUHelper.getInstance();
            String modifiedInterface = NetworkInterfaceInfo.getmodifiedInterface(beaninterfaceList);
            if (modifiedInterface != null && modifiedInterface.trim().length() > 0) {
                clusterVerification.setVariableValue("INTERCONNECT_LIST", modifiedInterface);
            }
            if ((resultSet = clusterVerification.checkNodeConnectivity(nodeList.toArray(new String[0]), interfaceName, subnet)) != null) {
                OverallStatus overallStatus = resultSet.getOverallStatus();
                if (overallStatus == OverallStatus.WARNING) {
                    severity[0] = Severity.WARNING;
                } else if (overallStatus == OverallStatus.SUCCESSFUL) {
                    return true;
                }
            }
        }
        catch (VerificationException e) {
            throw new UnhandledDriverException((Content)UnhandledDriverException.createExtraDetails(resultSet), (ErrorCode)CommonErrorCode.NODE_CONECTIVITY_CHECK_FAILED_FOR_INTERFACE, new Object[]{interfaceName});
        }
        return false;
    }

    public static String getmodifiedInterface(String[] beaninterfaceList) {
        String modifiedInterface = new String();
        ArrayList<String> modifiedInterfaceList = new ArrayList<String>();
        if (beaninterfaceList != null) {
            List<String> interfaces = Arrays.asList(beaninterfaceList);
            int IntrLen = interfaces.size();
            String tmp = "";
            String tmpStr = "";
            String intrName = "";
            String subnet = "";
            for (int iLoop = 0; iLoop < IntrLen; ++iLoop) {
                tmpStr = interfaces.get(iLoop).toString();
                StringTokenizer st = new StringTokenizer(tmpStr, "/");
                intrName = "\"" + st.nextToken() + "\"";
                subnet = st.nextToken();
                String strInterfaceType = st.nextToken();
                if (strInterfaceType.equals("1")) {
                    tmp = intrName + ":" + subnet + ":PUB";
                    modifiedInterfaceList.add(tmp);
                    continue;
                }
                if (strInterfaceType.equals("2")) {
                    tmp = intrName + ":" + subnet + ":PVT";
                    modifiedInterfaceList.add(tmp);
                    continue;
                }
                if (strInterfaceType.equals("4")) {
                    tmp = intrName + ":" + subnet + ":ASM";
                    modifiedInterfaceList.add(tmp);
                    continue;
                }
                if (!strInterfaceType.equals("5")) continue;
                tmp = intrName + ":" + subnet + ":ASM-PVT";
                modifiedInterfaceList.add(tmp);
            }
            modifiedInterface = NetworkInterfaceInfo.toString(modifiedInterfaceList);
        }
        return modifiedInterface;
    }

    private static String toString(List<String> list) {
        String string = null;
        if (list != null && !list.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            for (String entry : list) {
                if (entry == null) continue;
                buffer.append(',').append(entry);
            }
            buffer = buffer.length() > 0 ? buffer.deleteCharAt(0) : buffer;
            string = buffer.toString();
        }
        return string;
    }
}

