/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.system.process.AbstractLineProcessor;
import oracle.install.commons.system.process.DefaultLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.library.crs.CSSInfo;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InstallHelper;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.OFAWrapper;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.ProductInfo;
import oracle.install.library.util.VendorClusterwareInfo;
import oracle.install.library.util.cluster.ClusterConfig;
import oracle.install.library.util.cluster.ClusterNode;
import oracle.install.library.util.cluster.ClusterwareType;
import oracle.install.library.util.cluster.MultiClusterNode;
import oracle.install.library.util.cluster.SingleClusterNode;
import oracle.ops.mgmt.cluster.CSSConfigInfo;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.util.RunCtlCommand;
import oracle.sysman.oii.oiil.OiilNativeException;

public class RAC92Info {
    private static RAC92Info instance = null;
    private static final Logger logger = Logger.getLogger(RAC92Info.class.getName());
    private static final int iCurrentPlatform = PlatformInfo.getInstance().getCurrentPlatform();
    private String strLocalNode = "";
    private static ArrayList<String> nodeList;

    protected RAC92Info() {
    }

    public static RAC92Info getInstance() {
        if (instance == null) {
            ProxyFactory proxyFactory = ProxyFactory.getInstance();
            instance = (RAC92Info)proxyFactory.createProxy(RAC92Info.class);
            if (instance == null) {
                instance = new RAC92Info();
            }
            instance.init();
        }
        return instance;
    }

    protected void init() {
        if (PlatformInfo.getInstance().isWindows()) {
            InstallHelper.Load(InstallHelper.getInstallBinariesPath(), "ClusterQueries.dll");
        }
    }

    public native Object[] getActiveNodesbyCluster(String var1) throws OiilNativeException;

    public boolean is92RACPresent() {
        logger.info("checking for 92 RAC existence");
        String strFullHostName = MachineInfo.getInstance().getFullHostName();
        try {
            ArrayList arlCSSInfo = (ArrayList)CSSInfo.getCSSInfo(new String[]{strFullHostName});
            String[] strCSSInfo = ((String)arlCSSInfo.get(0)).split(":");
            return "true".equals(strCSSInfo[2]) && "ClusterCSS92".equals(strCSSInfo[1]);
        }
        catch (Exception e) {
            return false;
        }
    }

    public ClusterConfig getClusterConfig() {
        ClusterConfig rac92Config = null;
        MachineInfo machineInfo = MachineInfo.getInstance();
        ArrayList<String> nodeList = this.getNodeList(machineInfo.getFullHostName());
        if (nodeList != null) {
            logger.info("List of nodes configured for Oracle 9i RAC are : " + nodeList);
            rac92Config = new ClusterConfig();
            ArrayList<ClusterNode> clusterNodes = new ArrayList<ClusterNode>();
            for (int i = 0; i < nodeList.size(); ++i) {
                SingleClusterNode clusterNode = new SingleClusterNode();
                String publicNodeName = nodeList.get(i).toString();
                clusterNode.setPublicNodeName(publicNodeName);
                clusterNode.setVirtualHostName(machineInfo.getDefVIPName(publicNodeName));
                clusterNode.setOracle9iRACDetected(true);
                clusterNodes.add(clusterNode);
            }
            rac92Config.setClusterNodes(clusterNodes);
            VendorClusterwareInfo vc = VendorClusterwareInfo.getInstance();
            if (vc.isVendorClusterware()) {
                rac92Config.setClusterwareType(ClusterwareType.VENDOR_CLUSTERWARE);
            } else {
                rac92Config.setClusterwareType(ClusterwareType.ORACLE_CLUSTER_MANAGER);
            }
        } else {
            logger.info("No nodes are configured for Oracle 9i RAC");
        }
        return rac92Config;
    }

    public ArrayList<String> getNodeList(String strNodeName) {
        return this.getNodeList(strNodeName, true);
    }

    public ArrayList<String> getNodeList(String strNodeName, boolean reload) {
        if (reload) {
            nodeList = this.loadNodeList(strNodeName);
        }
        return nodeList;
    }

    private ArrayList<String> loadNodeList(String strNodeName) {
        logger.info("Fetching rac 92 nodes. Nodename:" + strNodeName);
        ArrayList<String> strNodes = new ArrayList<String>();
        String strHostName = MachineInfo.getInstance().getFullHostName();
        ArrayList<String> arl92Nodes = new ArrayList();
        if (PlatformInfo.getInstance().isUnix()) {
            this.strLocalNode = strNodeName;
        }
        if (PlatformInfo.getInstance().isUnix()) {
            try {
                arl92Nodes = this.get92RACNodes();
            }
            catch (InstallException e) {
                logger.log(Level.WARNING, "Error while retrieving the rac 92 nodes");
            }
        } else {
            if (!PlatformInfo.getInstance().isWindows()) {
                return arl92Nodes;
            }
            try {
                if (PlatformInfo.getInstance().isWindows()) {
                    InstallHelper.Load(InstallHelper.getInstallBinariesPath(), "ClusterQueries.dll");
                }
                strNodes.addAll(Arrays.asList((String[])this.getActiveNodesbyCluster(strHostName)));
            }
            catch (OiilNativeException e) {
                logger.severe("Failed to fetch nodes in cluster.");
            }
        }
        if (strNodes != null) {
            arl92Nodes.addAll(strNodes);
        }
        return arl92Nodes;
    }

    public String getQuorumLocation() {
        String[] strOHLocs = null;
        try {
            strOHLocs = OFAWrapper.getInstance().getAllOracleHomeLocs();
        }
        catch (InstallException installException) {
            // empty catch block
        }
        if (strOHLocs != null && strOHLocs.length > 0) {
            for (int i = 0; i < strOHLocs.length; ++i) {
                String strVer = null;
                try {
                    strVer = ProductInfo.getInstance().getProductVersion(strOHLocs[i], "oracle.rdbms");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                logger.info("Version = " + strVer);
                if (strVer == null || !strVer.startsWith("9.")) continue;
                logger.info("Found oracle.rdbms in " + strOHLocs[i]);
                File f = new File(strOHLocs[i] + "/oracm/admin/cmcfg.ora");
                if (!f.exists()) continue;
                String strLoc = null;
                String strKey = "CmDiskFile";
                try {
                    BufferedReader br = new BufferedReader(new FileReader(f));
                    String strLine = "";
                    while ((strLine = br.readLine()) != null) {
                        if ((strLine = strLine.replaceAll(" ", "")).startsWith("#") || !strLine.startsWith(strKey)) continue;
                        strLoc = strLine.substring(strKey.length() + 1);
                        break;
                    }
                    br.close();
                    if (strLoc == null) continue;
                    return strLoc;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return "";
    }

    public String get92RACHome(String[] nodeList) throws InstallException {
        String rachome = new String();
        List<Object> oracleHome = new ArrayList();
        oracleHome = InventoryInfo.getInstance().getListOfOH("oracle.server", "9.2.0.0.0", "9.2.99.99.99");
        for (String string : oracleHome) {
            try {
                List<String> value = this.getNodesFor92Home(string);
                if (value == null || value.size() != nodeList.length) continue;
                boolean flag = true;
                for (int i = 0; i < nodeList.length; ++i) {
                    if (value.contains(nodeList[i])) continue;
                    flag = false;
                }
                if (!flag) continue;
                rachome = string;
                break;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to execute lsnodes ", e);
            }
        }
        return rachome;
    }

    public ArrayList<String> get92RACNodes() throws InstallException {
        ArrayList<String> racNodes = new ArrayList<String>();
        String oracleHome = this.get92RACHomeForVC();
        List<Object> nodes = new ArrayList();
        if (oracleHome != null && oracleHome.length() > 0) {
            nodes = this.getNodesFor92Home(oracleHome);
        }
        Version ver92 = Version.get92Version();
        if (nodes != null && nodes.size() > 0) {
            try {
                for (int i = 0; i < nodes.size(); ++i) {
                    CSSConfigInfo ci = ClusterInfo.getCSSConfig((String)((String)nodes.get(i)), (Version)ver92);
                    if (ci == null || !ci.isClusterConfig() || racNodes.contains(nodes.get(i))) continue;
                    racNodes.add((String)nodes.get(i));
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed get the RAC nodes", e);
            }
        }
        return racNodes;
    }

    public List<String> checkGSDAlive(ClusterConfig clusterConfig) {
        ClusterwareType clusterwareType = clusterConfig.getClusterwareType();
        ArrayList<String> rac92Nodes = new ArrayList<String>();
        if (clusterwareType == ClusterwareType.ORACLE_CLUSTER_MANAGER || clusterwareType == ClusterwareType.VENDOR_CLUSTERWARE) {
            List<ClusterNode> clusterNodes = clusterConfig.getClusterNodes();
            for (ClusterNode clusterNode : clusterNodes) {
                if (!clusterNode.isOracle9iRACDetected()) continue;
                if (clusterNode instanceof SingleClusterNode) {
                    rac92Nodes.add(((SingleClusterNode)clusterNode).getPublicNodeName(false));
                    continue;
                }
                if (!(clusterNode instanceof MultiClusterNode)) continue;
                rac92Nodes.addAll(((MultiClusterNode)clusterNode).getAllPublicNodeNames(false));
            }
        }
        String[] nodeList = rac92Nodes.toArray(new String[0]);
        ArrayList<String> gsdNodes = new ArrayList<String>();
        if (!rac92Nodes.isEmpty()) {
            if (PlatformInfo.getInstance().isWindows()) {
                try {
                    ClusterWindows clusterWindows = new ClusterWindows();
                    for (String node : nodeList) {
                        if (!clusterWindows.checkServiceExistOnNode("OracleGSDService", node) || !clusterWindows.checkServiceRunningOnNode("OracleGSDService", node)) continue;
                        gsdNodes.add(node);
                    }
                }
                catch (ClusterException e) {
                    logger.log(Level.WARNING, "Validating the windows services", e);
                }
            } else {
                try {
                    String oracleHome = clusterwareType == ClusterwareType.VENDOR_CLUSTERWARE ? this.get92RACHomeForVC() : this.get92RACHome(nodeList);
                    String[] args = new String[]{"stat"};
                    String[] env = new String[]{"ORACLE_HOME=" + oracleHome, "LD_LIBRARY_PATH=" + oracleHome + "/lib"};
                    if (PlatformInfo.getInstance().isLinux()) {
                        env = new String[]{"ORACLE_HOME=" + oracleHome, "LD_ASSUME_KERNEL=2.4.19", "LD_LIBRARY_PATH=" + oracleHome + "/lib"};
                    }
                    String binPath = "/bin/gsdctl";
                    ClusterCmd cmd = new ClusterCmd();
                    for (String node : nodeList) {
                        try {
                            if (!cmd.fileExists(node, oracleHome + binPath)) continue;
                            RunCtlCommand command = new RunCtlCommand(oracleHome + binPath, args, env, node);
                            Command[] cmds = new Command[]{command};
                            try {
                                boolean success = cmd.submit(cmds);
                                if (!success) continue;
                                CommandResult result = command.getCommandResult();
                                gsdNodes.add(node);
                            }
                            catch (Exception e) {
                                logger.log(Level.WARNING, "Executing cluster command", e);
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, "Validating the file exists", e);
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Validating Inventory", e);
                }
            }
        }
        return gsdNodes;
    }

    public List<String> get92RACDatabasesUsingSRVCTL(List<String> nodeList) {
        String rachome = null;
        List<Object> oracleHome = new ArrayList();
        try {
            oracleHome = InventoryInfo.getInstance().getListOfOH("oracle.server", "9.2.0.0.0", "9.2.99.99.99");
            for (String string : oracleHome) {
                List<String> list = this.getNodesFor92Home(string);
                if (list == null || list.size() <= 0 || !nodeList.containsAll(list)) continue;
                rachome = string;
                break;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to retrive 92 rac home", e);
        }
        if (rachome != null) {
            class OutputParser
            extends DefaultLineProcessor {
                List<String> output;

                OutputParser() {
                }

                public void processLine(String line, int lineNumber) {
                    if (this.output == null) {
                        this.output = new ArrayList<String>();
                    }
                    this.output.add(line);
                }

                List<String> getOutput() {
                    return this.output;
                }
            }
            OutputParser outputParserObj = new OutputParser();
            DefaultLineProcessor defaultLineProcessor = new DefaultLineProcessor(){

                public void processLine(String line, int lineNumber) {
                    logger.warning(line);
                }
            };
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            File srvctl = null;
            File srvctlPath = new File(rachome, "bin");
            PlatformInfo platformInfo = PlatformInfo.getInstance();
            boolean windows = platformInfo.isWindows();
            srvctl = !windows ? new File(srvctlPath, "srvctl") : new File(srvctlPath, "srvctl.bat");
            if (srvctl == null || !srvctl.exists()) {
                logger.warning("SRVCTL not found");
                return null;
            }
            if (!windows) {
                processBuilder.command(srvctl.getPath());
            } else {
                processBuilder.command("\"" + srvctl.getPath() + "\"");
            }
            List<String> command = processBuilder.command();
            command.add("config");
            processBuilder.directory(srvctlPath);
            processBuilder.environment().remove("SRVM_TRACE");
            Map<String, String> map = processBuilder.environment();
            map.put("ORACLE_HOME", rachome);
            map.put("LD_ASSUME_KERNEL", "2.4.19");
            ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(processBuilder, (OutputProcessor)outputParserObj, (OutputProcessor)defaultLineProcessor);
            int exitStatus = 1;
            try {
                exitStatus = ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
            }
            catch (NullPointerException e) {
                logger.log(Level.WARNING, "Exception occured ", e);
                return null;
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.WARNING, "Exception occured ", e);
                return null;
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Exception occured ", e);
                return null;
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "Exception occured ", e);
                return null;
            }
            return exitStatus == 0 ? outputParserObj.getOutput() : null;
        }
        return null;
    }

    private List<String> getNodesFor92Home(String home) {
        try {
            String cmd = home + File.separator + "bin" + File.separator + "lsnodes";
            ProcessBuilder pb = new ProcessBuilder(cmd);
            Map<String, String> map = pb.environment();
            map.put("ORACLE_HOME", home);
            map.put("LD_LIBRARY_PATH", home + "/lib");
            if (PlatformInfo.getInstance().isLinux()) {
                map.put("LD_LIBRARY_PATH", home + "/lib32" + ":" + home + "/lib");
            }
            CMDLineParser lineParse = new CMDLineParser();
            ProcessLaunchInfo pli = new ProcessLaunchInfo(pb, (OutputProcessor)lineParse, null);
            ProcessLauncher.launch((ProcessLaunchInfo)pli);
            return lineParse.getOutStore();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to execute lsnodes ", e);
            return null;
        }
    }

    private String get92RACHomeForVC() {
        String home = "";
        List<Object> oracleHomes = new ArrayList();
        try {
            oracleHomes = InventoryInfo.getInstance().getListOfOH("oracle.server", "9.2.0.0.0", "9.2.99.99.99");
        }
        catch (InstallException installException) {
            // empty catch block
        }
        if (oracleHomes.size() > 0) {
            home = (String)oracleHomes.get(0);
        }
        return home;
    }

    private static class CMDLineParser
    extends AbstractLineProcessor {
        private List<String> outStore = new ArrayList<String>();
        private boolean appendNewline = false;

        CMDLineParser() {
        }

        public void processLine(String line, int lineNumber) {
            if (this.appendNewline) {
                line = line + '\u0000';
            }
            this.outStore.add(line);
        }

        public List<String> getOutStore() {
            return this.outStore;
        }
    }
}

