/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.util.Arrays;
import java.util.List;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.Validator;
import oracle.install.commons.net.support.SSHSupportManagerException;
import oracle.install.ivw.common.util.PreferenceHelper;
import oracle.install.ivw.common.view.SSHSetupPane;

public abstract class SSHPerformanceValidator
implements Validator {
    public void validate(FlowContext flowContext) throws ValidationException {
        List<String> nodes = this.getNodes(flowContext);
        boolean checkSSHPerformance = Boolean.parseBoolean(PreferenceHelper.getProperty("oracle.install.checkSSHPerformance"));
        if (checkSSHPerformance) {
            this.validateSSHPerformance(nodes.toArray(new String[0]));
        }
    }

    private void validateSSHPerformance(String[] nodes) throws ValidationException {
        if (PlatformInfo.getInstance().isWindows()) {
            return;
        }
        if (nodes != null && nodes.length > 0) {
            boolean showAdvice = false;
            try {
                SSHSetupPane.validateSSHPerformance(Arrays.asList(nodes), showAdvice);
            }
            catch (SSHSupportManagerException e) {
                throw new ValidationException(e.getErrorInfo());
            }
        }
    }

    protected abstract List<String> getNodes(FlowContext var1);
}

