/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResultSet;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.driver.oui.etc.UnhandledDriverException;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.cvu.CVUHelper;
import oracle.install.library.util.cvu.CVUValidationStatusMessage;

public class PrivilegedOSGroupsValidationHelper {
    private static PrivilegedOSGroupsValidationHelper instance = null;
    private static final Logger logger = Logger.getLogger(PrivilegedOSGroupsValidationHelper.class.getName());

    public static PrivilegedOSGroupsValidationHelper getInstance() {
        if (instance == null) {
            instance = new PrivilegedOSGroupsValidationHelper();
        }
        return instance;
    }

    public ValidationStatusMessage validateGroupMembership(String userName, String groupVal, String[] nodeList) throws UnhandledDriverException {
        CVUValidationStatusMessage message = null;
        if (userName != null && userName.length() > 0 && groupVal != null && groupVal.length() > 0 && nodeList != null && nodeList.length > 0) {
            try {
                logger.log(Level.INFO, "Checking if user {0} is a member of group {1} on nodes {2}", new Object[]{userName, groupVal, Arrays.toString(nodeList)});
                VerificationResultSet resultSet = CVUHelper.getInstance().checkGroupMembershipOnNodes(nodeList, userName, groupVal);
                if (resultSet != null) {
                    OverallStatus status = resultSet.getOverallStatus();
                    logger.log(Level.INFO, "User {0} member of group {1} check status {2}", new Object[]{userName, groupVal, status});
                    if (status == OverallStatus.OPERATION_FAILED) {
                        message = new CVUValidationStatusMessage((ErrorCode)CommonErrorCode.REMOTE_NODES_GROUP_MEMBERSHIP_CHECK_FAILED, groupVal, resultSet.getFailedNodes());
                    } else if (status == OverallStatus.VERIFICATION_FAILED) {
                        message = new CVUValidationStatusMessage((ErrorCode)CommonErrorCode.USER_NOT_MEMBER_REMOTE_NODES, userName, groupVal, resultSet.getFailedNodes());
                    }
                }
            }
            catch (VerificationException vex) {
                throw new UnhandledDriverException((ErrorCode)CommonErrorCode.REMOTE_NODES_GROUP_MEMBERSHIP_VERIFICATION_EXCEPTION, new Object[]{userName, groupVal, nodeList});
            }
        }
        return message;
    }
}

