/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.util.List;
import java.util.logging.Logger;
import oracle.cluster.verification.VerificationResultSet;
import oracle.install.commons.flow.validation.AbstractActionableStatusMessage;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorInfo;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.message.Content;
import oracle.install.commons.util.message.PlainContent;
import oracle.install.ivw.common.validator.ActionableValidationHelper;
import oracle.install.ivw.crs.bean.CRSInstallSettings;
import oracle.install.library.util.cvu.CVUHelper;

public class CVUActionableValidationStatusMessage
extends AbstractActionableStatusMessage<VerificationResultSet, CRSInstallSettings> {
    private Logger logger = Logger.getLogger(CVUActionableValidationStatusMessage.class.getName());

    public CVUActionableValidationStatusMessage(ErrorCode errorCode, Severity severity, VerificationResultSet result, Object ... messageArgs) {
        super(errorCode, severity, (Object)result, messageArgs);
        this.updateExtraDetails();
    }

    public CVUActionableValidationStatusMessage(ErrorCode errorCode, VerificationResultSet result, Object ... messageArgs) {
        super(errorCode, (Object)result, messageArgs);
        this.updateExtraDetails();
    }

    public CVUActionableValidationStatusMessage(String message, Severity severity, VerificationResultSet result) {
        super(message, severity, (Object)result);
        this.updateExtraDetails();
    }

    public CVUActionableValidationStatusMessage(String message, VerificationResultSet result) {
        super(message, (Object)result);
        this.updateExtraDetails();
    }

    public CVUActionableValidationStatusMessage(Throwable cause, VerificationResultSet result) {
        super(cause, (Object)result);
        this.updateExtraDetails();
    }

    public StatusMessages<ValidationStatusMessage> performAction(CRSInstallSettings bean) {
        VerificationResultSet cvuResultSet;
        this.logger.entering(CVUActionableValidationStatusMessage.class.getName(), "performAction");
        if (bean != null && (cvuResultSet = (VerificationResultSet)this.getResult()) != null) {
            List badNodes = cvuResultSet.getFailedNodes();
            ActionableValidationHelper.removeBadNodes(badNodes, bean);
        }
        this.logger.exiting(CVUActionableValidationStatusMessage.class.getName(), "performAction");
        return null;
    }

    protected void updateExtraDetails() {
        ErrorInfo errorInfo = this.getErrorInfo();
        if (errorInfo != null) {
            errorInfo.setExtraDetails(this.computeExtraDetails());
        }
    }

    protected Content computeExtraDetails() {
        PlainContent content = null;
        CVUHelper helper = CVUHelper.getInstance();
        if (!helper.isResultSetDirty()) {
            content = helper.getExtraDetails();
            helper.setResultSetDirty(true);
        }
        return content;
    }
}

