/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.util.autoupdates;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.system.filemgmt.FileSystem;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.EventListener;
import oracle.install.commons.util.EventSupport;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.ivw.common.bean.HttpProxySettings;
import oracle.install.ivw.common.bean.MyOracleSupportSettings;
import oracle.install.ivw.common.resource.AutoUpdatesManagerException;
import oracle.install.ivw.common.util.OracleInstaller;
import oracle.install.ivw.common.util.autoupdates.DownloadUpdateJobEvent;
import oracle.install.ivw.common.util.autoupdates.OUIUpdateManager;
import oracle.install.ivw.common.util.autoupdates.UpdatesCheckEvent;
import oracle.sysman.oii.oiii.OiiiPatchMetadata;

public abstract class UpdateManager {
    private static UpdateManager instance = null;
    private static final Logger logger = Logger.getLogger(UpdateManager.class.getName());
    private EventSupport<DownloadUpdateJobEvent> downloadEventSupport = new EventSupport();
    private EventSupport<UpdatesCheckEvent> updateCheckEventSupport = new EventSupport();

    public static UpdateManager getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (UpdateManager)(proxyFactory = ProxyFactory.getInstance()).createProxy(UpdateManager.class)) == null) {
            instance = new OUIUpdateManager();
        }
        return instance;
    }

    protected UpdateManager() {
    }

    public abstract boolean getConnection(MyOracleSupportSettings var1, HttpProxySettings var2) throws AutoUpdatesManagerException;

    public List<String> getListOfBugNumbers(List patches) {
        return null;
    }

    public abstract boolean downloadAndParseMetadata(MyOracleSupportSettings var1, HttpProxySettings var2, String var3) throws AutoUpdatesManagerException;

    public abstract boolean doRestart(String[] var1, String var2, String var3, int var4, int var5);

    public abstract boolean applyOPatch(HashMap var1, String var2, int var3);

    public abstract boolean applyOneOffs(HashMap var1, String var2, ArrayList<OiiiPatchMetadata> var3);

    public abstract boolean parseMetadata(String var1, int var2, String var3) throws AutoUpdatesManagerException;

    public abstract ArrayList getInstallUpdates();

    public abstract ArrayList getOneOffList();

    public abstract ArrayList getOneOffList(String var1);

    public abstract ArrayList getCPUUpdatesList();

    public abstract ArrayList getAllCPU();

    public abstract OiiiPatchMetadata getOUIUpdate();

    public abstract OiiiPatchMetadata getOPatchUpdate();

    public abstract void setCPUUpdatesList(ArrayList var1);

    public abstract boolean getRestartInstall();

    public abstract List getListOfUpdatesSelected();

    public abstract long getTotalDownloadSizeForAllPatches(MyOracleSupportSettings var1, HttpProxySettings var2);

    public boolean hasDownloadPrivileges(MyOracleSupportSettings settings, HttpProxySettings proxy) {
        return false;
    }

    public boolean hasDownloadHappened() {
        return false;
    }

    public String getDownloadedMetadata() {
        return null;
    }

    public ArrayList<OiiiPatchMetadata> getCPUUpdatesListFromLoc(String downloadLoc) {
        ArrayList<OiiiPatchMetadata> cpuUpdatesList = null;
        File f = new File(downloadLoc + File.separator + "LatestUpdates", "CPUs");
        int platform = PlatformInfo.getInstance().getARUId();
        if (f.exists()) {
            String[] cpuUpdates = f.list();
            cpuUpdatesList = new ArrayList<OiiiPatchMetadata>();
            if (cpuUpdates != null) {
                for (String bugId : cpuUpdates) {
                    int bugNo = Integer.parseInt(bugId);
                    logger.log(Level.FINEST, "Adding " + bugNo + " to cpu updates list");
                    OiiiPatchMetadata m = new OiiiPatchMetadata(bugNo, platform);
                    cpuUpdatesList.add(m);
                }
            }
        }
        return cpuUpdatesList;
    }

    public void addDownloadUpdateJobListener(EventListener<DownloadUpdateJobEvent> listener) {
        this.downloadEventSupport.addEventListener(listener);
    }

    public void removeDownloadUpdateJobListener(EventListener<DownloadUpdateJobEvent> listener) {
        this.downloadEventSupport.removeEventListener(listener);
    }

    public void fireDownloadUpdateJobEvent(DownloadUpdateJobEvent e) {
        this.downloadEventSupport.fireEvent((Object)e);
    }

    public boolean isStandAloneMode() {
        OracleInstaller installer;
        Application application = Application.getInstance();
        boolean isStandAlone = false;
        if (application instanceof OracleInstaller && (installer = (OracleInstaller)Application.getInstance()).getInstallerMode() != null && installer.getInstallerMode() == OracleInstaller.InstallerMode.STANDALONE_DOWNLOAD_MODE) {
            isStandAlone = true;
        }
        return isStandAlone;
    }

    public void copyMetadataToDownloadLoc(String downloadLoc) {
        String scratchPathLoc = System.getProperty("oracle.installer.scratchPath");
        String metadataDir = "metadata";
        File metadataLoc = new File(downloadLoc, metadataDir);
        if (metadataLoc.exists()) {
            FileSystem.delete((File)metadataLoc);
        }
        FileSystem.copy((File)new File(scratchPathLoc, metadataDir), (File)new File(downloadLoc, metadataDir), null);
        String latestUpdatesLoc = downloadLoc + File.separator + "LatestUpdates";
        List<String> aruXMLs = this.getAllCPURequiredXmls();
        if (aruXMLs != null && aruXMLs.size() > 0) {
            for (String s : aruXMLs) {
                File src;
                File dest = new File(latestUpdatesLoc, s);
                if (dest.exists()) {
                    FileSystem.delete((File)dest);
                }
                if (!(src = new File(scratchPathLoc, s)).exists()) continue;
                FileSystem.copy((File)src, (File)dest, null);
            }
        }
    }

    public abstract List<String> getAllCPURequiredXmls();

    public void addUpdatesCheckListener(EventListener<UpdatesCheckEvent> listener) {
        this.updateCheckEventSupport.addEventListener(listener);
    }

    public void removeUpdatesCheckListener(EventListener<UpdatesCheckEvent> listener) {
        this.updateCheckEventSupport.removeEventListener(listener);
    }

    public void fireUpdatesCheckEvent(UpdatesCheckEvent e) {
        this.updateCheckEventSupport.fireEvent((Object)e);
    }
}

