/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.util.autoupdates;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Retriable;
import oracle.install.commons.util.progress.Status;
import oracle.install.ivw.common.util.autoupdates.ApplyUpdatesJob;
import oracle.install.ivw.common.util.autoupdates.UpdateManager;
import oracle.install.ivw.common.util.autoupdates.UpdatesHelper;

public class PreApplyUpdatesJob
extends Job
implements Callable<Void>,
Retriable {
    private String downloadLoc;
    private String[] nodes;
    private HashMap sessionHashMap;
    private static Logger logger = Logger.getLogger(ApplyUpdatesJob.class.getName());
    UpdateManager updateManager = UpdateManager.getInstance();

    public PreApplyUpdatesJob(String downloadLoc, HashMap hashMap, String ... nodes) {
        Application application = Application.getInstance();
        Resource resource = application.getResource("oracle.install.ivw.common.resource.AutoUpdatesDialogLabelResID");
        String desc = resource.getString("PRE_AUTOUPDATES_APPLY_JOB", "Prepare to apply software updates", new Object[0]);
        this.setDescription(desc);
        this.downloadLoc = downloadLoc;
        this.nodes = nodes;
        this.sessionHashMap = hashMap;
        this.setWeightage(0.1f);
        this.setRequired(false);
        this.setRetryEnabled(true);
        this.setRetriable(this);
    }

    public void setDownloadLoc(String loc) {
        this.downloadLoc = loc;
    }

    public String getDownloadLoc() {
        return this.downloadLoc;
    }

    public Callable<?> getWork() {
        return this;
    }

    public void executePreScript() throws Exception {
        try {
            if (this.downloadLoc != null && this.downloadLoc.length() > 0 && this.sessionHashMap != null) {
                String oracleHome = (String)this.sessionHashMap.get("ORACLE_HOME");
                String[] args = new String[]{oracleHome};
                File customJobPropertiesFile = UpdatesHelper.getInstance().getCustomJobPropertiesFile(this.downloadLoc);
                if (customJobPropertiesFile != null && customJobPropertiesFile.exists()) {
                    Properties properties = new Properties();
                    properties.load(new FileInputStream(customJobPropertiesFile));
                    if (properties.getProperty("PRE_SCRIPT_LOC") != null && properties.getProperty("PRE_SCRIPT_LOC").length() > 0) {
                        String scriptToRun = UpdatesHelper.getInstance().getCustomJobPropertiesFile(this.downloadLoc).getParent() + File.separator + properties.getProperty("PRE_SCRIPT_LOC");
                        boolean statusOfCmd = UpdatesHelper.getInstance().executeScript(scriptToRun, args, this.nodes);
                        if (!statusOfCmd) {
                            this.setStatus(Status.FAILED);
                        } else {
                            this.setStatus(Status.SUCCEEDED);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error occurred while executing pre-updates script", e);
        }
    }

    public void retry() throws Exception {
        this.setStatus(Status.INPROGRESS);
        logger.log(Level.INFO, "Retrying to execute pre-updates script...");
        this.executePreScript();
    }

    @Override
    public Void call() throws Exception {
        this.setStatus(Status.INPROGRESS);
        logger.log(Level.INFO, "Preparing for running pre-script...");
        this.executePreScript();
        return null;
    }

    public List getRetriableJobs() {
        ArrayList<PreApplyUpdatesJob> jobList = new ArrayList<PreApplyUpdatesJob>();
        jobList.add(this);
        return jobList;
    }
}

