/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.common.ClusterException;
import oracle.cluster.impl.install.ConfigurationSetupImpl;
import oracle.cluster.install.ConfigException;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.FirstNodeException;
import oracle.cluster.install.LastNodeException;
import oracle.cluster.install.NodeStatus;
import oracle.cluster.install.RootConfigurationProgressListener;
import oracle.cluster.install.UserInfo;
import oracle.cluster.util.CompositeOperationException;
import oracle.install.commons.base.util.ScriptExecutor;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.LogManager;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.message.Content;
import oracle.install.commons.util.message.ContentType;
import oracle.install.commons.util.message.PlainContent;
import oracle.install.ivw.common.bean.RootConfigurationSettings;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.ivw.common.resource.StringResourceBundle;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.PlatformInfo;

public class RootScriptExecutor
extends ScriptExecutor<HashMap<String, NodeStatus>> {
    private static final Logger logger = Logger.getLogger(RootScriptExecutor.class.getName());
    ConfigurationSetup.ConfigMethod configMethod;
    UserInfo userInfo;
    private HashMap<String, NodeStatus> nodeStatusMap;
    private RootConfigurationSettings configSettings;
    private static RootScriptExecutor instance;
    ConfigurationSetup configurationSetup;
    private String configSetupHome;
    Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());
    private String programLocation;
    private String rootScriptLog;
    private static boolean isWindows;

    protected RootScriptExecutor(RootConfigurationSettings configSettings, String home) {
        this.nodeStatusMap = new HashMap();
        this.init(configSettings, home);
    }

    private void init(RootConfigurationSettings configSettings, String home) {
        if (home != null && home.length() > 0) {
            try {
                this.configurationSetup = new ConfigurationSetupImpl(home);
                this.configSetupHome = home;
                this.rootScriptLog = "<Oracle Base>" + File.separator + "crsdata" + File.separator + "<nodename>" + File.separator + "crsconfig" + File.separator + "rootcrs_<nodename>_<timestamp>.log";
            }
            catch (ConfigException e) {
                logger.log(Level.WARNING, "exception occured while creating config setup object", e);
            }
        }
        if (!isWindows && configSettings != null) {
            this.configSettings = configSettings;
            switch (this.configSettings.getConfigMethod()) {
                case ROOT: {
                    this.configMethod = ConfigurationSetup.ConfigMethod.ROOT;
                    this.userInfo = new UserInfo("root", configSettings.getRootPassword());
                    break;
                }
                case SUDO: {
                    this.configMethod = ConfigurationSetup.ConfigMethod.SUDO;
                    this.userInfo = new UserInfo(configSettings.getSudoUserName(), configSettings.getSudoPassword());
                    if (this.configurationSetup == null) break;
                    this.programLocation = configSettings.getSudoProgramPath();
                    this.configurationSetup.setSudoPath(configSettings.getSudoProgramPath());
                    break;
                }
                case PB: {
                    this.configMethod = ConfigurationSetup.ConfigMethod.PBRUN;
                    this.userInfo = new UserInfo(configSettings.getPowerBrokerUserName(), configSettings.getPbPassword());
                    if (this.configurationSetup == null) break;
                    this.programLocation = configSettings.getPowerBrokerPath();
                    this.configurationSetup.setPbrunPath(configSettings.getPowerBrokerPath());
                    break;
                }
                default: {
                    this.configMethod = ConfigurationSetup.ConfigMethod.SUDO;
                    this.userInfo = new UserInfo(System.getProperty("user.name"), "");
                }
            }
        }
    }

    public static RootScriptExecutor getInstance(RootConfigurationSettings configSettings, String home) {
        if (instance == null) {
            ProxyFactory proxyFactory = ProxyFactory.getInstance();
            instance = (RootScriptExecutor)((Object)proxyFactory.createProxy(RootScriptExecutor.class));
            if (instance == null) {
                instance = new RootScriptExecutor(configSettings, home);
            }
        } else {
            instance.init(configSettings, home);
        }
        return instance;
    }

    public ConfigurationSetup.ConfigMethod getConfigMethod() {
        return this.configMethod;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public String getProgramPath() {
        return this.programLocation;
    }

    public boolean execute(File script, List<String> nodes, String ... args) throws InstallException {
        if (script != null && nodes != null && nodes.size() > 0) {
            block9: {
                try {
                    if (this.configurationSetup != null) {
                        logger.log(Level.INFO, String.format("executing %s script on nodes: %s", script.getPath(), nodes));
                        this.configurationSetup.setProgressMonitor((RootConfigurationProgressListener)new RootScriptExecutorProgressListener());
                        this.nodeStatusMap.clear();
                        this.configurationSetup.runScript(this.configMethod, script.getPath(), args, nodes.toArray(new String[0]), this.userInfo, this.nodeStatusMap);
                        break block9;
                    }
                    logger.log(Level.WARNING, "SRVM configuration setup object is null for executing given script");
                    throw new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_CONFIG_OBJECT_NULL_EXCEPTION, script.getPath());
                }
                catch (ConfigException e) {
                    InstallException ie = new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_CONFIG_EXCEPTION, script.getPath());
                    ie.getErrorInfo().setExtraDetails((Content)this.createExtraDetails(script.getPath(), this.nodeStatusMap, e));
                    throw ie;
                }
                catch (ClusterException e) {
                    InstallException ie = new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_CLUSTER_EXCEPTION, script.getPath(), LogManager.getInstance().getDefaultLogFile());
                    ie.getErrorInfo().setExtraDetails((Content)this.createExtraDetails(script.getPath(), this.nodeStatusMap, e));
                    throw ie;
                }
                catch (CompositeOperationException e) {
                    String logFileString = this.resource.getString("RootScriptExecutor.custom.script.logFile.name", "<Script specific log file>", new Object[0]);
                    InstallException ie = new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_COMPOSITE_OPERATION_EXCEPTION, script.getPath(), LogManager.getInstance().getDefaultLogFile(), logFileString, this.getFailedNodes(this.nodeStatusMap));
                    ie.getErrorInfo().setExtraDetails((Content)this.createExtraDetails(script.getPath(), this.nodeStatusMap, e));
                    throw ie;
                }
                finally {
                    this.logResult(script.getPath());
                }
            }
            return this.getStatus();
        }
        logger.log(Level.WARNING, "script or node list is empty");
        return false;
    }

    public boolean runInstallScript(List<String> nodes) throws InstallException {
        if (nodes != null && nodes.size() > 0) {
            block18: {
                String scriptName = this.resource.getString("RootScriptExecutor.install.script.name", "Install", new Object[0]);
                try {
                    if (this.configurationSetup != null) {
                        logger.log(Level.INFO, String.format("executing %s script on nodes: %s", scriptName, nodes));
                        this.configurationSetup.setProgressMonitor((RootConfigurationProgressListener)new RootScriptExecutorProgressListener());
                        this.nodeStatusMap.clear();
                        if (isWindows) {
                            this.configurationSetup.configureGIInstall(nodes.toArray(new String[0]), this.nodeStatusMap);
                        } else {
                            this.configurationSetup.configureGIInstall(this.configMethod, nodes.toArray(new String[0]), this.userInfo, this.nodeStatusMap);
                        }
                        break block18;
                    }
                    logger.log(Level.WARNING, "SRVM configuration setup object is null for executing given script");
                    throw new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_CONFIG_OBJECT_NULL_EXCEPTION, scriptName);
                }
                catch (ConfigException e) {
                    InstallException ie = new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_CONFIG_EXCEPTION, scriptName);
                    ie.getErrorInfo().setExtraDetails((Content)this.createExtraDetails(scriptName, this.nodeStatusMap, e));
                    throw ie;
                }
                catch (ClusterException e) {
                    InstallException ie = new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_CLUSTER_EXCEPTION, scriptName, LogManager.getInstance().getDefaultLogFile());
                    ie.getErrorInfo().setExtraDetails((Content)this.createExtraDetails(scriptName, this.nodeStatusMap, e));
                    throw ie;
                }
                catch (CompositeOperationException e) {
                    boolean nodesRequireReboot;
                    List<String> rebootRequiredNodes = this.getRebootRequiredNodes(this.nodeStatusMap);
                    List<String> failedNodes = this.getFailedNodes(this.nodeStatusMap);
                    InstallException ie = null;
                    boolean nodesFailed = failedNodes != null && failedNodes.size() > 0;
                    boolean bl = nodesRequireReboot = rebootRequiredNodes != null && rebootRequiredNodes.size() > 0;
                    if (nodesFailed && nodesRequireReboot && failedNodes.containsAll(rebootRequiredNodes) && rebootRequiredNodes.containsAll(failedNodes)) {
                        ie = new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_FAILED_NODES_WITH_REBOOT_REQUIRED_EXCEPTION, scriptName, failedNodes, LogManager.getInstance().getDefaultLogFile(), this.rootScriptLog);
                    } else if (nodesFailed && nodesRequireReboot) {
                        ie = new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_FAILED_NODES_AND_REBOOT_REQUIRED_NODES_EXCEPTION, scriptName, failedNodes, rebootRequiredNodes, LogManager.getInstance().getDefaultLogFile(), this.rootScriptLog);
                    } else {
                        if (nodesFailed) {
                            ie = new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_FAILED_NODES_EXCEPTION, scriptName, failedNodes, LogManager.getInstance().getDefaultLogFile(), this.rootScriptLog);
                        }
                        if (nodesRequireReboot) {
                            ie = new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_REBOOT_REQUIRED_NODES_EXCEPTION, rebootRequiredNodes);
                        }
                    }
                    ie.getErrorInfo().setExtraDetails((Content)this.createExtraDetails(scriptName, this.nodeStatusMap, e));
                    throw ie;
                }
                catch (FirstNodeException e) {
                    List<String> rebootRequiredNodes = this.getRebootRequiredNodes(this.nodeStatusMap);
                    InstallException ie = null;
                    ie = rebootRequiredNodes != null && rebootRequiredNodes.size() > 0 ? new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_REBOOT_REQUIRED_ERR, scriptName, LogManager.getInstance().getDefaultLogFile(), this.rootScriptLog, rebootRequiredNodes) : new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_COMPOSITE_OPERATION_EXCEPTION, scriptName, LogManager.getInstance().getDefaultLogFile(), this.rootScriptLog, this.getFailedNodes(this.nodeStatusMap));
                    ie.getErrorInfo().setExtraDetails((Content)this.createExtraDetails(scriptName, this.nodeStatusMap, e));
                    throw ie;
                }
                finally {
                    this.logResult(scriptName);
                }
            }
            return this.getStatus();
        }
        logger.log(Level.WARNING, "node list is empty");
        return false;
    }

    public boolean runUpgradeScript(List<String> completNodes, String oldCRSHome, List<String> nodesToRun, boolean lastBatch, boolean ignoreDownNodes) throws InstallException {
        if (nodesToRun != null && nodesToRun.size() > 0) {
            block24: {
                String scriptName = this.resource.getString("RootScriptExecutor.upgrade.script.name", "Upgrade", new Object[0]);
                try {
                    if (this.configurationSetup != null) {
                        logger.log(Level.INFO, String.format("executing %s script on nodes: %s", scriptName, nodesToRun));
                        this.configurationSetup.setProgressMonitor((RootConfigurationProgressListener)new RootScriptExecutorProgressListener());
                        this.nodeStatusMap.clear();
                        if (isWindows) {
                            this.configurationSetup.configureGIUpgrade(completNodes.toArray(new String[0]), nodesToRun.toArray(new String[0]), oldCRSHome, lastBatch, ignoreDownNodes, this.nodeStatusMap);
                        } else {
                            this.configurationSetup.configureGIUpgrade(this.configMethod, completNodes.toArray(new String[0]), nodesToRun.toArray(new String[0]), this.userInfo, oldCRSHome, lastBatch, ignoreDownNodes, this.nodeStatusMap);
                        }
                        break block24;
                    }
                    logger.log(Level.WARNING, "SRVM configuration setup object is null for executing given script");
                    throw new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_CONFIG_OBJECT_NULL_EXCEPTION, scriptName);
                }
                catch (ConfigException e) {
                    InstallException ie = new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_CONFIG_EXCEPTION, scriptName);
                    ie.getErrorInfo().setExtraDetails((Content)this.createExtraDetails(scriptName, this.nodeStatusMap, e));
                    if (e != null) {
                        logger.log(Level.FINEST, "Stacktrace", e);
                    }
                    throw ie;
                }
                catch (ClusterException e) {
                    InstallException ie = new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_CLUSTER_EXCEPTION, scriptName, LogManager.getInstance().getDefaultLogFile());
                    ie.getErrorInfo().setExtraDetails((Content)this.createExtraDetails(scriptName, this.nodeStatusMap, e));
                    if (e != null) {
                        logger.log(Level.FINEST, "Stacktrace", e);
                    }
                    throw ie;
                }
                catch (CompositeOperationException e) {
                    boolean nodesRequireReboot;
                    List<String> rebootRequiredNodes = this.getRebootRequiredNodes(this.nodeStatusMap);
                    List<String> failedNodes = this.getFailedNodes(this.nodeStatusMap);
                    InstallException ie = null;
                    boolean nodesFailed = failedNodes != null && failedNodes.size() > 0;
                    boolean bl = nodesRequireReboot = rebootRequiredNodes != null && rebootRequiredNodes.size() > 0;
                    if (nodesFailed && nodesRequireReboot && failedNodes.containsAll(rebootRequiredNodes) && rebootRequiredNodes.containsAll(failedNodes)) {
                        ie = new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_FAILED_NODES_WITH_REBOOT_REQUIRED_EXCEPTION, scriptName, failedNodes, LogManager.getInstance().getDefaultLogFile(), this.rootScriptLog);
                    } else if (nodesFailed && nodesRequireReboot) {
                        ie = new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_FAILED_NODES_AND_REBOOT_REQUIRED_NODES_EXCEPTION, scriptName, failedNodes, rebootRequiredNodes, LogManager.getInstance().getDefaultLogFile(), this.rootScriptLog);
                    } else {
                        if (nodesFailed) {
                            ie = new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_FAILED_NODES_EXCEPTION, scriptName, failedNodes, LogManager.getInstance().getDefaultLogFile(), this.rootScriptLog);
                        }
                        if (nodesRequireReboot) {
                            ie = new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_REBOOT_REQUIRED_NODES_EXCEPTION, rebootRequiredNodes);
                        }
                    }
                    ie.getErrorInfo().setExtraDetails((Content)this.createExtraDetails(scriptName, this.nodeStatusMap, e));
                    if (e != null) {
                        logger.log(Level.FINEST, "Stacktrace", e);
                    }
                    throw ie;
                }
                catch (FirstNodeException e) {
                    List<String> rebootRequiredNodes = this.getRebootRequiredNodes(this.nodeStatusMap);
                    InstallException ie = null;
                    ie = rebootRequiredNodes != null && rebootRequiredNodes.size() > 0 ? new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_REBOOT_REQUIRED_ERR, scriptName, LogManager.getInstance().getDefaultLogFile(), this.rootScriptLog, rebootRequiredNodes) : new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_COMPOSITE_OPERATION_EXCEPTION, scriptName, LogManager.getInstance().getDefaultLogFile(), this.rootScriptLog, this.getFailedNodes(this.nodeStatusMap));
                    ie.getErrorInfo().setExtraDetails((Content)this.createExtraDetails(scriptName, this.nodeStatusMap, e));
                    if (e != null) {
                        logger.log(Level.FINEST, "Stacktrace", e);
                    }
                    throw ie;
                }
                catch (LastNodeException e) {
                    List<String> rebootRequiredNodes = this.getRebootRequiredNodes(this.nodeStatusMap);
                    InstallException ie = null;
                    ie = rebootRequiredNodes != null && rebootRequiredNodes.size() > 0 ? new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_REBOOT_REQUIRED_ERR, scriptName, LogManager.getInstance().getDefaultLogFile(), this.rootScriptLog, rebootRequiredNodes) : new InstallException((ErrorCode)CommonErrorCode.ROOT_SCRIPT_EXEC_LAST_NODE_EXCEPTION, scriptName, this.rootScriptLog);
                    ie.getErrorInfo().setExtraDetails((Content)this.createExtraDetails(scriptName, this.nodeStatusMap, e));
                    if (e != null) {
                        logger.log(Level.FINEST, "Stacktrace", e);
                    }
                    throw ie;
                }
                finally {
                    this.logResult(scriptName);
                }
            }
            return this.getStatus();
        }
        logger.log(Level.WARNING, "node list is empty");
        return false;
    }

    public Content getResultAsContent(String scriptName) {
        return this.createExtraDetails(scriptName, this.nodeStatusMap);
    }

    public List<String> getRebootRequiredNodes() {
        return this.getRebootRequiredNodes(this.nodeStatusMap);
    }

    private List<String> getRebootRequiredNodes(Map<String, NodeStatus> resultSet) {
        ArrayList<String> rebootRequiredNodes = new ArrayList<String>();
        if (this.nodeStatusMap != null) {
            for (String node : this.nodeStatusMap.keySet()) {
                NodeStatus nodeStatus = this.nodeStatusMap.get(node);
                if (!nodeStatus.getIsRebootReqd()) continue;
                rebootRequiredNodes.add(node);
            }
        }
        return rebootRequiredNodes;
    }

    private boolean getStatus() {
        return this.getStatus(this.nodeStatusMap);
    }

    private boolean getStatus(Map<String, NodeStatus> resultSet) {
        return this.getFailedNodes(resultSet).size() == 0;
    }

    public HashMap<String, NodeStatus> getResultSet() {
        return this.nodeStatusMap;
    }

    private void logResult(String scriptName) {
        boolean succeeded = this.getStatus();
        logger.log(Level.INFO, String.format("status of %s script execution is:", scriptName) + succeeded);
        logger.info("*********************************************");
        logger.log(Level.INFO, this.getExtraDetailsString(scriptName, this.nodeStatusMap, null, false));
        logger.info("*********************************************");
    }

    public PlainContent createExtraDetails(String scriptName, Map<String, NodeStatus> resultSet) {
        return this.createExtraDetails(scriptName, resultSet, null);
    }

    public PlainContent createExtraDetails(String scriptName, Map<String, NodeStatus> resultSet, Throwable e) {
        PlainContent content = new PlainContent(this.getExtraDetailsString(scriptName, resultSet, e, true));
        ContentType contentType = ContentType.HTML;
        content.setContentType(contentType);
        return content;
    }

    public String getExtraDetailsString(String scriptName, Map<String, NodeStatus> resultSet, Throwable e, boolean htmlFormat) {
        String nodeStatusMsg;
        StringBuffer stringBuffer = new StringBuffer();
        List<Object> succeededNodes = new ArrayList();
        List<Object> failedNodes = new ArrayList();
        if (e == null && this.getStatus(resultSet)) {
            succeededNodes = this.getSucceededNodes(resultSet);
            stringBuffer.append(this.resource.getString("RootScriptExecutor.successful.nodes.message", "Execution of {0} script is successful on nodes : {1}", new Object[]{scriptName, this.getNodeList(succeededNodes, false)}));
            stringBuffer.append(htmlFormat ? "<br><br>" : "\n\n");
        } else {
            succeededNodes = this.getSucceededNodes(resultSet);
            if (succeededNodes.size() > 0) {
                stringBuffer.append(this.resource.getString("RootScriptExecutor.successful.nodes.message", "Execution of {0} script is successful on nodes : {1}", new Object[]{scriptName, this.getNodeList(succeededNodes, false)}));
                stringBuffer.append(htmlFormat ? "<br><br>" : "\n\n");
            }
            if ((failedNodes = this.getFailedNodes(resultSet)).size() > 0) {
                stringBuffer.append(this.resource.getString("RootScriptExecutor.failed.nodes.message", "Execution of {0} script is failed on nodes : {1}", new Object[]{scriptName, this.getNodeList(failedNodes, htmlFormat)}));
                stringBuffer.append(htmlFormat ? "<br><br>" : "\n\n");
            }
        }
        if (e != null) {
            ArrayList causes = new ArrayList();
            ExceptionManager.enumCauses((Throwable)e, causes);
            String string = this.resource.getString("RootScriptExecutor.exception.details", "Exception Details:", new Object[0]);
            stringBuffer.append(htmlFormat ? "<b>" : "");
            stringBuffer.append(string);
            stringBuffer.append(htmlFormat ? "</b>" : "");
            stringBuffer.append(htmlFormat ? "<br>" : "\n");
            stringBuffer.append(htmlFormat ? "&nbsp;-&nbsp;" : " - ");
            stringBuffer.append(e.getLocalizedMessage());
            if (!causes.isEmpty()) {
                for (String cause : causes) {
                    stringBuffer.append(htmlFormat ? "<br>" : "\n");
                    stringBuffer.append(htmlFormat ? "&nbsp;-&nbsp;" : " - ");
                    stringBuffer.append(cause);
                }
            }
            stringBuffer.append(htmlFormat ? "<br>" : "\n");
            stringBuffer.append(htmlFormat ? "<br>" : "\n");
        }
        if (failedNodes.size() > 0) {
            for (String string : failedNodes) {
                stringBuffer.append(htmlFormat ? "<a name=\"" + string + "\"></a>" : "");
                nodeStatusMsg = this.resource.getString("RootScriptExecutor.failed.node.execution.status", "Execution status of failed node:", new Object[0]);
                stringBuffer.append(htmlFormat ? "<b>" + nodeStatusMsg + "</b>" : nodeStatusMsg);
                stringBuffer.append(string);
                stringBuffer.append(this.getNodeStatus(resultSet.get(string), htmlFormat));
                stringBuffer.append(htmlFormat ? "<br><br>" : "\n\n");
            }
        }
        if (!htmlFormat) {
            if (succeededNodes.size() > 0) {
                for (String string : succeededNodes) {
                    stringBuffer.append(htmlFormat ? "<a name=\"" + string + "\"></a>" : "");
                    nodeStatusMsg = this.resource.getString("RootScriptExecutor.succeeded.node.execution.status", "Execution status of succeeded node:", new Object[0]);
                    stringBuffer.append(htmlFormat ? "<b>" + nodeStatusMsg + "</b>" : nodeStatusMsg);
                    stringBuffer.append(string);
                    stringBuffer.append(this.getNodeStatus(resultSet.get(string), htmlFormat));
                    stringBuffer.append(htmlFormat ? "<br><br>" : "\n\n");
                }
            }
            for (String string : resultSet.keySet()) {
                stringBuffer.append(" Execution status of " + string + " is:" + resultSet.get(string).getStatus() + "\n");
                stringBuffer.append(" Execution exit code of " + string + " is:" + resultSet.get(string).getExitCode() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public List<String> getFailedNodes(Map<String, NodeStatus> resultSet) {
        ArrayList<String> failedNodes = new ArrayList<String>();
        if (resultSet != null) {
            for (String node : resultSet.keySet()) {
                NodeStatus nodeStatus = resultSet.get(node);
                if (nodeStatus.getExitCode() == 0 && nodeStatus.getStatus()) continue;
                failedNodes.add(node);
            }
        }
        return failedNodes;
    }

    public List<String> getSucceededNodes(Map<String, NodeStatus> resultSet) {
        ArrayList<String> succeededNodes = new ArrayList<String>();
        if (resultSet != null) {
            for (String node : resultSet.keySet()) {
                NodeStatus nodeStatus = resultSet.get(node);
                if (nodeStatus.getExitCode() != 0 || !nodeStatus.getStatus()) continue;
                succeededNodes.add(node);
            }
        }
        return succeededNodes;
    }

    public boolean isConfigurationPending(String node) {
        boolean result = false;
        Object configurationResult = this.getResultSet();
        if (configurationResult != null && node != null && !configurationResult.containsKey(node)) {
            result = true;
            logger.log(Level.INFO, "Configuration is pending on node : " + node);
        }
        return result;
    }

    public List<String> getConfigurationPendingNodes(List<String> nodeList) {
        ArrayList<String> configurationPendingNodes = new ArrayList<String>();
        Object configurationResult = this.getResultSet();
        if (nodeList != null && !nodeList.isEmpty() && configurationResult != null && !configurationResult.isEmpty()) {
            for (String node : nodeList) {
                if (node == null || configurationResult.containsKey(node)) continue;
                configurationPendingNodes.add(node);
            }
        }
        return configurationPendingNodes;
    }

    private String getNodeList(List<String> nodeList, boolean htmlFormat) {
        int n = nodeList.size();
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        for (int i = 0; i < n; ++i) {
            String node = nodeList.get(i);
            buffer.append(htmlFormat ? "<a href=\"#" + node + "\">" : "");
            buffer.append(node);
            buffer.append(htmlFormat ? "</a>" : "");
            if (i + 1 == n) continue;
            buffer.append(htmlFormat ? ", &nbsp;" : ", ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    private String getNodeStatus(NodeStatus nodeStatus, boolean htmlFormat) {
        StringBuffer messageBuffer = new StringBuffer();
        messageBuffer.append(htmlFormat ? "&nbsp;<table border=\"0\">" : " ");
        String rebootHeading = this.resource.getString("RootScriptExecutor.reboot.required.text", "Reboot required to complete", new Object[0]);
        boolean rebootRequired = nodeStatus.getIsRebootReqd();
        if (rebootRequired) {
            messageBuffer.append(htmlFormat ? "<tr>" : "\n");
            messageBuffer.append(htmlFormat ? "<td valign=\"top\" align=\"left\" nowrap>" : "").append(htmlFormat ? "&nbsp;" + rebootHeading + "&nbsp;" : " " + rebootHeading + " ").append(htmlFormat ? "</td>" : "");
            messageBuffer.append(htmlFormat ? "<td>" : "");
            messageBuffer.append(htmlFormat ? "&nbsp;:&nbsp;" : " : ");
            messageBuffer.append(Boolean.toString(rebootRequired));
            messageBuffer.append(htmlFormat ? "</td>" : "");
            messageBuffer.append(htmlFormat ? "</tr>" : "");
        }
        String errorHeading = this.resource.getString("RootScriptExecutor.errors.text", "Errors", new Object[0]);
        String errorString = nodeStatus.getStdErr();
        if (errorString != null && errorString.length() > 0) {
            if (htmlFormat) {
                errorString = errorString.replaceAll("<", "&lt;");
                errorString = errorString.replaceAll(">", "&gt;");
            }
            messageBuffer.append(htmlFormat ? "<tr>" : "\n");
            messageBuffer.append(htmlFormat ? "<td valign=\"top\" align=\"left\" nowrap>" : "").append(htmlFormat ? "&nbsp;" + errorHeading + "&nbsp;" : " " + errorHeading + " ").append(htmlFormat ? "</td>" : "");
            messageBuffer.append(htmlFormat ? "<td>" : "");
            messageBuffer.append(htmlFormat ? "&nbsp;:&nbsp;" : " : ");
            messageBuffer.append(htmlFormat ? errorString.replaceAll("\n", "<br>") : errorString);
            messageBuffer.append(htmlFormat ? "</td>" : "");
            messageBuffer.append(htmlFormat ? "</tr>" : "");
        }
        String stdOutHeader = this.resource.getString("RootScriptExecutor.standard.output.text", "Standard output", new Object[0]);
        String outputString = nodeStatus.getStdOut();
        if (outputString != null && outputString.length() > 0) {
            if (htmlFormat) {
                outputString = outputString.replaceAll("<", "&lt;");
                outputString = outputString.replaceAll(">", "&gt;");
            }
            messageBuffer.append(htmlFormat ? "<tr>" : "\n");
            messageBuffer.append(htmlFormat ? "<td valign=\"top\" align=\"left\" nowrap>" : "").append(htmlFormat ? "&nbsp;" + stdOutHeader + "&nbsp;" : " " + stdOutHeader + " ").append(htmlFormat ? "</td>" : "");
            messageBuffer.append(htmlFormat ? "<td>" : "");
            messageBuffer.append(htmlFormat ? "&nbsp;:&nbsp;" : " : ");
            messageBuffer.append(htmlFormat ? outputString.replaceAll("\n", "<br>") : outputString);
            messageBuffer.append(htmlFormat ? "</td>" : "");
            messageBuffer.append(htmlFormat ? "</tr>" : "");
        }
        if (nodeStatus.getExitCode() != 0 || !nodeStatus.getStatus()) {
            String exceptionHeader = this.resource.getString("RootScriptExecutor.exception.details", "Exception details", new Object[0]);
            String exceptionString = nodeStatus.getExceptionMesg();
            if (exceptionString != null && exceptionString.length() > 0) {
                if (htmlFormat) {
                    exceptionString = outputString.replaceAll("<", "&lt;");
                    exceptionString = outputString.replaceAll(">", "&gt;");
                }
                messageBuffer.append(htmlFormat ? "<tr>" : "\n");
                messageBuffer.append(htmlFormat ? "<td valign=\"top\" align=\"left\" nowrap>" : "").append(htmlFormat ? "&nbsp;" + exceptionHeader + "&nbsp;" : " " + exceptionHeader + " ").append(htmlFormat ? "</td>" : "");
                messageBuffer.append(htmlFormat ? "<td>" : "");
                messageBuffer.append(htmlFormat ? "&nbsp;:&nbsp;" : " : ");
                messageBuffer.append(htmlFormat ? exceptionString.replaceAll("\n", "<br>") : exceptionString);
                messageBuffer.append(htmlFormat ? "</td>" : "");
                messageBuffer.append(htmlFormat ? "</tr>" : "");
            }
        }
        messageBuffer.append(htmlFormat ? "</table>" : "");
        return messageBuffer.toString();
    }

    public String getRootScriptLog() {
        return this.rootScriptLog;
    }

    static {
        isWindows = PlatformInfo.getInstance().isWindows();
    }

    class RootScriptExecutorProgressListener
    implements RootConfigurationProgressListener {
        RootScriptExecutorProgressListener() {
        }

        public void setStatus(String status) {
            RootScriptExecutor.this.setStatusMessage(status);
        }

        public void updateProgress(int percent) {
            logger.log(Level.INFO, "Progress:" + percent);
            RootScriptExecutor.this.updateProgress((float)percent / 100.0f);
        }
    }
}

