/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.driver;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.system.process.AbstractLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.StringUtils;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.message.Content;
import oracle.install.commons.util.message.ContentType;
import oracle.install.commons.util.message.PlainContent;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Retriable;
import oracle.install.commons.util.progress.Status;
import oracle.install.ivw.common.resource.CommonDialogLabelResID;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.library.resource.StringResourceBundle;
import oracle.install.library.util.OFAWrapper;
import oracle.install.library.util.PlatformInfo;

public class DiagsetupToolJob
extends CompositeJob
implements Callable<Void>,
Retriable<Job> {
    private static final Logger logger = Logger.getLogger(DiagsetupToolJob.class.getName());
    ErrorMessage message;
    private static final String diagsetup_unix = "diagsetup";
    private static final String diagsetup_win = "diagsetup.bat";
    private OutputProcessor stdOutProcessor;
    private OutputProcessor stdErrProcessor;
    String oracleHome;
    String oracleBase;
    String localNode;
    private String optionalArgs;
    List<String> clusterNodes;
    public static final String SKIP_CREATE = "skipcreate=true";
    public static final Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());
    private boolean gridSetupWizard = Boolean.getBoolean("oracle.installer.setupWizard");

    public DiagsetupToolJob(String oracleHome, String oracleBase, String localNode, List<String> clusterNodes) {
        super((Object)diagsetup_unix, null, 0.1f);
        this.setDescription(Application.getInstance().getString(ResourceURL.resURL((String)CommonDialogLabelResID.class.getName(), (String)"diagsetupToolJob.description"), "Setup Oracle Base", new Object[0]));
        this.setRetryEnabled(true);
        this.setRequired(true);
        this.setRetriable(this);
        this.oracleHome = oracleHome;
        this.oracleBase = oracleBase;
        this.localNode = localNode;
        this.clusterNodes = clusterNodes;
        this.stdOutProcessor = new AbstractLineProcessor(){

            public void processLine(String line, int lineNumber) {
                this.getLines().add(line);
                logger.info(line);
            }
        };
        this.stdErrProcessor = new AbstractLineProcessor(){

            public void processLine(String line, int lineNumber) {
                this.getLines().add(line);
                logger.warning(line);
            }
        };
    }

    private String getCSVForList(List<String> list) {
        StringBuilder retStr = new StringBuilder();
        if (list != null) {
            for (String item : list) {
                retStr.append(item);
                retStr.append(",");
            }
            if (retStr.length() > 0) {
                retStr.deleteCharAt(retStr.lastIndexOf(","));
            }
        }
        return retStr.toString();
    }

    private void call(boolean retry) throws Exception {
        this.setStatus(Status.INPROGRESS);
        boolean succeeded = true;
        String ohBinDir = new File(this.oracleHome, "bin").getAbsolutePath();
        ArrayList<String> args = new ArrayList<String>();
        if (this.gridSetupWizard && this.oracleBase == null) {
            this.oracleBase = OFAWrapper.getInstance().getBaseForLocation(this.oracleHome);
        }
        String cmd = PlatformInfo.getInstance().isWindows() ? ohBinDir + File.separator + diagsetup_win : ohBinDir + File.separator + diagsetup_unix;
        args.add(cmd);
        if (Application.isCommandLineSwitchEnabled((String)"-debug")) {
            args.add("trace=true");
        }
        args.add("clustercheck=false");
        args.add("basedir=" + this.oracleBase);
        args.add("oraclehome=" + this.oracleHome);
        this.clusterNodes = this.getClusterNodes();
        if (this.clusterNodes != null && this.clusterNodes.size() > 0) {
            if (this.clusterNodes.size() > 1) {
                args.add("localnode=" + this.localNode);
                args.add("nodelist=" + this.getCSVForList(this.clusterNodes));
                ArrayList<String> remoteNodes = new ArrayList<String>(this.clusterNodes);
                int index = StringUtils.indexOfIgnoreCase(remoteNodes, (String)this.localNode);
                if (index >= 0) {
                    remoteNodes.remove(index);
                }
                args.add("remotenodes=" + this.getCSVForList(remoteNodes));
            } else {
                args.add("localnode=" + this.localNode);
                args.add("nodelist=" + this.getCSVForList(this.clusterNodes));
            }
        }
        if (null != this.optionalArgs && !this.optionalArgs.isEmpty()) {
            args.add(this.optionalArgs);
        }
        ProcessBuilder pb = new ProcessBuilder(args);
        ((AbstractLineProcessor)this.stdOutProcessor).getLines().clear();
        ((AbstractLineProcessor)this.stdErrProcessor).getLines().clear();
        ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(pb, this.stdOutProcessor, this.stdErrProcessor);
        int exitCode = 0;
        try {
            exitCode = ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
        }
        catch (Exception e) {
            succeeded = false;
            logger.log(Level.INFO, "ADR setup (diagsetup) tool failed", e);
            logger.log(Level.INFO, e.getMessage());
        }
        if (exitCode != 0) {
            succeeded = false;
        }
        if (succeeded) {
            this.setStatus(Status.SUCCEEDED);
        } else {
            Advice advice;
            this.message = new DefaultErrorMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_DIAGSETUP_FAILED, new Object[0]);
            this.message.getErrorInfo().setExtraDetails((Content)this.getExtraDetails(succeeded));
            if (args != null) {
                PlainContent extraDetails = new PlainContent();
                StringBuilder s = new StringBuilder("Command:\n");
                for (String arg : args) {
                    s.append(arg);
                    s.append(" ");
                }
                extraDetails.setContent(s.toString());
                logger.log(Level.INFO, s.toString());
            }
            if ((advice = ExceptionManager.advise((ErrorMessage)this.message)) == Advice.CONTINUE) {
                this.setStatus(Status.SUCCEEDED);
            } else {
                this.setStatus(Status.FAILED);
            }
        }
    }

    public Callable<?> getWork() {
        return this;
    }

    @Override
    public Void call() throws Exception {
        this.call(false);
        return null;
    }

    public void retry() throws Exception {
        this.call(true);
    }

    public List<Job> getRetriableJobs() {
        ArrayList<Job> retriableJobs = new ArrayList<Job>();
        List jobList = this.getJobs();
        if (jobList.size() > 0) {
            for (Job job : jobList) {
                Status status = job.getStatus();
                if (!job.isRetryEnabled() || status != Status.PENDING && status != Status.FAILED) continue;
                logger.log(Level.INFO, "Selecting job named ''{0}'' for retry", job.getDescription());
                retriableJobs.add(job);
            }
        } else {
            Status status = this.getStatus();
            if (this.isRetryEnabled() && (status == Status.PENDING || status == Status.FAILED)) {
                retriableJobs.add((Job)this);
            }
        }
        return retriableJobs;
    }

    public void setOptionalArgs(String optionalArgs) {
        this.optionalArgs = optionalArgs;
    }

    public PlainContent getExtraDetails(boolean succeeded) {
        PlainContent content = null;
        if (!succeeded) {
            content = new PlainContent("");
            content.setContentType(ContentType.HTML);
            content.setTitle(resource.getString("ErrorMessage.extraDetails.message", "Additional Information:", new Object[0]));
            StringBuffer extraDetails = new StringBuffer();
            ArrayList totalLines = new ArrayList();
            totalLines.addAll(((AbstractLineProcessor)this.stdOutProcessor).getLines());
            totalLines.addAll(((AbstractLineProcessor)this.stdErrProcessor).getLines());
            for (String line : totalLines) {
                if (line == null) continue;
                extraDetails.append("&nbsp;-&nbsp;");
                extraDetails.append(StringUtils.textToHtml((String)line) + "<br>");
            }
            StringBuffer details = new StringBuffer(content.getContent());
            details.append(extraDetails.toString());
            content.setContent(details.toString());
        }
        return content;
    }

    public List<String> getClusterNodes() {
        return this.clusterNodes;
    }
}

