/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.PasswordHelper;
import oracle.install.commons.flow.DefaultAction;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowExecutorType;
import oracle.install.commons.flow.annotation.UIRef;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.common.bean.WindowsSecureOptionSettings;
import oracle.install.ivw.common.resource.CommonDialogLabelResID;
import oracle.install.library.util.WinHelper;

@UIRef(value="WindowsSecureOptionUI")
public class WindowsSecureOptionAction
extends DefaultAction {
    private Logger logger = Logger.getLogger(WindowsSecureOptionAction.class.getName());
    private Resource resource = Application.getInstance().getResource(CommonDialogLabelResID.class.getName());

    public void execute(FlowContext flowContext) {
        this.logger.log(Level.INFO, "calling execute method of common.action.WindowsSecureOptionAction...");
        WindowsSecureOptionSettings bean = (WindowsSecureOptionSettings)((Object)flowContext.getBean(WindowsSecureOptionSettings.class));
        char[] password = null;
        if (Application.isCommandLineSwitchEnabled((String)"-promptForPassword")) {
            if (flowContext.getFlowExecutionType() == FlowExecutorType.SILENT) {
                try {
                    password = PasswordHelper.getPassword((String)this.resource.getString("Password.Prompt.Text", "\nEnter Oracle Home User Password: ", new Object[0]));
                }
                catch (IOException ioe) {
                    this.logger.log(Level.SEVERE, ioe.getMessage());
                }
                bean.setPassword(String.valueOf(password));
                Arrays.fill(password, ' ');
            } else {
                System.out.println("WARNING: -promptForPassword option is supported in silent mode only.");
                this.logger.log(Level.INFO, "WARNING: -promptForPassword option is supported in silent mode only.");
            }
        }
        String userName = bean.getUserName();
        String passWord = bean.getPassword();
        if (!bean.isDeclineOption() && userName != null && Boolean.getBoolean("oracle.installer.silent")) {
            if (WinHelper.UserExists(userName, passWord)) {
                bean.setExistingUser(true);
            } else {
                bean.setExistingUser(false);
            }
        }
    }
}

