/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.asm.util.kfod;

import java.util.ArrayList;
import java.util.List;
import oracle.install.asm.util.Disk;
import oracle.install.asm.util.DiskHeaderStatus;
import oracle.install.asm.util.kfod.Helper;
import oracle.install.asm.util.kfod.KFODOpOutputParser;
import oracle.install.commons.bean.TypeTranslator;

class DiskOpOutputParser
extends KFODOpOutputParser {
    private List<Disk> disks = new ArrayList<Disk>();

    @Override
    public void parseLine(String line) {
        Disk disk = this.parseDisk(line);
        if (disk != null) {
            this.disks.add(disk);
        }
    }

    public List<Disk> getDisks() {
        return this.disks;
    }

    private Disk parseDisk(String line) {
        Disk disk = null;
        String[] tokens = Helper.tokenize(line);
        if (tokens.length == 3 || tokens.length == 5) {
            try {
                long size = Long.parseLong(tokens[0].trim());
                DiskHeaderStatus headerStatus = (DiskHeaderStatus)((Object)TypeTranslator.translate((String)tokens[1].trim(), DiskHeaderStatus.class));
                String path = tokens[2].trim();
                disk = new Disk(path, size, headerStatus);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return disk;
    }
}

