/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.prereqs;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefHost;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import oracle.sysman.prov.prereqs.PortHandlerUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PortChecks {
    private static final int MAX_PORT_VALUE = 65536;
    private static final int MIN_PORT_VALUE = 0;

    private PortChecks() {
    }

    public static OipcrIResult checkPortAvailability(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        Hashtable usedPorts = PortHandlerUtil.getBusyPorts();
        if (oRulesEngine != null) {
            try {
                ArrayList<OipcrResultDetails> oResDetails;
                OipcrIResult oRes;
                String expected;
                String actual;
                OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                Node oPortNode = oGenRefHost.getNode("PORT");
                if (oPortNode != null) {
                    NamedNodeMap oPortAttributes = null;
                    Node oAttrib = null;
                    String value = null;
                    String beginVal = null;
                    String endVal = null;
                    actual = null;
                    expected = null;
                    oRes = null;
                    String recommendedPortsStr = "";
                    boolean isAvailable = false;
                    boolean isPortVar = false;
                    String portValue = null;
                    oPortAttributes = oPortNode.getAttributes();
                    for (int i = 0; i < oPortAttributes.getLength(); ++i) {
                        OiisVariable oVar;
                        oAttrib = oPortAttributes.item(i);
                        if (!isAvailable && oAttrib != null && oAttrib.getNodeName() != null && oAttrib.getNodeName().equals("VALUE")) {
                            value = oAttrib.getNodeValue();
                            if (usedPorts.keySet().contains(value)) {
                                isAvailable = false;
                                System.out.println("Port: " + value + " is already taken up by installed Oracle Home. Config file path is : " + usedPorts.get(value));
                            } else {
                                isAvailable = PortChecks.isPortFree(value);
                            }
                            expected = value;
                            if (isAvailable) {
                                actual = value;
                                oRes = OipcrResult.PASSED_RESULT;
                                continue;
                            }
                            oRes = OipcrResult.FAILED_RESULT;
                            continue;
                        }
                        if (!isAvailable && oAttrib != null && oAttrib.getNodeName() != null && oAttrib.getNodeName().equals("ATLEAST")) {
                            String freePort = null;
                            beginVal = oAttrib.getNodeValue();
                            oAttrib = oPortAttributes.getNamedItem("ATMOST");
                            endVal = String.valueOf(65536);
                            if (oAttrib != null) {
                                endVal = oAttrib.getNodeValue();
                            }
                            freePort = PortChecks.getFreePortInRange(beginVal, endVal, usedPorts);
                            expected = beginVal + "-" + endVal;
                            if (freePort != null) {
                                actual = freePort;
                                oRes = OipcrResult.PASSED_RESULT;
                                isAvailable = true;
                                continue;
                            }
                            freePort = PortChecks.getFreePortInRange(endVal, String.valueOf(65536), usedPorts);
                            if (freePort != null) {
                                oRes = OipcrResult.PASSED_RESULT;
                                isAvailable = true;
                                continue;
                            }
                            oRes = OipcrResult.FAILED_RESULT;
                            isAvailable = false;
                            continue;
                        }
                        if (isAvailable || oAttrib == null || oAttrib.getNodeName() == null || !oAttrib.getNodeName().equals("VAR")) continue;
                        String portVar = oAttrib.getNodeValue();
                        if (portVar != null && (oVar = oContext.getVariable(portVar)) != null) {
                            portValue = (String)oVar.getValue();
                        }
                        if (portValue != null) {
                            System.out.println("Port Value specified by user " + portValue);
                            if (usedPorts.contains(portValue)) {
                                isAvailable = false;
                                System.out.println("Port: " + portValue + " is already taken up by installed Oracle Home. Config file path is : " + usedPorts.get(portValue));
                            } else {
                                isAvailable = PortChecks.isPortFree(portValue);
                            }
                        }
                        expected = portValue;
                        if (isAvailable) {
                            System.out.println("Port specified by user " + portValue + " is available");
                            actual = portValue;
                            oRes = OipcrResult.PASSED_RESULT;
                        } else {
                            System.out.println("Port specified by user " + portValue + " is not available");
                            oRes = OipcrResult.FAILED_RESULT;
                            isPortVar = true;
                        }
                        if (portValue == null || portValue.trim().equals("")) continue;
                        if (isAvailable) break;
                        recommendedPortsStr = PortChecks.getRecommendedPort(oPortNode);
                        break;
                    }
                    oResDetails = new ArrayList<OipcrResultDetails>();
                    if (actual == null) {
                        actual = isPortVar ? OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_PROVIDED_PORT_UNAVAILABLE", (Object[])new String[]{portValue}) : OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_PORT_NOT_AVAILABLE");
                        actual = actual + " " + recommendedPortsStr;
                    } else {
                        actual = OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_PORT_AVAILABLE", (Object[])new String[]{actual});
                    }
                } else {
                    Object[] args = new String[]{sRefFile};
                    throw new OipcrExecuteRuleException("S_NO_PORT_TAGS_FOUND_FOR_CHECK", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_PORT_TAGS_FOUND_FOR_CHECK", (Object[])args));
                }
                oResDetails.add(new OipcrResultDetails((Object)actual, expected, oRes));
                oResult = new OipcrResult(oResDetails);
            }
            catch (UnknownHostException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("S_UNKNOWN_HOST_EXEPTION_BEFORE_CHECK", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_UNKNOWN_HOST_EXEPTION_BEFORE_CHECK"), (Throwable)e));
            }
            catch (OipcrExecuteRuleException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckNoReferenceSpecifiedException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownBuilderException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    private static String getRecommendedPort(Node oPortNode) {
        String returnVal;
        block15: {
            Hashtable usedPorts = PortHandlerUtil.getBusyPorts();
            returnVal = "";
            String portVal = null;
            Node oAttrib = null;
            if (oPortNode != null) {
                NamedNodeMap oPortAttributes = oPortNode.getAttributes();
                oAttrib = oPortAttributes.getNamedItem("VALUE");
                if (oAttrib != null) {
                    portVal = oAttrib.getNodeValue();
                }
                try {
                    String freePort = null;
                    System.out.println("Checking if port " + portVal + " is free");
                    if (usedPorts.keySet().contains(portVal)) {
                        System.out.println("Port: " + portVal + " is already taken up by installed Oracle Home.emd config file path is : " + usedPorts.get(portVal));
                    }
                    if (!usedPorts.keySet().contains(portVal) && PortChecks.isPortFree(portVal)) {
                        System.out.println("Port " + portVal + " is free");
                        freePort = portVal;
                    } else {
                        System.out.println("Port " + portVal + " is not free.");
                        String beginRange = null;
                        String endRange = null;
                        oAttrib = oPortAttributes.getNamedItem("ATLEAST");
                        if (oAttrib != null) {
                            beginRange = oAttrib.getNodeValue();
                        }
                        if ((oAttrib = oPortAttributes.getNamedItem("ATMOST")) != null) {
                            endRange = oAttrib.getNodeValue();
                        }
                        if (beginRange == null) {
                            returnVal = "";
                            return returnVal;
                        }
                        if (endRange == null) {
                            freePort = PortChecks.getFreePortInRange(beginRange, String.valueOf(65536), usedPorts);
                        } else {
                            System.out.println("begin range-" + beginRange + ".end range-" + endRange);
                            freePort = PortChecks.getFreePortInRange(beginRange, endRange, usedPorts);
                            if (freePort == null) {
                                freePort = PortChecks.getFreePortInRange(endRange, String.valueOf(65536), usedPorts);
                            }
                        }
                    }
                    if (freePort == null) {
                        System.out.println("Checks complete, no free port found..");
                        returnVal = OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_PORTS_ARE_AVAILABLE");
                        break block15;
                    }
                    System.out.println("Checks complete : free port found " + freePort);
                    returnVal = OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_USE_THIS_FREE_PORT", (Object[])new String[]{freePort});
                }
                catch (UnknownHostException unknownHostException) {
                    returnVal = "";
                }
            } else {
                returnVal = "";
            }
        }
        return returnVal;
    }

    public static boolean isANumber(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isPortValid(String port) {
        if (port == null || port.length() == 0) {
            return false;
        }
        return PortChecks.isANumber(port) && Integer.parseInt(port) > 0 && Integer.parseInt(port) <= 65536;
    }

    public static boolean isPortFree(int port) throws UnknownHostException {
        ServerSocket s = null;
        InetAddress[] allHostInetAddresses = null;
        InetAddress localInetAddress = null;
        localInetAddress = InetAddress.getLocalHost();
        String hostName = localInetAddress.getHostName();
        allHostInetAddresses = InetAddress.getAllByName(hostName);
        localInetAddress = InetAddress.getByName("127.0.0.1");
        try {
            if (allHostInetAddresses != null) {
                for (int i = 0; i < allHostInetAddresses.length; ++i) {
                    s = new ServerSocket(port, 0, allHostInetAddresses[i]);
                    s.close();
                    s = null;
                }
            }
            if (localInetAddress != null) {
                s = new ServerSocket(port, 0, localInetAddress);
                s.close();
                s = null;
            }
            s = new ServerSocket(port);
            s.close();
            s = null;
        }
        catch (IOException ioe) {
            System.out.println(" Port : " + port + " is in use by a process.");
            return false;
        }
        return true;
    }

    public static boolean isPortFree(String port) throws UnknownHostException {
        if (!PortChecks.isPortValid(port)) {
            return false;
        }
        return PortChecks.isPortFree(Integer.parseInt(port));
    }

    public static String getFreePortInRange(int beginrange, int endrange, Hashtable usedPorts) throws UnknownHostException {
        System.out.println("Trying to search a free port in range : " + beginrange + " to " + endrange);
        if (beginrange < 0 || endrange > 65536 || beginrange > endrange) {
            return null;
        }
        for (int i = beginrange; i <= endrange; ++i) {
            if (usedPorts.keySet().contains(i + "")) {
                System.out.println("Port: " + i + " is already taken up by installed Oracle Home. Config file path is : " + usedPorts.get(i + ""));
                continue;
            }
            if (!PortChecks.isPortFree(i)) continue;
            return Integer.toString(i);
        }
        return null;
    }

    public static String getFreePortInRange(String beginrange, String endrange, Hashtable usedPorts) throws UnknownHostException {
        System.out.println("Check if port ranges " + beginrange + " to " + endrange + " are valid");
        if (!PortChecks.isPortValid(beginrange) || !PortChecks.isPortValid(endrange)) {
            System.out.println("Invalid ranges found.. returning..");
            return null;
        }
        return PortChecks.getFreePortInRange(Integer.parseInt(beginrange), Integer.parseInt(endrange), usedPorts);
    }
}

