/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiix.OiixAssert;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectPackageFormatException;
import oracle.sysman.oip.oipc.oipch.OipchSolarisPackage;

public class OipchSolarisPackageReader {
    private static final String PKGINST = "PKGINST";
    private static final String NAME = "NAME";
    private static final String CATEGORY = "CATEGORY";
    private static final String ARCH = "ARCH";
    private static final String VERSION = "VERSION";
    private static final String BASEDIR = "BASEDIR";
    private static final String VENDOR = "VENDOR";
    private static final String DESC = "DESC";
    private static final String PSTAMP = "PSTAMP";
    private static final String INSTDATE = "INSTDATE";
    private static final String STATUS = "STATUS";
    private static final int START_STATE = 0;
    private static final int NAME_STATE = 1;
    private static final int VALUE_STATE = 2;

    private OipchSolarisPackageReader() {
    }

    static Collection readPackageDetails(String sFile) throws IOException {
        String currentLine;
        BufferedReader reader = new BufferedReader(new FileReader(sFile));
        ArrayList<OipchSolarisPackage> oPackages = new ArrayList<OipchSolarisPackage>();
        OipchSolarisPackage oPackage = null;
        while ((currentLine = reader.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(currentLine, " \t", false);
            oPackage = new OipchSolarisPackage();
            String str = st.nextToken().trim();
            oPackage.setCategory(str);
            str = st.nextToken().trim();
            oPackage.setName(str);
            StringBuffer sb = new StringBuffer();
            while (st.hasMoreTokens()) {
                sb.append(st.nextToken()).append(" ");
            }
            oPackage.setExternalName(sb.toString().trim());
            oPackages.add(oPackage);
        }
        reader.close();
        return oPackages;
    }

    static Collection readAllPackageDetails(String sFile) throws IOException {
        String currentLine;
        BufferedReader reader = new BufferedReader(new FileReader(sFile));
        ArrayList<OipchSolarisPackage> oPackages = new ArrayList<OipchSolarisPackage>();
        OipchSolarisPackage oPackage = null;
        while ((currentLine = reader.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(currentLine, ":", false);
            int state = 0;
            String sName = "";
            String sValue = "";
            while (st.hasMoreTokens()) {
                String str = st.nextToken().trim();
                switch (state) {
                    case 0: {
                        sName = str;
                        state = 1;
                        break;
                    }
                    case 1: {
                        sValue = str;
                        state = 2;
                        if (sName.equals(PKGINST)) {
                            oPackage = new OipchSolarisPackage();
                            oPackage.setName(sValue);
                            oPackages.add(oPackage);
                            break;
                        }
                        if (sName.equals(NAME)) {
                            oPackage.setExternalName(sValue);
                            break;
                        }
                        if (sName.equals(CATEGORY)) {
                            oPackage.setCategory(sValue);
                            break;
                        }
                        if (sName.equals(ARCH)) {
                            oPackage.setArch(sValue);
                            break;
                        }
                        if (sName.equals(VERSION)) {
                            try {
                                oPackage.setProperty(VERSION, sValue);
                            }
                            catch (OipchIncorrectPackageFormatException e) {
                                OiixAssert.assertion((boolean)true, (String)e.getMessage());
                            }
                            break;
                        }
                        if (sName.equals(BASEDIR)) {
                            oPackage.setBaseDirectory(sValue);
                            break;
                        }
                        if (sName.equals(VENDOR)) {
                            oPackage.setVendor(sValue);
                            break;
                        }
                        if (sName.equals(DESC)) {
                            oPackage.setDescription(sValue);
                            break;
                        }
                        if (sName.equals(PSTAMP)) {
                            oPackage.setPStamp(sValue);
                            break;
                        }
                        if (sName.equals(INSTDATE)) {
                            sValue = sValue + ":" + st.nextToken().trim();
                            try {
                                oPackage.setInstallDate(sValue);
                            }
                            catch (ParseException parseException) {}
                            break;
                        }
                        if (!sName.equals(STATUS)) break;
                        try {
                            oPackage.setInstallStatus(sValue);
                            break;
                        }
                        catch (OipchIncorrectPackageFormatException oipchIncorrectPackageFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
            state = 0;
        }
        reader.close();
        return oPackages;
    }
}

