/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oip.oipc.oipch.OipchAIXOSCreator;
import oracle.sysman.oip.oipc.oipch.OipchDECOSCreator;
import oracle.sysman.oip.oipc.oipch.OipchHPOSCreator;
import oracle.sysman.oip.oipc.oipch.OipchLinuxOSCreator;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchSolarisOSCreator;
import oracle.sysman.oip.oipc.oipch.OipchVersion;
import oracle.sysman.oip.oipc.oipch.OipchWindowsOSCreator;

abstract class OipchOSCreator {
    protected OipchOS m_oOS;
    protected int m_iPlatID = 0;

    protected OipchOSCreator(int iPlatID) {
        this.m_iPlatID = iPlatID;
    }

    protected abstract OipchOS createOS();

    static OipchOSCreator getCreator() {
        OipchOSCreator oOSCreator = null;
        int iPlat = OiixPlatform.getCurrentPlatform();
        switch (iPlat) {
            case 173: 
            case 453: {
                oOSCreator = new OipchSolarisOSCreator(iPlat);
                break;
            }
            case 46: 
            case 110: 
            case 211: 
            case 227: 
            case 525: {
                oOSCreator = new OipchLinuxOSCreator(iPlat);
                break;
            }
            case 2: 
            case 197: {
                oOSCreator = new OipchHPOSCreator(iPlat);
                break;
            }
            case 610: {
                oOSCreator = new OipchAIXOSCreator(iPlat);
                break;
            }
            case 87: {
                oOSCreator = new OipchDECOSCreator(iPlat);
                break;
            }
            case 208: 
            case 233: 
            case 912: {
                oOSCreator = new OipchWindowsOSCreator(iPlat);
            }
        }
        return oOSCreator;
    }

    final OipchOS getOS() {
        if (this.m_oOS == null) {
            this.m_oOS = this.createOS();
        }
        return this.m_oOS;
    }

    protected void updateOSInfo(OipchOS oOS) {
        oOS.setPlatformID(OiixPlatform.getCurrentPlatform());
        oOS.setOSName(OiixPlatform.getCurrentPlatformOSName());
        oOS.setOSVersion(new OipchVersion(OiixPlatform.getCurrentPlatformOSVer()));
        oOS.setOSArch(OiixPlatform.getCurrentPlatformArch());
    }
}

