/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import oracle.i18n.text.OraBoot;
import oracle.i18n.text.OraCollator;
import oracle.i18n.text.OraLanguage;
import oracle.i18n.text.OraMapTable;
import oracle.i18n.text.OraTerritory;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.LocaleMapper;
import oracle.i18n.util.Sort;

public class OraLocaleInfo {
    static final String ORA_DEFAULT_LANGUAGE = "AMERICAN";
    static final String ORA_DEFAULT_TERRITORY = "AMERICA";
    static final String ORA_DISPLAYLOCALE_NAME = "oracle.i18n.util.OraDisplayLocaleInfo";
    private static final OraMapTable ISO_ORACLE_NAME_MAPPING = OraMapTable.getInstance(1);
    private static final char M_C_DASH_CHAR = '-';
    private static final char M_C_UNDERBAR_CHAR = '_';
    private static final char M_C_ASTARISK = '*';
    private static final String M_C_LINGUISTIC_SORT_SEP = "-";
    private static final String[] m_ncharCharacterSets = new String[]{"AL16UTF16", "UTF8"};
    private static final String[][] m_commonCharsetsUnicode = new String[][]{{"AL32UTF8", "UTF8"}, m_ncharCharacterSets};
    private static final transient Map m_localTimeZonesMap = new HashMap();
    private static final String[] m_recommendedEBCDICDBCSs = new String[]{"AR8EBCDIC420S", "BLT8EBCDIC1112S", "CE8BS2000", "CL8BS2000", "CL8EBCDIC1025R", "CL8EBCDIC1158R", "D8EBCDIC1141", "DK8EBCDIC1142", "EE8BS2000", "EE8EBCDIC870S", "EL8EBCDIC423R", "EL8EBCDIC875R", "F8EBCDIC1147", "I8EBCDIC1144", "IW8EBCDIC424S", "JA16DBCS", "JA16EBCDIC930", "KO16DBCS", "S8EBCDIC1143", "TH8TISEBCDICS", "TR8EBCDIC1026S", "WE8BS2000", "WE8BS2000E", "WE8BS2000L5", "WE8EBCDIC1047E", "WE8EBCDIC1140", "WE8EBCDIC1145", "WE8EBCDIC1146", "WE8EBCDIC1148"};
    private static final String[] m_recommendedASCIIDBCSs = new String[]{"AL32UTF8", "AR8ISO8859P6", "AR8MSWIN1256", "BLT8ISO8859P13", "BLT8MSWIN1257", "CL8ISO8859P5", "CL8MSWIN1251", "EE8ISO8859P2", "EE8MSWIN1250", "EL8ISO8859P7", "EL8MSWIN1253", "IW8ISO8859P8", "IW8MSWIN1255", "JA16EUC", "JA16EUCTILDE", "JA16SJIS", "JA16SJISTILDE", "KO16MSWIN949", "NE8ISO8859P10", "NEE8ISO8859P4", "TH8TISASCII", "TR8MSWIN1254", "VN8MSWIN1258", "WE8ISO8859P15", "WE8ISO8859P9", "WE8MSWIN1252", "ZHS16GBK", "ZHT16HKSCS", "ZHT16MSWIN950", "ZHT32EUC"};
    private static transient OraLocaleInfo m_defobj;
    private final OraLanguage m_olang;
    private final OraTerritory m_oterr;
    private OraCollator m_ocoll = null;

    private OraLocaleInfo(String string, String string2, String string3) throws UnsupportedEncodingException {
        this(string, string2);
        if (string3 == null || string3.equals("")) {
            return;
        }
        int n = string3.indexOf(M_C_LINGUISTIC_SORT_SEP);
        if (n < 0) {
            this.setOraCollator(OraCollator.getInstance((String)string3));
        } else {
            this.setOraCollator(OraCollator.getInstance((String)string3.substring(0, n), (String)string3.substring(n + M_C_LINGUISTIC_SORT_SEP.length())));
        }
    }

    private OraLocaleInfo(String string, String string2) {
        OraBoot oraBoot = OraBoot.getInstance();
        this.m_olang = string == null || string.equals("") ? OraLanguage.getInstance(ORA_DEFAULT_LANGUAGE) : OraLanguage.getInstance(string);
        this.m_oterr = string2 == null || string2.equals("") ? OraTerritory.getInstance(oraBoot.getTerritoryName(this.m_olang.getDefaultTerritoryId())) : OraTerritory.getInstance(string == null ? "" : string, string2);
    }

    public static OraLocaleInfo getInstance(String string, String string2, String string3) {
        try {
            OraLocaleInfo oraLocaleInfo = new OraLocaleInfo(string, string2, string3);
            if (oraLocaleInfo.m_olang == null || oraLocaleInfo.m_oterr == null) {
                return null;
            }
            return oraLocaleInfo;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            int n = string3.indexOf(M_C_LINGUISTIC_SORT_SEP);
            throw new IllegalStateException(GDKMessage.getMessage(5210, n < 0 ? null : string3.substring(n + M_C_LINGUISTIC_SORT_SEP.length())));
        }
    }

    public static OraLocaleInfo getInstance(String string, String string2) {
        OraLocaleInfo oraLocaleInfo = new OraLocaleInfo(string, string2);
        if (oraLocaleInfo.m_olang == null || oraLocaleInfo.m_oterr == null) {
            return null;
        }
        return oraLocaleInfo;
    }

    public static OraLocaleInfo getInstance(Locale locale) {
        String string = LocaleMapper.getOraLanguage(locale);
        if (string == null) {
            string = ORA_DEFAULT_LANGUAGE;
        }
        String string2 = LocaleMapper.getOraTerritory(locale);
        return new OraLocaleInfo(string, string2);
    }

    public Locale getLocale() {
        return LocaleMapper.getJavaLocale(this.m_olang.getName(), this.m_oterr.getName());
    }

    public String getLanguage() {
        return this.m_olang.getName();
    }

    public String getTerritory() {
        return this.m_oterr.getName();
    }

    public String getLinguisticSort() {
        String string = this.getOraCollator().getName().toUpperCase(Locale.US);
        if (string.startsWith("BINARY")) {
            return string + M_C_LINGUISTIC_SORT_SEP + this.getOraCollator().getCharSet();
        }
        return string;
    }

    public int getWritingDirection() {
        return this.m_olang.getWritingDirection().startsWith("Left_To_Right") ? 0 : 1;
    }

    public String getShortLanguage() {
        return this.m_olang.getISOAbbreviation();
    }

    public String[] getLocalCharacterSets() {
        return this.getLocalCharacterSets(7);
    }

    public String[] getLocalCharacterSets(int n) {
        switch (n) {
            case 6: {
                return this.m_olang.getLocalCharsetsWin();
            }
            case 7: {
                return this.m_olang.getLocalCharacterSets();
            }
        }
        return this.m_olang.getLocalCharacterSets();
    }

    public static String[] getLocalCharacterSets(String string) {
        return OraLocaleInfo.getLocalCharacterSets(string, 7);
    }

    public static String[] getLocalCharacterSets(String string, int n) {
        OraLanguage oraLanguage = OraLanguage.getInstance(string);
        if (oraLanguage == null) {
            return null;
        }
        switch (n) {
            case 6: {
                return oraLanguage.getLocalCharsetsWin();
            }
            case 7: {
                return oraLanguage.getLocalCharacterSets();
            }
        }
        return oraLanguage.getLocalCharacterSets();
    }

    public static String[][] getLocalCommonCharacterSets(String string) {
        if (string == null || string.length() == 0) {
            return m_commonCharsetsUnicode;
        }
        int n = (string.equalsIgnoreCase("japanese") || string.equalsIgnoreCase("vietnamese")) && !System.getProperty("os.name").startsWith("Windows") ? 7 : 6;
        String[] stringArray = OraLocaleInfo.getLocalCharacterSets(string, n);
        return new String[][]{stringArray, m_ncharCharacterSets};
    }

    public static String[] getLocalLinguisticSorts(String string) {
        OraLanguage oraLanguage = OraLanguage.getInstance(string);
        return oraLanguage != null ? oraLanguage.getLocalLinguisticSorts() : null;
    }

    public String[] getLocalLinguisticSorts() {
        return this.m_olang.getLocalLinguisticSorts();
    }

    public static String[] getLocalCurrencies(String string) {
        OraTerritory oraTerritory = OraTerritory.getInstance(string);
        if (oraTerritory == null) {
            return null;
        }
        return new String[]{oraTerritory.getInternationalCurrencySymbol()};
    }

    public String[] getLocalCurrencies() {
        return new String[]{this.m_oterr.getInternationalCurrencySymbol()};
    }

    public static String getCurrencySymbol(String string) {
        String string2 = (String)CachedISO4217toSymbolMap.getInstance().getMap().get(string);
        if (string2 != null) {
            return string2;
        }
        return "";
    }

    public String getCurrencySymbol() {
        return this.m_oterr.getLocalCurrencySymbol();
    }

    public String[] getLocalTerritories() {
        return this.m_olang.getLocalTerritories();
    }

    public static String[] getLocalTerritories(String string) {
        OraLanguage oraLanguage = OraLanguage.getInstance(string);
        return oraLanguage != null ? oraLanguage.getLocalTerritories() : null;
    }

    public String[] getLocalLanguages() {
        return this.m_oterr.getLocalLanguages();
    }

    public static String[] getLocalLanguages(String string) {
        OraTerritory oraTerritory = OraTerritory.getInstance(string);
        return oraTerritory != null ? oraTerritory.getLocalLanguages() : null;
    }

    public static TimeZone[] getLocalTimeZones(String string) {
        OraTerritory oraTerritory = OraTerritory.getInstance(string);
        return oraTerritory != null ? OraLocaleInfo.getLocalTimeZonesByOraTerritory(oraTerritory) : null;
    }

    public TimeZone[] getLocalTimeZones() {
        return OraLocaleInfo.getLocalTimeZonesByOraTerritory(this.m_oterr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TimeZone[] getLocalTimeZonesByOraTerritory(OraTerritory oraTerritory) {
        TimeZone[] timeZoneArray;
        if (m_localTimeZonesMap != null && (timeZoneArray = (TimeZone[])m_localTimeZonesMap.get(oraTerritory)) != null) {
            return timeZoneArray;
        }
        timeZoneArray = null;
        Map map = m_localTimeZonesMap;
        synchronized (map) {
            timeZoneArray = (TimeZone[])m_localTimeZonesMap.get(oraTerritory);
            if (timeZoneArray != null) {
                return timeZoneArray;
            }
            String[] stringArray = oraTerritory.getLocalTimeZoneIds();
            timeZoneArray = new TimeZone[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                timeZoneArray[i] = TimeZone.getTimeZone(stringArray[i] != null ? stringArray[i] : "UTC");
            }
            m_localTimeZonesMap.put(oraTerritory, timeZoneArray);
        }
        return timeZoneArray;
    }

    public static String[] getAvailableLocale() {
        return CachedCommonOraLocales.getInstance().getArray();
    }

    public static TimeZone[] getCommonTimeZones() {
        return CachedCommonTimeZones.getInstance().getArray();
    }

    public static String[] getCommonTimeZoneIDs() {
        OraMapTable oraMapTable = OraMapTable.getInstance(4);
        return oraMapTable.getStringArrayAttribute("COMMON_TIMEZONES");
    }

    public static Locale[] getCommonLocales() {
        return CachedCommonLocales.getInstance().getArray();
    }

    public static Locale[] getCommonLocales(Locale locale) {
        List list = (List)OraLocaleInfo.callStaticMethod(ORA_DISPLAYLOCALE_NAME, "getCommonLocales", new Class[]{Locale.class}, new Object[]{locale});
        return list != null ? list.toArray(new Locale[0]) : OraLocaleInfo.getCommonLocales();
    }

    public static Locale[] getCommonDisplayLocales() {
        return CachedCommonDisplayLocales.getInstance().getArray();
    }

    public static String[] getAvailableLanguages() {
        return OraBoot.getInstance().availableLanguages();
    }

    public static String[][] getAvailableLanguages(Locale locale) {
        String[][] stringArray = (String[][])OraLocaleInfo.callStaticMethod(ORA_DISPLAYLOCALE_NAME, "getAvailableLanguages", new Class[]{Locale.class}, new Object[]{locale});
        if (stringArray != null) {
            return stringArray;
        }
        String[] stringArray2 = OraLocaleInfo.getAvailableLanguages();
        stringArray = new String[2][stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray[0][i] = stringArray2[i];
            stringArray[1][i] = stringArray2[i];
        }
        return stringArray;
    }

    public static String[] getAvailableTerritories() {
        return OraBoot.getInstance().availableTerritories();
    }

    public static String[][] getAvailableTerritories(Locale locale) {
        String[][] stringArray = (String[][])OraLocaleInfo.callStaticMethod(ORA_DISPLAYLOCALE_NAME, "getAvailableTerritories", new Class[]{Locale.class}, new Object[]{locale});
        if (stringArray != null) {
            return stringArray;
        }
        String[] stringArray2 = OraLocaleInfo.getAvailableTerritories();
        stringArray = new String[2][stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray[0][i] = stringArray2[i];
            stringArray[1][i] = stringArray2[i];
        }
        return stringArray;
    }

    public static String[] getAvailableCharacterSets() {
        return OraBoot.getInstance().availableCharacterSets();
    }

    public static String[] getAvailableCurrencies() {
        return CachedISO4217toSymbolMap.getInstance().getKeyArray();
    }

    public static String[] getAvailableLinguisticSorts() {
        return OraBoot.getInstance().availableLinguisticSorts();
    }

    public static boolean isEBCDIC() {
        byte[] byArray = "A".getBytes();
        return byArray[0] == -63;
    }

    public static String[] getAvailableDBCharacterSets() {
        if (OraLocaleInfo.isEBCDIC()) {
            List list = OraBoot.getInstance().getCharSetIsEbcdic();
            return list.toArray(new String[0]);
        }
        List list = OraBoot.getInstance().getCharSetIsAscii();
        String[] stringArray = list.toArray(new String[0]);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = OraBoot.getInstance().getCharSetId(stringArray[i]);
            int n = new Integer(string);
            if (!LocaleMapper.isSupersetOf(1, n) || n == 992 || n == 854) continue;
            arrayList.add(stringArray[i]);
        }
        arrayList.add("US7ASCII");
        return arrayList.toArray(new String[0]);
    }

    public static String[] getRecommendedDBCharacterSets() {
        if (OraLocaleInfo.isEBCDIC()) {
            return m_recommendedEBCDICDBCSs;
        }
        return m_recommendedASCIIDBCSs;
    }

    public static String[] getAvailableNationalCharacterSets() {
        return m_ncharCharacterSets;
    }

    public int getStartDayOfTheWeek() {
        return this.m_oterr.getStartDayOfTheWeek().charAt(0) - 48;
    }

    public static int getStartDayOfTheWeek(String string) {
        return OraTerritory.getInstance(string).getStartDayOfTheWeek().charAt(0) - 48;
    }

    public static int getStartDayOfTheWeek(String string, String string2) {
        return OraTerritory.getInstance(string, string2).getStartDayOfTheWeek().charAt(0) - 48;
    }

    public Object clone() {
        try {
            return OraLocaleInfo.getInstance(this.m_olang.getName(), this.m_oterr.getName(), this.getOraCollator().getName() + M_C_LINGUISTIC_SORT_SEP + this.getOraCollator().getCharSet());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException("OraCollator object is invalid");
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof OraLocaleInfo)) {
            return false;
        }
        OraLocaleInfo oraLocaleInfo = (OraLocaleInfo)object;
        return this.m_olang == oraLocaleInfo.m_olang && this.m_oterr == oraLocaleInfo.m_oterr && this.getOraCollator().equals((Object)oraLocaleInfo.getOraCollator());
    }

    public static OraLocaleInfo getDefault() {
        if (m_defobj == null) {
            m_defobj = new OraLocaleInfo(null, null);
        }
        return m_defobj;
    }

    public String toString() {
        return this.m_olang.getName() + "_" + this.m_oterr.getName() + "_" + this.getOraCollator().getName() + M_C_LINGUISTIC_SORT_SEP + this.getOraCollator().getCharSet();
    }

    public int hashCode() {
        int n = 17;
        try {
            n = 37 * n + Integer.parseInt(this.m_olang.getId());
            n = 37 * n + Integer.parseInt(this.m_oterr.getId());
            n = 37 * n + this.getOraCollator().hashCode();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public OraLanguage getOraLanguage() {
        return this.m_olang;
    }

    public OraTerritory getOraTerritory() {
        return this.m_oterr;
    }

    public synchronized OraCollator getOraCollator() {
        if (this.m_ocoll != null) {
            return this.m_ocoll;
        }
        OraBoot oraBoot = OraBoot.getInstance();
        try {
            String string = this.m_olang.getDefaultLinguisticId();
            this.m_ocoll = string.equals("0") ? OraCollator.getInstance((String)"BINARY", (String)oraBoot.getCharSetName(this.m_olang.getDefaultCharSetId())) : OraCollator.getInstance((String)oraBoot.getLinguisticName(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                this.m_ocoll = OraCollator.getInstance((String)"BINARY", (String)oraBoot.getCharSetName(this.m_olang.getDefaultCharSetId()));
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                throw new IllegalStateException(illegalArgumentException2.getMessage());
            }
        }
        return this.m_ocoll;
    }

    private void setOraCollator(OraCollator oraCollator) {
        this.m_ocoll = oraCollator;
    }

    public static Locale getLocaleFromString(String string) {
        return LocaleMapper.getLocaleFromString(string);
    }

    public static Locale[] getLocalesFromString(String string) {
        Object object;
        String string2;
        String string3;
        String string42;
        if (string.indexOf(42) < 0) {
            return new Locale[]{OraLocaleInfo.getLocaleFromString(string)};
        }
        int n = string.indexOf(45);
        int n2 = string.indexOf(95, n + 1);
        if (n < 0 && n2 > 0) {
            n = n2;
            n2 = string.indexOf(95, n + 1);
        }
        if (n < 0) {
            return OraLocaleInfo.getCommonLocales();
        }
        if (n2 < 0) {
            string42 = string.substring(0, n);
            string3 = string.substring(n + 1);
            string2 = "";
        } else {
            string42 = string.substring(0, n);
            string3 = string.substring(n + 1, n2);
            string2 = string.substring(n2 + 1);
        }
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        TreeSet<String> treeSet = new TreeSet<String>();
        if ('*' == string42.charAt(0)) {
            object = OraLocaleInfo.getAvailableLanguages();
            for (int i = 0; i < ((String[])object).length; ++i) {
                treeSet.add(LocaleMapper.getJavaLangFromOraLang(object[i]));
            }
        } else {
            treeSet.add(string42);
        }
        object = new TreeSet();
        if ('*' == string3.charAt(0)) {
            String[] stringArray = OraLocaleInfo.getAvailableTerritories();
            for (int i = 0; i < stringArray.length; ++i) {
                object.add(LocaleMapper.getJavaTerrFromOraTerr(stringArray[i]));
            }
        } else {
            object.add(string3);
        }
        if (treeSet.size() == 1) {
            arrayList.add(new Locale((String)treeSet.first(), "", string2));
        }
        for (String string42 : treeSet) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                arrayList.add(new Locale(string42, string3, string2));
            }
        }
        return arrayList.toArray(new Locale[0]);
    }

    private static Object callStaticMethod(String string, String string2, Class[] classArray, Object[] objectArray) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz.getMethod(string2, classArray).invoke((Object)classArray, objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static class CachedCommonOraLocales {
        private static final CachedCommonOraLocales m_sing = new CachedCommonOraLocales();
        private final String[] m_oraLocales;

        private CachedCommonOraLocales() {
            Locale[] localeArray = OraLocaleInfo.getCommonLocales();
            this.m_oraLocales = new String[localeArray.length];
            for (int i = 0; i < localeArray.length; ++i) {
                this.m_oraLocales[i] = LocaleMapper.getOraLocale(localeArray[i]);
            }
        }

        public static CachedCommonOraLocales getInstance() {
            return m_sing;
        }

        public String[] getArray() {
            return this.m_oraLocales;
        }
    }

    private static class CachedCommonLocales {
        protected static final OraMapTable COMMON_LOCALES = OraMapTable.getInstance(1);
        protected static final CachedCommonLocales m_sing = new CachedCommonLocales();
        protected final Locale[] m_locarTrans;

        private CachedCommonLocales() {
            String[] stringArray = COMMON_LOCALES.getStringArrayAttribute("COMMON_LOCALES");
            this.m_locarTrans = new Locale[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.m_locarTrans[i] = OraLocaleInfo.getLocaleFromString(stringArray[i]);
            }
        }

        public static CachedCommonLocales getInstance() {
            return m_sing;
        }

        public Locale[] getArray() {
            return this.m_locarTrans;
        }
    }

    private static class CachedCommonDisplayLocales {
        private static final OraMapTable COMMON_LOCALES = OraMapTable.getInstance(1);
        private static final CachedCommonDisplayLocales m_sing = new CachedCommonDisplayLocales();
        private final Locale[] m_locales;

        private CachedCommonDisplayLocales() {
            String[] stringArray = COMMON_LOCALES.getStringArrayAttribute("COMMON_DISPLAY_LOCALES");
            this.m_locales = new Locale[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.m_locales[i] = OraLocaleInfo.getLocaleFromString(stringArray[i]);
            }
        }

        public static CachedCommonDisplayLocales getInstance() {
            return m_sing;
        }

        public Locale[] getArray() {
            return this.m_locales;
        }
    }

    private static class CachedCommonTimeZones {
        private static final OraMapTable COMMON_TIMEZONES = OraMapTable.getInstance(4);
        private static final CachedCommonTimeZones m_sing = new CachedCommonTimeZones();
        private final TimeZone[] m_commonTimeZones;

        private CachedCommonTimeZones() {
            String[] stringArray = COMMON_TIMEZONES.getStringArrayAttribute("COMMON_TIMEZONES");
            this.m_commonTimeZones = new TimeZone[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.m_commonTimeZones[i] = TimeZone.getTimeZone(stringArray[i] != null ? stringArray[i] : "UTC");
            }
        }

        public static CachedCommonTimeZones getInstance() {
            return m_sing;
        }

        public TimeZone[] getArray() {
            return this.m_commonTimeZones;
        }
    }

    private static class CachedISO4217toSymbolMap {
        private static final transient OraMapTable ISO4217_CURRENCY = OraMapTable.getInstance(5);
        private static final CachedISO4217toSymbolMap map = new CachedISO4217toSymbolMap();
        private final Map m_iso4217toSymbol = ISO4217_CURRENCY.getHashMapAttribute("ISO4217_2_CURRENCY");
        private final String[] m_iso4217toSymbolKeyArr;

        private CachedISO4217toSymbolMap() {
            Set set = this.m_iso4217toSymbol.keySet();
            this.m_iso4217toSymbolKeyArr = set.toArray(new String[0]);
            Sort.quickSort(this.m_iso4217toSymbolKeyArr);
        }

        public static CachedISO4217toSymbolMap getInstance() {
            return map;
        }

        public Map getMap() {
            return this.m_iso4217toSymbol;
        }

        public String[] getKeyArray() {
            return this.m_iso4217toSymbolKeyArr;
        }
    }
}

