/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import oracle.sysman.oii.oiil.OiilQuery;
import oracle.sysman.oii.oiil.OiilQueryException;
import oracle.sysman.oii.oiix.OiixPlatform;

public class getMemorySize
implements OiilQuery {
    private String[] runCommand(String command) throws OiilQueryException {
        Vector<String> outVec = new Vector<String>();
        Process commProc = null;
        try {
            commProc = Runtime.getRuntime().exec(command);
        }
        catch (IOException ioex) {
            String ioName = "RuntimeException";
            String ioString = OiQueryFileRes.getString("RuntimeException_desc");
            throw new OiilQueryException(ioName, ioString);
        }
        InputStreamReader pIs = new InputStreamReader(commProc.getInputStream());
        BufferedReader pBr = new BufferedReader(pIs);
        try {
            commProc.waitFor();
        }
        catch (InterruptedException itse) {
            String ioName = "RuntimeException";
            String ioString = OiQueryFileRes.getString("RuntimeException_desc");
            throw new OiilQueryException(ioName, ioString);
        }
        try {
            String outStr = pBr.readLine();
            while (outStr != null) {
                outVec.addElement(outStr);
                outStr = pBr.readLine();
            }
        }
        catch (IOException itse) {
            String ioName = "RuntimeException";
            String ioString = OiQueryFileRes.getString("RuntimeException_desc");
            throw new OiilQueryException(ioName, ioString);
        }
        String[] outArr = new String[outVec.size()];
        for (int i = 0; i < outVec.size(); ++i) {
            outArr[i] = (String)outVec.elementAt(i);
        }
        return outArr;
    }

    public Object performQuery(Vector inputs) throws OiilQueryException {
        OiixPlatform oiiPl = new OiixPlatform();
        int platID = oiiPl.getCurrentPlatform();
        if (platID == 2 || platID == 197 || platID == 453) {
            ssgetMemorySize qc = new ssgetMemorySize();
            int retVal = 0;
            retVal = qc.ssgetMemorySize();
            return new Integer(retVal);
        }
        if (platID == 46 || platID == 211 || platID == 110) {
            String command = "/bin/cat /proc/meminfo";
            int retVal = 0;
            String[] commOut = this.runCommand(command);
            String memStr = null;
            for (int i = 0; i < commOut.length; ++i) {
                if (!commOut[i].startsWith("MemTotal")) continue;
                memStr = commOut[i].substring(commOut[i].indexOf(":") + 1).trim();
                break;
            }
            if (memStr == null) {
                return new Integer(0);
            }
            int end = memStr.indexOf(" ");
            try {
                retVal = (int)(Long.parseLong(memStr.substring(0, end)) / 1024L);
            }
            catch (NumberFormatException nfe) {
                return new Integer(0);
            }
            return new Integer(retVal);
        }
        if (platID == 610) {
            String command = "/usr/sbin/lsattr -F value -E -l sys0 -a realmem";
            String[] commOut = this.runCommand(command);
            int retVal = 0;
            try {
                retVal = Integer.parseInt(commOut[0]) / 1024;
            }
            catch (NumberFormatException nfe) {
                return new Integer(0);
            }
            return new Integer(retVal);
        }
        if (platID == 87) {
            String command = "/usr/bin/vmstat -P";
            String pattern = "Total Physical Memory";
            String[] commOut = this.runCommand(command);
            int retVal = 0;
            try {
                for (int i = 0; i < commOut.length; ++i) {
                    if (commOut[i].indexOf(pattern) == -1) continue;
                    int start = commOut[i].indexOf("=") + 1;
                    int end = commOut[i].indexOf("M", start);
                    String valStr = commOut[i].substring(start, end).trim();
                    float tempVal = Float.parseFloat(valStr);
                    retVal = (int)tempVal;
                    break;
                }
            }
            catch (NumberFormatException nfe) {
                return new Integer(0);
            }
            return new Integer(retVal);
        }
        return new Integer(0);
    }

    public static void main(String[] args) {
        getMemorySize gy = new getMemorySize();
        Vector inputs = new Vector();
        Integer retVal = new Integer(0);
        try {
            retVal = (Integer)gy.performQuery(inputs);
            System.out.println("Ret Val : " + retVal);
        }
        catch (OiilQueryException oiilQueryException) {
            // empty catch block
        }
    }
}

