/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jpub.runtime.OracleDataUtil;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class OracleDataMutableArray {
    int length;
    Object[] elements;
    Object[] jdbcObjects;
    OracleArray pickled;
    boolean pickledCorrect;
    int sqlType;
    OracleDataFactory oracleDataFactory;
    boolean isNChar;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    public OracleDataMutableArray(int n2, OracleArray oracleArray, OracleDataFactory oracleDataFactory) {
        this.length = -1;
        this.elements = null;
        this.jdbcObjects = null;
        this.pickled = oracleArray;
        this.pickledCorrect = true;
        this.isNChar = false;
        this.sqlType = n2;
        this.oracleDataFactory = oracleDataFactory;
    }

    public OracleDataMutableArray(int n2, Object[] objectArray, OracleDataFactory oracleDataFactory) {
        this.sqlType = n2;
        this.oracleDataFactory = oracleDataFactory;
        this.isNChar = false;
        this.setJDBCObjectArray(objectArray);
    }

    public OracleDataMutableArray(int n2, double[] dArray, OracleDataFactory oracleDataFactory) {
        this.sqlType = n2;
        this.oracleDataFactory = oracleDataFactory;
        this.isNChar = false;
        this.setArray(dArray);
    }

    public OracleDataMutableArray(int n2, int[] nArray, OracleDataFactory oracleDataFactory) {
        this.sqlType = n2;
        this.oracleDataFactory = oracleDataFactory;
        this.isNChar = false;
        this.setArray(nArray);
    }

    public OracleDataMutableArray(int n2, float[] fArray, OracleDataFactory oracleDataFactory) {
        this.sqlType = n2;
        this.oracleDataFactory = oracleDataFactory;
        this.isNChar = false;
        this.setArray(fArray);
    }

    public OracleDataMutableArray(int n2, short[] sArray, OracleDataFactory oracleDataFactory) {
        this.sqlType = n2;
        this.oracleDataFactory = oracleDataFactory;
        this.isNChar = false;
        this.setArray(sArray);
    }

    public Object toJDBCObject(Connection connection, String string) throws SQLException {
        if (!this.pickledCorrect) {
            this.pickled = (OracleArray)((oracle.jdbc.OracleConnection)connection).createOracleArray(string, this.getJDBCObjectArray(connection));
            this.pickledCorrect = true;
        }
        return this.pickled;
    }

    public Object[] getOracleArray() throws SQLException {
        return this.getOracleArray(0L, Integer.MAX_VALUE);
    }

    public Object[] getOracleArray(long l2, int n2) throws SQLException {
        int n3 = this.sliceLength(l2, n2);
        if (n3 < 0) {
            return null;
        }
        Object[] objectArray = null;
        switch (this.sqlType) {
            case -13: {
                objectArray = new BFILE[n3];
                break;
            }
            case 2004: {
                objectArray = new BLOB[n3];
                break;
            }
            case 1: 
            case 12: {
                objectArray = new CHAR[n3];
                break;
            }
            case 2005: {
                objectArray = new CLOB[n3];
                break;
            }
            case 91: {
                objectArray = new DATE[n3];
                break;
            }
            case 93: {
                objectArray = new TIMESTAMP[n3];
                break;
            }
            case -101: {
                objectArray = new TIMESTAMPTZ[n3];
                break;
            }
            case -102: {
                objectArray = new TIMESTAMPLTZ[n3];
                break;
            }
            case -104: {
                objectArray = new INTERVALDS[n3];
                break;
            }
            case -103: {
                objectArray = new INTERVALYM[n3];
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = new NUMBER[n3];
                break;
            }
            case -2: {
                objectArray = new RAW[n3];
                break;
            }
            case 100: {
                objectArray = new BINARY_FLOAT[n3];
                break;
            }
            case 101: {
                objectArray = new BINARY_DOUBLE[n3];
                break;
            }
            case 0: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2007: {
                objectArray = new OracleData[n3];
                break;
            }
            default: {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 48);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return this.getOracleArray(l2, objectArray);
    }

    public Object[] getOracleArray(long l2, Object[] objectArray) throws SQLException {
        block5: {
            int n2;
            int n3;
            block4: {
                if (objectArray == null) {
                    return null;
                }
                n3 = this.sliceLength(l2, objectArray.length);
                n2 = (int)l2;
                if (n3 != objectArray.length) {
                    return null;
                }
                if (this.sqlType != 2002 && this.sqlType != 2007 && this.sqlType != 2003 && this.sqlType != 2006 && this.sqlType != 0) break block4;
                if (this.oracleDataFactory == null) break block5;
                for (int i2 = 0; i2 < n3; ++i2) {
                    objectArray[i2] = this.oracleDataFactory.create(this.getJDBCObjectElement(n2++, null), this.sqlType);
                }
                break block5;
            }
            for (int i3 = 0; i3 < n3; ++i3) {
                objectArray[i3] = this.getJDBCObjectElement(n2++, null);
            }
        }
        return objectArray;
    }

    public Object[] getOracleArray(Object[] objectArray) throws SQLException {
        return this.getOracleArray(0L, objectArray);
    }

    public Object[] getObjectArray() throws SQLException {
        return this.getObjectArray(0L, Integer.MAX_VALUE);
    }

    public Object[] getObjectArray(long l2, int n2) throws SQLException {
        Object[] objectArray;
        int n3 = this.sliceLength(l2, n2);
        if (n3 < 0) {
            return null;
        }
        switch (this.sqlType) {
            case 1: 
            case 12: {
                objectArray = new String[n3];
                break;
            }
            case 91: {
                objectArray = new Date[n3];
                break;
            }
            case 93: {
                objectArray = new Timestamp[n3];
                break;
            }
            case 2: 
            case 3: {
                objectArray = new BigDecimal[n3];
                break;
            }
            case 6: 
            case 8: {
                objectArray = new Double[n3];
                break;
            }
            case 4: 
            case 5: {
                objectArray = new Integer[n3];
                break;
            }
            case 7: {
                objectArray = new Float[n3];
                break;
            }
            case -2: {
                objectArray = (Object[])new byte[n3][];
                break;
            }
            default: {
                return this.getOracleArray(l2, n2);
            }
        }
        return this.getObjectArray(l2, objectArray);
    }

    public Object[] getObjectArray(long l2, Object[] objectArray) throws SQLException {
        if (objectArray == null) {
            return null;
        }
        int n2 = this.sliceLength(l2, objectArray.length);
        int n3 = (int)l2;
        if (n2 != objectArray.length) {
            return null;
        }
        switch (this.sqlType) {
            case -2: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 93: {
                for (int i2 = 0; i2 < n2; ++i2) {
                    objectArray[i2] = this.getObjectElement(n3++);
                }
                return objectArray;
            }
        }
        return this.getOracleArray(l2, objectArray);
    }

    public Object[] getObjectArray(Object[] objectArray) throws SQLException {
        return this.getObjectArray(0L, objectArray);
    }

    public Object getArray() throws SQLException {
        return this.getArray(0L, Integer.MAX_VALUE);
    }

    public Object getArray(long l2, int n2) throws SQLException {
        int n3 = this.sliceLength(l2, n2);
        int n4 = (int)l2;
        if (n3 < 0) {
            return null;
        }
        switch (this.sqlType) {
            case 6: 
            case 8: 
            case 101: {
                double[] dArray = new double[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    dArray[i2] = (Double)this.getObjectElement(n4++);
                }
                return dArray;
            }
            case 100: {
                float[] fArray = new float[n3];
                for (int i3 = 0; i3 < n3; ++i3) {
                    fArray[i3] = ((Float)this.getObjectElement(n4++)).floatValue();
                }
                return fArray;
            }
            case 4: {
                int[] nArray = new int[n3];
                for (int i4 = 0; i4 < n3; ++i4) {
                    nArray[i4] = (Integer)this.getObjectElement(n4++);
                }
                return nArray;
            }
            case 5: {
                short[] sArray = new short[n3];
                for (int i5 = 0; i5 < n3; ++i5) {
                    sArray[i5] = (short)((Integer)this.getObjectElement(n4++)).intValue();
                }
                return sArray;
            }
            case 7: {
                float[] fArray = new float[n3];
                for (int i6 = 0; i6 < n3; ++i6) {
                    fArray[i6] = ((Float)this.getObjectElement(n4++)).floatValue();
                }
                return fArray;
            }
        }
        return this.getObjectArray(l2, n2);
    }

    public void setOracleArray(Object[] objectArray) {
        if (this.oracleDataFactory == null) {
            this.setJDBCObjectArray(objectArray);
        } else {
            this.setObjectArray(objectArray);
        }
    }

    public void setOracleArray(Object[] objectArray, long l2) throws SQLException {
        if (this.oracleDataFactory == null) {
            this.setJDBCObjectArray(objectArray, l2);
        } else {
            this.setObjectArray(objectArray, l2);
        }
    }

    public void setObjectArray(Object[] objectArray) {
        if (objectArray == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(objectArray.length);
            this.elements = new Object[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                this.elements[i2] = objectArray[i2];
            }
        }
    }

    public void setObjectArray(Object[] objectArray, long l2) throws SQLException {
        if (objectArray == null) {
            return;
        }
        int n2 = this.sliceLength(l2, objectArray.length);
        int n3 = (int)l2;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setObjectElement(objectArray[i2], n3++);
        }
    }

    public void setArray(double[] dArray) {
        if (dArray == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(dArray.length);
            this.elements = new Object[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                this.elements[i2] = dArray[i2];
            }
        }
    }

    public void setArray(double[] dArray, long l2) throws SQLException {
        if (dArray == null) {
            return;
        }
        int n2 = this.sliceLength(l2, dArray.length);
        int n3 = (int)l2;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setObjectElement(dArray[i2], n3++);
        }
    }

    public void setArray(int[] nArray) {
        if (nArray == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(nArray.length);
            this.elements = new Object[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                this.elements[i2] = nArray[i2];
            }
        }
    }

    public void setArray(int[] nArray, long l2) throws SQLException {
        if (nArray == null) {
            return;
        }
        int n2 = this.sliceLength(l2, nArray.length);
        int n3 = (int)l2;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setObjectElement(nArray[i2], n3++);
        }
    }

    public void setArray(float[] fArray) {
        if (fArray == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(fArray.length);
            this.elements = new Object[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                this.elements[i2] = Float.valueOf(fArray[i2]);
            }
        }
    }

    public void setArray(float[] fArray, long l2) throws SQLException {
        if (fArray == null) {
            return;
        }
        int n2 = this.sliceLength(l2, fArray.length);
        int n3 = (int)l2;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setObjectElement(Float.valueOf(fArray[i2]), n3++);
        }
    }

    public void setArray(short[] sArray) {
        if (sArray == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(sArray.length);
            this.elements = new Object[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                this.elements[i2] = (int)sArray[i2];
            }
        }
    }

    public void setArray(short[] sArray, long l2) throws SQLException {
        if (sArray == null) {
            return;
        }
        int n2 = this.sliceLength(l2, sArray.length);
        int n3 = (int)l2;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setObjectElement(sArray[i2], n3++);
        }
    }

    public Object getObjectElement(long l2) throws SQLException {
        Object object = this.getLazyArray()[(int)l2];
        if (object == null && this.oracleDataFactory != null) {
            Object object2 = this.getLazyOracleArray()[(int)l2];
            this.elements[(int)l2] = object = OracleDataUtil.convertToObject(object2, this.sqlType, this.oracleDataFactory);
            if (OracleDataUtil.isMutable(object2, this.oracleDataFactory)) {
                this.resetOracleElement(l2);
            }
        }
        return object;
    }

    public Object getOracleElement(long l2) throws SQLException {
        if (this.oracleDataFactory == null) {
            Object object = this.getJDBCObjectElement(l2, null);
            if (OracleDataUtil.isMutable(object, this.oracleDataFactory)) {
                this.pickledCorrect = false;
            }
            return object;
        }
        return this.getObjectElement(l2);
    }

    public void setObjectElement(Object object, long l2) throws SQLException {
        if (object == null) {
            this.getLazyOracleArray();
        }
        this.resetOracleElement(l2);
        this.getLazyArray()[(int)l2] = object;
    }

    public void setOracleElement(Object object, long l2) throws SQLException {
        if (this.oracleDataFactory == null) {
            this.setJDBCObjectElement(object, l2);
        } else {
            this.setObjectElement(object, l2);
        }
    }

    public String getBaseTypeName() throws SQLException {
        return this.pickled.getBaseTypeName();
    }

    public int getBaseType() throws SQLException {
        return this.pickled.getBaseType();
    }

    Object[] getJDBCObjectArray(Connection connection) throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        if (this.jdbcObjects == null) {
            return null;
        }
        Object[] objectArray = new Object[this.length];
        for (int i2 = 0; i2 < this.length; ++i2) {
            objectArray[i2] = this.getJDBCObjectElement(i2, connection);
        }
        return objectArray;
    }

    void setJDBCObjectArray(Object[] objectArray) {
        if (objectArray == null) {
            this.setNullArray();
        } else {
            this.length = objectArray.length;
            this.elements = null;
            this.jdbcObjects = (Object[])objectArray.clone();
            this.pickled = null;
            this.pickledCorrect = false;
        }
    }

    void setJDBCObjectArray(Object[] objectArray, long l2) throws SQLException {
        if (objectArray == null) {
            return;
        }
        int n2 = this.sliceLength(l2, objectArray.length);
        int n3 = (int)l2;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setJDBCObjectElement(objectArray[i2], n3++);
        }
    }

    Object getJDBCObjectElement(long l2, Connection connection) throws SQLException {
        Object object = this.getLazyOracleArray()[(int)l2];
        if (object == null) {
            Object object2 = this.getLazyArray()[(int)l2];
            this.jdbcObjects[(int)l2] = object = OracleDataUtil.convertToOracle(object2, connection, this.isNChar);
        }
        return object;
    }

    void setJDBCObjectElement(Object object, long l2) throws SQLException {
        this.resetElement(l2);
        this.getLazyOracleArray()[(int)l2] = object;
        this.pickledCorrect = false;
    }

    void resetElement(long l2) throws SQLException {
        if (this.elements != null) {
            this.elements[(int)l2] = null;
        }
    }

    void setNullArray() {
        this.length = -1;
        this.elements = null;
        this.jdbcObjects = null;
        this.pickled = null;
        this.pickledCorrect = false;
    }

    void setArrayGeneric(int n2) {
        this.length = n2;
        this.jdbcObjects = new Object[n2];
        this.pickled = null;
        this.pickledCorrect = false;
    }

    public int length() throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        return this.length;
    }

    public int sliceLength(long l2, int n2) throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        if (l2 < 0L) {
            return (int)l2;
        }
        return Math.min(this.length - (int)l2, n2);
    }

    void resetOracleElement(long l2) throws SQLException {
        if (this.jdbcObjects != null) {
            this.jdbcObjects[(int)l2] = null;
        }
        this.pickledCorrect = false;
    }

    Object[] getLazyArray() throws SQLException {
        if (this.length == -1) {
            this.getLazyOracleArray();
        }
        if (this.elements == null) {
            this.elements = new Object[this.length];
        }
        return this.elements;
    }

    Object[] getLazyOracleArray() throws SQLException {
        if (this.jdbcObjects == null) {
            if (this.pickled != null) {
                this.jdbcObjects = (Object[])this.pickled.getArray();
                this.length = this.jdbcObjects.length;
                this.pickledCorrect = true;
                if (this.elements != null) {
                    for (int i2 = 0; i2 < this.length; ++i2) {
                        if (this.elements[i2] == null) continue;
                        this.jdbcObjects[i2] = null;
                        this.pickledCorrect = false;
                    }
                }
            } else if (this.length >= 0) {
                this.jdbcObjects = new Object[this.length];
            }
        }
        return this.jdbcObjects;
    }

    public void setNChar() {
        this.isNChar = true;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

