/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ClassifierTable {
    private Map m_table;
    private Vector m_values;

    public ClassifierTable() {
        this(11);
    }

    public ClassifierTable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ClassifierTable(int initialCapacity, float loadFactor) {
        this.m_table = Collections.synchronizedMap(new LinkedHashMap(initialCapacity, loadFactor));
        this.m_values = new Vector(initialCapacity);
    }

    protected Collection makeSubGroup() {
        return new Vector();
    }

    public boolean put(Object key, Object value) {
        Collection subGroup;
        if (this.m_table.containsKey(key)) {
            subGroup = (Collection)this.m_table.get(key);
        } else {
            subGroup = this.makeSubGroup();
            this.m_table.put(key, subGroup);
        }
        boolean isAdded = subGroup.add(value);
        if (isAdded) {
            this.m_values.add(value);
        }
        return isAdded;
    }

    public Collection getSubGroup(Object key) {
        Collection subGroup = (Collection)this.m_table.get(key);
        return subGroup;
    }

    public Collection subGroups() {
        return this.m_table.values();
    }

    public int numSubGroups() {
        return this.m_table.size();
    }

    public Collection values() {
        return this.m_values;
    }

    public int size() {
        return this.m_values.size();
    }

    public Set keySet() {
        return this.m_table.keySet();
    }
}

