/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import oracle.cluster.impl.verification.DiskInfoResultSetImpl;
import oracle.cluster.verification.DiskInfoResultSet;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.registry.RegistryKeyData;
import oracle.ops.mgmt.command.registry.RegistryNativeResult;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.PathDiskInfo;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.VerifyStorage;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.HAHomeNotFoundException;
import oracle.ops.verification.framework.util.InvalidEnvironmentException;
import oracle.ops.verification.framework.util.InvalidOUIInventoryDataException;
import oracle.ops.verification.framework.util.OUIData;
import oracle.ops.verification.framework.util.VerificationUtil;

class sVerificationUtil {
    private static final String INSTLOC_KEY = "HKEY_LOCAL_MACHINE\\SOFTWARE\\ORACLE";
    private static final String INSTLOC_VALUE = "inst_loc";
    private static final String INVENTORY_XML_PATH_EXTENSION = VerificationConstants.FILE_SEPARATOR + "ContentsXML" + VerificationConstants.FILE_SEPARATOR + "inventory.xml";
    static final String OS_VER_COMPAT_XML_FILENAME = "usm_oscompat.xml";
    static final String LS_C1_COMMAND = "DIR";
    static final String NEW_LINE_STRING = "\\n";
    static final String WILD_CARD_CHARACTER = "*";
    static final String DEFAULT_ASM_DISKS = "\\\\.\\ORCLDISK*";
    static final String UNSUPPORTED = "UNSUPPORTED";
    static final String USM_DRIVER_SCRIPT = "acfsdriverstate";
    static final String STR_USMDEV_PERMS = "0770";
    static final String STR_USMDEV_OWNER = "root";
    private static String[] m_supportedArchs = new String[]{"x86"};
    private static final String WINDOWS_OLR_LOCATION = "HKEY_LOCAL_MACHINE\\Software\\Oracle\\Olr";
    static final String CSSDPATH = "/etc/init.d/init.cssd";
    static final String ORACLE_USER = "ORACLE_USER";
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static final String m_afdDriverStateCommand = new SystemFactory().CreateSystem().getScriptFileName("afddriverstate");
    private static final String m_afdToolCommand = new SystemFactory().CreateSystem().getExeName("afdtool");

    protected sVerificationUtil() {
    }

    protected String getInventoryFileLocation() throws InvalidOUIInventoryDataException {
        String invDirectory = sVerificationUtil.getInventoryConfigFilePointer();
        if (invDirectory == null) {
            throw new InvalidOUIInventoryDataException("Error in fetching registry key for inst_loc");
        }
        String configFileName = invDirectory + INVENTORY_XML_PATH_EXTENSION;
        File configFile = new File(configFileName);
        if (!configFile.exists()) {
            Trace.out((String)("Inventory Config File '" + configFileName + "'   doesn't exist"));
            throw new InvalidOUIInventoryDataException("Inventory Config File '" + configFileName + "'   doesn't exist");
        }
        Trace.out((String)("Inventory File Location is-->" + configFileName));
        return configFileName;
    }

    public static String getInventoryConfigFilePointer() {
        String invDirectory = null;
        try {
            ClusterWindows clusterWindows = new ClusterWindows();
            invDirectory = clusterWindows.getRegStringDataOnNode(INSTLOC_KEY, INSTLOC_VALUE);
        }
        catch (ClusterException ce) {
            Trace.out((String)("Error in fetching registry key for inst_loc" + VerificationConstants.LINE_SEPARATOR + ce.getMessage()));
        }
        Trace.out((String)("Inventory Directory is-->" + invDirectory));
        return invDirectory;
    }

    public static String getUniqueDistributionID(Result result) {
        String distID = System.getProperty("os.version");
        result.setStatus(1);
        Trace.out((String)("==== UniqueDistributionID=" + distID));
        return distID;
    }

    public static void getExecutionEnvironment() throws InvalidEnvironmentException {
        VerificationUtil.setCurrentGroup("Administrators");
    }

    public static String getCurrentGroup() throws InvalidEnvironmentException {
        return "Administrators";
    }

    private static boolean isOCFSConfigured() {
        String ocfsRegKey = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\ocfs";
        RegistryNativeResult m_result = new RegistryNativeResult();
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        try {
            nativeSystem.regKeyExists(VerificationUtil.getLocalHost(), ocfsRegKey, (NativeResult)m_result);
            return m_result.getStatus();
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static String getOraInventoryGroup() {
        return null;
    }

    public static String getPreReqXmlPath() throws XmlFilePathException {
        String xmlFile = VerificationUtil.getEnv("CV_PREREQ_XML");
        if (xmlFile == null) {
            xmlFile = System.getProperty("CV_PREREQ_XML");
        }
        Trace.out((String)("Pre-req xml file is: '" + xmlFile + "'"));
        return xmlFile;
    }

    public static String getCompSoftwareConfigXmlPath() throws XmlFilePathException {
        String xmlFile = VerificationUtil.getEnv("CV_SOFTWARE_XML");
        if (xmlFile == null) {
            throw new XmlFilePathException("Unable to find the location for software distribution xml file." + VerificationConstants.LINE_SEPARATOR + "Set CV_SOFTWARE_XML environment variable to the correct location.");
        }
        Trace.out((String)("CV_SOFTWARE_XML file is: '" + xmlFile + "'"));
        return xmlFile;
    }

    public static String getOSVersionCompatXmlPath() {
        String xmlFile = VerificationUtil.getEnv("CV_OSVERCOMPAT_XML");
        if (xmlFile == null) {
            xmlFile = System.getProperty("CV_OSVERCOMPAT_XML");
        }
        if (xmlFile == null) {
            String s_fsep = System.getProperty("file.separator");
            String cvhome = VerificationUtil.getCVHome();
            xmlFile = cvhome + "cv" + s_fsep + "cvdata" + s_fsep + OS_VER_COMPAT_XML_FILENAME;
        }
        Trace.out((String)("====  File listing supported OS versions for USM: " + xmlFile));
        return xmlFile;
    }

    public static String resolve(CVUVariableConstants variable) {
        String returnValue = null;
        boolean condRes = false;
        switch (variable) {
            case OCFS: {
                condRes = sVerificationUtil.isOCFSConfigured();
                returnValue = Boolean.toString(condRes);
                break;
            }
            default: {
                Trace.out((String)("condition variable " + variable.name() + " not handled "));
            }
        }
        return returnValue;
    }

    public String[] getDefaultDiscoveryDevice(String version) {
        return new String[]{DEFAULT_ASM_DISKS};
    }

    public String getFileListCommand() {
        return LS_C1_COMMAND;
    }

    public List<String> parseFileListOutput(String[] cmdOut) {
        List<String> fList = Arrays.asList(cmdOut);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Size of parsed output list is = " + fList.size()));
            for (int i = 0; i < fList.size(); ++i) {
                Trace.out((String)("Output " + i + " : " + fList.get(i)));
            }
        }
        return fList;
    }

    public boolean containsWildCard(String path) {
        return path.contains(WILD_CARD_CHARACTER);
    }

    public String getUSMDriverScript() {
        if (System.getProperty("os.arch").equalsIgnoreCase("AMD64")) {
            return new String(USM_DRIVER_SCRIPT);
        }
        return new String(UNSUPPORTED);
    }

    public String getUSMDeviceOwner() {
        if (System.getProperty("os.arch").equalsIgnoreCase("AMD64")) {
            return new String(STR_USMDEV_OWNER);
        }
        return new String(UNSUPPORTED);
    }

    public String getDefaultUSMDevPerms() {
        if (System.getProperty("os.arch").equalsIgnoreCase("AMD64")) {
            return new String(STR_USMDEV_PERMS);
        }
        return new String(UNSUPPORTED);
    }

    public static boolean checkPlatform(String osname, String osarch) {
        boolean match = false;
        for (String arch : m_supportedArchs) {
            if (!VerificationUtil.isStringGood(osarch) || !osarch.equalsIgnoreCase(arch)) continue;
            match = true;
        }
        Trace.out((String)("Match = " + match));
        if (VerificationUtil.isStringGood(osname) && osname.equalsIgnoreCase(sVerificationUtil.getSupportedOSPlatform().getJavaOSName()) && match) {
            Trace.out((String)"Return value = true");
            return true;
        }
        Trace.out((String)"Return value = false");
        return false;
    }

    public static boolean checkPlatformOS(String osname) {
        if (osname.equalsIgnoreCase(sVerificationUtil.getSupportedOSPlatform().getJavaOSName())) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Return value = true");
            }
            return true;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Return value = false");
        }
        return false;
    }

    public static VerificationConstants.OSType getSupportedOSPlatform() {
        return VerificationConstants.OSType.WINDOWS;
    }

    public static String getSupportedArch() {
        return Arrays.toString(m_supportedArchs);
    }

    public static String getCurrentOS() {
        return System.getProperty("os.name");
    }

    public static String getCurrentArch() {
        String processorArch = VerificationUtil.getEnv("PROCESSOR_ARCHITECTURE");
        String processorArch6432 = VerificationUtil.getEnv("PROCESSOR_ARCHITEW6432");
        if ("x86".equals(processorArch) && (processorArch6432 == null || processorArch6432.length() == 0)) {
            return "x86";
        }
        return "x86_64";
    }

    public static void setFileDirPerm(String permStr, String fileDir) {
    }

    public static float getCTSSOffsetLimit() {
        float f = 1000.0f;
        return f;
    }

    public static String getHAHomeWithException() throws HAHomeNotFoundException {
        try {
            String olrCrsHomePropertyValue = sVerificationUtil.getPropertyValue("localnode", WINDOWS_OLR_LOCATION, "crs_home");
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("crs_home=" + olrCrsHomePropertyValue));
            }
            return olrCrsHomePropertyValue;
        }
        catch (NativeException ne) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("NativeException is caught:" + ne.getMessage()));
            }
            throw new HAHomeNotFoundException(ne.getMessage());
        }
    }

    private static String getPropertyValue(String node, String configLocation, String propertyName) throws NativeException {
        String propertyValue = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        NativeResult nativeResult = new NativeResult();
        RegistryKeyData regData = new RegistryKeyData(configLocation, propertyName);
        String nodeName = "localnode".equalsIgnoreCase(node) ? null : node;
        regData.setDataType(10);
        if (nativeSys.regKeyExists(nodeName, configLocation, nativeResult)) {
            nativeResult.setStatus(false);
            nativeSys.regGetData(node, configLocation, propertyName, regData, nativeResult);
            if (nativeResult.getStatus()) {
                propertyValue = regData.getStringData();
            }
        } else if (!nativeResult.getStatus()) {
            Object[] args = new Object[]{propertyName, configLocation, node, nativeResult.getOSString()};
            throw new NativeException("1011", args);
        }
        return propertyValue;
    }

    private static int getPropertyValueNumeric(String node, String regKeyName, String propertyName) throws NativeException {
        int propertyValue = 0;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        NativeResult nativeResult = new NativeResult();
        RegistryKeyData regData = new RegistryKeyData(regKeyName, propertyName);
        String nodeName = "localnode".equalsIgnoreCase(node) ? null : node;
        regData.setDataType(12);
        if (nativeSys.regKeyExists(nodeName, regKeyName, nativeResult)) {
            nativeResult.setStatus(false);
            nativeSys.regGetData(node, regKeyName, propertyName, regData, nativeResult);
            if (nativeResult.getStatus()) {
                propertyValue = regData.getIntegerData();
            }
        } else if (!nativeResult.getStatus()) {
            Object[] args = new Object[]{propertyName, regKeyName, node, nativeResult.getOSString()};
            throw new NativeException("1011", args);
        }
        return propertyValue;
    }

    public static String getLoginShell() {
        return null;
    }

    public static boolean isUSMSupported() {
        if (System.getProperty("os.arch").equalsIgnoreCase("AMD64") && (sVerificationUtil.getCurrentOS().equalsIgnoreCase("Windows Server 2003") || sVerificationUtil.getCurrentOS().equalsIgnoreCase("Windows 2003"))) {
            Trace.out((String)("ACFS supported on: " + sVerificationUtil.getCurrentOS() + " with architecture of: " + System.getProperty("os.arch")));
            return true;
        }
        Trace.out((String)("ACFS NOT supported on: " + sVerificationUtil.getCurrentOS() + " with architecture of: " + System.getProperty("os.arch")));
        return false;
    }

    public static boolean isUDEVSupported() {
        return false;
    }

    public static String getKernelRelease() {
        return new String("NTKERNEL");
    }

    public static String getCRSHome(String node, Result result) {
        NativeResult nativeRes;
        boolean keyExist;
        ErrorDescription errDesc = null;
        String inventoryFile = null;
        OUIData ouid = null;
        sVerificationUtil sVerUtil = new sVerificationUtil();
        try {
            inventoryFile = sVerUtil.getInventoryFileLocation();
            Trace.out((String)("sVerificationUtil:: The Inventory file is :" + inventoryFile));
            ouid = OUIData.getInstance(inventoryFile);
        }
        catch (InvalidOUIInventoryDataException e) {
            errDesc = new ErrorDescription(e.getMessage());
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            ReportUtil.printError(e.getMessage());
            Trace.out((Exception)e);
            return null;
        }
        if (ouid == null) {
            Trace.out((String)"sVerificationUtil::getCRSHome(node, result): ERROR instantiating the OUIData object");
            result.setStatus(2);
            return null;
        }
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        String olrFileLoc = nativeSys.getOLRConfigLocation(node, new Version());
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("olrFileName=" + olrFileLoc));
        }
        if (!(keyExist = nativeSys.regKeyExists(node, olrFileLoc, nativeRes = new NativeResult()))) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)(olrFileLoc + " does not exist, Hence considering pre-TB returning CRS Home of Local Node."));
            }
            result.setStatus(1);
            return ouid.getCRSHomeLocation();
        }
        if (!ouid.isCRSInstalledOnNode(node)) {
            Trace.out((String)("sVerificationUtil::CRS wasn't found installed  on node: " + node));
            errDesc = new ErrorDescription(s_msgBundle.getMessage("7593", false, (Object[])new String[]{node}));
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            return null;
        }
        Trace.out((String)("sVerificationUtil::CRS found installed  on node: " + node));
        String olrCrsHomePropertyValue = null;
        try {
            olrCrsHomePropertyValue = sVerificationUtil.getPropertyValue(node, olrFileLoc, "crs_home");
        }
        catch (NativeException e) {
            Trace.out((String)("sVerificationUtil::Failed to retrieve property value from node : " + node));
            errDesc = new ErrorDescription(e.getMessage());
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            ReportUtil.printError(e.getMessage());
            Trace.out((Exception)((Object)e));
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("crs_home=" + olrCrsHomePropertyValue));
        }
        if (olrCrsHomePropertyValue != null) {
            result.setStatus(1);
            return olrCrsHomePropertyValue;
        }
        result.setStatus(2);
        return null;
    }

    public static String getCSSDFileLoc() {
        return "Not supported on Windows";
    }

    public static String getTZFileLoc() {
        return "Not supported on Windows";
    }

    public static String[] getLdLibraryStrings() {
        String[] ldLibArray = null;
        return ldLibArray;
    }

    public static boolean isAutoMountEnabled(String node) {
        try {
            if (0 == sVerificationUtil.getPropertyValueNumeric(node, "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\MountMgr", "NoAutoMount")) {
                Trace.out((String)"Returning: false");
                return true;
            }
        }
        catch (NativeException ne) {
            Trace.out((String)("NATIVEEXCEPTION: " + ne.getMessage() + (Object)((Object)ne)));
        }
        Trace.out((String)"Returning: false");
        return false;
    }

    public static boolean isDisplayEnabled() {
        return true;
    }

    public static String getOLRPropertyValue(String nodeName, String propertyName, Result result, boolean ignoreCase) {
        String value = null;
        try {
            value = sVerificationUtil.getPropertyValue(nodeName, WINDOWS_OLR_LOCATION, propertyName);
        }
        catch (NativeException ne) {
            Trace.out((String)("Caught NativeException with error : " + ne.getMessage()));
            result.addErrorDescription(new ErrorDescription(ne.getMessage()));
            result.setStatus(2);
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)(propertyName + "=" + value));
        }
        if (VerificationUtil.isStringGood(value)) {
            result.setStatus(1);
        } else {
            result.setStatus(3);
        }
        return value;
    }

    public static DiskInfoResultSet getDiskInfoForPath(String[] nodeList, String path) throws InvalidPathException {
        DiskInfoResultSetImpl resultSet = new DiskInfoResultSetImpl(nodeList, path);
        ErrorDescription errorDesc = null;
        String errMsg = null;
        if (nodeList == null || nodeList.length == 0) {
            errMsg = s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"nodeList"});
            errorDesc = new ErrorDescription(errMsg);
            resultSet.addErrorDescription(errorDesc);
            resultSet.setStatus(2);
            return resultSet;
        }
        if (path == null || path.length() == 0) {
            errMsg = s_msgBundle.getMessage("7517", false);
            errorDesc = new ErrorDescription(errMsg);
            resultSet.addErrorDescription(errorDesc);
            resultSet.addResult(nodeList, 2);
            throw new InvalidPathException(errMsg);
        }
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " path =" + path));
        }
        Trace.out((String)("\nprocessing path " + path));
        sVerificationUtil.resolvePath(nodeList, path, resultSet);
        return resultSet;
    }

    private static void resolvePath(String[] nodeList, String path, DiskInfoResultSetImpl resultSet) throws InvalidPathException {
        String errMsg = null;
        ClusterWindows clusterWindows = null;
        VerifyStorage vfyStorage = new VerifyStorage();
        PathDiskInfo pathInfo = null;
        HashMap<String, String> failedNodes = new HashMap<String, String>();
        String origPath = path;
        try {
            clusterWindows = new ClusterWindows();
            HashMap nodePathPair = null;
            try {
                nodePathPair = clusterWindows.resolvePath(nodeList, origPath, VerificationUtil.getCVHome());
            }
            catch (RemoteFileOperationException re) {
                Trace.out((String)("Remote operation failure " + re.getMessage()));
                String[] stringArray = nodeList;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String node = stringArray[i];
                    try {
                        if (re.getStatus(node) == 1) {
                            errMsg = re.getErrorMessage(node);
                            failedNodes.put(node, errMsg);
                            continue;
                        }
                        if (re.getStatus(node) != 2) continue;
                        errMsg = re.getException(node).getMessage();
                        failedNodes.put(node, errMsg);
                        continue;
                    }
                    catch (NoSuchNodeException ne) {
                        Trace.out((String)ne.getMessage());
                        Trace.out((Exception)((Object)ne));
                    }
                }
            }
            for (String node : nodeList) {
                if (failedNodes.containsKey(node)) {
                    errMsg = (String)failedNodes.get(node);
                    pathInfo = new PathDiskInfo(node, origPath, null, null);
                    if (VerificationUtil.isStringGood(errMsg)) {
                        pathInfo.addErrorDescription(new ErrorDescription(errMsg));
                    }
                    pathInfo.setStatus(2);
                } else {
                    String resolvedPath = (String)nodePathPair.get(node);
                    Trace.out((String)("Resolved path " + origPath + " as " + resolvedPath + " on node " + node));
                    boolean failure = false;
                    if (VerificationUtil.isStringGood(resolvedPath)) {
                        try {
                            pathInfo = vfyStorage.getDiskInfo(node, resolvedPath);
                            pathInfo.setOrigPath(path);
                        }
                        catch (StorageException se) {
                            errMsg = se.getMessage();
                            failure = true;
                        }
                    } else {
                        failure = true;
                    }
                    if (failure) {
                        errMsg = VerificationUtil.isStringGood(errMsg) ? s_gMsgBundle.getMessage("5501", true, (Object[])new String[]{origPath, node}) + Constants.LINE_SEPARATOR + errMsg : s_gMsgBundle.getMessage("5501", true, (Object[])new String[]{origPath, node});
                        pathInfo = new PathDiskInfo(node, origPath, null, null);
                        pathInfo.addErrorDescription(new ErrorDescription(errMsg));
                        pathInfo.setStatus(2);
                    } else {
                        pathInfo.setStatus(1);
                    }
                }
                resultSet.addPathInfo(pathInfo);
            }
        }
        catch (ClusterException ce) {
            Trace.out((String)("Cannot create ClusterWindows " + ce.getMessage()));
            for (String node : nodeList) {
                errMsg = s_gMsgBundle.getMessage("5500", false) + Constants.LINE_SEPARATOR + ce.getMessage();
                pathInfo = new PathDiskInfo(node, origPath, null, null);
                pathInfo.addErrorDescription(new ErrorDescription(errMsg));
                pathInfo.setStatus(2);
                resultSet.addPathInfo(pathInfo);
            }
        }
    }

    static String getLocalRootGroup(ResultSet resultSet) {
        return new String("Not supported on Windows");
    }

    public static String getRootUsername() {
        return new String("Not supported on Windows");
    }

    public static boolean isExadataSystem() {
        return false;
    }

    public static boolean isODASystem() {
        return false;
    }

    public static boolean isASMLibInstallConsistent(String[] nodeList, ResultSet asmLibInstallRsltSet, Vector<String> asmLibNotInstallNodes, Vector<String> operationFailedNode) {
        return false;
    }

    public static boolean isASMLibConfiguredConsistently(String[] nodeList, ResultSet asmLibconfiguredRsltSet, Vector<String> asmLibInconsistantConfigNodes, Vector<String> operationFailedNode) {
        return false;
    }

    public static boolean isASMLibConfigured(String[] nodeList) {
        return false;
    }

    public static String getAFDDriverCommandPath(String giHome) {
        return giHome + VerificationConstants.FILE_SEPARATOR + "bin" + VerificationConstants.FILE_SEPARATOR + m_afdDriverStateCommand;
    }

    public static String getAFDToolCommandPath(String giHome) {
        return giHome + VerificationConstants.FILE_SEPARATOR + "bin" + VerificationConstants.FILE_SEPARATOR + m_afdToolCommand;
    }

    public static String getDomainSocketsDir() {
        return "Not supported on Windows";
    }

    public static String getInitTabLoc() {
        return "Not supported on Windows";
    }

    public static String getInitdLoc() {
        return "Not supported on Windows";
    }

    public void doSolarisNonGlobalZoneDaemonCheck(String[] nodeList, ResultSet locrs) {
        throw new UnsupportedOperationException("Operation 'doSolarisNonGlobalZoneDaemonCheck' is not supported on this platform");
    }

    public static String[] filterSolarisZoneNodes(String[] nodeList, boolean globalZone, ResultSet resultSet) {
        resultSet.addResult(nodeList, 2);
        HashSet inZoneNodes = new HashSet();
        return inZoneNodes.toArray(new String[0]);
    }

    public static boolean isSolarisKernelZone(String[] nodeList, ResultSet resultSet) {
        resultSet.addResult(nodeList, 2);
        return false;
    }

    public static ResultSet getSharedMemory(String[] nodeList, StorageUnit unit) {
        ResultSet resultSet = new ResultSet();
        for (String node : nodeList) {
            resultSet.addResult(node, 2);
        }
        Trace.out((String)"This API is not supported on Windows platform.");
        return resultSet;
    }

    public static List<String> filterLinuxContainerNodes(String[] nodeList, ResultSet resultSet) {
        resultSet.addResult(nodeList, 2);
        return new ArrayList<String>();
    }

    public static boolean isChronySupported() {
        return false;
    }

    public static boolean isVirtualEnvironment() {
        return false;
    }

    public static boolean isHAIPSupported() {
        return false;
    }
}

