/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.CollectionElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OCRDumpParser
implements VerificationConstants {
    public static List<CollectionElement> parse(InputSource input) throws XmlParserException {
        ArrayList<CollectionElement> ocrKeysCE = new ArrayList<CollectionElement>();
        try {
            DocumentBuilderFactory m_xmlFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder m_xmlParser = m_xmlFactory.newDocumentBuilder();
            ErrorHandler handler = new ErrorHandler(){

                @Override
                public void error(SAXParseException arg0) throws SAXException {
                    throw arg0;
                }

                @Override
                public void fatalError(SAXParseException arg0) throws SAXException {
                    throw arg0;
                }

                @Override
                public void warning(SAXParseException arg0) throws SAXException {
                    Trace.out((String)("Igonred warning while parsing: " + arg0));
                }
            };
            m_xmlParser.setErrorHandler(handler);
            Document m_xmlDocument = null;
            m_xmlDocument = m_xmlParser.parse(input);
            Element m_rootElement = m_xmlDocument.getDocumentElement();
            NodeList keys = OCRDumpParser.getChildrenByTagName(m_rootElement, "KEY");
            for (int np = 0; np < keys.getLength(); ++np) {
                Element key = (Element)keys.item(np);
                ocrKeysCE.addAll(OCRDumpParser.parseKey(key));
            }
        }
        catch (ParserConfigurationException pce) {
            throw new XmlParserException(pce.getMessage(), pce);
        }
        catch (IOException ioe) {
            throw new XmlParserException(ioe.getMessage(), ioe);
        }
        catch (SAXException se) {
            throw new XmlParserException(se.getMessage(), se);
        }
        return ocrKeysCE;
    }

    private static List<CollectionElement> parseKey(Element keyElement) throws XmlParserException {
        ArrayList<CollectionElement> keyCollectionElementList = new ArrayList<CollectionElement>();
        Element nameElement = OCRDumpParser.getFirstChildByTagName(keyElement, "NAME");
        Element valueTypeElement = OCRDumpParser.getFirstChildByTagName(keyElement, "VALUE_TYPE");
        Element valueElement = OCRDumpParser.getFirstChildByTagName(keyElement, "VALUE");
        Element userPermissionsElement = OCRDumpParser.getFirstChildByTagName(keyElement, "USER_PERMISSION");
        Element groupPermissionsElement = OCRDumpParser.getFirstChildByTagName(keyElement, "GROUP_PERMISSION");
        Element otherPermissionsElement = OCRDumpParser.getFirstChildByTagName(keyElement, "OTHER_PERMISSION");
        Element userNameElement = OCRDumpParser.getFirstChildByTagName(keyElement, "USER_NAME");
        Element groupNameElement = OCRDumpParser.getFirstChildByTagName(keyElement, "GROUP_NAME");
        CollectionElement nameCE = new CollectionElement(OCRDumpParser.getFirstChildNodeValue(nameElement), null, null, null, OCRDumpParser.getFirstChildNodeValue(nameElement), 1);
        CollectionElement ValueTypeCE = null;
        if (valueTypeElement != null) {
            ValueTypeCE = new CollectionElement(valueTypeElement.getTagName(), OCRDumpParser.getFirstChildNodeValue(valueTypeElement), null, null, valueTypeElement.getTagName(), 1);
        }
        CollectionElement ValueCE = null;
        if (valueElement != null) {
            ValueCE = new CollectionElement(valueElement.getTagName(), OCRDumpParser.getFirstChildNodeValue(valueElement), null, null, valueElement.getTagName(), 1);
        }
        CollectionElement UPCE = null;
        if (userPermissionsElement != null) {
            UPCE = new CollectionElement(userPermissionsElement.getTagName(), OCRDumpParser.getFirstChildNodeValue(userPermissionsElement), null, null, userPermissionsElement.getTagName(), 1);
        }
        CollectionElement GPCE = null;
        if (groupPermissionsElement != null) {
            GPCE = new CollectionElement(groupPermissionsElement.getTagName(), OCRDumpParser.getFirstChildNodeValue(groupPermissionsElement), null, null, groupPermissionsElement.getTagName(), 1);
        }
        CollectionElement OPCE = null;
        if (otherPermissionsElement != null) {
            OPCE = new CollectionElement(otherPermissionsElement.getTagName(), OCRDumpParser.getFirstChildNodeValue(otherPermissionsElement), null, null, otherPermissionsElement.getTagName(), 1);
        }
        CollectionElement UNCE = null;
        if (userNameElement != null) {
            UNCE = new CollectionElement(userNameElement.getTagName(), OCRDumpParser.getFirstChildNodeValue(userNameElement), null, null, userNameElement.getTagName(), 1);
        }
        CollectionElement GNCE = null;
        if (groupNameElement != null) {
            GNCE = new CollectionElement(groupNameElement.getTagName(), OCRDumpParser.getFirstChildNodeValue(groupNameElement), null, null, groupNameElement.getTagName(), 1);
        }
        if (ValueTypeCE != null) {
            nameCE.addChild(ValueTypeCE);
        }
        if (ValueCE != null) {
            nameCE.addChild(ValueCE);
        }
        if (UPCE != null) {
            nameCE.addChild(UPCE);
        }
        if (GPCE != null) {
            nameCE.addChild(GPCE);
        }
        if (OPCE != null) {
            nameCE.addChild(OPCE);
        }
        if (UNCE != null) {
            nameCE.addChild(UNCE);
        }
        if (GNCE != null) {
            nameCE.addChild(GNCE);
        }
        keyCollectionElementList.add(nameCE);
        NodeList keys = OCRDumpParser.getChildrenByTagName(keyElement, "KEY");
        for (int np = 0; np < keys.getLength(); ++np) {
            Element key = (Element)keys.item(np);
            keyCollectionElementList.addAll(OCRDumpParser.parseKey(key));
        }
        return keyCollectionElementList;
    }

    private static NodeList getChildrenByTagName(Element elem, String tagName) {
        Trace.out((String)"Method Entry. elem=%s, tagName=%s", (Object[])new Object[]{elem.getTagName(), tagName});
        NodeList allChildren = elem.getChildNodes();
        final ArrayList<Node> _items = new ArrayList<Node>();
        NodeList immediateChildren = new NodeList(){

            @Override
            public int getLength() {
                return _items.size();
            }

            @Override
            public Node item(int paramInt) {
                return (Node)_items.get(paramInt);
            }
        };
        boolean j = false;
        for (int i = 0; i < allChildren.getLength(); ++i) {
            Node toddler = allChildren.item(i);
            if (toddler == null || !toddler.getNodeName().equals(tagName)) continue;
            _items.add(toddler);
            Trace.out((String)("Adding the node " + toddler.getNodeName()));
        }
        return immediateChildren;
    }

    private static Element getFirstChildByTagName(Element osElem, String elemName) throws XmlParserException {
        if (osElem == null || elemName == null) {
            return null;
        }
        NodeList nl = osElem.getElementsByTagName(elemName);
        if (nl.getLength() >= 1) {
            return (Element)nl.item(0);
        }
        return null;
    }

    private static String getFirstChildNodeValue(Element elem) {
        String value = null;
        if (elem != null && elem.getFirstChild() != null) {
            value = elem.getFirstChild().getNodeValue();
        }
        return value;
    }
}

