/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.io.File;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.rowset.RowSetMetaDataImpl;
import oracle.cluster.common.CSSMode;
import oracle.cluster.common.NodeRole;
import oracle.cluster.sql.DBConnectionException;
import oracle.cluster.sql.SQLFactory;
import oracle.cluster.util.EnumConstNotFoundException;
import oracle.cluster.verification.CollectionResultSet;
import oracle.cluster.verification.util.DatabaseInfo;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionResultSetImpl;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.ASMDiskGroup;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.ASMPresence;
import oracle.ops.verification.framework.util.CVUAutoUpdateManager;
import oracle.ops.verification.framework.util.CVUHelperException;
import oracle.ops.verification.framework.util.CVUHelperExec;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.GNSData;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.helper.CVUHelperConstants;

public class CVUHelperUtil
implements CVUHelperConstants {
    private static String HELPER_VERSION_11107 = "11107";
    private static String HELPER_VERSION_10205 = "10205";
    private static String HELPER_VERSION_11201 = "11201";
    private static String HELPER_VERSION_11202 = "11202";
    private static String HELPER_VERSION_11203 = "11203";
    private static String HELPER_VERSION_12101 = "12101";
    private static String HELPER_VERSION_12201 = "12201";
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static String GET_CRSUSER_HELPER_ARG = "-getCRSUser";
    private static String CHECK_DEFAULT_LISTENER_HELPER_ARG = "-checkDefaultListener";
    private static String GNS_DATA_HELPER_ARG = "-getGNSResourceStatus";
    private static String GET_GNS_DOMAIN_VIP_ARG = "-getGNSDomainAndVip";
    private static String CHECK_VIP_ARG = "-vipExists";
    private static String GET_NET_CONFIG_ARG = "-getNetworkInfo";
    private static String GET_CSSMODE_HELPER_ARG = "-getCSSMode";
    private static String GET_ASM_ATTRIBUTE = "-getASMResourceAttribute";
    private static String PRESENCE = "PRESENCE";
    private static String ASM_COUNT = "ASM_INSTANCE_COUNT";
    private static String GET_NODE_ROLE = "-getNodeRole";
    private static String GET_NODE_NAMES = "-getNodeNames";
    private static String GET_ASM_HOME = "-getASMhome";
    private static String GET_ASM_INSTANCE = "-getASMsid";
    private static String VALIDATE_GNS_CREDENTIAL = "-validateGNSCredential";
    private static String DYNAMIC_NETWORK = "-checkDynamicNetwork";
    private static String OCR_LOCATIONS = "-getOCRLocations";
    private static String ACTIVE = "ACTIVE";
    private static String CONFIGURED = "CONFIGURED";
    private static String GET_DB_SERVICE_COUNT = "-getDBServiceCount";
    private static String GET_DB_NODES = "-getDbNodes";
    private static String IS_VALID_GNS_VIP = "-isValidGNSVIP";
    private static String GET_DB_INFOS = "-getDatabaseInfos";
    private static String RUN_ASM_QUERY = "-runASMQuery";
    private static String GET_ORACLE_PATCH_LIST = "-getOraclePatchList";
    private static String GET_OPATCH_STATUS = "-getOPatchStatus";
    private static String GET_SCAN_INFO = "-getScanInfo";
    private static String GET_ASM_CONNECTION_INFO = "-getASMConnectionInfo";
    private static String GET_ASM_PWFILE = "-getASMPWFile";
    private static String CVU_HELPER_JAR_PREFIX = "cvuhelper";
    private static String CVU_HELPER_JAR_SUFFIX = ".jar";
    private static final char[] cmdSepArrNT = new char[]{',', ';'};
    private static ASMPresence m_asmPresence = null;
    private static boolean m_isSIHA = false;
    private static String m_crsHomeSupportedFunctions = null;
    private static String m_crsHomeVersion = null;
    private static String m_crsHome = null;
    private static String m_connStringASM = null;

    private static void getCRSHomeInfo() throws CVUHelperException {
        m_crsHome = VerificationUtil.getCRSHome();
        if (m_crsHome == null && (m_crsHome = VerificationUtil.getHAHome()) != null) {
            Trace.out((String)"found SIHA home");
            m_isSIHA = true;
        }
        if (m_crsHome == null) {
            Trace.out((String)"Crshome couldn't be obtained");
            String errMsg = s_msgBundle.getMessage("5301", true);
            throw new CVUHelperException(errMsg);
        }
        Trace.out((String)("crshome obtained is " + m_crsHome));
        m_crsHomeVersion = !m_isSIHA ? VerificationUtil.getCRSReleaseVersion(m_crsHome, false) : VerificationUtil.getSIHAReleaseVersion(true);
        if (!VerificationUtil.isStringGood(m_crsHomeVersion)) {
            String errMsg = !m_isSIHA ? s_msgBundle.getMessage("5316", true, (Object[])new String[]{VerificationUtil.getLocalNode()}) : s_msgBundle.getMessage("5325", true);
            throw new CVUHelperException(errMsg);
        }
        m_crsHomeVersion = m_crsHomeVersion.toLowerCase();
    }

    private static String getHelperVersion(String crsHome, String methodName) {
        if (m_crsHomeVersion == null) {
            Trace.out((String)"unable to determine version");
            return HELPER_VERSION_12201;
        }
        return CVUHelperUtil.getHelperVersion(crsHome, m_crsHomeVersion, methodName);
    }

    private static MessageBundle mapMessageBundle(String facility) {
        if ("PRVG".equals(facility)) {
            return s_gMsgBundle;
        }
        if ("PRVF".equals(facility)) {
            return s_msgBundle;
        }
        return null;
    }

    public static String getHelperVersion(String home, String version, String methodName) {
        if (VerificationUtil.isStringGood(version)) {
            if (VerificationUtil.isVersionPre(version, "11.1")) {
                return HELPER_VERSION_10205;
            }
            if (VerificationUtil.isVersionPre(version, "11.2")) {
                return HELPER_VERSION_11107;
            }
            if (version.startsWith("11.2.0.3")) {
                return HELPER_VERSION_11203;
            }
            if (version.startsWith("11.2.0.2")) {
                Trace.out((String)"using cvuhelper 11.2.0.2");
                return HELPER_VERSION_11202;
            }
            if (version.startsWith("11.2.0.1")) {
                Trace.out((String)"using cvuhelper 11.2.0.1");
                return HELPER_VERSION_11201;
            }
            if (version.startsWith("11.2")) {
                Trace.out((String)"using cvuhelper 11.2.0.3");
                return HELPER_VERSION_11203;
            }
            if (version.startsWith("12.1")) {
                Trace.out((String)"using cvuhelper 12.1.0.1");
                return HELPER_VERSION_12101;
            }
        }
        Trace.out((String)"using cvuhelper 12.2.0.1 as latest");
        return HELPER_VERSION_12201;
    }

    public static CVUHelperExec runCVUHelper(String[] args, String[] env) throws CVUHelperException {
        if (m_crsHome == null) {
            CVUHelperUtil.getCRSHomeInfo();
        }
        return CVUHelperUtil.runCVUHelper(args, env, m_crsHome);
    }

    public static String getHelperJarFullPath(String helperVersion) {
        String helperJarFile = CVUHelperUtil.getHelperJarFile(helperVersion);
        String[] allPathArr = new String[]{"jlib" + FSEP, ".." + FSEP + "ext" + FSEP + "jlib" + FSEP, "opsm" + FSEP + "jlib" + FSEP};
        String fullPath = null;
        for (String path : allPathArr) {
            fullPath = CVUAutoUpdateManager.getCVUFileLocation(path + helperJarFile);
            File file = new File(fullPath);
            if (!file.exists()) continue;
            return fullPath;
        }
        return fullPath;
    }

    public static String getHelperJarFile(String helperVersion) {
        String helperJarFile = CVU_HELPER_JAR_PREFIX;
        helperJarFile = helperVersion != null ? helperJarFile + helperVersion.substring(0, 3) : helperJarFile + "122";
        helperJarFile = helperJarFile + CVU_HELPER_JAR_SUFFIX;
        return helperJarFile;
    }

    public static CVUHelperExec runCVUHelper(String[] args, String[] env, String crsHome) throws CVUHelperException {
        int i;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        boolean isUnix = nativeSystem.isUnixSystem();
        String cvuHelper = nativeSystem.getScriptFileName("cvuhelper");
        String cvHome = VerificationUtil.getCVHome();
        String currentVersion = new Version().toString();
        if (!VerificationUtil.isStringGood(crsHome)) {
            if (!VerificationUtil.isStringGood(m_crsHome)) {
                CVUHelperUtil.getCRSHomeInfo();
                crsHome = m_crsHome;
            } else {
                crsHome = m_crsHome;
            }
        }
        if (args.length < 1) {
            String errMsg = s_gMsgBundle.getMessage("1001", true, (Object[])new String[]{cvuHelper});
            throw new CVUHelperException(errMsg);
        }
        String cvuHelperCmd = isUnix && cvHome.equals(crsHome + FSEP) || !isUnix && cvHome.equalsIgnoreCase(crsHome + FSEP) ? CVUAutoUpdateManager.getCVUFileLocation("cv" + FSEP + "remenv" + FSEP + cvuHelper) : (CVUHelperUtil.isCRSHomeHelperCapable(args[0], crsHome, currentVersion, cvuHelper) ? crsHome + FSEP + "cv" + FSEP + "remenv" + FSEP + cvuHelper : cvHome + FSEP + "cv" + FSEP + "remenv" + FSEP + cvuHelper);
        Trace.out((String)("About to run" + cvuHelperCmd));
        String[] execArgs = null;
        int argPos = 0;
        if (VerificationUtil.isVersionPre(m_crsHomeVersion, currentVersion) || currentVersion.equalsIgnoreCase(m_crsHomeVersion)) {
            execArgs = new String[args.length + 5];
            execArgs[0] = cvuHelperCmd;
            execArgs[1] = crsHome;
            execArgs[2] = CVUHelperUtil.getHelperVersion(crsHome, args[0]);
            execArgs[3] = CVUHelperUtil.getHelperJarFullPath(execArgs[2]);
            execArgs[4] = CVUAutoUpdateManager.getDerivedCVUHome();
            argPos = 5;
            Trace.out((String)"calling known version of cvuhelper");
        } else {
            execArgs = new String[args.length + 6];
            execArgs[0] = crsHome + FSEP + "cv" + FSEP + "remenv" + FSEP + cvuHelper;
            execArgs[1] = "-client";
            execArgs[2] = crsHome;
            execArgs[3] = m_crsHomeVersion;
            execArgs[4] = cvHome;
            execArgs[5] = currentVersion;
            argPos = 6;
            Trace.out((String)"calling cvuhelper in compatibility mode");
        }
        if (isUnix) {
            for (i = 0; i < args.length; ++i) {
                execArgs[i + argPos] = args[i];
            }
        } else {
            for (i = 0; i < args.length; ++i) {
                boolean addQuote = false;
                for (int j = 0; j < cmdSepArrNT.length; ++j) {
                    if (args[i].indexOf(cmdSepArrNT[j]) == -1) continue;
                    addQuote = true;
                    break;
                }
                execArgs[i + argPos] = addQuote ? "\"" + args[i] + "\"" : args[i];
            }
        }
        CVUHelperExec cvExec = new CVUHelperExec(execArgs, env);
        cvExec.runCommand();
        Trace.out((String)("after execution of cvu helper for " + args[0]));
        return cvExec;
    }

    private static boolean isCRSHomeHelperCapable(String methodName, String crsHome, String currentVersion, String cvuHelper) {
        if (VerificationUtil.isVersionPre(m_crsHomeVersion, currentVersion)) {
            return false;
        }
        if (VerificationUtil.isVersionPre(m_crsHomeVersion, "12.1")) {
            return false;
        }
        if (m_crsHomeSupportedFunctions == null) {
            String[] execArgs = new String[6];
            String[] env = null;
            execArgs[0] = m_crsHome + FSEP + "cv" + FSEP + "remenv" + FSEP + cvuHelper;
            execArgs[1] = crsHome;
            execArgs[2] = CVUHelperUtil.getHelperVersion(crsHome, methodName);
            execArgs[3] = CVUHelperUtil.getHelperJarFullPath(execArgs[2]);
            execArgs[4] = CVUAutoUpdateManager.getDerivedCVUHome();
            execArgs[5] = "-getSupportedMethods2";
            CVUHelperExec cvExec = new CVUHelperExec(execArgs, env);
            cvExec.runCommand();
            m_crsHomeSupportedFunctions = cvExec.getOutputString();
        }
        Trace.out((String)("searching for " + methodName));
        return m_crsHomeSupportedFunctions != null && m_crsHomeSupportedFunctions.indexOf(" " + methodName + " ") != -1;
    }

    public static int fetchVerificationStatus(String sfmtd) {
        String tagValue = VerificationUtil.fetchTextByTags(sfmtd, null, "<CVH_VRES>", "</CVH_VRES>");
        if (tagValue == null) {
            tagValue = VerificationUtil.fetchTextByTags(sfmtd, null, "<CVH_ERES>", "</CVH_ERES>");
        }
        return Integer.parseInt(tagValue);
    }

    public static String[] fetchError(String[] sfmtd) {
        String[] errArr = CVUHelperUtil.fetchArrayByTags(sfmtd, "<CVH_EMSG>", "</CVH_EMSG>");
        ArrayList<String> errList = new ArrayList<String>();
        String msgID = null;
        String msgArgStr = null;
        String msgAdd = null;
        Object msgKey = null;
        for (int i = 0; i < errArr.length; ++i) {
            MessageBundle msgBundle;
            String facility = VerificationUtil.fetchTextByTags(errArr[i], "<FACILITY>", "</FACILITY>");
            if (facility == null) {
                errList.add(errArr[i]);
                Trace.out((String)errArr[i]);
                continue;
            }
            msgID = VerificationUtil.fetchTextByTags(errArr[i], "<ID>", "</ID>");
            if (msgID == null || msgID.length() == 0 || (msgBundle = CVUHelperUtil.mapMessageBundle(facility)) == null) continue;
            msgArgStr = VerificationUtil.fetchTextByTags(errArr[i], "<ARGS>", "</ARGS>");
            msgAdd = VerificationUtil.fetchTextByTags(errArr[i], "<AMSG>", "</AMSG>");
            String errMsg = msgArgStr == null || msgArgStr.length() == 0 ? msgBundle.getMessage(msgID, true) : msgBundle.getMessage(msgID, true, (Object[])VerificationUtil.string2strArr(msgArgStr, "|"));
            if (msgAdd != null && msgAdd.length() != 0) {
                errMsg = errMsg + LSEP + msgAdd;
            }
            errList.add(errMsg);
        }
        return errList.toArray(new String[0]);
    }

    public static String[] fetchWarning(String[] sfmtd) {
        return CVUHelperUtil.fetchArrayByTags(sfmtd, "<CVH_WMSG>", "</CVH_WMSG>");
    }

    public static String[] fetchOutput(String[] sfmtd) {
        return CVUHelperUtil.fetchArrayByTags(sfmtd, "<CVH_OUT>", "</CVH_OUT>");
    }

    public static String[] fetchArrayByTags(String[] sfmtd, String tagStart, String tagEnd) {
        int i = 0;
        ArrayList<String> resultList = new ArrayList<String>();
        String sfmtdStr = null;
        block0: while (i < sfmtd.length) {
            while (i < sfmtd.length) {
                sfmtdStr = sfmtd[i].trim();
                Trace.out((String)("###" + sfmtdStr + "###"));
                if (!sfmtdStr.equalsIgnoreCase(tagStart)) {
                    Trace.out((String)("starting tag not found : " + i));
                    ++i;
                    continue;
                }
                Trace.out((String)("Starting tag found : " + ++i));
                break;
            }
            while (i < sfmtd.length) {
                sfmtdStr = sfmtd[i].trim();
                if (sfmtdStr.equalsIgnoreCase(tagEnd)) {
                    Trace.out((String)("found end tag at : " + ++i));
                    continue block0;
                }
                Trace.out((String)("adding " + sfmtdStr));
                resultList.add(sfmtdStr);
                ++i;
            }
        }
        return resultList.toArray(new String[0]);
    }

    public static String getCRSUser() {
        String[] args = new String[]{GET_CRSUSER_HELPER_ARG};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            return null;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            return null;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("failed to get crsuser" + helperExec.getErrorString()));
                return null;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                return outArr[0];
            }
            Trace.out((String)"no output from cvuhelper");
            return null;
        }
        Trace.out((String)"cvuhelper produced no output");
        return null;
    }

    public static String[] getDbNodes(String dbUniqueName) throws CVUHelperException {
        String[] args = new String[]{GET_DB_NODES, dbUniqueName};
        String[] env = null;
        CVUHelperExec helperExec = null;
        String errMsg = "";
        helperExec = CVUHelperUtil.runCVUHelper(args, env);
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            throw new CVUHelperException(helperExec.getErrorString());
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("CVU helper failed to retrieve nodes for given unique database " + args[1] + " with output " + helperExec.getOutputString()));
                String[] errorArray = CVUHelperUtil.fetchError(output);
                throw new CVUHelperException(VerificationUtil.strArr2String(errorArray, LSEP));
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                return VerificationUtil.string2strArr(outArr[0]);
            }
            Trace.out((String)"output from cvuhelper is empty");
            errMsg = s_gMsgBundle.getMessage("11008", true, (Object[])new String[]{VerificationUtil.strArr2String(outArr, LSEP), dbUniqueName});
            throw new CVUHelperException(errMsg);
        }
        Trace.out((String)"cvuhelper produced no output");
        errMsg = s_gMsgBundle.getMessage("11009", true, (Object[])new String[]{dbUniqueName});
        String errStr = helperExec.getErrorString();
        if (errStr != null && errStr.length() != 0) {
            errMsg = errMsg + LSEP + helperExec.getErrorString();
        }
        throw new CVUHelperException(errMsg);
    }

    public static CollectionResultSet<List<DatabaseInfo>> getDatabaseInfos() throws CVUHelperException {
        String[] args = new String[]{GET_DB_INFOS};
        String[] env = null;
        CVUHelperExec helperExec = null;
        String errMsg = "";
        helperExec = CVUHelperUtil.runCVUHelper(args, env);
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            throw new CVUHelperException(helperExec.getErrorString());
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("CVU helper failed to retrieve database infos with output " + helperExec.getOutputString()));
                String[] errorArray = CVUHelperUtil.fetchError(output);
                throw new CVUHelperException(VerificationUtil.strArr2String(errorArray, LSEP));
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                CollectionResultSetImpl databaseInfosCR = new CollectionResultSetImpl();
                ArrayList<DatabaseInfo> databaseInfoList = new ArrayList<DatabaseInfo>();
                databaseInfosCR.setCollectedClusterwideData(databaseInfoList);
                databaseInfosCR.setStatus(1);
                for (String outLine : outArr) {
                    String dbHome;
                    String dbUniqueName;
                    if (!VerificationUtil.isStringGood(outLine)) continue;
                    String[] tokens = outLine.trim().split(Pattern.quote("|"));
                    if (tokens.length > 2) {
                        dbUniqueName = tokens[0];
                        dbHome = tokens[1];
                        String dbVersion = tokens[2];
                        databaseInfoList.add(new DatabaseInfo(dbUniqueName, null, dbVersion, dbHome));
                        continue;
                    }
                    dbUniqueName = tokens[0];
                    dbHome = tokens[1];
                    databaseInfoList.add(new DatabaseInfo(dbUniqueName, null, (String)null, dbHome));
                }
                return databaseInfosCR;
            }
            Trace.out((String)"output from cvuhelper is empty");
            errMsg = s_gMsgBundle.getMessage("11010", true, (Object[])new String[]{VerificationUtil.strArr2String(outArr, LSEP)});
            throw new CVUHelperException(errMsg);
        }
        Trace.out((String)"cvuhelper produced no output");
        errMsg = s_gMsgBundle.getMessage("11011", true);
        String errStr = helperExec.getErrorString();
        if (errStr != null && errStr.length() != 0) {
            errMsg = errMsg + LSEP + helperExec.getErrorString();
        }
        throw new CVUHelperException(errMsg);
    }

    public static void checkDefaultListener(Result listenerResult) {
        String[] output;
        String localNode = null;
        String resourceRunningNode = null;
        localNode = listenerResult.getNode();
        listenerResult.setExpectedValue(localNode);
        String[] args = new String[]{CHECK_DEFAULT_LISTENER_HELPER_ARG, localNode};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException che) {
            Trace.out((String)("cvuhelper couldn't be executed " + che.getMessage()));
            listenerResult.addErrorDescription(new ErrorDescription(che.getMessage()));
            listenerResult.setStatus(2);
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            if (VerificationUtil.isStringGood(helperExec.getErrorString())) {
                listenerResult.addErrorDescription(new ErrorDescription(helperExec.getErrorString()));
            }
            listenerResult.setStatus(2);
        }
        if ((output = helperExec.getOutput()).length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("Default listener for node " + localNode + " was not found configured \n" + helperExec.getErrorString()));
                listenerResult.setStatus(3);
            } else {
                String[] outArr = CVUHelperUtil.fetchOutput(output);
                if (outArr.length > 0 && VerificationUtil.isStringGood(outArr[0])) {
                    resourceRunningNode = outArr[0];
                    if (resourceRunningNode.equalsIgnoreCase(localNode)) {
                        listenerResult.setStatus(1);
                    } else {
                        listenerResult.setStatus(4);
                    }
                    listenerResult.setActualValue(resourceRunningNode);
                    listenerResult.setHasResultValues(true);
                } else {
                    Trace.out((String)"no output from cvuhelper");
                    if (VerificationUtil.isStringGood(helperExec.getErrorString())) {
                        listenerResult.addErrorDescription(new ErrorDescription(helperExec.getErrorString()));
                    }
                    listenerResult.setStatus(2);
                }
            }
        } else {
            Trace.out((String)"cvuhelper produced no output");
            if (VerificationUtil.isStringGood(helperExec.getErrorString())) {
                listenerResult.addErrorDescription(new ErrorDescription(helperExec.getErrorString()));
            }
            listenerResult.setStatus(2);
        }
    }

    public static boolean getGNSDomainAndVIP(ResultSet rs, String node) {
        return CVUHelperUtil.getGNSDomainAndVIP(rs, node, false);
    }

    public static boolean getGNSDomainAndVIP(ResultSet rs, String node, boolean mute) {
        String gnsDomainName = null;
        String gnsServiceDomainName = null;
        String gnsVIP = null;
        String gnsAddress = null;
        String gnsType = null;
        String[] args = new String[]{GET_GNS_DOMAIN_VIP_ARG};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)("cvuhelper couldn't be executed" + e.getMessage()));
            if (!mute) {
                String errMsg = s_gMsgBundle.getMessage("1004", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                rs.addResult(node, 2);
                rs.addErrorDescription(errorDesc);
                ReportUtil.printError(errMsg);
            }
            return false;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            if (!mute) {
                String errMsg = s_gMsgBundle.getMessage("1004", true, (Object[])new String[]{helperExec.getCommandString()}) + LSEP + helperExec.getErrorString();
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                rs.addResult(node, 2);
                rs.addErrorDescription(errorDesc);
                ReportUtil.printError(errMsg);
            }
            return false;
        }
        String[] output = helperExec.getOutput();
        String[] errorArray = null;
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"error during cvu helper execution");
                if (!mute) {
                    errorArray = CVUHelperUtil.fetchError(output);
                    String errMsg = VerificationUtil.strArr2String(errorArray, LSEP);
                    ErrorDescription errorDesc = new ErrorDescription(errMsg);
                    rs.addResult(node, 2);
                    rs.addErrorDescription(errorDesc);
                    ReportUtil.printError(errMsg);
                }
                return false;
            }
            Trace.out((String)"gns details collected");
            String[] gnsDetails = CVUHelperUtil.fetchOutput(output);
            gnsDomainName = VerificationUtil.fetchTextByTags(gnsDetails[0], null, "<GNS_DOMAIN_NAME>", "</GNS_DOMAIN_NAME>");
            gnsServiceDomainName = VerificationUtil.fetchTextByTags(gnsDetails[0], null, "<GNS_SERVICE_DOMAIN_NAME>", "</GNS_SERVICE_DOMAIN_NAME>");
            gnsVIP = VerificationUtil.fetchTextByTags(gnsDetails[0], null, "<GNS_VIP_NAME>", "</GNS_VIP_NAME>");
            gnsAddress = VerificationUtil.fetchTextByTags(gnsDetails[0], null, "<GNS_VIP_ADDRESS>", "</GNS_VIP_ADDRESS>");
            String currVersion = VerificationUtil.getCRSReleaseVersion(VerificationUtil.getCRSHome(), false);
            if (VerificationUtil.isVersionPost(currVersion, "12.1")) {
                gnsType = VerificationUtil.fetchTextByTags(gnsDetails[0], null, "<GNS_TYPE>", "</GNS_TYPE>");
                CVUVariables.setValue(CVUVariableConstants.USE_SHARED_GNS, "CLIENT".equalsIgnoreCase(gnsType) ? "TRUE" : "FALSE");
            }
            CVUVariables.setValue(CVUVariableConstants.GNS_SUB_DOMAIN, gnsDomainName);
            CVUVariables.setValue(CVUVariableConstants.GNS_SERVICE_SUB_DOMAIN, gnsServiceDomainName);
            CVUVariables.setValue(CVUVariableConstants.GNS_VIP_ADDRESS, gnsVIP);
            CVUVariables.setValue(CVUVariableConstants.GNS_IP_ADDRESS, gnsAddress);
            Trace.out((String)("config domain=" + gnsDomainName));
            Trace.out((String)("Service domain=" + gnsServiceDomainName));
            Trace.out((String)("vip=" + gnsVIP));
            Trace.out((String)("address=" + gnsAddress));
            return true;
        }
        Trace.out((String)"cvuhelper failed to produce output");
        if (!mute) {
            String errMsg = s_gMsgBundle.getMessage("1004", true, (Object[])new String[]{helperExec.getCommandString()});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errMsg = errMsg + LSEP + helperExec.getErrorString();
            }
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            rs.addResult(node, 2);
            rs.addErrorDescription(node, errorDesc);
            ReportUtil.printError(errMsg);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkASMRunning(String[] nodeList, List<String> runningASMNodes, List<String> failedASMNodes, ResultSet resultSet) {
        String[] validNodeArr = nodeList;
        Hashtable<String, List<ASMDiskGroup>> asmDiskGroupHT = new Hashtable<String, List<ASMDiskGroup>>();
        ASMDiskGroupsUtil asmdg = new ASMDiskGroupsUtil();
        try {
            asmdg.checkASMRunning(nodeList, runningASMNodes, failedASMNodes);
        }
        catch (ASMDiskGroupsUtilException e1) {
            resultSet.addResult(nodeList, 2);
            for (String node : nodeList) {
                failedASMNodes.add(node);
            }
            Trace.out((int)5, (String)("Error checking if ASM running on all nodes." + e1));
        }
        if (failedASMNodes.size() > 0) {
            String[] failedNodeArr = failedASMNodes.toArray(new String[0]);
            resultSet.addResult(failedNodeArr, 3);
            if (runningASMNodes.size() <= 0) {
                ReportUtil.printError(LSEP + s_msgBundle.getMessage("4194", true) + LSEP);
                return false;
            }
            ReportUtil.printError(LSEP + s_msgBundle.getMessage("4193", true) + LSEP);
            ReportUtil.sureprintNodelist(failedASMNodes.toArray(new String[0]));
            validNodeArr = runningASMNodes.toArray(new String[0]);
            resultSet.addResult(validNodeArr, 1);
        } else {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5108", false));
            resultSet.addResult(validNodeArr, 1);
        }
        try {
            asmdg.getDiskGroups(validNodeArr, resultSet, asmDiskGroupHT);
            return true;
        }
        catch (ASMDiskGroupsUtilException e2) {
            String errMsg = s_msgBundle.getMessage("5131", true) + LSEP + e2.getMessage();
            ReportUtil.sureprintln(errMsg);
            return false;
        }
    }

    public static String getASMhome(Result result) {
        String[] args = new String[]{GET_ASM_HOME, VerificationUtil.getLocalNode()};
        String[] env = null;
        CVUHelperExec helperExec = null;
        result.setStatus(1);
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)("cvuhelper couldn't be executed" + e.getMessage()));
            String errMsg = s_gMsgBundle.getMessage("1030", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            String[] output = helperExec.getOutput();
            String errStr = null;
            if (output != null) {
                String[] errorArray = CVUHelperUtil.fetchError(output);
                errStr = VerificationUtil.strArr2String(errorArray, LSEP);
            }
            String errMsg = s_gMsgBundle.getMessage("1030", true, (Object[])new String[]{helperExec.getCommandString()});
            if (VerificationUtil.isStringGood(errStr)) {
                errMsg = errMsg + LSEP + errStr;
            }
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"failed to get ASM home");
                String errMsg = s_gMsgBundle.getMessage("1030", true, (Object[])new String[]{helperExec.getCommandString()});
                String[] errorArray = CVUHelperUtil.fetchError(output);
                String errStr = VerificationUtil.strArr2String(errorArray, LSEP);
                if (errStr != null && errStr.length() != 0) {
                    errMsg = errMsg + LSEP + errStr;
                }
                result.setStatus(3);
                result.addErrorDescription(new ErrorDescription(errMsg));
                return null;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                Trace.out((String)("Fetched ASM home successfully; returning '" + outArr[0] + "'"));
                return outArr[0];
            }
            Trace.out((String)"no output from cvuhelper");
            String errMsg = s_gMsgBundle.getMessage("1030", true, (Object[])new String[]{helperExec.getCommandString()});
            result.setStatus(3);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        Trace.out((String)"cvuhelper failed to produce output");
        String errMsg = s_gMsgBundle.getMessage("1030", true, (Object[])new String[]{helperExec.getCommandString()});
        String errStr = helperExec.getErrorString();
        if (errStr != null && errStr.length() != 0) {
            errMsg = errMsg + LSEP + helperExec.getErrorString();
        }
        result.setStatus(3);
        result.addErrorDescription(new ErrorDescription(errMsg));
        return null;
    }

    public static boolean getNeworkConfig(int networkNumber, boolean mute) {
        String networkInterconnect = null;
        String[] args = new String[]{GET_NET_CONFIG_ARG, Integer.toString(networkNumber)};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)("cvuhelper couldn't be executed" + e.getMessage()));
            if (!mute) {
                String errMsg = s_gMsgBundle.getMessage("1010", true, (Object[])new String[]{"cvuhelper", Integer.toString(networkNumber)}) + LSEP + e.getMessage();
                ReportUtil.printError(errMsg);
            }
            return false;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            if (!mute) {
                String errMsg = s_gMsgBundle.getMessage("1010", true, (Object[])new String[]{helperExec.getCommandString(), Integer.toString(networkNumber)}) + LSEP + helperExec.getErrorString();
                ReportUtil.printError(errMsg);
            }
            return false;
        }
        String[] output = helperExec.getOutput();
        String[] errorArray = null;
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"error during cvu helper execution");
                if (!mute) {
                    errorArray = CVUHelperUtil.fetchError(output);
                    String errMsg = VerificationUtil.strArr2String(errorArray, LSEP);
                    ReportUtil.printError(errMsg);
                }
                return false;
            }
            Trace.out((String)"gns details collected");
            String[] gnsDetails = CVUHelperUtil.fetchOutput(output);
            String netSubDomain = VerificationUtil.fetchTextByTags(gnsDetails[0], null, "<NET_SUBDOMAIN>", "</NET_SUBDOMAIN>");
            String netInterface = VerificationUtil.fetchTextByTags(gnsDetails[0], null, "<NET_INTERFACE>", "</NET_INTERFACE>");
            String netClass = VerificationUtil.fetchTextByTags(gnsDetails[0], null, "<NET_CLASS>", "</NET_CLASS>");
            networkInterconnect = netInterface == null || netInterface.length() == 0 ? "\"*\":" : "\"" + netInterface + "\":";
            networkInterconnect = networkInterconnect + netSubDomain + ":" + netClass;
            CVUVariables.setValue(CVUVariableConstants.INTERCONNECT_LIST, networkInterconnect);
            Trace.out((String)("network interconnect=" + networkInterconnect));
            return true;
        }
        Trace.out((String)"cvuhelper failed to produce output");
        if (!mute) {
            String errMsg = s_gMsgBundle.getMessage("1004", true, (Object[])new String[]{helperExec.getCommandString()});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errMsg = errMsg + LSEP + helperExec.getErrorString();
            }
            ReportUtil.printError(errMsg);
        }
        return false;
    }

    public static CSSMode getCSSMode() {
        String[] args = new String[]{GET_CSSMODE_HELPER_ARG};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            return null;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            return null;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("failed to get crsuser" + helperExec.getErrorString()));
                return null;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                if (CSSMode.cssBCCLUSTERED.name().equalsIgnoreCase(outArr[0])) {
                    return CSSMode.cssBCCLUSTERED;
                }
                if (CSSMode.cssCLUSTERED.name().equalsIgnoreCase(outArr[0])) {
                    return CSSMode.cssCLUSTERED;
                }
                if (CSSMode.cssEXCLUSIVE.name().equalsIgnoreCase(outArr[0])) {
                    return CSSMode.cssEXCLUSIVE;
                }
                if (CSSMode.cssLOCALONLY.name().equalsIgnoreCase(outArr[0])) {
                    return CSSMode.cssLOCALONLY;
                }
                return CSSMode.cssNULL;
            }
            Trace.out((String)"no output from cvuhelper");
            return null;
        }
        Trace.out((String)"cvuhelper produced no output");
        return null;
    }

    public static ASMPresence getASMPresence() {
        if (m_asmPresence != null) {
            return m_asmPresence;
        }
        String[] args = new String[]{GET_ASM_ATTRIBUTE, PRESENCE};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            return null;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            return null;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("failed to get ASM presence" + helperExec.getErrorString()));
                return null;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                try {
                    m_asmPresence = ASMPresence.getEnumMember(outArr[0]);
                }
                catch (EnumConstNotFoundException e) {
                    Trace.out((String)("output for asm presence was " + outArr[0]));
                }
                return m_asmPresence;
            }
            Trace.out((String)"no output from cvuhelper");
            return null;
        }
        Trace.out((String)"cvuhelper produced no output");
        return null;
    }

    public static int getASMCount() {
        String[] args = new String[]{GET_ASM_ATTRIBUTE, ASM_COUNT};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            return -1;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            return -1;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("failed to get ASM presence" + helperExec.getErrorString()));
                return -1;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                return Integer.parseInt(outArr[0]);
            }
            Trace.out((String)"no output from cvuhelper");
            return -1;
        }
        Trace.out((String)"cvuhelper produced no output");
        return -1;
    }

    public static CollectionResultSet<Integer> getDBServiceCount() {
        String[] args = new String[]{GET_DB_SERVICE_COUNT};
        String[] env = null;
        CVUHelperExec helperExec = null;
        CollectionResultSetImpl<Integer> rs = new CollectionResultSetImpl<Integer>();
        try {
            if (m_crsHomeVersion == null) {
                CVUHelperUtil.getCRSHomeInfo();
            }
            if (VerificationUtil.isVersionPre(m_crsHomeVersion, "11.2")) {
                Trace.out((String)("DB service count is not available for version " + m_crsHomeVersion));
                rs.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("11911", true)));
                rs.setStatus(3);
                return rs;
            }
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            rs.addErrorDescription(new ErrorDescription(e.getMessage()));
            String errMsg = s_gMsgBundle.getMessage("11912", true, (Object[])new String[]{helperExec.getCommandString()});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errMsg = errMsg + LSEP + helperExec.getErrorString();
            }
            rs.addErrorDescription(new ErrorDescription(errMsg));
            rs.setStatus(3);
            return rs;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)("failed to get DB service count" + helperExec.getErrorString()));
            String errMsg = s_gMsgBundle.getMessage("11912", true, (Object[])new String[]{helperExec.getCommandString()});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errMsg = errMsg + LSEP + helperExec.getErrorString();
            }
            rs.addErrorDescription(new ErrorDescription(errMsg));
            rs.setStatus(3);
            return rs;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("failed to get DB service count" + helperExec.getErrorString()));
                String errMsg = s_gMsgBundle.getMessage("11912", true, (Object[])new String[]{helperExec.getCommandString()});
                String errStr = helperExec.getErrorString();
                if (errStr != null && errStr.length() != 0) {
                    errMsg = errMsg + LSEP + helperExec.getErrorString();
                }
                rs.addErrorDescription(new ErrorDescription(errMsg));
                rs.setStatus(3);
                return rs;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                String dbServiceCount = VerificationUtil.fetchTextByTags(outArr[0], null, "<DB_SERVICE_COUNT>", "</DB_SERVICE_COUNT>");
                rs.setStatus(1);
                rs.setCollectedClusterwideData(Integer.parseInt(dbServiceCount));
                return rs;
            }
            Trace.out((String)("failed to get DB service count" + helperExec.getErrorString()));
            String errMsg = s_gMsgBundle.getMessage("11912", true, (Object[])new String[]{helperExec.getCommandString()});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errMsg = errMsg + LSEP + helperExec.getErrorString();
            }
            rs.addErrorDescription(new ErrorDescription(errMsg));
            rs.setStatus(3);
            return rs;
        }
        Trace.out((String)("failed to get DB service count" + helperExec.getErrorString()));
        String errMsg = s_gMsgBundle.getMessage("11912", true, (Object[])new String[]{helperExec.getCommandString()});
        String errStr = helperExec.getErrorString();
        if (errStr != null && errStr.length() != 0) {
            errMsg = errMsg + LSEP + helperExec.getErrorString();
        }
        rs.addErrorDescription(new ErrorDescription(errMsg));
        rs.setStatus(3);
        return rs;
    }

    public static NodeRole getNodeConfiguredRole(String node) {
        String roleType = "CONFIGURED";
        String[] args = new String[]{GET_NODE_ROLE, roleType, node};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            return null;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            return null;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("failed to get ASM presence" + helperExec.getErrorString()));
                return null;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                int role = Integer.parseInt(outArr[0]);
                return NodeRole.getEnumMember((int)role);
            }
            Trace.out((String)"no output from cvuhelper");
            return null;
        }
        Trace.out((String)"cvuhelper produced no output");
        return null;
    }

    public static String[] getNodeNames(NodeRole nodeRole) {
        String[] args = new String[]{GET_NODE_NAMES, nodeRole.getRole() + ""};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            return null;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            return null;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("failed to get ASM presence" + helperExec.getErrorString()));
                return null;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                return VerificationUtil.string2strArr(outArr[0]);
            }
            Trace.out((String)"no output from cvuhelper");
            return null;
        }
        Trace.out((String)"cvuhelper produced no output");
        return null;
    }

    public static boolean isASMLocal() {
        return CVUHelperUtil.getASMPresence() == ASMPresence.LOCAL;
    }

    public static boolean isASMFar() {
        return CVUHelperUtil.getASMPresence() == ASMPresence.FAR;
    }

    public static boolean isASMNear() {
        return CVUHelperUtil.getASMPresence() == ASMPresence.NEAR;
    }

    public static boolean validateGNSCredential(String gnsCredFile, Result result) {
        String[] args = new String[]{VALIDATE_GNS_CREDENTIAL, gnsCredFile};
        String[] env = null;
        String gnsDomain = null;
        String[] gnsAddress = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)("cvuhelper couldn't be executed " + e.getMessage()));
            String errMsg = s_gMsgBundle.getMessage("1110", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return false;
        }
        if (helperExec.getExitValue() != 0) {
            Trace.out((String)"cvuhelper failed to execute");
            String[] output = helperExec.getOutput();
            String errStr = null;
            if (output != null) {
                String[] errorArray = CVUHelperUtil.fetchError(output);
                errStr = VerificationUtil.strArr2String(errorArray, LSEP);
            }
            String errMsg = s_gMsgBundle.getMessage("1110", true, (Object[])new String[]{helperExec.getCommandString()});
            if (VerificationUtil.isStringGood(errStr)) {
                errMsg = errMsg + LSEP + errStr;
            }
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return false;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String errStr;
            String outputStr = helperExec.getOutputString();
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("failed to get GNS subdomain " + helperExec.getErrorString()));
                String errMsg = s_gMsgBundle.getMessage("1110", true, (Object[])new String[]{helperExec.getCommandString()});
                String[] errorArray = CVUHelperUtil.fetchError(output);
                String errStr2 = VerificationUtil.strArr2String(errorArray, LSEP);
                if (VerificationUtil.isStringGood(errStr2)) {
                    errMsg = errMsg + LSEP + errStr2;
                }
                result.setStatus(2);
                result.addErrorDescription(new ErrorDescription(errMsg));
                return false;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                gnsDomain = VerificationUtil.fetchTextByTags(outArr[0], "<GNS_DOMAIN_NAME>", "</GNS_DOMAIN_NAME>");
                CVUVariables.setValue(CVUVariableConstants.GNS_SUB_DOMAIN, gnsDomain);
                gnsAddress = VerificationUtil.fetchTextByTagsRepeat(outArr[0], "<GNS_VIP_ADDRESS>", "</GNS_VIP_ADDRESS>");
                CVUVariables.setValue(CVUVariableConstants.GNS_IP_ADDRESS, VerificationUtil.strArr2List(gnsAddress));
                return true;
            }
            Trace.out((String)"no output from cvuhelper");
            String errMsg = s_gMsgBundle.getMessage("1110", true, (Object[])new String[]{helperExec.getCommandString()});
            String[] errorArray = CVUHelperUtil.fetchError(output);
            if (errorArray.length != 0 && VerificationUtil.isStringGood(errStr = VerificationUtil.strArr2String(errorArray, LSEP))) {
                errMsg = errMsg + LSEP + errStr;
            }
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return false;
        }
        Trace.out((String)"cvuhelper failed to produce output");
        String errMsg = s_gMsgBundle.getMessage("1110", true, (Object[])new String[]{helperExec.getCommandString()});
        String errStr = helperExec.getErrorString();
        if (VerificationUtil.isStringGood(errStr)) {
            errMsg = errMsg + LSEP + helperExec.getErrorString();
        }
        result.setStatus(2);
        result.addErrorDescription(new ErrorDescription(errMsg));
        return false;
    }

    public static String getASMSid(Result result) {
        String[] args = new String[]{GET_ASM_INSTANCE, VerificationUtil.getLocalNode()};
        String[] env = null;
        CVUHelperExec helperExec = null;
        result.setStatus(1);
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)("cvuhelper couldn't be executed" + e.getMessage()));
            String errMsg = s_gMsgBundle.getMessage("1031", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            String[] output = helperExec.getOutput();
            String errStr = null;
            if (output != null) {
                String[] errorArray = CVUHelperUtil.fetchError(output);
                errStr = VerificationUtil.strArr2String(errorArray, LSEP);
            }
            String errMsg = s_gMsgBundle.getMessage("1031", true, (Object[])new String[]{helperExec.getCommandString()});
            if (VerificationUtil.isStringGood(errStr)) {
                errMsg = errMsg + LSEP + errStr;
            }
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"failed to get ASM sid");
                String errMsg = s_gMsgBundle.getMessage("1031", true, (Object[])new String[]{helperExec.getCommandString()});
                String[] errorArray = CVUHelperUtil.fetchError(output);
                String errStr = VerificationUtil.strArr2String(errorArray, LSEP);
                if (errStr != null && errStr.length() != 0) {
                    errMsg = errMsg + LSEP + errStr;
                }
                result.setStatus(3);
                result.addErrorDescription(new ErrorDescription(errMsg));
                return null;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                Trace.out((String)("Fetched ASM instance successfully; returning '" + outArr[0] + "'"));
                return outArr[0];
            }
            Trace.out((String)"no output from cvuhelper");
            String errMsg = s_gMsgBundle.getMessage("1031", true, (Object[])new String[]{helperExec.getCommandString()});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errMsg = errMsg + LSEP + helperExec.getErrorString();
            }
            result.setStatus(3);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        Trace.out((String)"cvuhelper failed to produce output");
        String errMsg = s_gMsgBundle.getMessage("1031", true, (Object[])new String[]{helperExec.getCommandString()});
        String errStr = helperExec.getErrorString();
        if (errStr != null && errStr.length() != 0) {
            errMsg = errMsg + LSEP + helperExec.getErrorString();
        }
        result.setStatus(3);
        result.addErrorDescription(new ErrorDescription(errMsg));
        return null;
    }

    public static String[] checkDynamicNetwork(ResultSet result) {
        String[] args = new String[]{DYNAMIC_NETWORK};
        String[] env = null;
        String[] strOut = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)("cvuhelper couldn't be executed " + e.getMessage()));
            String errMsg = s_gMsgBundle.getMessage("1102", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        if (helperExec.getExitValue() != 0) {
            Trace.out((String)"cvuhelper failed to execute");
            String[] output = helperExec.getOutput();
            String errStr = null;
            if (output != null) {
                String[] errorArray = CVUHelperUtil.fetchError(output);
                errStr = VerificationUtil.strArr2String(errorArray, LSEP);
            }
            String errMsg = s_gMsgBundle.getMessage("1102", true, (Object[])new String[]{helperExec.getCommandString()});
            if (VerificationUtil.isStringGood(errStr)) {
                errMsg = errMsg + LSEP + errStr;
            }
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("failed to get networks " + helperExec.getErrorString()));
                String errMsg = s_gMsgBundle.getMessage("1102", true, (Object[])new String[]{helperExec.getCommandString()});
                String[] errorArray = CVUHelperUtil.fetchError(output);
                String errStr = VerificationUtil.strArr2String(errorArray, LSEP);
                if (errStr != null && errStr.length() != 0) {
                    errMsg = errMsg + LSEP + errStr;
                }
                result.setStatus(3);
                result.addErrorDescription(new ErrorDescription(errMsg));
                return null;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                strOut = VerificationUtil.fetchTextByTagsRepeat(outArr[0], "<DYNAMIC_NETWORK>", "</DYNAMIC_NETWORK>");
                return strOut;
            }
            Trace.out((String)"no output from cvuhelper");
            String errMsg = s_gMsgBundle.getMessage("1102", true, (Object[])new String[]{helperExec.getCommandString()});
            result.setStatus(3);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        Trace.out((String)"cvuhelper failed to produce output");
        String errMsg = s_gMsgBundle.getMessage("1102", true, (Object[])new String[]{helperExec.getCommandString()});
        String errStr = helperExec.getErrorString();
        if (errStr != null && errStr.length() != 0) {
            errMsg = errMsg + LSEP + helperExec.getErrorString();
        }
        result.setStatus(3);
        result.addErrorDescription(new ErrorDescription(errMsg));
        return null;
    }

    public static List<String> getOCRLocations(Result result) {
        String[] args = new String[]{OCR_LOCATIONS};
        String[] env = null;
        String[] strOut = null;
        CVUHelperExec helperExec = null;
        List<String> outLocs = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)("cvuhelper couldn't be executed " + e.getMessage()));
            String errMsg = s_gMsgBundle.getMessage("1103", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        if (helperExec.getExitValue() != 0) {
            Trace.out((String)"cvuhelper failed to execute");
            String[] output = helperExec.getOutput();
            String errStr = null;
            if (output != null) {
                String[] errorArray = CVUHelperUtil.fetchError(output);
                errStr = VerificationUtil.strArr2String(errorArray, LSEP);
            }
            String errMsg = s_gMsgBundle.getMessage("1103", true, (Object[])new String[]{helperExec.getCommandString()});
            if (VerificationUtil.isStringGood(errStr)) {
                errMsg = errMsg + LSEP + errStr;
            }
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("failed to get ocr information " + helperExec.getErrorString()));
                String errMsg = s_gMsgBundle.getMessage("1103", true, (Object[])new String[]{helperExec.getCommandString()});
                String[] errorArray = CVUHelperUtil.fetchError(output);
                String errStr = VerificationUtil.strArr2String(errorArray, LSEP);
                if (errStr != null && errStr.length() != 0) {
                    errMsg = errMsg + LSEP + errStr;
                }
                result.setStatus(3);
                result.addErrorDescription(new ErrorDescription(errMsg));
                return null;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                strOut = VerificationUtil.fetchTextByTagsRepeat(outArr[0], "<OCR_LOCATION>", "</OCR_LOCATION>");
                outLocs = Arrays.asList(strOut);
                result.setStatus(1);
                return outLocs;
            }
            Trace.out((String)"no output from cvuhelper");
            String errMsg = s_gMsgBundle.getMessage("1103", true, (Object[])new String[]{helperExec.getCommandString()});
            result.setStatus(3);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        Trace.out((String)"cvuhelper failed to produce output");
        String errMsg = s_gMsgBundle.getMessage("1102", true, (Object[])new String[]{helperExec.getCommandString()});
        String errStr = helperExec.getErrorString();
        if (errStr != null && errStr.length() != 0) {
            errMsg = errMsg + LSEP + helperExec.getErrorString();
        }
        result.setStatus(3);
        result.addErrorDescription(new ErrorDescription(errMsg));
        return null;
    }

    public static CollectionResultSet<List<GNSData>> getGNSStatus() {
        String[] nodeList = null;
        String[] args = null;
        String[] env = null;
        CVUHelperExec helperExec = null;
        GNSData gnsData = null;
        String localNode = VerificationUtil.getLocalNode();
        ArrayList<GNSData> gnsDataList = new ArrayList<GNSData>();
        CollectionResultSetImpl<ArrayList<GNSData>> collectRS = new CollectionResultSetImpl<ArrayList<GNSData>>();
        try {
            nodeList = VerificationUtil.getStaticNodelist();
            args = new String[]{GNS_DATA_HELPER_ARG, VerificationUtil.strArr2String(nodeList, ",")};
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            String errMsg = s_gMsgBundle.getMessage("1005", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            collectRS.addResult(localNode, 2);
            collectRS.addErrorDescription(errorDesc);
            return collectRS;
        }
        catch (NodelistNotFoundException e) {
            Trace.out((String)("Failed to get the cluster nodes: " + e.getMessage()));
            String errMsg = s_msgBundle.getMessage("9004", false);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            collectRS.addResult(localNode, 2);
            collectRS.addErrorDescription(errorDesc);
            return collectRS;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            String errMsg = s_gMsgBundle.getMessage("1005", true, (Object[])new String[]{"cvuhelper"}) + LSEP + helperExec.getErrorString();
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            collectRS.addResult(nodeList, 2);
            collectRS.addErrorDescription(errorDesc);
            return collectRS;
        }
        String[] output = helperExec.getOutput();
        String[] gnsDetailsArr = null;
        String[] errorArray = null;
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"error during cvu helper execution");
                errorArray = CVUHelperUtil.fetchError(output);
                String errMsg = VerificationUtil.strArr2String(errorArray, LSEP);
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                collectRS.addResult(nodeList, 3);
                collectRS.addErrorDescription(errorDesc);
                return collectRS;
            }
        } else {
            Trace.out((String)"cvuhelper failed to produce output");
            String errMsg = s_gMsgBundle.getMessage("1005", true, (Object[])new String[]{"cvuhelper"});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errMsg = errMsg + LSEP + helperExec.getErrorString();
            }
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            collectRS.addResult(nodeList, 2);
            collectRS.addErrorDescription(errorDesc);
            return collectRS;
        }
        Trace.out((String)"all data collected");
        gnsDetailsArr = CVUHelperUtil.fetchOutput(output);
        Trace.out((String)("there are " + gnsDetailsArr.length + " gns info"));
        if (gnsDetailsArr != null && gnsDetailsArr.length > 0) {
            for (int i = 0; i < gnsDetailsArr.length; ++i) {
                String gnsVIPIsRunningStr;
                String gnsIsRunningStr;
                String gnsVIPIsEnabledStr;
                boolean isEnabled = false;
                boolean isRunning = false;
                boolean isGNSVIPEnabled = false;
                boolean isGNSVIPRunning = false;
                Trace.out((String)("gns detail = " + gnsDetailsArr[i]));
                String gnsLine = VerificationUtil.fetchTextByTags(gnsDetailsArr[i], null, "<GNS_DETAILS>", "</GNS_DETAILS>");
                if (gnsLine == null || gnsLine.length() == 0) {
                    Trace.out((String)"not processing as gns info");
                    continue;
                }
                String nodeName = VerificationUtil.fetchTextByTags(gnsLine, null, "<GNS_NODE>", "</GNS_NODE>");
                String gnsIsEnabledStr = VerificationUtil.fetchTextByTags(gnsLine, null, "<GNS_ENABLE>", "</GNS_ENABLE>");
                if (gnsIsEnabledStr != null && gnsIsEnabledStr.length() != 0) {
                    isEnabled = Boolean.valueOf(gnsIsEnabledStr);
                }
                if ((gnsVIPIsEnabledStr = VerificationUtil.fetchTextByTags(gnsLine, null, "<VIP_ENABLE>", "</VIP_ENABLE>")) != null && gnsVIPIsEnabledStr.length() != 0) {
                    isGNSVIPEnabled = Boolean.valueOf(gnsIsEnabledStr);
                }
                if ((gnsIsRunningStr = VerificationUtil.fetchTextByTags(gnsLine, null, "<GNS_RUN>", "</GNS_RUN>")) != null && gnsIsRunningStr.length() != 0) {
                    isRunning = Boolean.valueOf(gnsIsRunningStr);
                }
                if ((gnsVIPIsRunningStr = VerificationUtil.fetchTextByTags(gnsLine, null, "<VIP_RUN>", "</VIP_RUN>")) != null && gnsVIPIsRunningStr.length() != 0) {
                    isGNSVIPRunning = Boolean.valueOf(gnsVIPIsRunningStr);
                }
                gnsData = new GNSData(nodeName, isEnabled, isRunning, isGNSVIPEnabled, isGNSVIPRunning);
                gnsDataList.add(gnsData);
            }
            collectRS.setStatus(1);
            collectRS.setCollectedClusterwideData(gnsDataList);
        }
        return collectRS;
    }

    public static boolean isValidGNSVIP(String gnsVIP, boolean preCheck, Result result) {
        String[] args = null;
        String[] env = null;
        String isValid = null;
        CVUHelperExec helperExec = null;
        args = new String[]{IS_VALID_GNS_VIP, gnsVIP, String.valueOf(preCheck)};
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)("cvuhelper couldn't be executed " + e.getMessage()));
            String errMsg = s_gMsgBundle.getMessage("1111", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return false;
        }
        if (helperExec.getExitValue() != 0) {
            Trace.out((String)"cvuhelper failed to execute");
            String[] output = helperExec.getOutput();
            String errStr = null;
            if (output != null) {
                String[] errorArray = CVUHelperUtil.fetchError(output);
                errStr = VerificationUtil.strArr2String(errorArray, LSEP);
            }
            String errMsg = s_gMsgBundle.getMessage("1111", true, (Object[])new String[]{helperExec.getCommandString()});
            if (VerificationUtil.isStringGood(errStr)) {
                errMsg = errMsg + LSEP + errStr;
            }
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return false;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String errStr;
            String outputStr = helperExec.getOutputString();
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)("GNS VIP is not valid " + helperExec.getErrorString()));
                String[] errorArray = CVUHelperUtil.fetchError(output);
                String errStr2 = VerificationUtil.strArr2String(errorArray, LSEP);
                if (VerificationUtil.isStringGood(errStr2)) {
                    result.addErrorDescription(new ErrorDescription(errStr2));
                }
                result.setStatus(2);
                return false;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                Trace.out((String)("output from cvuhelper " + outArr[0]));
                result.setStatus(1);
                isValid = VerificationUtil.fetchTextByTags(outArr[0], "<IS_VALID_GNS>", "</IS_VALID_GNS>");
                return Boolean.parseBoolean(isValid);
            }
            Trace.out((String)"no output from cvuhelper");
            String errMsg = s_gMsgBundle.getMessage("1111", true, (Object[])new String[]{helperExec.getCommandString()});
            String[] errorArray = CVUHelperUtil.fetchError(output);
            if (errorArray.length != 0 && VerificationUtil.isStringGood(errStr = VerificationUtil.strArr2String(errorArray, LSEP))) {
                errMsg = errMsg + LSEP + errStr;
            }
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return false;
        }
        Trace.out((String)"cvuhelper failed to produce output");
        String errMsg = s_gMsgBundle.getMessage("1111", true, (Object[])new String[]{helperExec.getCommandString()});
        String errStr = helperExec.getErrorString();
        if (VerificationUtil.isStringGood(errStr)) {
            errMsg = errMsg + LSEP + helperExec.getErrorString();
        }
        result.setStatus(2);
        result.addErrorDescription(new ErrorDescription(errMsg));
        return false;
    }

    public static OracleCachedRowSet runASMQuery(String query, String internalLogon, Result result) {
        String[] args = new String[]{RUN_ASM_QUERY, query, VerificationUtil.getLocalNode(), internalLogon};
        String[] env = null;
        CVUHelperExec helperExec = null;
        String home = null;
        result.setStatus(1);
        try {
            if (m_crsHome == null) {
                CVUHelperUtil.getCRSHomeInfo();
            }
            if ((home = VerificationUtil.isVersionPre(m_crsHomeVersion, "11.2") ? CVUHelperUtil.getASMhome(result) : m_crsHome) == null) {
                return null;
            }
            if (VerificationUtil.isVersionPre(m_crsHomeVersion, "12.1") && (ParamManager.isRuncluvfy() || !VerificationUtil.isOTN())) {
                if (m_connStringASM == null) {
                    m_connStringASM = CVUHelperUtil.getASMConnectDescriptor(result);
                }
                if (!VerificationUtil.isStringGood(m_connStringASM)) {
                    return null;
                }
                OracleConnection asmConnection = SQLFactory.getConnection((String)m_connStringASM, (String)"", (String)"", (String)internalLogon, (boolean)false);
                Trace.out((String)"Connection to Local ASM instance successful");
                Statement stmt = asmConnection.createStatement();
                Trace.out((String)("Executing the query " + query));
                java.sql.ResultSet queryResult = stmt.executeQuery(query);
                OracleCachedRowSet rowSet = new OracleCachedRowSet();
                rowSet.populate(queryResult);
                return rowSet;
            }
            helperExec = CVUHelperUtil.runCVUHelper(args, env, home);
        }
        catch (CVUHelperException e) {
            Trace.out((String)("cvuhelper couldn't be executed" + e.getMessage()));
            String errMsg = s_gMsgBundle.getMessage("12938", true, (Object[])new String[]{VerificationUtil.getLocalNode()}) + LSEP + e.getMessage();
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        catch (DBConnectionException dbex) {
            Trace.out((String)("Exception while getting connection " + dbex.getMessage()));
            result.setStatus(2);
            String errMsg = s_gMsgBundle.getMessage("12945", true, (Object[])new String[]{m_connStringASM}) + LSEP + dbex.getMessage();
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        catch (SQLException e) {
            Trace.out((String)("Exception while executing query :" + e.getMessage()));
            result.setStatus(2);
            String errMsg = s_gMsgBundle.getMessage("12941", true, (Object[])new String[]{VerificationUtil.getLocalNode()}) + LSEP + e.getMessage();
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            String[] output = helperExec.getOutput();
            String errStr = null;
            if (output != null) {
                String[] errorArray = CVUHelperUtil.fetchError(output);
                errStr = VerificationUtil.strArr2String(errorArray, LSEP);
            }
            String errMsg = s_gMsgBundle.getMessage("12938", true, (Object[])new String[]{VerificationUtil.getLocalNode()});
            if (VerificationUtil.isStringGood(errStr)) {
                errMsg = errMsg + LSEP + errStr;
            }
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"failed to run ASM query");
                String errMsg = s_gMsgBundle.getMessage("12941", true, (Object[])new String[]{VerificationUtil.getLocalNode()});
                String[] errorArray = CVUHelperUtil.fetchError(output);
                String errStr = VerificationUtil.strArr2String(errorArray, LSEP);
                if (errStr != null && errStr.length() != 0) {
                    errMsg = errMsg + LSEP + errStr;
                }
                result.setStatus(2);
                result.addErrorDescription(new ErrorDescription(errMsg));
                return null;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                Trace.out((String)("Query result can be found at'" + outArr[0] + "'"));
                int colCount = 0;
                int colCounter = 1;
                try {
                    String[] rows;
                    String colCountString = VerificationUtil.fetchTextByTags(outArr[0], "<COLUMN_COUNT>", "</COLUMN_COUNT>");
                    if (VerificationUtil.isStringGood(colCountString)) {
                        colCount = Integer.parseInt(colCountString);
                    }
                    RowSetMetaDataImpl metaData = new RowSetMetaDataImpl();
                    metaData.setColumnCount(colCount);
                    String colNameStr = VerificationUtil.fetchTextByTags(outArr[0], "<COLUMN_NAME>", "</COLUMN_NAME>");
                    String colLabelStr = VerificationUtil.fetchTextByTags(outArr[0], "<COLUMN_LABEL>", "</COLUMN_LABEL>");
                    String[] colNameArr = VerificationUtil.string2strArr(colNameStr, "|");
                    String[] colLabelArr = VerificationUtil.string2strArr(colLabelStr, "|");
                    for (int i = 1; i <= colNameArr.length; ++i) {
                        metaData.setColumnName(i, colNameArr[i - 1]);
                        metaData.setColumnLabel(i, colLabelArr[i - 1]);
                        metaData.setColumnType(i, 12);
                    }
                    OracleCachedRowSet rowSet = new OracleCachedRowSet();
                    rowSet.setMetaData(metaData);
                    rowSet.setCommand(query);
                    for (String row : rows = VerificationUtil.fetchTextByTagsRepeat(outArr[0], "<ROW_DATA>", "</ROW_DATA>")) {
                        Trace.out((String)("Row data:" + row));
                        String[] columns = VerificationUtil.string2strArr(row, "|");
                        rowSet.moveToInsertRow();
                        colCounter = 1;
                        for (String column : columns) {
                            Trace.out((String)("Column data:" + column));
                            Trace.out((String)("column index : " + colCounter));
                            rowSet.updateString(colCounter, column);
                            ++colCounter;
                        }
                        rowSet.insertRow();
                    }
                    return rowSet;
                }
                catch (SQLException ex) {
                    Trace.out((String)ex.getMessage());
                    String errMsg = s_gMsgBundle.getMessage("12940", true, (Object[])new String[]{helperExec.getCommandString(), VerificationUtil.getLocalNode()});
                    errMsg = errMsg + LSEP + ex.getMessage();
                    result.setStatus(2);
                    result.addErrorDescription(new ErrorDescription(errMsg));
                    return null;
                }
                catch (NumberFormatException nfe) {
                    Trace.out((String)nfe.getMessage());
                    String errMsg = s_gMsgBundle.getMessage("12940", true, (Object[])new String[]{helperExec.getCommandString(), VerificationUtil.getLocalNode()});
                    result.setStatus(2);
                    result.addErrorDescription(new ErrorDescription(errMsg));
                    return null;
                }
            }
            Trace.out((String)"no output from cvuhelper");
            String errMsg = s_gMsgBundle.getMessage("12939", true, (Object[])new String[]{VerificationUtil.getLocalNode()});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errMsg = errMsg + LSEP + helperExec.getErrorString();
            }
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        Trace.out((String)"cvuhelper failed to produce output");
        String errMsg = s_gMsgBundle.getMessage("12939", true, (Object[])new String[]{VerificationUtil.getLocalNode()});
        String errStr = helperExec.getErrorString();
        if (errStr != null && errStr.length() != 0) {
            errMsg = errMsg + LSEP + helperExec.getErrorString();
        }
        result.setStatus(2);
        result.addErrorDescription(new ErrorDescription(errMsg));
        return null;
    }

    public static String getASMParameter(String parameter, Result result) {
        String query = "select value from v$parameter where name like'" + parameter + "'";
        String paramValue = null;
        OracleCachedRowSet rowSet = CVUHelperUtil.runASMQuery(query, "sysdba", result);
        if (rowSet != null) {
            try {
                rowSet.first();
                paramValue = rowSet.getString(1);
                Trace.out((String)("obtained paramater value " + paramValue));
            }
            catch (SQLException sqlex) {
                Trace.out((String)("failed to retreive results " + sqlex.getMessage()));
                result.setStatus(2);
                result.addErrorDescription(new ErrorDescription(sqlex.getMessage()));
            }
        }
        return paramValue;
    }

    public static String getASMConnectDescriptor(Result result) {
        String[] args = new String[]{GET_ASM_CONNECTION_INFO, "sysdba", VerificationUtil.getLocalNode()};
        String[] env = null;
        CVUHelperExec helperExec = null;
        Object home = null;
        result.setStatus(1);
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)("cvuhelper couldn't be executed" + e.getMessage()));
            String errMsg = s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"GET_ASM_CONN-1-" + VerificationUtil.getLocalNode()}) + LSEP + e.getMessage();
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            String[] output = helperExec.getOutput();
            String errStr = null;
            if (output != null) {
                String[] errorArray = CVUHelperUtil.fetchError(output);
                errStr = VerificationUtil.strArr2String(errorArray, LSEP);
            }
            String errMsg = s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"GET_ASM_CONN-2-" + VerificationUtil.getLocalNode()});
            if (VerificationUtil.isStringGood(errStr)) {
                errMsg = errMsg + LSEP + errStr;
            }
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"failed to get ASM Connection information");
                String errMsg = s_gMsgBundle.getMessage("12947", true, (Object[])new String[]{VerificationUtil.getLocalNode()});
                String[] errorArray = CVUHelperUtil.fetchError(output);
                String errStr = VerificationUtil.strArr2String(errorArray, LSEP);
                if (errStr != null && errStr.length() != 0) {
                    errMsg = errMsg + LSEP + errStr;
                }
                result.setStatus(2);
                result.addErrorDescription(new ErrorDescription(errMsg));
                return null;
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                return VerificationUtil.fetchTextByTags(outArr[0], "<CONN_STRING>", "</CONN_STRING>");
            }
            Trace.out((String)"no output from cvuhelper");
            String errMsg = s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"GET_ASM_CONN_NO_OP-" + VerificationUtil.getLocalNode()});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errMsg = errMsg + LSEP + helperExec.getErrorString();
            }
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(errMsg));
            return null;
        }
        Trace.out((String)"cvuhelper failed to produce output");
        String errMsg = s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"GET_ASM_CONN_NO_OP-" + VerificationUtil.getLocalNode()});
        String errStr = helperExec.getErrorString();
        if (errStr != null && errStr.length() != 0) {
            errMsg = errMsg + LSEP + helperExec.getErrorString();
        }
        result.setStatus(2);
        result.addErrorDescription(new ErrorDescription(errMsg));
        return null;
    }

    public static Hashtable<String, Hashtable<String, List<String>>> getOraclePatchList(String[] nodeList, String home, String homeVersion, ResultSet resultSet) {
        String crsHome;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        GlobalExecution globalExec = new GlobalExecution();
        boolean isUnix = nativeSystem.isUnixSystem();
        String cvuHelper = nativeSystem.getScriptFileName("cvuhelper");
        Hashtable<String, Hashtable<String, List<String>>> nodewisePatchList = new Hashtable<String, Hashtable<String, List<String>>>();
        String cvHome = VerificationUtil.getCVHome();
        String currentVersion = new Version().toString();
        String[] errorArray = null;
        String[] outArr = null;
        String errMsg = "";
        if (!VerificationUtil.isStringGood(m_crsHome)) {
            try {
                CVUHelperUtil.getCRSHomeInfo();
                crsHome = m_crsHome;
            }
            catch (CVUHelperException e) {
                errMsg = e.getMessage();
                Trace.out((String)e.getMessage());
                resultSet.addErrorDescription(new ErrorDescription(errMsg));
                resultSet.addResult(nodeList, 2);
                return nodewisePatchList;
            }
        } else {
            crsHome = m_crsHome;
        }
        String cvuHelperPath = isUnix && cvHome.equals(crsHome + FSEP) || !isUnix && cvHome.equalsIgnoreCase(crsHome + FSEP) ? CVUAutoUpdateManager.getCVUFileLocation("cv" + FSEP + "remenv" + FSEP + cvuHelper) : (CVUHelperUtil.isCRSHomeHelperCapable(GET_ORACLE_PATCH_LIST, crsHome, currentVersion, cvuHelper) ? crsHome + FSEP + "cv" + FSEP + "remenv" + FSEP + cvuHelper : cvHome + FSEP + "cv" + FSEP + "remenv" + FSEP + cvuHelper);
        String helperVersion = CVUHelperUtil.getHelperVersion(home, homeVersion, GET_ORACLE_PATCH_LIST);
        String cvuHelperCmd = cvuHelperPath + " " + home + " " + helperVersion + " " + CVUHelperUtil.getHelperJarFullPath(helperVersion) + " " + CVUAutoUpdateManager.getDerivedCVUHome() + " " + GET_ORACLE_PATCH_LIST + " " + home;
        globalExec.runGenericCmd(nodeList, cvuHelperCmd, resultSet);
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result != null && result.getStatus() == 1) {
                String[] cmdOut = (String[])result.getResultInfoSet().get(1);
                if (cmdOut.length <= 0) continue;
                String outputStr = VerificationUtil.strArr2List(cmdOut);
                Trace.out((String)outputStr);
                int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
                if (status == 2) {
                    Trace.out((String)"error during cvu helper execution");
                    errorArray = CVUHelperUtil.fetchError(cmdOut);
                    errMsg = s_gMsgBundle.getMessage("1260", true, (Object[])new String[]{cvuHelperCmd}) + LSEP + VerificationUtil.strArr2List(errorArray);
                    result.addErrorDescription(new ErrorDescription(errMsg));
                    result.setStatus(3);
                    resultSet.addResult(node, result);
                    continue;
                }
                if (status == 1) {
                    Trace.out((String)"partial success with data collection");
                    outArr = CVUHelperUtil.fetchOutput(cmdOut);
                    errorArray = CVUHelperUtil.fetchError(cmdOut);
                    errMsg = s_gMsgBundle.getMessage("1260", true, (Object[])new String[]{cvuHelperCmd}) + LSEP + VerificationUtil.strArr2List(errorArray);
                    result.addErrorDescription(new ErrorDescription(errMsg));
                    result.setStatus(3);
                    resultSet.addResult(node, result);
                    continue;
                }
                Trace.out((String)"all data collected");
                outArr = CVUHelperUtil.fetchOutput(cmdOut);
                if (outArr.length <= 0) continue;
                Hashtable patchList = new Hashtable();
                Pattern p = Pattern.compile("Patch ID : ([^:]*) \\| Bugs Fixed : ([^:]*)$");
                for (String outLine : outArr) {
                    if (!VerificationUtil.isStringGood(outLine)) continue;
                    String patchID = null;
                    String bugIDs = null;
                    Matcher m = p.matcher(outLine);
                    if (m.matches()) {
                        patchID = m.group(1).trim();
                        bugIDs = m.group(2).trim();
                        Trace.out((String)("Patch ID : " + patchID + " Bugs Fixed : + " + bugIDs));
                    }
                    ArrayList<String> bugList = new ArrayList<String>();
                    if (VerificationUtil.isStringGood(bugIDs)) {
                        bugIDs = bugIDs.substring(1, bugIDs.length() - 1);
                        bugList.addAll(Arrays.asList(VerificationUtil.string2strArr(bugIDs)));
                    }
                    if (!VerificationUtil.isStringGood(patchID)) continue;
                    patchList.put(patchID, bugList);
                }
                nodewisePatchList.put(node, patchList);
                continue;
            }
            errMsg = s_gMsgBundle.getMessage("1260", true, (Object[])new String[]{cvuHelperCmd});
            result.addErrorDescription(new ErrorDescription(errMsg));
        }
        return nodewisePatchList;
    }

    public static boolean getOPatchStatus(String[] nodeList, String home, String requiredPatchID, String homeVersion, ResultSet resultSet) {
        String crsHome;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        GlobalExecution globalExec = new GlobalExecution();
        boolean isUnix = nativeSystem.isUnixSystem();
        String cvuHelper = nativeSystem.getScriptFileName("cvuhelper");
        String cvHome = VerificationUtil.getCVHome();
        String currentVersion = new Version().toString();
        boolean patchStatus = true;
        String[] errorArray = null;
        String[] outArr = null;
        String patchID = null;
        String errMsg = "";
        if (!VerificationUtil.isStringGood(m_crsHome)) {
            try {
                CVUHelperUtil.getCRSHomeInfo();
                crsHome = m_crsHome;
            }
            catch (CVUHelperException e) {
                errMsg = e.getMessage();
                Trace.out((String)e.getMessage());
                resultSet.addErrorDescription(new ErrorDescription(errMsg));
                resultSet.addResult(nodeList, 2);
                return false;
            }
        } else {
            crsHome = m_crsHome;
        }
        String cvuHelperPath = isUnix && cvHome.equals(crsHome + FSEP) || !isUnix && cvHome.equalsIgnoreCase(crsHome + FSEP) ? CVUAutoUpdateManager.getCVUFileLocation("cv" + FSEP + "remenv" + FSEP + cvuHelper) : (CVUHelperUtil.isCRSHomeHelperCapable(GET_OPATCH_STATUS, crsHome, currentVersion, cvuHelper) ? crsHome + FSEP + "cv" + FSEP + "remenv" + FSEP + cvuHelper : cvHome + FSEP + "cv" + FSEP + "remenv" + FSEP + cvuHelper);
        String helperVersion = CVUHelperUtil.getHelperVersion(home, homeVersion, GET_OPATCH_STATUS);
        String cvuHelperCmd = cvuHelperPath + " " + home + " " + helperVersion + " " + CVUHelperUtil.getHelperJarFullPath(helperVersion) + " " + CVUAutoUpdateManager.getDerivedCVUHome() + " " + GET_OPATCH_STATUS + " " + home + " " + requiredPatchID;
        globalExec.runGenericCmd(nodeList, cvuHelperCmd, resultSet);
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result != null && result.getStatus() == 1) {
                String[] cmdOut = (String[])result.getResultInfoSet().get(1);
                if (cmdOut.length == 0 || VerificationUtil.strArr2List(cmdOut).indexOf("CVH_OUT") < 0) continue;
                String outputStr = VerificationUtil.strArr2List(cmdOut);
                Trace.out((String)outputStr);
                int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
                if (status == 2) {
                    Trace.out((String)"error during cvu helper execution");
                    errorArray = CVUHelperUtil.fetchError(cmdOut);
                    errMsg = s_gMsgBundle.getMessage("1260", true, (Object[])new String[]{cvuHelperCmd}) + LSEP + VerificationUtil.strArr2List(errorArray);
                    result.addErrorDescription(new ErrorDescription(errMsg));
                    result.setStatus(3);
                    continue;
                }
                if (status == 1) {
                    Trace.out((String)"partial success with data collection");
                    errorArray = CVUHelperUtil.fetchError(cmdOut);
                    errMsg = s_gMsgBundle.getMessage("1260", true, (Object[])new String[]{cvuHelperCmd}) + LSEP + VerificationUtil.strArr2List(errorArray);
                    result.addErrorDescription(new ErrorDescription(errMsg));
                    result.setStatus(3);
                    continue;
                }
                Trace.out((String)"all data collected");
                boolean pStatus = false;
                outArr = CVUHelperUtil.fetchOutput(cmdOut);
                if (outArr.length <= 0) continue;
                Pattern p = Pattern.compile("([^:]*):installed$");
                for (String outLine : outArr) {
                    Matcher m = p.matcher(outLine);
                    if (!m.matches()) continue;
                    pStatus = true;
                    patchID = m.group(1);
                    break;
                }
                if (!pStatus) {
                    errMsg = s_gMsgBundle.getMessage("1253", true, (Object[])new String[]{node, home});
                    ErrorDescription errDesc = new ErrorDescription(errMsg);
                    ReportUtil.sureprintln(errMsg);
                    result.setExpectedValue(requiredPatchID.replaceAll(Pattern.quote("|"), "OR"));
                    result.setActualValue(patchID);
                    result.addErrorDescription(errDesc);
                    result.setStatus(3);
                }
                patchStatus &= pStatus;
                continue;
            }
            errMsg = s_gMsgBundle.getMessage("1260", true, (Object[])new String[]{cvuHelperCmd});
            result.addErrorDescription(new ErrorDescription(errMsg));
        }
        return patchStatus;
    }

    public static String[] getScanInfo(String[] nodeList, ResultSet resultSet) {
        String[] args = new String[]{GET_SCAN_INFO};
        String[] env = null;
        String[] scanInfo = null;
        String errorMessage = null;
        int status = 2;
        CVUHelperExec helperExec = null;
        resultSet.addResult(nodeList, 1);
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            errorMessage = s_gMsgBundle.getMessage("1002", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
            ErrorDescription errorDesc = new ErrorDescription(errorMessage);
            resultSet.addResult(nodeList, 2);
            resultSet.addErrorDescription(nodeList, errorDesc);
            ReportUtil.printError(errorMessage);
            return scanInfo;
        }
        if (helperExec.getExitValue() == 2) {
            String[] helperErrors;
            Trace.out((String)"cvuhelper failed to execute");
            errorMessage = s_gMsgBundle.getMessage("1002", true, (Object[])new String[]{helperExec.getCommandString()});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errorMessage = errorMessage + LSEP + errStr;
            }
            if ((helperErrors = helperExec.getErrorMessages()) != null && helperErrors.length > 0) {
                errorMessage = errorMessage + LSEP + VerificationUtil.strArr2List(helperErrors);
            }
            ErrorDescription errorDesc = new ErrorDescription(errorMessage);
            resultSet.addResult(nodeList, 2);
            resultSet.addErrorDescription(nodeList, errorDesc);
            ReportUtil.printError(errorMessage);
            return scanInfo;
        }
        String[] output = helperExec.getOutput();
        String[] errorArray = null;
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"error during cvu helper execution");
                errorArray = CVUHelperUtil.fetchError(output);
            } else if (status == 1) {
                Trace.out((String)"partial success with data collection");
                scanInfo = CVUHelperUtil.fetchOutput(output);
                errorArray = CVUHelperUtil.fetchError(output);
                if (scanInfo.length == 0) {
                    Trace.out((String)"all failure");
                }
            } else {
                Trace.out((String)"all data collected");
                scanInfo = CVUHelperUtil.fetchOutput(output);
            }
        } else {
            Trace.out((String)"cvuhelper failed to produce output");
            errorMessage = s_gMsgBundle.getMessage("1002", true, (Object[])new String[]{helperExec.getCommandString()});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errorMessage = errorMessage + LSEP + helperExec.getErrorString();
            }
            ErrorDescription errorDesc = new ErrorDescription(errorMessage);
            resultSet.addResult(nodeList, 2);
            resultSet.addErrorDescription(nodeList, errorDesc);
            ReportUtil.printError(errorMessage);
            return scanInfo;
        }
        if (status != 0) {
            ErrorDescription errorDesc;
            if (errorArray.length >= 1) {
                Trace.out((String)"cvuhelper returned error");
                errorMessage = VerificationUtil.strArr2String(errorArray, LSEP);
                errorDesc = new ErrorDescription(errorMessage);
                resultSet.addResult(nodeList, 3);
                resultSet.addErrorDescription(nodeList, errorDesc);
                ReportUtil.printError(errorMessage);
            } else {
                Trace.out((String)"cvu helper didn't succeed. But no error was returned");
                errorMessage = s_gMsgBundle.getMessage("1002", true, (Object[])new String[]{helperExec.getCommandString()});
                errorMessage = errorMessage + helperExec.getOutputString();
                errorDesc = new ErrorDescription(errorMessage);
                resultSet.addResult(nodeList, 2);
                resultSet.addErrorDescription(nodeList, errorDesc);
                ReportUtil.printError(errorMessage);
            }
        }
        return scanInfo;
    }

    public static String getASMPWFile() throws CVUHelperException {
        CVUHelperExec helperExec = null;
        String[] args = new String[]{GET_ASM_PWFILE};
        String[] env = null;
        String pwFile = null;
        String errMsg = null;
        helperExec = CVUHelperUtil.runCVUHelper(args, env);
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            throw new CVUHelperException(helperExec.getErrorString());
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                String[] errorArray = CVUHelperUtil.fetchError(output);
                errMsg = VerificationUtil.strArr2String(errorArray, LSEP);
                Trace.out((String)("CVU helper failed to get the password file location. Error string is : " + errMsg));
                throw new CVUHelperException(errMsg);
            }
            String[] outArr = CVUHelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                pwFile = outArr[0].trim();
            }
        } else {
            Trace.out((String)"cvuhelper produced no output");
            errMsg = s_gMsgBundle.getMessage("10090", true);
            String errStr = helperExec.getErrorString();
            if (VerificationUtil.isStringGood(errStr)) {
                errMsg = errMsg + LSEP + errStr;
            }
            throw new CVUHelperException(errMsg);
        }
        return pwFile;
    }
}

