/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.cluster.verification.StorageType;
import oracle.ops.verification.framework.engine.Entity;
import oracle.ops.verification.framework.engine.EntityStatus;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.storage.FSDetails;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageData;
import oracle.ops.verification.framework.storage.StorageDataHandler;

public class VxFSData
extends StorageData
implements StorageConstants {
    private Entity<FSDetails> m_fsDetails = new Entity();

    public VxFSData(String id) {
        super(id, StorageType.VXFS);
    }

    public VxFSData(String id, Entity<FSDetails> fsDetails) {
        super(id, StorageType.VXFS);
        this.m_fsDetails = fsDetails;
        if (fsDetails.getStatus() == EntityStatus.VALID) {
            this.setFreeSpace(fsDetails.getValue().getFreeSpace());
            this.setStorageSize(fsDetails.getValue().getSize());
        }
    }

    @Override
    public void checkSharedness(HashMap<String, StorageData> nodeSDmap, ResultSet rSet) {
        StorageDataHandler.checkFileSystemSharedness(nodeSDmap, rSet);
    }

    public Entity<FSDetails> getFSDetails() {
        return this.m_fsDetails;
    }

    @Override
    public List<ErrorDescription> getEntityErrors() {
        if (this.m_fsDetails != null) {
            return this.m_fsDetails.getErrors();
        }
        return new ArrayList<ErrorDescription>();
    }

    @Override
    public String toString() {
        return super.toString() + LSEP + "FSDetails: " + this.m_fsDetails;
    }
}

