/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.StorageType;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.storage.PathDiskInfo;
import oracle.ops.verification.framework.storage.StorageCheckContext;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageData;
import oracle.ops.verification.framework.storage.StorageDataHandler;
import oracle.ops.verification.framework.storage.StorageDataParser;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.TypeFinder;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.MultiNodeException;

public class VerifyStorage
implements StorageConstants,
VerificationConstants {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");

    public boolean isShared(String path, String[] nodeList, OracleFileType fileType, String release) throws StorageException, MultiNodeException {
        return this.isShared(path, nodeList, new Vector<StorageInfo>(), fileType, nodeList.length, new ArrayList<String>(), release, false);
    }

    public boolean isShared(String path, String[] nodeList, Vector<StorageInfo> stList, OracleFileType fileType, int targetCount, Collection<String> succNodeList, String release, boolean considerASMStorage) throws StorageException, MultiNodeException {
        VerificationUtil.traceAndLog("path='%s' nodeList='%s' fileType='%s' targetCount='%s' release='%s' considerASMStorage='%s'", path, VerificationUtil.strArr2List(nodeList), fileType.name(), targetCount, release, considerASMStorage);
        StorageCheckContext scCtx = new StorageCheckContext();
        scCtx.setUsageType(fileType);
        scCtx.setRelease(release);
        scCtx.setTargetCount(targetCount);
        scCtx.setConsiderASMStorage(considerASMStorage);
        StorageDataHandler sdHndlr = new StorageDataHandler(scCtx);
        HashMap<String, StorageData> nodeSDmap = sdHndlr.getStorageData(path, nodeList);
        new TypeFinder().nodeSDmap2SIcol(nodeSDmap, stList);
        ResultSet locRS = new ResultSet();
        ArrayList<String> succNodes = new ArrayList<String>();
        sdHndlr.checkSharedness(nodeSDmap, targetCount, succNodes, locRS);
        int rsStatus = locRS.getStatus();
        if (rsStatus == 2) {
            throw new StorageException("7000", locRS.getAllErrorsStr());
        }
        if (rsStatus == 3) {
            return false;
        }
        succNodeList.addAll(succNodes);
        HashMap<String, StorageData> succNodeSDmap = new HashMap<String, StorageData>();
        for (String sucNode : succNodes) {
            succNodeSDmap.put(sucNode, nodeSDmap.get(sucNode));
        }
        if (fileType != null) {
            locRS = new ResultSet();
            sdHndlr.checkUsageCompatibility(succNodeSDmap, locRS);
            if (!locRS.allSuccess()) {
                VerificationUtil.traceAndLog("Storage type is not compatible with Oracle Usage");
                throw new StorageException("7000", locRS.getAllErrorsStr());
            }
        }
        locRS = new ResultSet();
        sdHndlr.checkStorageAttributes(succNodeSDmap, locRS);
        if (!locRS.allSuccess()) {
            VerificationUtil.traceAndLog("Storage attributes validation failed on at least one node");
            throw new StorageException("7000", locRS.getAllErrorsStr());
        }
        return true;
    }

    public boolean isSharedDevice(String refNode, String[] nodeList, String path) throws StorageException {
        boolean isShared = true;
        StorageInfo stInfo = null;
        String devSignature = null;
        VerificationCommand vfyCmd = null;
        int type = 0;
        try {
            stInfo = new TypeFinder().getStorageInstance(path, refNode);
            devSignature = stInfo.getSignature();
            type = stInfo.getType();
            for (String node : nodeList) {
                vfyCmd = new VerificationCommand(node, new String[]{"-getStInfo", "GET_DISK_BY_SIGNATURE", devSignature}, null);
                boolean bResult = vfyCmd.execute();
                if (!bResult) {
                    VerificationUtil.traceAndLog("Getting device signature failed on node: " + node);
                    isShared = false;
                    continue;
                }
                if (0 == vfyCmd.getVfyCode()) continue;
                VerificationUtil.traceAndLog("Could not verify disk on node: " + node);
                isShared = false;
            }
        }
        catch (StorageException e) {
            VerificationUtil.traceAndLog("STORAGEEXCEPTION: " + e.getMessage() + e + "\nStorageException generating info cmd for location '" + path + "' of type " + type);
            throw e;
        }
        catch (Exception e2) {
            VerificationUtil.traceAndLog("EXCEPTION: " + e2.getMessage() + e2);
            throw new StorageException(e2);
        }
        return isShared;
    }

    public PathDiskInfo getDiskInfo(String node, String path) throws StorageException, InvalidPathException {
        VerificationUtil.traceAndLog("node=" + node + "; path=" + path);
        if (!VerificationUtil.isStringGood(path)) {
            throw new InvalidPathException(s_msgBundle.getMessage("7517", true));
        }
        VerificationCommand vfyCmd = new VerificationCommand(node, new String[]{"-getdiskdetail", path}, null);
        vfyCmd.execute();
        StorageDataParser sdParser = new StorageDataParser(new StorageCheckContext());
        Result rslt = new Result(node);
        PathDiskInfo pdInfo = sdParser.parseDiskDetailResult(path, vfyCmd, rslt);
        if (rslt.getStatus() != 1) {
            VerificationUtil.traceAndLog("Execution or parsing failed for -getdiskdetail command ");
            throw new StorageException(VerificationUtil.errorCollection2String(rslt.getErrors()));
        }
        pdInfo.setOrigPath(path);
        return pdInfo;
    }

    public boolean isOCFS(String node, String path) throws StorageException {
        StorageType fileSystem = this.getFileSystem(node, path);
        return fileSystem == StorageType.OCFS || fileSystem == StorageType.OCFS2;
    }

    public boolean isACFS(String node, String path) throws StorageException {
        StorageType fileSystem = this.getFileSystem(node, path);
        return fileSystem == StorageType.ACFS;
    }

    StorageType getFileSystem(String node, String path) throws StorageException {
        StorageCheckContext scCtx = new StorageCheckContext();
        StorageDataHandler sdHndlr = new StorageDataHandler(scCtx);
        Result rslt = new Result(node);
        StorageType fileSystem = sdHndlr.getFileSystem(node, path, rslt);
        if (rslt.getStatus() == 2) {
            VerificationUtil.traceAndLog("File system type could not be determined successfully");
            throw new StorageException(VerificationUtil.errorCollection2String(rslt.getErrors()));
        }
        if (rslt.getStatus() == 3) {
            VerificationUtil.traceAndLog("File system does not exist");
            return StorageType.UNKNOWN;
        }
        VerificationUtil.traceAndLog("File system of type '%s' exists on path ", fileSystem.name());
        return fileSystem;
    }
}

