/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import oracle.cluster.verification.StorageType;
import oracle.ops.verification.framework.storage.DiskData;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageData;
import oracle.ops.verification.framework.util.VerificationUtil;

class PartitionData
extends StorageData
implements StorageConstants {
    private DiskData m_disk;
    private String m_partNum;
    private String m_partType;

    PartitionData(String id) {
        super(id, StorageType.DISK_PARTITION);
    }

    PartitionData(String id, String partNum, String partType) {
        super(id, StorageType.DISK_PARTITION);
        this.m_partNum = partNum;
        this.m_partType = partType;
    }

    void setDiskData(DiskData disk) {
        this.m_disk = disk;
    }

    protected String getPartitionNumber() {
        return this.m_partNum;
    }

    protected String getPartitionType() {
        return this.m_partType;
    }

    public boolean isRaw() {
        return VerificationUtil.isStringGood(this.m_partType) && this.m_partType.equalsIgnoreCase("RAW");
    }

    @Override
    public String toString() {
        return super.toString() + LSEP + "Name:" + this.getID() + " | Type:" + this.m_partType + " | PartNumber:" + this.m_partNum;
    }
}

