/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.HashMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.cluster.verification.StorageType;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.storage.StorageCheckContext;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageData;
import oracle.ops.verification.framework.storage.StorageDataHandler;
import oracle.ops.verification.framework.storage.StorageSignature;
import oracle.ops.verification.framework.storage.StorageWithSignature;
import oracle.ops.verification.framework.util.VerificationUtil;

class LvmDGData
extends StorageData
implements StorageConstants,
StorageWithSignature {
    private String m_uuid = null;
    private SortedMap<String, String> m_pvIDpvPathMap = new TreeMap<String, String>();

    public LvmDGData(String id) {
        super(id, StorageType.LVMDG);
    }

    LvmDGData(String gname, String uuid) {
        super(gname, StorageType.LVMDG);
        this.m_uuid = uuid;
        if (VerificationUtil.isStringGood(this.m_uuid)) {
            this.setStorageSignature(new StorageSignature(this.m_uuid));
        }
    }

    LvmDGData(String gname, String pvID, String pvPath) {
        super(gname, StorageType.LVMDG);
        this.m_pvIDpvPathMap.put(pvID, pvPath);
        this.setStorageSignature(new StorageSignature(this.createSignatureString()));
    }

    public void addPV(String pvID, String pvPath) {
        this.m_pvIDpvPathMap.put(pvID, pvPath);
        this.setStorageSignature(new StorageSignature(this.createSignatureString()));
    }

    private String createSignatureString() {
        Set<String> pvIDList = this.m_pvIDpvPathMap.keySet();
        String[] pvIDStrArr = pvIDList.toArray(new String[pvIDList.size()]);
        return VerificationUtil.strArr2String(pvIDStrArr);
    }

    @Override
    public void checkSharedness(HashMap<String, StorageData> nodeSDmap, ResultSet rSet) {
        StorageDataHandler.checkSignatures(nodeSDmap, rSet);
    }

    @Override
    public void checkStorageAttributes(HashMap<String, StorageData> nodeSDmap, StorageCheckContext stChkContext, ResultSet rSet) {
        new StorageDataHandler(stChkContext).checkVGAttributes(nodeSDmap, rSet);
    }

    public String getUID() {
        return this.m_uuid;
    }

    @Override
    public String toString() {
        return super.toString() + LSEP + "uuid=" + this.m_uuid;
    }
}

