/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageType;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.verification.framework.engine.Entity;
import oracle.ops.verification.framework.engine.EntityStatus;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.storage.FSDetails;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageData;
import oracle.ops.verification.framework.storage.StorageDataHandler;

public class ACFSData
extends StorageData
implements StorageConstants {
    private Entity<FSDetails> m_fsDetails = new Entity();
    private String m_version;
    private String m_diskGrpName;

    public ACFSData(String id) {
        super(id, StorageType.ACFS);
    }

    public ACFSData(String id, Entity<FSDetails> fsDetails) {
        super(id, StorageType.ACFS);
        this.m_fsDetails = fsDetails;
        if (fsDetails.getStatus() == EntityStatus.VALID) {
            this.setFreeSpace(fsDetails.getValue().getFreeSpace());
            this.setStorageSize(fsDetails.getValue().getSize());
        }
    }

    public ACFSData(String id, String ver, String diskGrpName, long free, long size) {
        super(id, StorageType.ACFS);
        this.m_version = ver;
        this.m_diskGrpName = diskGrpName;
        this.setFreeSpace(new StorageSize((double)(free / 1024L), StorageUnit.KBYTE));
        this.setStorageSize(new StorageSize((double)(size / 1024L), StorageUnit.KBYTE));
    }

    void setVer(String ver) {
        this.m_version = ver;
    }

    void setDiskGrpName(String diskGrpName) {
        this.m_diskGrpName = diskGrpName;
    }

    @Override
    public void checkSharedness(HashMap<String, StorageData> nodeSDmap, ResultSet rSet) {
        StorageDataHandler.checkFileSystemSharedness(nodeSDmap, rSet);
    }

    public String getVersion() {
        return this.m_version;
    }

    public String getDiskGrpName() {
        return this.m_diskGrpName;
    }

    public Entity<FSDetails> getFSDetails() {
        return this.m_fsDetails;
    }

    @Override
    public List<ErrorDescription> getEntityErrors() {
        if (this.m_fsDetails != null) {
            return this.m_fsDetails.getErrors();
        }
        return new ArrayList<ErrorDescription>();
    }

    @Override
    public String toString() {
        return super.toString() + LSEP + "version=" + this.m_version + " | diskGrpName=" + this.m_diskGrpName + " | FSDetails: " + this.m_fsDetails;
    }
}

