/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report.xmlreport;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.ResultValuesUnavailableException;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.util.CollectionGroup;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultKeyType;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportPurgeTool;
import oracle.ops.verification.framework.report.ReportToolException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.report.ReportUtilConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlBrowserException;
import oracle.ops.verification.framework.report.htmlreport.HtmlBrowserInterface;
import oracle.ops.verification.framework.report.htmlreport.HtmlConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlPage;
import oracle.ops.verification.framework.report.htmlreport.HtmlPopupPage;
import oracle.ops.verification.framework.report.htmlreport.HtmlReportToolException;
import oracle.ops.verification.framework.report.htmlreport.Table;
import oracle.ops.verification.framework.report.htmlreport.TableCell;
import oracle.ops.verification.framework.report.htmlreport.Text;
import oracle.ops.verification.framework.report.xmlreport.CVXMLReportReader;
import oracle.ops.verification.framework.report.xmlreport.CVXMLReportWriter;
import oracle.ops.verification.framework.report.xmlreport.XmlReportToolException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlReportTool {
    private Calendar m_timeStamp = null;
    private MessageBundle s_rptMsgBundle = VerificationUtil.getMessageBundle("Prve");
    private String m_xmlReportFilePath = null;
    private ZipOutputStream m_reportZOS = null;
    private int m_xmlReportCount = 1;
    private List<Thread> m_reportWriterThreadList = new ArrayList<Thread>();
    private List<ErrorDescription> m_reportWriterErrorList = new ArrayList<ErrorDescription>();

    public XmlReportTool() throws ParserConfigurationException {
        this.m_timeStamp = Calendar.getInstance();
    }

    public void addHeader(ReportUtilConstants.BasicClusterWareDetails details) throws ParserConfigurationException, XmlReportToolException {
        CVXMLReportWriter writer;
        if (details == null) {
            throw new XmlReportToolException(this.s_rptMsgBundle.getMessage("10051", false, (Object[])new String[]{"details"}));
        }
        String headerFileName = new File(this.m_xmlReportFilePath).getParent() + VerificationUtil.FSEP + "header" + ".xml";
        try {
            writer = new CVXMLReportWriter(new BufferedWriter(new FileWriter(headerFileName)));
        }
        catch (FileNotFoundException e) {
            throw new XmlReportToolException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XmlReportToolException(e.getMessage(), e);
        }
        writer.writeStartDocument();
        writer.writeStartElement("ROOT");
        String reportName = CVUVariables.getValue("BASELINE_REPORT_NAME");
        this.writeReportHeader(details, writer, reportName);
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.close();
        try {
            this.addZipEntryAndDelete(headerFileName, "header.xml", this.m_reportZOS);
        }
        catch (IOException e) {
            throw new XmlReportToolException(e.getMessage(), e);
        }
    }

    protected void writeReportHeader(ReportUtilConstants.BasicClusterWareDetails details, CVXMLReportWriter writer, String reportName) throws XmlReportToolException {
        String osPlatformVal;
        String crsUserVal;
        String crsHomeVal;
        String nodeListVal;
        String crsVersionVal;
        writer.writeStartElement("HEADER");
        this.writeTimeStamp(writer);
        if (VerificationUtil.isStringGood(reportName)) {
            writer.writeStartElement("REPORT_NAME");
            writer.writeCharacters(reportName);
            writer.writeEndElement();
        }
        writer.writeStartElement("CLUSTER_DETAILS");
        String clusterNameVal = details.getClusterName();
        if (VerificationUtil.isStringGood(clusterNameVal)) {
            writer.writeAttribute("CLUSTER_NAME", clusterNameVal);
        }
        if (VerificationUtil.isStringGood(crsVersionVal = details.getClusterwareVersion())) {
            writer.writeAttribute("CLUSTERWARE_VERSION", crsVersionVal);
        }
        if (VerificationUtil.isStringGood(nodeListVal = details.getnodeListStr())) {
            writer.writeAttribute("NODE_LIST", nodeListVal);
        }
        if (VerificationUtil.isStringGood(crsHomeVal = details.getCrsHome())) {
            writer.writeAttribute("CRS_HOME", crsHomeVal);
        }
        if (VerificationUtil.isStringGood(details.getOracleBase())) {
            writer.writeAttribute("ORACLE_BASE", details.getOracleBase());
        }
        if (VerificationUtil.isStringGood(crsUserVal = details.getCrsUserName())) {
            writer.writeAttribute("CRS_USER", crsUserVal);
        }
        if (VerificationUtil.isStringGood(osPlatformVal = details.getOsPlatform())) {
            writer.writeAttribute("OS_PLATFORM", osPlatformVal);
        }
        writer.writeEndElement();
        Vector<ReportUtilConstants.DatabaseDetails> dbList = details.getDatabases();
        if (dbList != null && dbList.size() > 0) {
            writer.writeStartElement("DATABASE_LIST");
            for (ReportUtilConstants.DatabaseDetails db : dbList) {
                String dbNameVal = db.getDatabaseName();
                String dbVersionVal = db.getDatabaseVersion();
                String dbHomePath = db.getDatabaseHome();
                if (!VerificationUtil.isStringGood(dbNameVal) || !VerificationUtil.isStringGood(dbVersionVal) || !VerificationUtil.isStringGood(dbHomePath)) continue;
                writer.writeStartElement("DATABASE");
                writer.writeAttribute("NAME", dbNameVal);
                writer.writeAttribute("DATABASE_VERSION", dbVersionVal);
                writer.writeAttribute("DATABASE_HOME", dbHomePath);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addZipEntryAndDelete(String fileName, String zipEntryName, ZipOutputStream zos) throws IOException {
        File file = new File(fileName);
        FileInputStream fis = new FileInputStream(file);
        ZipEntry zipEntry = new ZipEntry(zipEntryName);
        try {
            int length;
            zos.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zos.write(bytes, 0, length);
            }
        }
        finally {
            zos.closeEntry();
            fis.close();
            file.delete();
        }
    }

    public String getXMLFilePath() {
        return this.m_xmlReportFilePath;
    }

    public void startDocument(String saveDir, String reportPrefix) throws XmlReportToolException, XmlFilePathException, ReportToolException {
        try {
            this.m_xmlReportFilePath = VerificationUtil.isStringGood(saveDir) ? this.saveToXmlFile(saveDir, reportPrefix) : this.saveToDefaultXmlFile(reportPrefix);
            this.m_reportZOS = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.m_xmlReportFilePath)));
        }
        catch (FileNotFoundException e) {
            throw new ReportToolException(e.getMessage(), e);
        }
    }

    public void endDocument() throws XmlReportToolException {
        try {
            for (Thread t : this.m_reportWriterThreadList) {
                try {
                    t.join();
                }
                catch (InterruptedException e) {
                    throw new XmlReportToolException(e.getMessage(), e);
                }
            }
            if (this.m_reportWriterErrorList.size() > 0) {
                String errMsg = this.s_rptMsgBundle.getMessage("10211", true) + VerificationUtil.LSEP;
                for (ErrorDescription e : this.m_reportWriterErrorList) {
                    errMsg = errMsg + e.getErrorMessage() + VerificationUtil.LSEP;
                }
                throw new XmlReportToolException(errMsg);
            }
            if (this.m_reportZOS != null) {
                this.m_reportZOS.close();
            }
        }
        catch (IOException e) {
            throw new XmlReportToolException(e.getMessage(), e);
        }
    }

    public void addTarget(VerificationType vfyType, Collection<Task> tasks, String clusterName, String dbName, String home) throws TransformerException, XmlReportToolException {
        this.addTarget(vfyType.getID(), tasks, clusterName, dbName, home);
    }

    public void addTarget(VerificationType vfyType, List<Task> tasks, ReportUtilConstants.BasicClusterWareDetails clusterwareDetails) throws TransformerException, XmlReportToolException {
        if (VerificationType.COMPONENT.equals(vfyType.getID()) || VerificationType.STAGE.equals(vfyType.getID())) {
            this.addTarget(vfyType.getID(), tasks, clusterwareDetails.getCVUOperation(), null, clusterwareDetails.getCrsHome());
        } else {
            this.addTarget(vfyType.getID(), tasks, clusterwareDetails.getClusterName(), null, clusterwareDetails.getCrsHome());
        }
    }

    public void addTarget(CollectionGroup collectionGroup, Collection<Task> tasks, String clusterName, String dbName, String home) throws TransformerException, XmlReportToolException {
        this.addTarget(collectionGroup.getID(), tasks, clusterName, dbName, home);
    }

    private void addTarget(final String verificationID, final Collection<Task> tasks, final String clusterName, final String dbName, final String home) throws TransformerException, XmlReportToolException {
        CVXMLReportWriter writer;
        if (!VerificationUtil.isStringGood(dbName) && (VerificationType.BESTPRACTICE_POSTREQ_DB_CONFIG.getID().equals(verificationID) || VerificationType.POSTREQ_DB_CONFIG.getID().equals(verificationID) || VerificationType.PREREQ_DB_CONFIG.getID().equals(verificationID) || VerificationType.PREREQ_DB_INST.getID().equals(verificationID) || VerificationType.SYSREQ_DB.getID().equals(verificationID) || VerificationType.SYSREQ_SI_DB.getID().equals(verificationID))) {
            throw new XmlReportToolException(this.s_rptMsgBundle.getMessage("10051", false, (Object[])new String[]{"dbName"}));
        }
        final String targetKey = new File(this.m_xmlReportFilePath).getName().substring(0, new File(this.m_xmlReportFilePath).getName().length() - ".zip".length()) + "_" + this.m_xmlReportCount++;
        final String targetFileName = new File(this.m_xmlReportFilePath).getParent() + VerificationUtil.FSEP + targetKey + ".xml";
        try {
            writer = new CVXMLReportWriter(new BufferedWriter(new FileWriter(targetFileName)));
        }
        catch (FileNotFoundException e) {
            throw new XmlReportToolException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XmlReportToolException(e.getMessage(), e);
        }
        Thread reportWriterThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    writer.writeStartDocument();
                    writer.writeStartElement("ROOT");
                    XmlReportTool.this.writeTargetData(tasks, clusterName, dbName, home, verificationID, writer);
                    writer.writeEndElement();
                    writer.writeEndDocument();
                    writer.close();
                    ZipOutputStream zipOutputStream = XmlReportTool.this.m_reportZOS;
                    synchronized (zipOutputStream) {
                        XmlReportTool.this.addZipEntryAndDelete(targetFileName, targetKey + ".xml", XmlReportTool.this.m_reportZOS);
                    }
                }
                catch (IOException e) {
                    Trace.out((int)5, (String)"Exception %s encountered while generating the xml : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
                    List list = XmlReportTool.this.m_reportWriterErrorList;
                    synchronized (list) {
                        XmlReportTool.this.m_reportWriterErrorList.add(new ErrorDescription(XmlReportTool.this.s_rptMsgBundle.getMessage("10210", true, (Object[])new String[]{targetFileName, verificationID, e.getMessage()})));
                    }
                    return;
                }
                catch (XmlReportToolException e) {
                    Trace.out((int)5, (String)"Exception %s encountered while generating the xml : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
                    List list = XmlReportTool.this.m_reportWriterErrorList;
                    synchronized (list) {
                        XmlReportTool.this.m_reportWriterErrorList.add(new ErrorDescription(XmlReportTool.this.s_rptMsgBundle.getMessage("10210", true, (Object[])new String[]{targetFileName, verificationID, e.getMessage()})));
                    }
                    return;
                }
                catch (TransformerException e) {
                    Trace.out((int)5, (String)"Exception %s encountered while generating the xml : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
                    List list = XmlReportTool.this.m_reportWriterErrorList;
                    synchronized (list) {
                        XmlReportTool.this.m_reportWriterErrorList.add(new ErrorDescription(XmlReportTool.this.s_rptMsgBundle.getMessage("10210", true, (Object[])new String[]{targetFileName, verificationID, e.getMessage()})));
                    }
                    return;
                }
            }
        };
        this.m_reportWriterThreadList.add(reportWriterThread);
        Trace.out((int)5, (String)"Starting the thread to write report with VerificationType: %s, clusterName: %s, dbName: %s, home: %s", (Object[])new Object[]{verificationID, clusterName, dbName, home});
        reportWriterThread.start();
    }

    public void addTarget(final VerificationType vfyType, final List<Task> taskList, final String clusterName, final String dbName, final String home) throws TransformerException, XmlReportToolException {
        CVXMLReportWriter writer;
        final String targetKey = new File(this.m_xmlReportFilePath).getName().substring(0, new File(this.m_xmlReportFilePath).getName().length() - ".zip".length()) + "_" + this.m_xmlReportCount++;
        final String targetFileName = new File(this.m_xmlReportFilePath).getParent() + VerificationUtil.FSEP + targetKey + ".xml";
        try {
            writer = new CVXMLReportWriter(new BufferedWriter(new FileWriter(targetFileName)));
        }
        catch (FileNotFoundException e) {
            throw new XmlReportToolException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XmlReportToolException(e.getMessage(), e);
        }
        Thread reportWriterThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    writer.writeStartDocument();
                    writer.writeStartElement("ROOT");
                    XmlReportTool.this.writeTargetData(taskList, clusterName, dbName, home, vfyType.getID(), writer);
                    writer.writeEndElement();
                    writer.writeEndDocument();
                    writer.close();
                    ZipOutputStream zipOutputStream = XmlReportTool.this.m_reportZOS;
                    synchronized (zipOutputStream) {
                        XmlReportTool.this.addZipEntryAndDelete(targetFileName, targetKey + ".xml", XmlReportTool.this.m_reportZOS);
                    }
                }
                catch (IOException e) {
                    Trace.out((int)5, (String)"Exception %s encountered while generating the xml : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
                    List list = XmlReportTool.this.m_reportWriterErrorList;
                    synchronized (list) {
                        XmlReportTool.this.m_reportWriterErrorList.add(new ErrorDescription(XmlReportTool.this.s_rptMsgBundle.getMessage("10210", true, (Object[])new String[]{targetFileName, vfyType.getID(), e.getMessage()})));
                    }
                    return;
                }
                catch (XmlReportToolException e) {
                    Trace.out((int)5, (String)"Exception %s encountered while generating the xml : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
                    List list = XmlReportTool.this.m_reportWriterErrorList;
                    synchronized (list) {
                        XmlReportTool.this.m_reportWriterErrorList.add(new ErrorDescription(XmlReportTool.this.s_rptMsgBundle.getMessage("10210", true, (Object[])new String[]{targetFileName, vfyType.getID(), e.getMessage()})));
                    }
                    return;
                }
                catch (TransformerException e) {
                    Trace.out((int)5, (String)"Exception %s encountered while generating the xml : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
                    List list = XmlReportTool.this.m_reportWriterErrorList;
                    synchronized (list) {
                        XmlReportTool.this.m_reportWriterErrorList.add(new ErrorDescription(XmlReportTool.this.s_rptMsgBundle.getMessage("10210", true, (Object[])new String[]{targetFileName, vfyType.getID(), e.getMessage()})));
                    }
                    return;
                }
            }
        };
        this.m_reportWriterThreadList.add(reportWriterThread);
        Trace.out((int)5, (String)"Starting the thread to write report with VerificationType: %s, clusterName: %s, dbName: %s, home: %s", (Object[])new Object[]{vfyType.getID(), clusterName, dbName, home});
        reportWriterThread.start();
    }

    protected void writeTargetData(Collection<Task> taskList, String clusterName, String dbName, String home, String verificationID, CVXMLReportWriter writer) throws XmlReportToolException, TransformerException {
        writer.writeStartElement("TARGET_DATA");
        writer.writeAttribute("ID", verificationID);
        if (VerificationUtil.isStringGood(clusterName)) {
            writer.writeAttribute("CLUSTERNAME", clusterName);
        }
        if (VerificationUtil.isStringGood(dbName)) {
            writer.writeAttribute("DATABASENAME", dbName);
        }
        if (VerificationUtil.isStringGood(home)) {
            writer.writeAttribute("HOME", home);
        }
        writer.writeStartElement("TASK_LIST");
        ArrayList<Task> allTasks = new ArrayList<Task>(taskList.size());
        for (Task task : taskList) {
            if (task.hasSubtasks()) {
                try {
                    for (VerificationTask subTask : task.getSubtasks()) {
                        allTasks.add((Task)subTask);
                    }
                    continue;
                }
                catch (SubtasksUnavailableException subtasksUnavailableException) {
                    continue;
                }
            }
            allTasks.add(task);
        }
        for (Task task : allTasks) {
            this.addTaskToTarget(task, clusterName, dbName, home, writer);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void addTaskToTarget(Task task, String clusterName, String dbName, String home, CVXMLReportWriter writer) throws TransformerException, XmlReportToolException {
        List<VerificationResult> nodeResults;
        writer.writeStartElement("TASK");
        if (task.isBestPractice()) {
            writer.writeAttribute("TYPE", ReportUtilConstants.TaskType.RECCOMENDED_TASK.name());
        } else {
            writer.writeAttribute("TYPE", ReportUtilConstants.TaskType.MANDATORY_TASK.name());
        }
        writer.writeAttribute("TASK_LEVEL", task.getChildTaskLevel().toString());
        writer.writeAttribute("SEVERITY", task.getSeverity().name());
        writer.writeAttribute("OVER_ALL_STATUS", task.getResultSet().getOverallStatus().name());
        writer.writeStartElement("ELEMENT");
        writer.writeCharacters(task.getDefaultElementName());
        writer.writeEndElement();
        writer.writeStartElement("DESC");
        writer.writeCharacters(task.getDefaultDescription());
        writer.writeEndElement();
        writer.writeStartElement("MORE_DETAILS");
        if (VerificationUtil.isStringGood(task.getMoreDetails())) {
            writer.writeStartElement("TEXT");
            writer.writeCharacters(task.getMoreDetails());
            writer.writeEndElement();
        }
        List<String> references = task.getReferences();
        for (int cnt = 0; references != null && cnt < references.size(); ++cnt) {
            String[] refLink = references.get(cnt);
            if (!VerificationUtil.isStringGood((String)refLink)) continue;
            writer.writeStartElement("REFERENCE");
            writer.writeCharacters((String)refLink);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        ResultSet rsltSet = task.getResultSet();
        writer.writeStartElement("SUCC_NODES");
        if (rsltSet.anySuccess()) {
            for (String nodeName : rsltSet.getSuccNodes()) {
                Result succNodeResult = rsltSet.getResult(nodeName);
                ResultKeyType succNodeResultKeyType = succNodeResult.getType();
                Trace.out((int)1, (String)("SUCCESS element for node: '" + nodeName + "' key type: '" + succNodeResultKeyType.getResultKeyStr() + "' \n" + succNodeResult.traceResultInfo()));
                writer.writeStartElement("NODE");
                writer.writeAttribute("ID", nodeName);
                writer.writeAttribute("RESULTKEYTYPE", succNodeResultKeyType.getResultKeyStr());
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
        writer.writeStartElement("FAILED_NODES");
        if (rsltSet.anyFailure()) {
            for (String nodeName : rsltSet.getFailureNodes()) {
                Result failNodeResult = rsltSet.getResult(nodeName);
                ResultKeyType failNodeResultKeyType = failNodeResult.getType();
                Trace.out((int)1, (String)("FAILURE element for node: '" + nodeName + "' key type: '" + failNodeResultKeyType.getResultKeyStr() + "' \n" + failNodeResult.traceResultInfo()));
                writer.writeStartElement("NODE");
                writer.writeAttribute("ID", nodeName);
                writer.writeAttribute("RESULTKEYTYPE", failNodeResultKeyType.getResultKeyStr());
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
        writer.writeStartElement("GLOBAL_ERROR_DESC_LIST");
        List<VerificationError> globalErrorList = rsltSet.getErrors();
        for (VerificationError error : globalErrorList) {
            this.writeErrorDescElement(error, writer);
        }
        writer.writeEndElement();
        try {
            nodeResults = task.getResultSet().getNodeResults();
        }
        catch (NodeResultsUnavailableException e) {
            Trace.out((String)("NODERESULTSUNAVAILABLEEXCEPTION: " + e.getMessage()));
            nodeResults = null;
        }
        if (nodeResults != null) {
            if (Trace.isLevelEnabled((int)1)) {
                rsltSet.traceResultSet("ResultSet for XML data ===>");
            }
            writer.writeStartElement("NODE_RESULT_SET");
            for (VerificationResult nodeRes : nodeResults) {
                String node = nodeRes.getNode();
                writer.writeStartElement("NODE_RESULT");
                writer.writeAttribute("NAME", node);
                writer.writeAttribute("STATUS", nodeRes.getNodeResultStatus().name());
                ResultKeyType resultKeyType = ((Result)nodeRes).getType();
                writer.writeAttribute("RESULTKEYTYPE", resultKeyType.getResultKeyStr());
                if (Trace.isLevelEnabled((int)1)) {
                    Result resultData = (Result)nodeRes;
                    Trace.out((String)("Result data for XML: " + resultData.traceResultInfo()));
                }
                Trace.out((String)("Writing XML for node: '" + node + "' of type: '" + resultKeyType.getResultKeyStr() + "'"));
                writer.writeAttribute("FIXUP_AVAILABLE", nodeRes.isFixupAvailable() ? new String("true") : new String("false"));
                writer.writeStartElement("EXP_ACT_VALUE");
                try {
                    if (nodeRes.hasResultValues()) {
                        String actualVal;
                        String expectedVal = nodeRes.getExpectedValue();
                        if (VerificationUtil.isStringGood(expectedVal)) {
                            writer.writeStartElement("EXPECTED_VALUE");
                            writer.writeCharacters(expectedVal);
                            writer.writeEndElement();
                        }
                        if (VerificationUtil.isStringGood(actualVal = nodeRes.getActualValue())) {
                            writer.writeStartElement("ACTUAL_VALUE");
                            writer.writeCharacters(actualVal);
                            writer.writeEndElement();
                        }
                    }
                }
                catch (ResultValuesUnavailableException e) {
                    Trace.out((String)("RESULTVALUESUNAVAILABLEEXETPTION: node: '" + node + "' " + e.getMessage()));
                }
                writer.writeEndElement();
                writer.writeStartElement("ERROR_DESC_LIST");
                List<VerificationError> errorList = nodeRes.getErrors();
                for (VerificationError error : errorList) {
                    this.writeErrorDescElement(error, writer);
                }
                writer.writeEndElement();
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeStartElement("TASK_SUMMARY");
        if (VerificationUtil.isStringGood(rsltSet.getResultSummary())) {
            writer.writeCharacters(rsltSet.getResultSummary());
        }
        writer.writeEndElement();
        writer.writeStartElement("GLOBAL_COLLECTION_SET");
        List<CollectionElement> globalCollectionElemList = task.getResultSet().getCollectionElements();
        for (CollectionElement collectionElement : globalCollectionElemList) {
            this.writeCollectionElement(null, collectionElement, writer);
        }
        writer.writeEndElement();
        writer.writeStartElement("NODE_COLLECTION_SET");
        if (nodeResults != null) {
            for (VerificationResult nodeRes : nodeResults) {
                String node = nodeRes.getNode();
                List<CollectionElement> nodeCollectionSet = ((Result)nodeRes).getCollectionElements();
                for (CollectionElement collectionElement : nodeCollectionSet) {
                    this.writeCollectionElement(node, collectionElement, writer);
                }
            }
        }
        writer.writeEndElement();
        if (task.hasCreatedTasks()) {
            writer.writeStartElement("SUBTASK_LIST");
            for (VerificationTask subTask : task.getCreatedTasks()) {
                this.addTaskToTarget((Task)subTask, clusterName, dbName, home, writer);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeCollectionElement(String node, CollectionElement collectionElement, CVXMLReportWriter writer) throws XmlReportToolException {
        writer.writeStartElement("COLLECTION_ELEMENT");
        writer.writeAttribute("NAME", collectionElement.getName());
        if (node != null) {
            writer.writeAttribute("NODE", node);
        }
        if (VerificationUtil.isStringGood(collectionElement.getDescription())) {
            writer.writeAttribute("DESCRIPTION", collectionElement.getDescription());
        }
        if (collectionElement.getComparator() != null) {
            // empty if block
        }
        writer.writeAttribute("STATUS", collectionElement.getStatusString());
        writer.writeStartElement("EXP_ACT_VALUE");
        Object expectedVal = collectionElement.getExpectedValue();
        writer.writeStartElement("EXPECTED_VALUE");
        if (expectedVal != null) {
            writer.writeCharacters(String.valueOf(expectedVal));
        }
        writer.writeEndElement();
        Object actualVal = collectionElement.getValue();
        writer.writeStartElement("ACTUAL_VALUE");
        if (actualVal != null) {
            writer.writeCharacters(String.valueOf(actualVal));
        }
        writer.writeEndElement();
        List<CollectionElement> childCollectionElementList = collectionElement.getChildrens();
        if (childCollectionElementList.size() > 0) {
            writer.writeStartElement("COLLECTION_SET");
            for (CollectionElement childCollectionElement : childCollectionElementList) {
                this.writeCollectionElement(node, childCollectionElement, writer);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeStartElement("ERROR_DESC_LIST");
        List<ErrorDescription> errorList = collectionElement.getErrorDescriptionList();
        if (errorList != null) {
            for (VerificationError verificationError : errorList) {
                this.writeErrorDescElement(verificationError, writer);
            }
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private List<Task> sortTaskAsPerStatus(List<Task> taskList, boolean reverse) {
        ArrayList<Task> sortedList = new ArrayList<Task>();
        if (taskList == null || taskList.size() == 0) {
            return sortedList;
        }
        Vector<Task> successTask = new Vector<Task>(taskList.size());
        Vector<Task> warningTask = new Vector<Task>(taskList.size());
        Vector<Task> errorTask = new Vector<Task>(taskList.size());
        ResultSet rs = null;
        for (Task task : taskList) {
            rs = task.getResultSet();
            if (rs.allSuccess() && !rs.anyWarning()) {
                successTask.add(task);
                continue;
            }
            if (!rs.anyFailure() && rs.anyWarning()) {
                warningTask.add(task);
                continue;
            }
            errorTask.add(task);
        }
        if (reverse) {
            sortedList.addAll(errorTask);
            sortedList.addAll(warningTask);
            sortedList.addAll(successTask);
        } else {
            sortedList.addAll(successTask);
            sortedList.addAll(warningTask);
            sortedList.addAll(errorTask);
        }
        return sortedList;
    }

    private void writeErrorDescElement(VerificationError error, CVXMLReportWriter writer) throws XmlReportToolException {
        if (error.getErrorMessage() != null) {
            writer.writeStartElement("ERROR_DESC");
            writer.writeStartElement("MSG_TXT");
            writer.writeCharacters(error.getErrorMessage());
            writer.writeEndElement();
            if (error.getCause() != null) {
                writer.writeStartElement("CAUSE");
                writer.writeCharacters(error.getCause());
                writer.writeEndElement();
            }
            if (error.getAction() != null) {
                writer.writeStartElement("ACTION");
                writer.writeCharacters(error.getAction());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void createHTMLHead(ReportUtilConstants.ReportContext context, HtmlPage htmlDoc) {
        Text heading = null;
        if (context == ReportUtilConstants.ReportContext.BEST_PRACTICE) {
            try {
                heading = new Text(this.s_rptMsgBundle.getMessage("10001", false));
                heading.setBookMarkName("MAIN");
                htmlDoc.addHeadingToHtmlBody(heading, 3, HtmlConstants.HorizontalAlignment.center);
            }
            catch (ReportToolException e) {
                Trace.out((String)("Exception in CreateHTMLHead : " + e.getMessage()));
            }
        }
    }

    private Vector<String> createErrorDescriptionMsgFromElement(List<VerificationError> list) {
        Vector<String> errorList = new Vector<String>();
        for (VerificationError errorDesc : list) {
            StringBuffer error = new StringBuffer();
            String errorMsg = errorDesc.getErrorMessage();
            String cause = errorDesc.getCause();
            String action = errorDesc.getAction();
            if (VerificationUtil.isStringGood(errorMsg)) {
                error.append(this.s_rptMsgBundle.getMessage("10065", false) + " - " + errorMsg + VerificationConstants.LINE_SEPARATOR);
            }
            if (VerificationUtil.isStringGood(cause) && VerificationUtil.isStringGood(action)) {
                error.append("     " + this.s_rptMsgBundle.getMessage("10066", false) + " - " + cause + VerificationConstants.LINE_SEPARATOR);
                error.append("     " + this.s_rptMsgBundle.getMessage("10067", false) + " - " + action + VerificationConstants.LINE_SEPARATOR);
            }
            if (!VerificationUtil.isStringGood(errorMsg)) continue;
            errorList.add(error.toString().trim());
        }
        return errorList;
    }

    public String saveToXmlFile(String dirPath, String reportPrefix) throws XmlFilePathException, XmlReportToolException {
        String xmlFileName = reportPrefix + "_" + this.getTimeStampStr(this.m_timeStamp) + ".zip";
        String reportName = CVUVariables.getValue(CVUVariableConstants.BASELINE_REPORT_NAME);
        String xmlFilePath = null;
        if (VerificationUtil.isStringGood(reportName)) {
            xmlFileName = reportName.replaceAll("\\s+", "_") + ".zip";
        } else {
            ReportPurgeTool tool = new ReportPurgeTool(dirPath, reportPrefix, ".zip");
            tool.purgeOlderFiles(9);
        }
        if (!VerificationUtil.isStringGood(dirPath) || !new File(dirPath.trim()).exists()) {
            throw new XmlFilePathException(this.s_rptMsgBundle.getMessage("10058", false));
        }
        xmlFilePath = (dirPath.endsWith(VerificationConstants.FILE_SEPARATOR) ? dirPath : dirPath + VerificationConstants.FILE_SEPARATOR) + xmlFileName;
        Trace.out((String)("Saving the XML report to file " + xmlFilePath));
        return xmlFilePath;
    }

    public String saveToDefaultXmlFile(String reportPrefix) throws XmlFilePathException, XmlReportToolException {
        String defaultDirPath = null;
        try {
            defaultDirPath = ReportUtilConstants.getCvuXmlReportDefaultDirPath();
        }
        catch (ClusterException ce) {
            throw new XmlReportToolException(ce.getMessage());
        }
        return this.saveToXmlFile(defaultDirPath, reportPrefix);
    }

    private String saveToHtmlFile(HtmlPage page, String dirPath) throws XmlFilePathException, XmlReportToolException {
        String htmlFilePath;
        String fileName = "cvucheckreport_" + this.getTimeStampStr(this.m_timeStamp) + ".html";
        String fullpath = null;
        if (VerificationUtil.isStringGood(dirPath)) {
            dirPath = dirPath.trim();
        } else {
            try {
                dirPath = ReportUtilConstants.getCvuHtmlReportDefaultDirPath();
            }
            catch (ClusterException e) {
                throw new XmlReportToolException(e.getMessage(), e);
            }
        }
        File dir = new File(dirPath);
        if (dir.exists()) {
            if (!dirPath.endsWith(VerificationConstants.FILE_SEPARATOR)) {
                dirPath = dirPath + VerificationConstants.FILE_SEPARATOR;
            }
            fullpath = dirPath + fileName;
        }
        if (VerificationUtil.isStringGood(fullpath)) {
            ReportPurgeTool tool = new ReportPurgeTool(dirPath, "cvucheckreport", ".html");
            tool.purgeOlderFiles(4);
            try {
                htmlFilePath = page.saveToFile(fullpath);
            }
            catch (ReportToolException hrte) {
                throw new XmlReportToolException(hrte.getMessage(), hrte);
            }
        } else {
            throw new XmlFilePathException(this.s_rptMsgBundle.getMessage("10058", false));
        }
        Trace.out((String)("Outputing message for file: '" + htmlFilePath + "'"));
        ReportUtil.quietprintln(VerificationConstants.LSEP + this.s_rptMsgBundle.getMessage("10028", false, (Object[])new String[]{htmlFilePath}));
        return fullpath;
    }

    private void saveToTextFile(StringBuffer textBuffer, String dirPath) throws XmlFilePathException, XmlReportToolException {
        String textFilePath;
        String textFileName = "cvucheckreport_" + this.getTimeStampStr(this.m_timeStamp) + ".txt";
        String textReportPath = null;
        if (VerificationUtil.isStringGood(dirPath)) {
            dirPath = dirPath.trim();
        } else {
            try {
                dirPath = ReportUtilConstants.getCvuTextReportDefaultDirPath();
            }
            catch (ClusterException e) {
                throw new XmlReportToolException(e.getMessage(), e);
            }
        }
        File dir = new File(dirPath);
        if (dir.exists()) {
            if (!dirPath.endsWith(VerificationConstants.FILE_SEPARATOR)) {
                dirPath = dirPath + VerificationConstants.FILE_SEPARATOR;
            }
            textReportPath = dirPath + textFileName;
        }
        if (VerificationUtil.isStringGood(textReportPath)) {
            ReportPurgeTool tool = new ReportPurgeTool(dirPath, "cvucheckreport", ".txt");
            tool.purgeOlderFiles(4);
            File textFile = new File(textReportPath);
            textFilePath = null;
            try {
                FileOutputStream stream = new FileOutputStream(textFile);
                stream.write(textBuffer.toString().getBytes());
                textFilePath = textFile.getCanonicalPath();
            }
            catch (FileNotFoundException fne) {
                throw new XmlReportToolException(fne.getMessage());
            }
            catch (IOException ioe) {
                throw new XmlReportToolException(ioe.getMessage());
            }
        } else {
            throw new XmlFilePathException(this.s_rptMsgBundle.getMessage("10058", false));
        }
        ReportUtil.quietprintln(this.s_rptMsgBundle.getMessage("10028", false, (Object[])new String[]{textFilePath}));
    }

    public void xmlToHtml(String title, boolean showFailuresOnly, ReportUtilConstants.ReportContext context, boolean showInBrowser, String browserPath, boolean saveFile, String saveDirPath) throws HtmlReportToolException, XmlFilePathException, HtmlBrowserException, XmlReportToolException {
        this.xmlToHtml(title, null, showFailuresOnly, context, showInBrowser, browserPath, saveFile, saveDirPath);
    }

    public void xmlToHtml(String title, String author, boolean showFailuresOnly, ReportUtilConstants.ReportContext context, boolean showInBrowser, String browserPath, boolean saveFile, String saveDirPath) throws HtmlReportToolException, XmlFilePathException, HtmlBrowserException, XmlReportToolException {
        this.xmlToHtml(title, author, showFailuresOnly, HtmlConstants.Colors.Cornsilk, context, showInBrowser, browserPath, saveFile, saveDirPath);
    }

    public void xmlToHtml(String title, String author, boolean showFailuresOnly, HtmlConstants.Colors backGroundColor, ReportUtilConstants.ReportContext context, boolean showInBrowser, String browserPath, boolean saveFile, String saveDirPath) throws HtmlReportToolException, XmlFilePathException, HtmlBrowserException, XmlReportToolException {
        HtmlPage mainPage;
        CVXMLReportReader reader = null;
        try {
            reader = CVXMLReportReader.getCVXMLReportReader(this.m_xmlReportFilePath);
            mainPage = new HtmlPage(title, author, backGroundColor, true);
        }
        catch (ReportToolException rte) {
            throw new HtmlReportToolException(rte.getMessage(), rte);
        }
        this.createHTMLHead(context, mainPage);
        Table mainTargetTable = new Table(1);
        Table basicClusterDetails = this.createBasicClusterDetailsHtmlTable(mainPage, reader);
        HashMap<String, HashMap<String, String>> targetList = reader.getTargetList();
        if (targetList == null) {
            targetList = new HashMap();
        }
        ArrayList<Text> listOfTargetNames = new ArrayList<Text>();
        Text topSymbol = new Text("&#8593;" + this.s_rptMsgBundle.getMessage("10055", false) + "&#8593;");
        topSymbol.setTextColor(HtmlConstants.Colors.DarkBlue);
        topSymbol.setBold(true);
        topSymbol.setReferencelink("#MAIN");
        topSymbol.setMouseOverDescription(this.s_rptMsgBundle.getMessage("10043", false));
        String topSymbolHtmlText = topSymbol.toHtmlString();
        String dbName = null;
        int cnt = 0;
        for (String targetKey : targetList.keySet()) {
            String captionMsg;
            ReportUtilConstants.TargetType targetType = null;
            Text targetHead = null;
            HashMap<String, String> targetAttributes = targetList.get(targetKey);
            String targetStr = targetAttributes.get("ID");
            Trace.out((String)("Processing targetStr: '" + targetStr + "'"));
            if (!VerificationUtil.isStringGood(targetStr)) {
                Trace.out((String)"skipping without adding any target because target type null");
                continue;
            }
            if (targetStr.trim().equalsIgnoreCase(VerificationType.PREREQ_CRS_INST.getID())) {
                captionMsg = this.s_rptMsgBundle.getMessage("10012", false);
                targetHead = new Text(captionMsg);
                targetType = ReportUtilConstants.TargetType.SYSTEM_BASED_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.POSTREQ_CRS_INST.getID())) {
                captionMsg = this.s_rptMsgBundle.getMessage("10014", false);
                targetHead = new Text(captionMsg);
                targetType = ReportUtilConstants.TargetType.CLUSTER_BASED_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_PRE_CRS_INST.getID())) {
                captionMsg = this.s_rptMsgBundle.getMessage("10013", false);
                targetHead = new Text(captionMsg);
                targetType = ReportUtilConstants.TargetType.SYSTEM_BASED_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_POSTREQ_CRS_INST.getID())) {
                captionMsg = this.s_rptMsgBundle.getMessage("10015", false);
                targetHead = new Text(captionMsg);
                targetType = ReportUtilConstants.TargetType.CLUSTER_BASED_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.PREREQ_DB_CONFIG.getID()) || targetStr.trim().equalsIgnoreCase(VerificationType.PREREQ_DB_INST.getID()) || targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_POSTREQ_DB_CONFIG.getID()) || targetStr.trim().equalsIgnoreCase(VerificationType.POSTREQ_DB_CONFIG.getID())) {
                captionMsg = null;
                dbName = targetAttributes.get("DATABASENAME");
                captionMsg = targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_POSTREQ_DB_CONFIG.getID()) ? this.s_rptMsgBundle.getMessage("10017", false, (Object[])new String[]{dbName}) : this.s_rptMsgBundle.getMessage("10016", false, (Object[])new String[]{dbName});
                targetHead = new Text(captionMsg);
                targetType = ReportUtilConstants.TargetType.DATABASE_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_ASM.getID())) {
                captionMsg = this.s_rptMsgBundle.getMessage("10187", false);
                targetHead = new Text(captionMsg);
                targetType = ReportUtilConstants.TargetType.ASM_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.COMPONENT_ASM_INTEGRITY.getID())) {
                captionMsg = this.s_rptMsgBundle.getMessage("10186", false);
                targetHead = new Text(captionMsg);
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.PREREQ_APPLICATION_CLUSTER_INST.getID()) || targetStr.trim().equalsIgnoreCase(VerificationType.POSTREQ_APPLICATION_CLUSTER_INST.getID())) {
                captionMsg = this.s_rptMsgBundle.getMessage("10200", false);
                targetHead = new Text(captionMsg);
                targetType = ReportUtilConstants.TargetType.CLUSTER_BASED_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.COMPONENT.getID())) {
                targetHead = new Text("COMPONENT TESTING");
                targetType = ReportUtilConstants.TargetType.SYSTEM_BASED_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.STAGE.getID())) {
                targetHead = new Text("STAGE TESTING");
                targetType = ReportUtilConstants.TargetType.SYSTEM_BASED_CHECKS;
            } else {
                Trace.out((String)("ERROR: No title defined for target " + targetStr));
                targetHead = new Text(targetStr);
                targetType = ReportUtilConstants.TargetType.SYSTEM_BASED_CHECKS;
                continue;
            }
            List<Task> taskList = this.sortTaskAsPerStatus(reader.getTaskList(targetKey), true);
            Table targetTable = this.createHtmlTableForTarget("TARGET" + Integer.toString(cnt + 1), targetHead.getTextData(), targetType, showFailuresOnly, mainPage, taskList, topSymbolHtmlText);
            if (targetTable.getRowCount() == 0) continue;
            targetHead.setReferencelink("#TARGET" + Integer.toString(cnt + 1));
            targetHead.setTextColor(HtmlConstants.Colors.MediumBlue);
            listOfTargetNames.add(targetHead);
            TableCell row = new TableCell(targetTable, HtmlConstants.Colors.Gainsboro, null, HtmlConstants.HorizontalAlignment.center);
            mainTargetTable.addRow(new TableCell[]{row});
            ++cnt;
        }
        if (mainPage.isBackGroundColorSet()) {
            basicClusterDetails.setBackGroundColor(mainPage.getBackgroundColor());
        }
        mainPage.addTableToHtmlBody(basicClusterDetails, HtmlConstants.HorizontalAlignment.center);
        Text subject = new Text(VerificationConstants.LINE_SEPARATOR + this.s_rptMsgBundle.getMessage("10029", false));
        mainPage.addLineBreakToHtmlBody();
        subject.setTextColor(HtmlConstants.Colors.DarkGoldenRod);
        mainPage.addHeadingToHtmlBody(subject, 3, HtmlConstants.HorizontalAlignment.left);
        mainPage.addListToHtmlBody(listOfTargetNames.toArray(new Text[0]), true);
        mainPage.addLineBreakToHtmlBody();
        mainPage.addTableToHtmlBody(mainTargetTable, HtmlConstants.HorizontalAlignment.center);
        String htmlFilePath = this.saveToHtmlFile(mainPage, saveDirPath);
        if (showInBrowser) {
            HtmlBrowserInterface.showHtmlInBrowser(htmlFilePath, browserPath);
        }
        mainPage.cleanUp();
        mainPage = null;
    }

    public void resultToHtml(ReportUtilConstants.BasicClusterWareDetails details, List<Task> taskList, boolean showFailuresOnly, HtmlConstants.Colors backGroundColor, ReportUtilConstants.ReportContext context, boolean showInBrowser, String browserPath, boolean saveFile, String saveDirPath) throws HtmlReportToolException, HtmlBrowserException {
        HtmlPage mainPage;
        CVXMLReportReader reader = null;
        try {
            reader = CVXMLReportReader.getCVXMLReportReader(this.m_xmlReportFilePath);
            mainPage = new HtmlPage(details.getCVUOperation(), details.getCrsUserName(), backGroundColor, true);
        }
        catch (ReportToolException rte) {
            Trace.out((String)("REPORTTOOLEXCEPTION: " + rte.getMessage()));
            throw new HtmlReportToolException(rte.getMessage(), rte);
        }
        catch (XmlReportToolException e) {
            throw new HtmlReportToolException(e.getMessage(), e);
        }
        Trace.out((int)1, (String)"Creating HTML header");
        this.createHTMLHead(context, mainPage);
        Table mainTargetTable = new Table(1);
        HashMap<String, HashMap<String, String>> targetList = null;
        Table basicClusterDetails = this.createBasicClusterDetailsHtmlTable(mainPage, details);
        try {
            targetList = reader.getTargetList();
        }
        catch (XmlReportToolException e) {
            throw new HtmlReportToolException(e.getMessage(), e);
        }
        if (targetList == null) {
            targetList = new HashMap();
        }
        ArrayList<Text> listOfTargetNames = new ArrayList<Text>();
        Text topSymbol = new Text("&#8593;" + this.s_rptMsgBundle.getMessage("10055", false) + "&#8593;");
        topSymbol.setTextColor(HtmlConstants.Colors.DarkBlue);
        topSymbol.setBold(true);
        topSymbol.setReferencelink("#MAIN");
        topSymbol.setMouseOverDescription(this.s_rptMsgBundle.getMessage("10043", false));
        String topSymbolHtmlText = topSymbol.toHtmlString();
        String dbName = null;
        int cnt = 0;
        for (String targetKey : targetList.keySet()) {
            String captionMsg;
            Trace.out((int)1, (String)("targetKey: '" + targetKey + "'"));
            ReportUtilConstants.TargetType targetType = null;
            Text targetHead = null;
            HashMap<String, String> targetAttributes = targetList.get(targetKey);
            String targetStr = targetAttributes.get("ID");
            Trace.out((String)("Processing targetStr: '" + targetStr + "'"));
            if (!VerificationUtil.isStringGood(targetStr)) {
                Trace.out((String)"skipping without adding any target because target type null");
                continue;
            }
            if (targetStr.trim().equalsIgnoreCase(VerificationType.PREREQ_CRS_INST.getID())) {
                captionMsg = this.s_rptMsgBundle.getMessage("10012", false);
                targetHead = new Text(captionMsg);
                targetType = ReportUtilConstants.TargetType.SYSTEM_BASED_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.POSTREQ_CRS_INST.getID())) {
                captionMsg = this.s_rptMsgBundle.getMessage("10014", false);
                targetHead = new Text(captionMsg);
                targetType = ReportUtilConstants.TargetType.CLUSTER_BASED_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_PRE_CRS_INST.getID())) {
                captionMsg = this.s_rptMsgBundle.getMessage("10013", false);
                targetHead = new Text(captionMsg);
                targetType = ReportUtilConstants.TargetType.SYSTEM_BASED_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_POSTREQ_CRS_INST.getID())) {
                captionMsg = this.s_rptMsgBundle.getMessage("10015", false);
                targetHead = new Text(captionMsg);
                targetType = ReportUtilConstants.TargetType.CLUSTER_BASED_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.PREREQ_DB_CONFIG.getID()) || targetStr.trim().equalsIgnoreCase(VerificationType.PREREQ_DB_INST.getID()) || targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_POSTREQ_DB_CONFIG.getID()) || targetStr.trim().equalsIgnoreCase(VerificationType.POSTREQ_DB_CONFIG.getID())) {
                captionMsg = null;
                dbName = targetAttributes.get("DATABASENAME");
                captionMsg = targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_POSTREQ_DB_CONFIG.getID()) ? this.s_rptMsgBundle.getMessage("10017", false, (Object[])new String[]{dbName}) : this.s_rptMsgBundle.getMessage("10016", false, (Object[])new String[]{dbName});
                targetHead = new Text(captionMsg);
                targetType = ReportUtilConstants.TargetType.DATABASE_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_ASM.getID())) {
                captionMsg = this.s_rptMsgBundle.getMessage("10187", false);
                targetHead = new Text(captionMsg);
                targetType = ReportUtilConstants.TargetType.ASM_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.COMPONENT_ASM_INTEGRITY.getID())) {
                captionMsg = this.s_rptMsgBundle.getMessage("10186", false);
                targetHead = new Text(captionMsg);
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.PREREQ_APPLICATION_CLUSTER_INST.getID()) || targetStr.trim().equalsIgnoreCase(VerificationType.POSTREQ_APPLICATION_CLUSTER_INST.getID())) {
                captionMsg = this.s_rptMsgBundle.getMessage("10200", false);
                targetHead = new Text(captionMsg);
                targetType = ReportUtilConstants.TargetType.CLUSTER_BASED_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.COMPONENT.getID())) {
                targetHead = new Text("COMPONENT TESTING");
                targetType = ReportUtilConstants.TargetType.SYSTEM_BASED_CHECKS;
            } else {
                if (!targetStr.trim().equalsIgnoreCase(VerificationType.STAGE.getID())) continue;
                targetHead = new Text("STAGE TESTING");
                targetType = ReportUtilConstants.TargetType.SYSTEM_BASED_CHECKS;
            }
            Table targetTable = this.createHtmlTableForTarget("TARGET" + Integer.toString(cnt + 1), targetHead.getTextData(), targetType, showFailuresOnly, mainPage, taskList, topSymbolHtmlText);
            if (targetTable.getRowCount() == 0) continue;
            targetHead.setReferencelink("#TARGET" + Integer.toString(cnt + 1));
            targetHead.setTextColor(HtmlConstants.Colors.MediumBlue);
            listOfTargetNames.add(targetHead);
            TableCell row = new TableCell(targetTable, HtmlConstants.Colors.Gainsboro, null, HtmlConstants.HorizontalAlignment.center);
            mainTargetTable.addRow(new TableCell[]{row});
            ++cnt;
        }
        if (mainPage.isBackGroundColorSet()) {
            basicClusterDetails.setBackGroundColor(mainPage.getBackgroundColor());
        }
        mainPage.addTableToHtmlBody(basicClusterDetails, HtmlConstants.HorizontalAlignment.center);
        Text subject = new Text(VerificationConstants.LINE_SEPARATOR + this.s_rptMsgBundle.getMessage("10029", false));
        mainPage.addLineBreakToHtmlBody();
        subject.setTextColor(HtmlConstants.Colors.DarkGoldenRod);
        mainPage.addHeadingToHtmlBody(subject, 3, HtmlConstants.HorizontalAlignment.left);
        mainPage.addListToHtmlBody(listOfTargetNames.toArray(new Text[0]), true);
        mainPage.addLineBreakToHtmlBody();
        mainPage.addTableToHtmlBody(mainTargetTable, HtmlConstants.HorizontalAlignment.center);
        if (saveFile) {
            try {
                this.saveToHtmlFile(mainPage, saveDirPath);
            }
            catch (XmlReportToolException e) {
                throw new HtmlReportToolException(e.getMessage(), e);
            }
            catch (XmlFilePathException xfpe) {
                throw new HtmlReportToolException(xfpe.getMessage(), xfpe);
            }
        }
        if (showInBrowser) {
            HtmlBrowserInterface.showHtmlInBrowser(mainPage, browserPath);
        }
        mainPage.destroy();
        mainPage = null;
    }

    private Table createHtmlTableForTarget(String reference, String targetName, ReportUtilConstants.TargetType targetType, boolean showFailuresOnly, HtmlPage htmlPage, List<Task> taskList, String topNavigationTxt) throws HtmlReportToolException {
        int numberOfColumns = 3;
        String unknown = this.s_rptMsgBundle.getMessage("10057", false);
        String notApplicable = this.s_rptMsgBundle.getMessage("10026", false);
        String notAvailable = this.s_rptMsgBundle.getMessage("10027", false);
        TableCell[] headers = new TableCell[numberOfColumns];
        headers[0] = new TableCell(new Text(this.s_rptMsgBundle.getMessage("10019", false)), HtmlConstants.Colors.LightSteelBlue, null, null);
        headers[1] = new TableCell(new Text(this.s_rptMsgBundle.getMessage("10020", false)), HtmlConstants.Colors.LightSteelBlue, null, null);
        headers[1].setWrapText(false);
        headers[2] = new TableCell(new Text(this.s_rptMsgBundle.getMessage("10021", false)), HtmlConstants.Colors.LightSteelBlue, null, null);
        Text targetDefination = new Text(targetName);
        targetDefination.setFontSize(5);
        targetDefination.setBold(true);
        targetDefination.setBookMarkName(reference);
        targetDefination.setTextColor(HtmlConstants.Colors.DarkGreen);
        String captionStr = VerificationConstants.LINE_SEPARATOR + VerificationConstants.LINE_SEPARATOR + topNavigationTxt + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + targetDefination.toHtmlString() + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + topNavigationTxt;
        Text caption = new Text(captionStr);
        Table table = new Table(caption, headers, HtmlConstants.Colors.Navy, HtmlConstants.Colors.DarkGoldenRod, 1);
        table.setWidth(95);
        for (int i = 0; i < taskList.size(); ++i) {
            Task task = taskList.get(i);
            TableCell[] row = new TableCell[numberOfColumns];
            boolean isTaskMandatory = true;
            isTaskMandatory = !task.isBestPractice();
            boolean isTaskCritical = true;
            String severity = task.getSeverity().name();
            isTaskCritical = VerificationUtil.isStringGood(severity) && (severity.trim().equalsIgnoreCase(SeverityType.CRITICAL.name()) || severity.trim().equalsIgnoreCase(SeverityType.FATAL.name()));
            String check = task.getElementName();
            if (check == null) {
                check = unknown;
            }
            Text checkNameText = new Text(check);
            String overAllStatus = task.getResultSet().getOverallStatus().name();
            Text overAllStatusText = null;
            if (VerificationUtil.isStringGood(overAllStatus) && overAllStatus.toLowerCase().contains("success")) {
                if (showFailuresOnly) continue;
                overAllStatusText = isTaskMandatory ? new Text(this.s_rptMsgBundle.getMessage("10030", false)) : new Text(this.s_rptMsgBundle.getMessage("10034", false));
                overAllStatusText.setTextColor(HtmlConstants.Colors.Green);
            } else if (VerificationUtil.isStringGood(overAllStatus) && overAllStatus.toLowerCase().contains("warning")) {
                if (showFailuresOnly && isTaskMandatory) continue;
                if (isTaskMandatory) {
                    overAllStatusText = new Text(this.s_rptMsgBundle.getMessage("10032", false));
                    overAllStatusText.setTextColor(HtmlConstants.Colors.Orange);
                } else {
                    overAllStatusText = new Text(this.s_rptMsgBundle.getMessage("10035", false));
                    overAllStatusText.setTextColor(HtmlConstants.Colors.Red);
                }
            } else if (VerificationUtil.isStringGood(overAllStatus) && overAllStatus.toLowerCase().contains("failed")) {
                if (isTaskMandatory && isTaskCritical) {
                    overAllStatusText = new Text(this.s_rptMsgBundle.getMessage("10031", false));
                    overAllStatusText.setTextColor(HtmlConstants.Colors.Red);
                } else if (isTaskMandatory && !isTaskCritical) {
                    overAllStatusText = new Text(this.s_rptMsgBundle.getMessage("10032", false));
                    overAllStatusText.setTextColor(HtmlConstants.Colors.Orange);
                } else {
                    overAllStatusText = new Text(this.s_rptMsgBundle.getMessage("10035", false));
                    overAllStatusText.setTextColor(HtmlConstants.Colors.Red);
                }
            } else {
                overAllStatusText = new Text(this.s_rptMsgBundle.getMessage("10033", false));
                overAllStatusText.setTextColor(HtmlConstants.Colors.Red);
            }
            String description = task.getDescription();
            if (!VerificationUtil.isStringGood(description)) {
                description = notApplicable;
            }
            row[0] = new TableCell(checkNameText, null, null, null);
            HtmlPopupPage popUpPage = this.createNodeDetailsPopupPage(task, targetType, htmlPage.getBackgroundColor());
            overAllStatusText.setPopUpWindowsLink("#NODEDETAILS", popUpPage);
            overAllStatusText.setMouseOverDescription(this.s_rptMsgBundle.getMessage("10042", false));
            row[1] = new TableCell(overAllStatusText, null, null, null);
            String moreDetailsText = task.getMoreDetails();
            List<String> moreDetailsLinks = task.getReferences();
            if (VerificationUtil.isStringGood(moreDetailsText) || moreDetailsLinks != null && moreDetailsLinks.size() > 0) {
                HtmlPopupPage moreDetailspopUpPage = this.createMoreDetailsPopupPage(this.s_rptMsgBundle.getMessage("10040", false, (Object[])new String[]{check}), moreDetailsText, moreDetailsLinks, htmlPage.getBackgroundColor());
                Text moreDet = new Text(this.s_rptMsgBundle.getMessage("10053", false));
                moreDet.setPopUpWindowsLink("#MOREDETAILS", moreDetailspopUpPage);
                moreDet.setMouseOverDescription(this.s_rptMsgBundle.getMessage("10041", false));
                description = description + "... " + moreDet.toHtmlString();
            }
            Text descriptionText = new Text(description);
            descriptionText.setFontSize(2);
            row[2] = new TableCell(descriptionText, null, null, null);
            if ((i + 1) % 2 == 0) {
                row[0].setBackGroundColor(HtmlConstants.Colors.MistyRose);
                row[1].setBackGroundColor(HtmlConstants.Colors.MistyRose);
                row[2].setBackGroundColor(HtmlConstants.Colors.MistyRose);
            } else {
                row[0].setBackGroundColor(HtmlConstants.Colors.LightGrey);
                row[1].setBackGroundColor(HtmlConstants.Colors.LightGrey);
                row[2].setBackGroundColor(HtmlConstants.Colors.LightGrey);
            }
            table.addRow(row);
        }
        return table;
    }

    private HtmlPopupPage createNodeDetailsPopupPage(Task task, ReportUtilConstants.TargetType targetType, HtmlConstants.Colors backGroundColor) throws HtmlReportToolException {
        Vector<String> errorMsgList;
        HtmlPopupPage popUpPage;
        String nodeSummary;
        String expectedValue;
        String unknown = this.s_rptMsgBundle.getMessage("10057", false);
        String notApplicable = this.s_rptMsgBundle.getMessage("10026", false);
        String notAvailable = this.s_rptMsgBundle.getMessage("10027", false);
        String passed = this.s_rptMsgBundle.getMessage("10030", false);
        String warning = this.s_rptMsgBundle.getMessage("10032", false);
        String failed = this.s_rptMsgBundle.getMessage("10031", false);
        StringBuffer header = new StringBuffer();
        boolean hasExpActVal = false;
        String check = task.getElementName();
        if (VerificationUtil.isStringGood(check)) {
            Text verCheckTxt = new Text(this.s_rptMsgBundle.getMessage("10019", false) + " : ");
            verCheckTxt.setBold(true);
            verCheckTxt.setTextColor(HtmlConstants.Colors.BlueViolet);
            header.append(VerificationConstants.LINE_SEPARATOR + verCheckTxt.toHtmlString() + check);
        }
        if (VerificationUtil.isStringGood(expectedValue = this.getExpectedValue(task))) {
            Text expValTxt = new Text(this.s_rptMsgBundle.getMessage("10024", false) + " : ");
            expValTxt.setBold(true);
            expValTxt.setTextColor(HtmlConstants.Colors.BlueViolet);
            header.append(VerificationConstants.LINE_SEPARATOR + expValTxt.toHtmlString() + expectedValue);
            hasExpActVal = true;
        }
        if (VerificationUtil.isStringGood(nodeSummary = task.getResultSet().getResultSummary())) {
            Text summaryText = new Text(this.s_rptMsgBundle.getMessage("10047", false) + " : ");
            summaryText.setBold(true);
            summaryText.setTextColor(HtmlConstants.Colors.BlueViolet);
            header.append(VerificationConstants.LINE_SEPARATOR + summaryText.toHtmlString() + nodeSummary);
        }
        String title = this.s_rptMsgBundle.getMessage("10046", false, (Object[])new String[]{check});
        try {
            popUpPage = new HtmlPopupPage(title, null, backGroundColor, false);
        }
        catch (ReportToolException rte) {
            throw new HtmlReportToolException(rte.getMessage(), rte);
        }
        if (header.toString().length() > 0) {
            popUpPage.addParagraphToHtmlBody(new Text(header.toString()), HtmlConstants.HorizontalAlignment.justify);
        }
        ResultSet taskRS = task.getResultSet();
        for (ResultKeyType resKeyType : ResultKeyType.values()) {
            String[] failedNodes = taskRS.getFailureByType(resKeyType);
            List<String> succNodes = Arrays.asList(taskRS.getSuccessByType(resKeyType));
            String[] notAppNodes = taskRS.getNotAppByType(resKeyType);
            Vector<String> allNodes = new Vector<String>(succNodes);
            allNodes.addAll(Arrays.asList(failedNodes));
            allNodes.addAll(Arrays.asList(notAppNodes));
            if (allNodes.isEmpty()) continue;
            TableCell[] headers = new TableCell[hasExpActVal ? 4 : 3];
            headers[0] = new TableCell(new Text(this.s_rptMsgBundle.getMessage(this.getNodeHeaderStr(resKeyType), false)), HtmlConstants.Colors.LightSteelBlue, null, null);
            headers[1] = new TableCell(new Text(this.s_rptMsgBundle.getMessage("10056", false)), HtmlConstants.Colors.LightSteelBlue, null, null);
            if (hasExpActVal) {
                headers[2] = new TableCell(new Text(this.s_rptMsgBundle.getMessage("10025", false)), HtmlConstants.Colors.LightSteelBlue, null, null);
                headers[3] = new TableCell(new Text(this.s_rptMsgBundle.getMessage("10036", false)), HtmlConstants.Colors.LightSteelBlue, null, null);
                headers[3].setWrapText(false);
            } else {
                headers[2] = new TableCell(new Text(this.s_rptMsgBundle.getMessage("10036", false)), HtmlConstants.Colors.LightSteelBlue, null, null);
                headers[2].setWrapText(false);
            }
            Text caption = new Text(title);
            caption.setTextColor(HtmlConstants.Colors.DarkBlue);
            caption.setBold(true);
            Table nodeWiseTable = new Table(caption, headers, null, null, 1);
            nodeWiseTable.setWidth(75);
            Vector<TableCell[]> allRowsToSort = new Vector<TableCell[]>();
            for (int cnt = 0; cnt < allNodes.size(); ++cnt) {
                int errCnt;
                Text[] allErrorsArray;
                Result nodeResult;
                Vector<Object> nodeErrors = new Vector();
                String nodeName = allNodes.elementAt(cnt);
                if (!VerificationUtil.isStringGood(nodeName) || (nodeResult = task.getResultSet().getResult(nodeName)) == null) continue;
                String nodeStatus = this.getStatusString(nodeResult.getStatus());
                String actualValue = null;
                if (nodeResult.hasResultValues()) {
                    try {
                        actualValue = nodeResult.getActualValue();
                    }
                    catch (ResultValuesUnavailableException e) {
                        actualValue = null;
                    }
                }
                Text NodeStatusText = null;
                if (VerificationUtil.isStringGood(nodeStatus) && nodeStatus.toLowerCase().contains("success")) {
                    NodeStatusText = new Text(passed);
                    NodeStatusText.setTextColor(HtmlConstants.Colors.Green);
                } else if (VerificationUtil.isStringGood(nodeStatus) && nodeStatus.toLowerCase().contains("warning")) {
                    NodeStatusText = new Text(warning);
                    NodeStatusText.setTextColor(HtmlConstants.Colors.Orange);
                } else if (VerificationUtil.isStringGood(nodeStatus) && nodeStatus.toLowerCase().contains("failed")) {
                    NodeStatusText = new Text(failed);
                    NodeStatusText.setTextColor(HtmlConstants.Colors.Red);
                } else if (VerificationUtil.isStringGood(nodeStatus) && nodeStatus.toLowerCase().contains("not_applicable")) {
                    NodeStatusText = new Text(notApplicable);
                    NodeStatusText.setTextColor(HtmlConstants.Colors.Yellow);
                } else {
                    nodeStatus = unknown;
                    NodeStatusText = new Text(unknown);
                    NodeStatusText.setTextColor(HtmlConstants.Colors.Red);
                }
                if (nodeResult.getErrors() != null && nodeResult.getErrors().size() > 0) {
                    nodeErrors = this.createErrorDescriptionMsgFromElement(nodeResult.getErrors());
                }
                TableCell[] nodeRow = new TableCell[hasExpActVal ? 4 : 3];
                nodeRow[0] = new TableCell(new Text(nodeName), null, null, null);
                nodeRow[1] = new TableCell(NodeStatusText, null, null, null);
                if (hasExpActVal) {
                    if (!VerificationUtil.isStringGood(actualValue)) {
                        actualValue = "";
                    }
                    nodeRow[2] = new TableCell(new Text(actualValue), null, null, null);
                    nodeRow[2].setWrapText(false);
                    if (nodeErrors.size() > 0) {
                        allErrorsArray = new Text[nodeErrors.size()];
                        errCnt = 0;
                        for (String string : nodeErrors) {
                            allErrorsArray[errCnt++] = new Text(string);
                        }
                        nodeRow[3] = new TableCell(allErrorsArray, null, null, null);
                    } else {
                        nodeRow[3] = new TableCell(new Text(this.s_rptMsgBundle.getMessage("10054", false)), null, null, null);
                    }
                } else if (nodeErrors.size() > 0) {
                    allErrorsArray = new Text[nodeErrors.size()];
                    errCnt = 0;
                    for (String string : nodeErrors) {
                        allErrorsArray[errCnt++] = new Text(string);
                    }
                    nodeRow[2] = new TableCell(allErrorsArray, null, null, null);
                } else {
                    nodeRow[2] = new TableCell(new Text(this.s_rptMsgBundle.getMessage("10054", false)), null, null, null);
                }
                allRowsToSort.add(nodeRow);
            }
            for (TableCell[] row : allRowsToSort) {
                if (!((Text)row[1].getObject()).getTextData().equals(failed)) continue;
                nodeWiseTable.addRow(row);
            }
            for (TableCell[] row : allRowsToSort) {
                if (!((Text)row[1].getObject()).getTextData().equals(warning)) continue;
                nodeWiseTable.addRow(row);
            }
            for (TableCell[] row : allRowsToSort) {
                if (!((Text)row[1].getObject()).getTextData().equals(unknown)) continue;
                nodeWiseTable.addRow(row);
            }
            for (TableCell[] row : allRowsToSort) {
                if (!((Text)row[1].getObject()).getTextData().equals(passed)) continue;
                nodeWiseTable.addRow(row);
            }
            for (TableCell[] row : allRowsToSort) {
                if (!((Text)row[1].getObject()).getTextData().equals(notApplicable)) continue;
                nodeWiseTable.addRow(row);
            }
            popUpPage.addTableToHtmlBody(nodeWiseTable, null);
        }
        List<VerificationError> globalError = task.getResultSet().getErrors();
        if (globalError != null && globalError.size() > 0 && (errorMsgList = this.createErrorDescriptionMsgFromElement(globalError)).size() > 0) {
            Vector<Text> listErrors = new Vector<Text>();
            for (String errorMsg : errorMsgList) {
                if (!VerificationUtil.isStringGood(errorMsg)) continue;
                listErrors.add(new Text(errorMsg));
            }
            if (listErrors.size() > 0) {
                Text globalErrorHeader = new Text(this.s_rptMsgBundle.getMessage("10064", false));
                globalErrorHeader.setBold(true);
                globalErrorHeader.setTextColor(HtmlConstants.Colors.BlueViolet);
                popUpPage.addHeadingToHtmlBody(globalErrorHeader, 4, HtmlConstants.HorizontalAlignment.left);
                Text[] list = new Text[listErrors.size()];
                listErrors.toArray(list);
                popUpPage.addListToHtmlBody(list, false);
            }
        }
        return popUpPage;
    }

    private String getExpectedValue(Task task) {
        ResultSet resultSet = task.getResultSet();
        String expectedValue = null;
        Hashtable t = resultSet.getResultTable();
        Enumeration nodeKeys = t.keys();
        while (nodeKeys.hasMoreElements()) {
            String node = (String)nodeKeys.nextElement();
            Result result = (Result)t.get(node);
            if (!result.hasResultValues()) continue;
            try {
                expectedValue = result.getExpectedValue();
            }
            catch (ResultValuesUnavailableException e) {
                expectedValue = null;
            }
            break;
        }
        return expectedValue;
    }

    public String getStatusString(int status) {
        if (status == 1) {
            return "SUCCESSFUL";
        }
        if (status == 2) {
            return "OPERATION_FAILED";
        }
        if (status == 3) {
            return "VERIFICATION_FAILED";
        }
        if (status == 4) {
            return "VERIFICATION_WARNING";
        }
        if (status == 6) {
            return "NOT_APPLICABLE";
        }
        return "UNDEFINED";
    }

    private HtmlPopupPage createMoreDetailsPopupPage(String heading, String paraGraph, List<String> links, HtmlConstants.Colors backgroundColor) throws HtmlReportToolException {
        HtmlPopupPage popUpPage = null;
        try {
            popUpPage = new HtmlPopupPage(heading, null, backgroundColor, false);
        }
        catch (ReportToolException rte) {
            throw new HtmlReportToolException(rte.getMessage(), rte);
        }
        if (VerificationUtil.isStringGood(heading)) {
            Text headingTxt = new Text(heading);
            popUpPage.addHeadingToHtmlBody(headingTxt, 3, null);
        }
        if (VerificationUtil.isStringGood(paraGraph)) {
            Text paraGraphTxt = new Text(paraGraph);
            popUpPage.addParagraphToHtmlBody(paraGraphTxt, null);
        }
        if (links != null && links.size() > 0) {
            String referenceHead = this.s_rptMsgBundle.getMessage("10048", false);
            Text headingRef = new Text(referenceHead);
            popUpPage.addHeadingToHtmlBody(headingRef, 4, null);
            Text[] listOfLinks = new Text[links.size()];
            for (int cnt = 0; cnt < links.size(); ++cnt) {
                String link = links.get(cnt);
                if (!VerificationUtil.isStringGood(link)) continue;
                listOfLinks[cnt] = new Text(link);
                listOfLinks[cnt].setReferencelink(link);
            }
            popUpPage.addListToHtmlBody(listOfLinks, true);
        }
        return popUpPage;
    }

    private Table createBasicClusterDetailsHtmlTable(HtmlPage htmlPage, CVXMLReportReader reader) throws HtmlReportToolException {
        ReportUtilConstants.BasicClusterWareDetails headerElement;
        try {
            headerElement = reader.getHeader();
        }
        catch (XmlReportToolException e) {
            throw new HtmlReportToolException(e.getMessage(), e);
        }
        return this.createBasicClusterDetailsHtmlTable(htmlPage, headerElement);
    }

    private Table createBasicClusterDetailsHtmlTable(HtmlPage htmlPage, ReportUtilConstants.BasicClusterWareDetails headerElement) throws HtmlReportToolException {
        int numberOfColumns = 2;
        boolean numberofRows = false;
        Table table = new Table(numberOfColumns);
        table.setWidth(100);
        Text caption = new Text(this.s_rptMsgBundle.getMessage("10002", false));
        caption.setTextColor(HtmlConstants.Colors.DarkSlateBlue);
        htmlPage.addHeadingToHtmlBody(caption, 3, HtmlConstants.HorizontalAlignment.justify);
        if (headerElement != null) {
            String[] timeStampArray;
            Calendar timeStamp = headerElement.getTimeStamp();
            if (timeStamp != null && (timeStampArray = this.createTimeAndDateStringsFromXML(timeStamp, "/", ":")) != null) {
                TableCell[] dateRow = new TableCell[numberOfColumns];
                String dateStr = timeStampArray[0];
                Text dateHead = new Text(this.s_rptMsgBundle.getMessage("10010", false));
                dateHead.setBold(true);
                dateHead.setTextColor(HtmlConstants.Colors.DarkBlue);
                dateRow[0] = new TableCell(dateHead, null, null, null);
                dateRow[0].setWidth(20);
                dateRow[1] = new TableCell(new Text(dateStr), null, null, null);
                table.addRow(dateRow);
                TableCell[] timeRow = new TableCell[numberOfColumns];
                String timeStr = timeStampArray[1];
                Text timeHead = new Text(this.s_rptMsgBundle.getMessage("10011", false));
                timeHead.setBold(true);
                timeHead.setTextColor(HtmlConstants.Colors.DarkBlue);
                timeRow[0] = new TableCell(timeHead, null, null, null);
                timeRow[0].setWidth(20);
                timeRow[1] = new TableCell(new Text(timeStr), null, null, null);
                table.addRow(timeRow);
            }
            if (headerElement != null) {
                TableCell[] row;
                String clusterNameStr = headerElement.getClusterName();
                String crsHome = headerElement.getCrsHome();
                String crsUser = headerElement.getCrsUserName();
                String clusterVersion = headerElement.getClusterwareVersion();
                String osPlatform = headerElement.getOsPlatform();
                if (VerificationUtil.isStringGood(clusterNameStr)) {
                    row = new TableCell[numberOfColumns];
                    Text clusNameHead = new Text(this.s_rptMsgBundle.getMessage("10005", false));
                    clusNameHead.setBold(true);
                    clusNameHead.setTextColor(HtmlConstants.Colors.DarkBlue);
                    row[0] = new TableCell(clusNameHead, null, null, null);
                    row[0].setWidth(20);
                    row[1] = new TableCell(new Text(clusterNameStr), null, null, null);
                    table.addRow(row);
                }
                if (VerificationUtil.isStringGood(clusterVersion)) {
                    row = new TableCell[numberOfColumns];
                    Text clusVerHead = new Text(this.s_rptMsgBundle.getMessage("10049", false));
                    clusVerHead.setBold(true);
                    clusVerHead.setTextColor(HtmlConstants.Colors.DarkBlue);
                    row[0] = new TableCell(clusVerHead, null, null, null);
                    row[0].setWidth(20);
                    row[1] = new TableCell(new Text(clusterVersion), null, null, null);
                    table.addRow(row);
                }
                if (crsHome != null) {
                    row = new TableCell[numberOfColumns];
                    Text crsHomeHead = new Text(this.s_rptMsgBundle.getMessage("10037", false));
                    crsHomeHead.setBold(true);
                    crsHomeHead.setTextColor(HtmlConstants.Colors.DarkBlue);
                    row[0] = new TableCell(crsHomeHead, null, null, null);
                    row[0].setWidth(20);
                    row[1] = new TableCell(new Text(crsHome), null, null, null);
                    table.addRow(row);
                }
                if (crsUser != null) {
                    row = new TableCell[numberOfColumns];
                    Text crsUserHead = new Text(this.s_rptMsgBundle.getMessage("10038", false));
                    crsUserHead.setBold(true);
                    crsUserHead.setTextColor(HtmlConstants.Colors.DarkBlue);
                    row[0] = new TableCell(crsUserHead, null, null, null);
                    row[0].setWidth(20);
                    row[1] = new TableCell(new Text(crsUser), null, null, null);
                    table.addRow(row);
                }
                if (VerificationUtil.isStringGood(osPlatform)) {
                    row = new TableCell[numberOfColumns];
                    Text osPlatHead = new Text(this.s_rptMsgBundle.getMessage("10050", false));
                    osPlatHead.setBold(true);
                    osPlatHead.setTextColor(HtmlConstants.Colors.DarkBlue);
                    row[0] = new TableCell(osPlatHead, null, null, null);
                    row[0].setWidth(20);
                    row[1] = new TableCell(new Text(osPlatform), null, null, null);
                    table.addRow(row);
                }
            }
            int dbCount = 0;
            if (headerElement.getDatabaseCount() > 0) {
                for (ReportUtilConstants.DatabaseDetails dbDetails : headerElement.getDatabases()) {
                    TableCell[] row = new TableCell[2];
                    Text dbNameHead = new Text(this.s_rptMsgBundle.getMessage("10007", false, (Object[])new String[]{Integer.toString(++dbCount)}));
                    dbNameHead.setBold(true);
                    dbNameHead.setTextColor(HtmlConstants.Colors.DarkBlue);
                    row[0] = new TableCell(dbNameHead, null, null, null);
                    row[0].setWidth(20);
                    Table dbTable = new Table(2);
                    dbTable.setBorderColor(HtmlConstants.Colors.DarkBlue);
                    dbTable.setTableBorderWidth(1);
                    TableCell[] dbNameRow = new TableCell[2];
                    Text dbNameTxt = new Text(this.s_rptMsgBundle.getMessage("10006", false));
                    dbNameTxt.setBold(true);
                    dbNameRow[0] = new TableCell(dbNameTxt, null, null, null);
                    dbNameRow[1] = new TableCell(new Text(dbDetails.getDatabaseName()), null, null, null);
                    dbTable.addRow(dbNameRow);
                    TableCell[] dbVerRow = new TableCell[2];
                    Text dbVersionTxt = new Text(this.s_rptMsgBundle.getMessage("10008", false));
                    dbVersionTxt.setBold(true);
                    dbVerRow[0] = new TableCell(dbVersionTxt, null, null, null);
                    String dbVer = dbDetails.getDatabaseVersion();
                    dbVerRow[1] = new TableCell(new Text(VerificationUtil.isStringGood(dbVer) ? dbVer : new String("")), null, null, null);
                    dbTable.addRow(dbVerRow);
                    TableCell[] dbHomeRow = new TableCell[2];
                    Text dbHomeTxt = new Text(this.s_rptMsgBundle.getMessage("10009", false));
                    dbHomeTxt.setBold(true);
                    String dbHome = dbDetails.getDatabaseHome();
                    dbHomeRow[0] = new TableCell(dbHomeTxt, null, null, null);
                    dbHomeRow[1] = new TableCell(new Text(VerificationUtil.isStringGood(dbHome) ? dbHome : new String("")), null, null, null);
                    dbTable.addRow(dbHomeRow);
                    row[1] = new TableCell(dbTable, null, null, null);
                    table.addRow(row);
                }
            }
        }
        return table;
    }

    public void xmlToText(ReportUtilConstants.ReportContext context, boolean showFailure, boolean saveFile, String saveDirPath, boolean dispStdOut) throws XmlFilePathException, XmlReportToolException {
        StringBuffer textBuffer = new StringBuffer();
        String dbName = null;
        CVXMLReportReader reader = CVXMLReportReader.getCVXMLReportReader(this.m_xmlReportFilePath);
        textBuffer.append(VerificationConstants.LINE_SEPARATOR + this.createBasicClusterDetailsTextTable(reader));
        HashMap<String, HashMap<String, String>> targetList = reader.getTargetList();
        if (targetList == null) {
            targetList = new HashMap();
        }
        int cnt = -1;
        for (String targetKey : targetList.keySet()) {
            ++cnt;
            String captionMsg = null;
            HashMap<String, String> targetAttributes = targetList.get(targetKey);
            String targetStr = targetAttributes.get("ID");
            ReportUtilConstants.TargetType targetType = null;
            if (!VerificationUtil.isStringGood(targetStr)) {
                Trace.out((String)"skipping without adding any target because target type null");
                continue;
            }
            if (targetStr.trim().equalsIgnoreCase(VerificationType.PREREQ_CRS_INST.getID())) {
                captionMsg = this.s_rptMsgBundle.getMessage("10012", false);
                targetType = ReportUtilConstants.TargetType.SYSTEM_BASED_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.POSTREQ_CRS_INST.getID())) {
                captionMsg = this.s_rptMsgBundle.getMessage("10014", false);
                targetType = ReportUtilConstants.TargetType.CLUSTER_BASED_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_PRE_CRS_INST.getID())) {
                captionMsg = this.s_rptMsgBundle.getMessage("10013", false);
                targetType = ReportUtilConstants.TargetType.CLUSTER_BASED_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_POSTREQ_CRS_INST.getID())) {
                captionMsg = this.s_rptMsgBundle.getMessage("10015", false);
                targetType = ReportUtilConstants.TargetType.SYSTEM_BASED_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.PREREQ_DB_CONFIG.getID()) || targetStr.trim().equalsIgnoreCase(VerificationType.PREREQ_DB_INST.getID()) || targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_POSTREQ_DB_CONFIG.getID()) || targetStr.trim().equalsIgnoreCase(VerificationType.POSTREQ_DB_CONFIG.getID())) {
                captionMsg = null;
                dbName = targetAttributes.get("DATABASENAME");
                captionMsg = targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_POSTREQ_DB_CONFIG.getID()) ? this.s_rptMsgBundle.getMessage("10017", false, (Object[])new String[]{dbName}) : this.s_rptMsgBundle.getMessage("10016", false, (Object[])new String[]{dbName});
                targetType = ReportUtilConstants.TargetType.DATABASE_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_ASM.getID())) {
                captionMsg = this.s_rptMsgBundle.getMessage("10187", false);
                targetType = ReportUtilConstants.TargetType.ASM_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.COMPONENT_ASM_INTEGRITY.getID())) {
                captionMsg = this.s_rptMsgBundle.getMessage("10186", false);
            } else {
                if (!targetStr.trim().equalsIgnoreCase(VerificationType.PREREQ_APPLICATION_CLUSTER_INST.getID()) && !targetStr.trim().equalsIgnoreCase(VerificationType.POSTREQ_APPLICATION_CLUSTER_INST.getID())) continue;
                captionMsg = this.s_rptMsgBundle.getMessage("10200", false);
                targetType = ReportUtilConstants.TargetType.CLUSTER_BASED_CHECKS;
            }
            StringBuffer tableDataBuffer = this.createTextTableForTarget(this.sortTaskAsPerStatus(reader.getTaskList(targetKey), true), targetType, showFailure);
            if (tableDataBuffer.toString().trim().length() > 0 && VerificationUtil.isStringGood(captionMsg)) {
                textBuffer.append(VerificationConstants.LINE_SEPARATOR);
                this.addTextLine(textBuffer, "*");
                textBuffer.append(captionMsg);
                this.addTextLine(textBuffer, "*");
                textBuffer.append(tableDataBuffer);
                continue;
            }
            Trace.out((String)"Not adding any data.");
        }
        if (dispStdOut) {
            ReportUtil.quietprintln(textBuffer.toString());
        }
        if (saveFile) {
            this.saveToTextFile(textBuffer, saveDirPath);
        }
    }

    private StringBuffer createTextTableForTarget(List<Task> taskList, ReportUtilConstants.TargetType targetType, boolean showFailure) {
        StringBuffer buffer = new StringBuffer();
        String unknown = this.s_rptMsgBundle.getMessage("10057", false);
        String notApplicable = this.s_rptMsgBundle.getMessage("10026", false);
        String notAvailable = this.s_rptMsgBundle.getMessage("10027", false);
        String none = this.s_rptMsgBundle.getMessage("10054", false);
        for (Task task : taskList) {
            Vector<String> errorMsgList;
            String summary;
            boolean isTaskMandatory = !task.isBestPractice();
            boolean isTaskCritical = true;
            String severity = task.getSeverity().name();
            isTaskCritical = VerificationUtil.isStringGood(severity) && (severity.trim().equalsIgnoreCase(SeverityType.CRITICAL.name()) || severity.trim().equalsIgnoreCase(SeverityType.FATAL.name()));
            String check = task.getElementName();
            if (!VerificationUtil.isStringGood(check)) {
                check = unknown;
                continue;
            }
            String overAllStatus = task.getResultSet().getOverallStatus().name();
            if (VerificationUtil.isStringGood(overAllStatus) && overAllStatus.toLowerCase().contains("success")) {
                if (showFailure) continue;
                overAllStatus = isTaskMandatory ? this.s_rptMsgBundle.getMessage("10030", false) : this.s_rptMsgBundle.getMessage("10034", false);
            } else if (VerificationUtil.isStringGood(overAllStatus) && overAllStatus.toLowerCase().contains("warning")) {
                if (showFailure && isTaskMandatory) continue;
                overAllStatus = isTaskMandatory ? this.s_rptMsgBundle.getMessage("10032", false) : this.s_rptMsgBundle.getMessage("10035", false);
            } else {
                overAllStatus = VerificationUtil.isStringGood(overAllStatus) && overAllStatus.toLowerCase().contains("failed") ? (isTaskMandatory && isTaskCritical ? this.s_rptMsgBundle.getMessage("10031", false) : (isTaskMandatory && !isTaskCritical ? this.s_rptMsgBundle.getMessage("10032", false) : this.s_rptMsgBundle.getMessage("10035", false))) : this.s_rptMsgBundle.getMessage("10033", false);
            }
            String description = task.getDescription();
            if (!VerificationUtil.isStringGood(description)) {
                description = notAvailable;
            }
            if (!VerificationUtil.isStringGood(summary = task.getResultSet().getResultSummary())) {
                summary = notAvailable;
            }
            List<VerificationError> globalErrorList = task.getResultSet().getErrors();
            String globalErrors = null;
            if (globalErrorList != null && (errorMsgList = this.createErrorDescriptionMsgFromElement(globalErrorList)).size() > 0) {
                StringBuffer listErrors = new StringBuffer();
                for (String errorMsg : errorMsgList) {
                    if (!VerificationUtil.isStringGood(errorMsg)) continue;
                    listErrors.append(errorMsg);
                }
                globalErrors = listErrors.toString().trim();
            }
            String moreDetailsText = notAvailable;
            List<String> moreDetailReferences = null;
            moreDetailsText = task.getMoreDetails();
            if (!VerificationUtil.isStringGood(moreDetailsText)) {
                moreDetailsText = notAvailable;
            }
            moreDetailReferences = task.getReferences();
            int maxLengthOfCol = 0;
            Vector<String[]> summaryTable = new Vector<String[]>();
            String[] currentRow = null;
            if (VerificationUtil.isStringGood(check) && !check.equalsIgnoreCase(notAvailable)) {
                currentRow = new String[2];
                currentRow[0] = this.s_rptMsgBundle.getMessage("10019", false);
                if (VerificationUtil.isStringGood(currentRow[0]) && currentRow[0].length() > maxLengthOfCol) {
                    maxLengthOfCol = currentRow[0].length();
                }
                currentRow[1] = check;
                summaryTable.add(currentRow);
                currentRow = null;
            }
            if (VerificationUtil.isStringGood(description) && !description.equalsIgnoreCase(notAvailable)) {
                currentRow = new String[2];
                currentRow[0] = this.s_rptMsgBundle.getMessage("10021", false);
                if (VerificationUtil.isStringGood(currentRow[0]) && currentRow[0].length() > maxLengthOfCol) {
                    maxLengthOfCol = currentRow[0].length();
                }
                currentRow[1] = description;
                summaryTable.add(currentRow);
                currentRow = null;
            }
            if (VerificationUtil.isStringGood(overAllStatus) && !overAllStatus.equalsIgnoreCase(notAvailable)) {
                currentRow = new String[2];
                currentRow[0] = this.s_rptMsgBundle.getMessage("10020", false);
                if (VerificationUtil.isStringGood(currentRow[0]) && currentRow[0].length() > maxLengthOfCol) {
                    maxLengthOfCol = currentRow[0].length();
                }
                currentRow[1] = overAllStatus;
                summaryTable.add(currentRow);
                currentRow = null;
            }
            if (VerificationUtil.isStringGood(globalErrors)) {
                currentRow = new String[2];
                currentRow[0] = this.s_rptMsgBundle.getMessage("10064", false);
                if (VerificationUtil.isStringGood(currentRow[0]) && currentRow[0].length() > maxLengthOfCol) {
                    maxLengthOfCol = currentRow[0].length();
                }
                currentRow[1] = globalErrors;
                summaryTable.add(currentRow);
                currentRow = null;
            }
            if (VerificationUtil.isStringGood(summary) && !summary.equalsIgnoreCase(notAvailable)) {
                currentRow = new String[2];
                currentRow[0] = this.s_rptMsgBundle.getMessage("10047", false);
                if (VerificationUtil.isStringGood(currentRow[0]) && currentRow[0].length() > maxLengthOfCol) {
                    maxLengthOfCol = currentRow[0].length();
                }
                currentRow[1] = summary;
                summaryTable.add(currentRow);
                currentRow = null;
            }
            if (VerificationUtil.isStringGood(moreDetailsText) && !moreDetailsText.equalsIgnoreCase(notAvailable)) {
                currentRow = new String[2];
                currentRow[0] = this.s_rptMsgBundle.getMessage("10023", false);
                if (VerificationUtil.isStringGood(currentRow[0]) && currentRow[0].length() > maxLengthOfCol) {
                    maxLengthOfCol = currentRow[0].length();
                }
                currentRow[1] = moreDetailsText;
                summaryTable.add(currentRow);
                currentRow = null;
            }
            if (moreDetailReferences != null && moreDetailReferences.size() > 0) {
                currentRow = new String[2];
                currentRow[0] = this.s_rptMsgBundle.getMessage("10048", false);
                if (VerificationUtil.isStringGood(currentRow[0]) && currentRow[0].length() > maxLengthOfCol) {
                    maxLengthOfCol = currentRow[0].length();
                }
                currentRow[1] = "";
                for (String link : moreDetailReferences) {
                    currentRow[1] = currentRow[1] + link + VerificationConstants.LINE_SEPARATOR;
                }
                summaryTable.add(currentRow);
            }
            for (String[] colElem : summaryTable) {
                Vector<String> lines = this.formatTextLine(colElem, new int[]{maxLengthOfCol + 5, 90 - (maxLengthOfCol + 5)}, ":");
                for (String line : lines) {
                    buffer.append(VerificationConstants.LINE_SEPARATOR + line);
                }
            }
            buffer.append(VerificationConstants.LINE_SEPARATOR);
            int[] space = new int[]{20, 10, 30, 30};
            LinkedHashMap nodeWiseErrors = new LinkedHashMap();
            ResultSet taskRS = task.getResultSet();
            for (ResultKeyType resKeyType : ResultKeyType.values()) {
                Vector<String> rowsOfHeaders;
                String[] header;
                String[] failedNodes = taskRS.getFailureByType(resKeyType);
                String[] notAppNodes = taskRS.getNotAppByType(resKeyType);
                List<String> succNodes = Arrays.asList(taskRS.getSuccessByType(resKeyType));
                Vector<String> allNodes = new Vector<String>(Arrays.asList(failedNodes));
                if (!showFailure) {
                    allNodes.addAll(succNodes);
                    allNodes.addAll(Arrays.asList(notAppNodes));
                }
                String nodeStatus = unknown;
                if (allNodes.size() > 0) {
                    header = new String[]{this.s_rptMsgBundle.getMessage(this.getNodeHeaderStr(resKeyType), false), this.s_rptMsgBundle.getMessage("10056", false), this.s_rptMsgBundle.getMessage("10024", false), this.s_rptMsgBundle.getMessage("10025", false)};
                    rowsOfHeaders = this.formatTextLine(header, space, null);
                    for (String row : rowsOfHeaders) {
                        buffer.append(VerificationConstants.LINE_SEPARATOR + row);
                    }
                    this.addTextLine(buffer, "-", 90);
                    for (int cnt = 0; cnt < allNodes.size(); ++cnt) {
                        Result nodeResult;
                        String nodeName = allNodes.elementAt(cnt);
                        String[] rowElements = new String[4];
                        if (!VerificationUtil.isStringGood(nodeName) || (nodeResult = task.getResultSet().getResult(nodeName)) == null) continue;
                        nodeStatus = this.getStatusString(nodeResult.getStatus());
                        nodeStatus = nodeStatus.toLowerCase().contains("success") ? this.s_rptMsgBundle.getMessage("10030", false) : (nodeStatus.toLowerCase().contains("warning") ? (isTaskMandatory ? this.s_rptMsgBundle.getMessage("10032", false) : this.s_rptMsgBundle.getMessage("10035", false)) : (nodeStatus.toLowerCase().contains("failed") ? (isTaskMandatory && isTaskCritical ? this.s_rptMsgBundle.getMessage("10031", false) : (isTaskMandatory && !isTaskCritical ? this.s_rptMsgBundle.getMessage("10032", false) : this.s_rptMsgBundle.getMessage("10035", false))) : (nodeStatus.toLowerCase().contains("not_applicable") ? this.s_rptMsgBundle.getMessage("10026", false) : unknown)));
                        Object expectedValue = null;
                        String actualValue = null;
                        try {
                            expectedValue = nodeResult.getExpectedValue();
                            actualValue = nodeResult.getActualValue();
                        }
                        catch (ResultValuesUnavailableException e) {
                            expectedValue = null;
                            actualValue = null;
                        }
                        rowElements[0] = nodeName;
                        rowElements[1] = nodeStatus;
                        rowElements[2] = VerificationUtil.isStringGood((String)expectedValue) ? expectedValue : notApplicable;
                        rowElements[3] = VerificationUtil.isStringGood(actualValue) ? actualValue : notApplicable;
                        Vector<String> rowLines = this.formatTextLine(rowElements, space, null);
                        for (String row : rowLines) {
                            buffer.append(VerificationConstants.LINE_SEPARATOR + row);
                        }
                    }
                    buffer.append(VerificationConstants.LINE_SEPARATOR);
                    this.addTextLine(buffer, "_");
                }
                if (nodeWiseErrors.size() <= 0) continue;
                space = new int[]{20, 70};
                header = new String[]{this.s_rptMsgBundle.getMessage(this.getNodeHeaderStr(resKeyType), false), this.s_rptMsgBundle.getMessage("10036", false)};
                rowsOfHeaders = this.formatTextLine(header, space, null);
                for (String row : rowsOfHeaders) {
                    buffer.append(VerificationConstants.LINE_SEPARATOR + row);
                }
                this.addTextLine(buffer, "-", 90);
                for (String nodeName : ((HashMap)nodeWiseErrors).keySet()) {
                    Vector nodeErrors = (Vector)((HashMap)nodeWiseErrors).get(nodeName);
                    StringBuffer listErrors = new StringBuffer();
                    for (String errorMsg : nodeErrors) {
                        if (!VerificationUtil.isStringGood(errorMsg)) continue;
                        listErrors.append(errorMsg);
                    }
                    String[] rowElements = new String[]{nodeName, listErrors.toString().trim()};
                    Vector<String> rowLines = this.formatTextLine(rowElements, space, null);
                    for (String row : rowLines) {
                        buffer.append(VerificationConstants.LINE_SEPARATOR + row);
                    }
                }
                this.addTextLine(buffer, "_");
            }
        }
        return buffer;
    }

    private String createBasicClusterDetailsTextTable(CVXMLReportReader reader) throws XmlReportToolException {
        StringBuffer buffer = new StringBuffer();
        int maxLengthOfKey = 0;
        Vector<String[]> entries = new Vector<String[]>();
        this.addTextLine(buffer, "*");
        buffer.append("\t" + this.s_rptMsgBundle.getMessage("10002", false));
        this.addTextLine(buffer, "*");
        ReportUtilConstants.BasicClusterWareDetails header = reader.getHeader();
        if (header != null) {
            Object row = null;
            Calendar timeStamp = header.getTimeStamp();
            if (timeStamp != null) {
                SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyy");
                String[] rowElement = new String[2];
                String dateStr = formatter.format(timeStamp.getTime());
                rowElement[0] = this.s_rptMsgBundle.getMessage("10010", false);
                if (VerificationUtil.isStringGood(rowElement[0]) && rowElement[0].length() > maxLengthOfKey) {
                    maxLengthOfKey = rowElement[0].length();
                }
                rowElement[1] = dateStr;
                entries.add(rowElement);
                formatter = new SimpleDateFormat("HH:mm:ss");
                rowElement = new String[2];
                String timeStr = formatter.format(timeStamp.getTime());
                rowElement[0] = this.s_rptMsgBundle.getMessage("10011", false);
                if (VerificationUtil.isStringGood(rowElement[0]) && rowElement[0].length() > maxLengthOfKey) {
                    maxLengthOfKey = rowElement[0].length();
                }
                rowElement[1] = timeStr;
                entries.add(rowElement);
            }
            if (header != null) {
                String[] rowElement;
                String clusterNameStr = header.getClusterName();
                String crsHome = header.getCrsHome();
                String crsUser = header.getCrsUserName();
                String clusterVersion = header.getClusterwareVersion();
                String osPlatform = header.getOsPlatform();
                if (VerificationUtil.isStringGood(clusterNameStr)) {
                    rowElement = new String[2];
                    rowElement[0] = this.s_rptMsgBundle.getMessage("10005", false);
                    if (VerificationUtil.isStringGood(rowElement[0]) && rowElement[0].length() > maxLengthOfKey) {
                        maxLengthOfKey = rowElement[0].length();
                    }
                    rowElement[1] = clusterNameStr;
                    entries.add(rowElement);
                }
                if (VerificationUtil.isStringGood(clusterVersion)) {
                    rowElement = new String[2];
                    rowElement[0] = this.s_rptMsgBundle.getMessage("10049", false);
                    if (VerificationUtil.isStringGood(rowElement[0]) && rowElement[0].length() > maxLengthOfKey) {
                        maxLengthOfKey = rowElement[0].length();
                    }
                    rowElement[1] = clusterVersion;
                    entries.add(rowElement);
                }
                if (VerificationUtil.isStringGood(crsHome)) {
                    rowElement = new String[2];
                    rowElement[0] = this.s_rptMsgBundle.getMessage("10037", false);
                    if (VerificationUtil.isStringGood(rowElement[0]) && rowElement[0].length() > maxLengthOfKey) {
                        maxLengthOfKey = rowElement[0].length();
                    }
                    rowElement[1] = crsHome;
                    entries.add(rowElement);
                }
                if (VerificationUtil.isStringGood(crsUser)) {
                    rowElement = new String[2];
                    rowElement[0] = this.s_rptMsgBundle.getMessage("10038", false);
                    if (VerificationUtil.isStringGood(rowElement[0]) && rowElement[0].length() > maxLengthOfKey) {
                        maxLengthOfKey = rowElement[0].length();
                    }
                    rowElement[1] = crsUser;
                    entries.add(rowElement);
                }
                if (VerificationUtil.isStringGood(osPlatform)) {
                    rowElement = new String[2];
                    rowElement[0] = this.s_rptMsgBundle.getMessage("10050", false);
                    if (VerificationUtil.isStringGood(rowElement[0]) && rowElement[0].length() > maxLengthOfKey) {
                        maxLengthOfKey = rowElement[0].length();
                    }
                    rowElement[1] = osPlatform;
                    entries.add(rowElement);
                }
            }
            int dbCount = 0;
            if (header.getDatabaseCount() > 0) {
                for (ReportUtilConstants.DatabaseDetails dbDetails : header.getDatabases()) {
                    String dbHome;
                    String dbVersion;
                    String[] rowElement = new String[2];
                    rowElement[0] = this.s_rptMsgBundle.getMessage("10007", false, (Object[])new String[]{Integer.toString(++dbCount)});
                    if (VerificationUtil.isStringGood(rowElement[0]) && rowElement[0].length() > maxLengthOfKey) {
                        maxLengthOfKey = rowElement[0].length();
                    }
                    Vector<String[]> perDbTable = new Vector<String[]>();
                    int internalMaxLength = 0;
                    String[] dbNameRow = new String[2];
                    dbNameRow[0] = this.s_rptMsgBundle.getMessage("10006", false);
                    if (internalMaxLength < dbNameRow[0].length()) {
                        internalMaxLength = dbNameRow[0].length();
                    }
                    dbNameRow[1] = dbDetails.getDatabaseName();
                    perDbTable.add(dbNameRow);
                    String[] dbVerRow = new String[2];
                    dbVerRow[0] = this.s_rptMsgBundle.getMessage("10008", false);
                    if (internalMaxLength < dbVerRow[0].length()) {
                        internalMaxLength = dbVerRow[0].length();
                    }
                    dbVerRow[1] = VerificationUtil.isStringGood(dbVersion = dbDetails.getDatabaseVersion()) ? dbVersion : new String("");
                    perDbTable.add(dbVerRow);
                    String[] dbHomeRow = new String[2];
                    dbHomeRow[0] = this.s_rptMsgBundle.getMessage("10009", false);
                    if (internalMaxLength < dbHomeRow[0].length()) {
                        internalMaxLength = dbHomeRow[0].length();
                    }
                    dbHomeRow[1] = VerificationUtil.isStringGood(dbHome = dbDetails.getDatabaseHome()) ? dbHome : new String("");
                    perDbTable.add(dbHomeRow);
                    StringBuffer perDBDetails = new StringBuffer();
                    for (int cnt = 0; cnt < perDbTable.size(); ++cnt) {
                        String[] rows = (String[])perDbTable.elementAt(cnt);
                        for (String line : this.formatTextLine(rows, new int[]{internalMaxLength + 5, 50 - (internalMaxLength + 5)}, "-")) {
                            perDBDetails.append(line + VerificationConstants.LINE_SEPARATOR);
                        }
                    }
                    rowElement[1] = perDBDetails.toString().trim();
                    entries.add(rowElement);
                }
            }
        }
        for (int cnt = 0; cnt < entries.size(); ++cnt) {
            String[] rows = (String[])entries.elementAt(cnt);
            for (String line : this.formatTextLine(rows, new int[]{maxLengthOfKey + 5, 50}, ":")) {
                buffer.append(VerificationConstants.LINE_SEPARATOR + line);
            }
        }
        return buffer.toString();
    }

    private String[] createTimeAndDateStringsFromXML(Calendar calendar, String dateSep, String timeSep) {
        String[] timeStampArray = null;
        String dateStr = null;
        String timeStr = null;
        String dateDelim = dateSep;
        String timeDelim = timeSep;
        if (calendar != null) {
            String pattern = null;
            pattern = dateDelim != null ? "dd" + dateSep + "MM" + dateSep + "yyyy" : "ddMMyyy";
            SimpleDateFormat formatter = new SimpleDateFormat(pattern);
            dateStr = formatter.format(calendar.getTime());
            pattern = timeDelim != null ? "HH" + timeDelim + "mm" + timeDelim + "ss" : "HHmmss";
            formatter = new SimpleDateFormat(pattern);
            timeStr = formatter.format(calendar.getTime());
        }
        if (VerificationUtil.isStringGood(timeStr) && VerificationUtil.isStringGood(dateStr)) {
            timeStampArray = new String[]{dateStr, timeStr};
        }
        return timeStampArray;
    }

    private Element searchAndGetFirstChildNode(Element parent, String elementTagName) {
        NodeList childNodes = parent.getElementsByTagName(elementTagName);
        Element child = null;
        if (childNodes != null) {
            child = (Element)childNodes.item(0);
        }
        return child;
    }

    private void writeTimeStamp(CVXMLReportWriter writer) throws XmlReportToolException {
        String year = Integer.toString(this.m_timeStamp.get(1));
        String month = Integer.toString(this.m_timeStamp.get(2) + 1);
        String day = Integer.toString(this.m_timeStamp.get(5));
        String hours = Integer.toString(this.m_timeStamp.get(11));
        String minutes = Integer.toString(this.m_timeStamp.get(12));
        String seconds = Integer.toString(this.m_timeStamp.get(13));
        writer.writeStartElement("TIME_STAMP");
        writer.writeAttribute("YEAR", year);
        writer.writeAttribute("MONTH", month);
        writer.writeAttribute("DAY", day);
        writer.writeAttribute("HOURS", hours);
        writer.writeAttribute("MINUTES", minutes);
        writer.writeAttribute("SECONDS", seconds);
        writer.writeEndElement();
    }

    private String getTimeStampStr(Calendar calendar) {
        SimpleDateFormat formatter = new SimpleDateFormat("MMddyyyHHmmss");
        return formatter.format(calendar.getTime());
    }

    private void addTextLine(StringBuffer txtBuffer, String lineChar) {
        this.addTextLine(txtBuffer, lineChar, 0);
    }

    private void addTextLine(StringBuffer txtBuffer, String lineChar, int length) {
        if (length <= 0) {
            length = 90;
        }
        txtBuffer.append(VerificationConstants.LINE_SEPARATOR);
        for (int i = 0; i < length; ++i) {
            txtBuffer.append(lineChar);
        }
        txtBuffer.append(VerificationConstants.LINE_SEPARATOR);
    }

    private Vector<String> formatTextLine(String[] columns, int[] space, String delim) {
        Vector<String> lines = new Vector<String>();
        if (columns == null || space == null || columns.length != space.length) {
            return null;
        }
        boolean oneMoreLine = false;
        String[] newArray = new String[columns.length];
        StringBuffer buffer = new StringBuffer();
        for (int cnt = 0; cnt < columns.length; ++cnt) {
            int allowedSpan = space[cnt] - 2;
            String col = columns[cnt].trim();
            if (col.length() > allowedSpan) {
                String colForThisLine = col.substring(0, allowedSpan);
                if (colForThisLine.contains("\n")) {
                    int newLineIndx = colForThisLine.indexOf("\n");
                    buffer.append(colForThisLine.substring(0, newLineIndx));
                    newArray[cnt] = col.substring(newLineIndx, col.length());
                    oneMoreLine = true;
                } else {
                    int lastSpaceIndx = colForThisLine.lastIndexOf(" ");
                    int additionalSpaces = 0;
                    if (lastSpaceIndx != -1) {
                        colForThisLine = col.substring(0, lastSpaceIndx);
                        additionalSpaces = col.substring(0, allowedSpan).substring(lastSpaceIndx).length();
                        for (int i = 0; i < additionalSpaces; ++i) {
                            colForThisLine = colForThisLine + " ";
                        }
                    } else {
                        lastSpaceIndx = allowedSpan;
                    }
                    buffer.append(colForThisLine);
                    newArray[cnt] = col.substring(lastSpaceIndx, col.length());
                    oneMoreLine = true;
                }
            } else if (col.length() < allowedSpan) {
                int i;
                buffer.append(col);
                if (cnt == 0 && VerificationUtil.isStringGood(delim)) {
                    for (i = 0; i < allowedSpan - col.length() - 1; ++i) {
                        buffer.append(" ");
                    }
                    buffer.append(delim.charAt(0));
                } else {
                    for (i = 0; i < allowedSpan - col.length(); ++i) {
                        buffer.append(" ");
                    }
                }
                newArray[cnt] = "";
            } else {
                buffer.append(col);
                newArray[cnt] = "";
            }
            buffer.append("  ");
        }
        lines.add(buffer.toString());
        if (oneMoreLine) {
            Vector<String> moreLines = this.formatTextLine(newArray, space, null);
            for (String str : moreLines) {
                lines.add(str);
            }
        }
        return lines;
    }

    private String getNodeHeaderStr(ResultKeyType keyType) {
        if (keyType == null) {
            return "10052";
        }
        switch (keyType) {
            case DB: 
            case DB_INSTANCE: {
                return "10022";
            }
            case ASM: {
                return "10214";
            }
            case ASMINSTANCE: {
                return "10185";
            }
            case ASMDISKGROUP: {
                return "10212";
            }
            case ASMDISK: {
                return "10213";
            }
        }
        return "10052";
    }
}

