/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.param.parser;

import java.util.List;
import oracle.cluster.util.ConsoleUtil;
import oracle.cluster.util.ConsoleUtilException;
import oracle.cluster.winsecurity.Home;
import oracle.cluster.winsecurity.WinSecurityFactory;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.param.parser.CLCommand;
import oracle.ops.verification.framework.param.parser.CLSyntaxValidator;
import oracle.ops.verification.framework.param.parser.InvalidCLException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ServiceUserPasswordValidator
extends CLSyntaxValidator {
    @Override
    public void isValid(List<String> clTokens, CLCommand command) throws InvalidCLException {
        String serviceUser = CVUVariables.getValue(CVUVariableConstants.SERVICE_USER.name());
        ConsoleUtil consoleUtil = new ConsoleUtil();
        if (!VerificationUtil.isStringGood(serviceUser)) {
            String destloc = VerificationUtil.getDestLoc();
            String srcloc = VerificationUtil.getCVHome();
            String oracleHome = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
            try {
                WinSecurityFactory wsecFac = WinSecurityFactory.getInstance((String)srcloc, (String)destloc);
                Home home = wsecFac.getHome(oracleHome, new Version());
                serviceUser = home.getServiceUserFromHomePath().getUsername();
            }
            catch (WindowsSecurityException e) {
                Trace.out((String)("WindowsSecurityException " + e.getMessage()));
                Trace.out((Exception)((Object)e));
                throw new InvalidCLException(e.getMessage());
            }
        }
        try {
            String passwdMessage = s_msgBundle.getMessage("1048", false, (Object[])new String[]{serviceUser});
            String s_password = new String(consoleUtil.readPassword(passwdMessage));
            CVUVariables.setValue(CVUVariableConstants.SERVICEPWD, s_password);
        }
        catch (ConsoleUtilException e) {
            Trace.out((String)("Console util failed" + e.getMessage()));
            Trace.out((Exception)((Object)e));
            throw new InvalidCLException(e.getMessage());
        }
    }
}

