/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.param;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.param.parser.CLCommand;
import oracle.ops.verification.framework.param.parser.CLSyntaxXMLParser;
import oracle.ops.verification.framework.param.parser.InvalidCLException;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public final class CLSyntax {
    public static final String FSEP = System.getProperty("file.separator");
    public static final String LSEP = System.getProperty("line.separator");
    public static final String TAB = "\t";
    public static final String FROM_RUNCLUVFY = "_FROM_RUNCLUVFY";
    public static final String FROM_RACHOME = "_FROM_RACHOME";
    public static final String KEY_SEP = ".";
    public static String DELIMETER = ",";
    public static String STR_HELP = "-help";
    public static String STR_LIST = "-list";
    public static String STR_DIAG = "-diag";
    public static String STR_VERBOSE = "-verbose";
    public static String STR_OLDFORMAT = "-oldformat";
    public static String STR_VER10GR1 = "-ver10gr1";
    public static String STR_DISPLAYSTATUS = "-display_status";
    public static String STR_VER10GR2 = "-ver10gr2";
    public static String STR_VER11GR1 = "-ver11gr1";
    public static String STR_VER11GR2 = "-ver11gr2";
    public static String STR_VERSION = "-version";
    public static String STR_CFS_OH = "-cfs_oh";
    public static String STR_SSH_ONLY = "-sshonly";
    public static String STR_SERVICE = "-service";
    public static String STR_PROFILE_FLAG = "-profile";
    public static String STR_FIXUP = "-fixup";
    public static String STR_FIXUP_NO_EXECUTE = "-fixupnoexec";
    public static String STR_DHCP_FLAG = "-dhcp";
    public static String STR_DNS_FLAG = "-dns";
    public static String STR_DHCP_PORT = "-dhcpport";
    public static String STR_NOCTSS = "-noctss";
    public static String STR_FORMAT = "-_format";
    public static String STR_CHECK_TYPE = "-_check_type";
    public static String STR_PATCH_ONLY = "-_patch_only";
    public static String STR_HTML = "-html";
    public static String STR_DEVIATIONS = "-deviations";
    public static String STR_SAVE = "-save";
    public static String STR_SAVEDIR = "-savedir";
    public static String STR_COLLECT = "-collect";
    public static String STR_CLUSTER = "cluster";
    public static String STR_DATABASE = "database";
    public static String STR_BESTPRACTICE = "-bestpractice";
    public static String STR_MANDATORY = "-mandatory";
    public static String STR_UPGRADE = "-upgrade";
    public static String STR_SERVICEPWD = "-servicepasswd";
    public static String STR_DEST_SERVICEPWD = "-dest_servicepasswd";
    public static String STR_SUMMARY = "-summary";
    public static String STR_REPORT_NAME = "-reportname";
    public static String STR_BASELINE = "baseline";
    public static String STR_BASE_LINE = "-baseline";
    public static String STR_BASELINE_BINLIBFILES = "-binlibfilesonly";
    public static String STR_PRINT_MISMATCH = "-print_mismatch";
    public static String STR_ROOTSCRIPT = "-rootscript";
    public static String STR_RESOURCE = "-resource";
    public static String STR_INSTALLER = "-installer";
    public static String STR_HOME_NAME = "-homename";
    public static String STR_SAVETOALLNODES = "-saveToAllNodes";
    public static String STR_DB = "-db";
    public static String STR_PROFILE = "profile";
    public static String STR_STAGE = "stage";
    public static String STR_PRE = "-pre";
    public static String STR_POST = "-post";
    public static String STR_HWOS = "hwos";
    public static String STR_CFS = "cfs";
    public static String STR_CRSINST = "crsinst";
    public static String STR_HACONFIG = "hacfg";
    public static String STR_DBINST = "dbinst";
    public static String STR_DBCFG = "dbcfg";
    public static String STR_USMCFG = "acfscfg";
    public static String STR_NODEADD = "nodeadd";
    public static String STR_NODEDEL = "nodedel";
    public static String STR_STORADD = "storadd";
    public static String STR_NETMOD = "netmod";
    public static String STR_APPCLUSTER = "appcluster";
    public static String STR_COMPONENT = "comp";
    public static String STR_NODECON = "nodecon";
    public static String STR_NODEREACH = "nodereach";
    public static String STR_SSA = "ssa";
    public static String STR_SYS = "sys";
    public static String STR_SPACE = "space";
    public static String STR_ADMPRV = "admprv";
    public static String STR_CLUMGR = "clumgr";
    public static String STR_CLU = "clu";
    public static String STR_NODEAPP = "nodeapp";
    public static String STR_OCR = "ocr";
    public static String STR_OLR = "olr";
    public static String STR_HA = "ha";
    public static String STR_CRS = "crs";
    public static String STR_PEER = "peer";
    public static String STR_SOFTWARE = "software";
    public static String STR_USM = "acfs";
    public static String STR_ASM = "asm";
    public static String STR_GPNP = "gpnp";
    public static String STR_GNS = "gns";
    public static String STR_DNS = "dns";
    public static String STR_DHCP = "dhcp";
    public static String STR_SCAN = "scan";
    public static String STR_OHASD = "ohasd";
    public static String STR_CTSS = "clocksync";
    public static String STR_VDISK = "vdisk";
    public static String STR_HEALTH = "health";
    public static String STR_HEALTH_CHECK = "healthcheck";
    public static String STR_FREESPACE = "freespace";
    public static String STR_FARM_CHECK = "farmcheck";
    public static String STR_ALL = "all";
    public static String STR_A = "-a";
    public static String STR_C = "-c";
    public static String STR_D = "-d";
    public static String STR_F = "-f";
    public static String STR_H = "-h";
    public static String STR_I = "-i";
    public static String STR_L = "-l";
    public static String STR_N = "-n";
    public static String STR_O = "-o";
    public static String STR_P = "-p";
    public static String STR_Q = "-q";
    public static String STR_R = "-r";
    public static String STR_S = "-s";
    public static String STR_T = "-t";
    public static String STR_Z = "-z";
    public static String STR_REFNODE = "-refnode";
    public static String STR_SRCNODE = "-srcnode";
    public static String STR_OSDBA = "-osdba";
    public static String STR_OSOPER = "-osoper";
    public static String STR_ORAINV = "-orainv";
    public static String STR_ORAUSER = "-orauser";
    public static String STR_CLUVFY_OH = "-cluvfyoh";
    public static String STR_ASMGRP = "-asmgrp";
    public static String STR_ASMDBAGRP = "-asmdbagrp";
    public static String STR_ASMOPERGRP = "-asmopergrp";
    public static String STR_OSBACKUP = "-osbackup";
    public static String STR_OSDG = "-osdg";
    public static String STR_OSKM = "-oskm";
    public static String STR_ASMDEV = "-asmdev";
    public static String STR_ASMDG = "-diskgroup";
    public static String STR_ASMFLAG = "-asm";
    public static String STR_USMFLAG = "-acfs";
    public static String STR_CRS_HOME = "-crshome";
    public static String STR_CLUSTERNAME = "-clustername";
    public static String STR_VIPTYPE = "-viptype";
    public static String STR_VIPRESNAME = "-vipresname";
    public static String STR_SERVER = "-server";
    public static String STR_CLIENT = "-client";
    public static String STR_GNSDOMAIN = "-domain";
    public static String STR_GNS_LAST_CLIENT = "-last";
    public static String STR_GNSVIP_ADDRESS = "-vipaddress";
    public static String STR_GNSVIP = "-vip";
    public static String STR_GNSCLIENTDATA = "-clientdata";
    public static String STR_PORT = "-port";
    public static String STR_GNSPRE = "-precrsinst";
    public static String STR_GNSPOST = "-postcrsinst";
    public static String STR_CFGFILE = "-file";
    public static String STR_RSPFILE = "-responseFile";
    public static String STR_NETWORKS = "-networks";
    public static String STR_SRC_CRSHOME = "-src_crshome";
    public static String STR_DEST_CRSHOME = "-dest_crshome";
    public static String STR_ROLLING = "-rolling";
    public static String STR_DEST_VERSION = "-dest_version";
    public static String STR_SRC_DBHOME = "-src_dbhome";
    public static String STR_DEST_DBHOME = "-dest_dbhome";
    public static String STR_DBNAME = "-dbname";
    public static String STR_ASM_CRED = "-asmcredentials";
    public static String STR_ASM_PRESENCE = "-presence";
    public static final String STR_ASM_PRESENCE_LOCAL = "LOCAL";
    public static final String STR_ASM_PRESENCE_FLEX = "FLEX";
    public static String STR_ROOT_USER = "-user";
    public static String STR_CONFIG_METHOD = "-method";
    public static String STR_SUDO_PBRUN_LOC = "-location";
    public static String STR_AUTO = "-auto";
    public static String STR_HUB = "-hub";
    public static String STR_RIM = "-leaf";
    public static String STR_TARGET_HUB_SIZE = "-targethubsize";
    public static String STR_FLEX = "-flex";
    public static String STR_COMPARE = "-compare";
    public static String STR_ALL_SOFTWARE = "-allfiles";
    public static String STR_SIZE_BYTE = "B";
    public static String STR_SIZE_KILO = "K";
    public static String STR_SIZE_MEGA = "M";
    public static String STR_SIZE_GIGA = "G";
    public static final String STR_USER_EQUIV = "user_equiv";
    public static final String STR_CFS_INST = "cfs_inst";
    public static final String STR_RDBMS_INST = "db_inst";
    public static final String STR_CRS_INST = "crs_inst";
    public static final String STR_DB_CONFIG = "db_config";
    public static final String STR_USM_CONFIG = "acfs_config";
    public static final String STR_PROD_CRS = "crs";
    public static final String STR_PROD_HA = "ha";
    public static final String STR_PROD_DATABASE = "database";
    public static final String REL_10GR1 = "10gR1";
    public static final String REL_10GR2 = "10gR2";
    public static final String REL_11GR1 = "11gR1";
    public static final String REL_11GR2 = "11gR2";
    public static final String REL_101 = "10.1";
    public static final String REL_102 = "10.2";
    public static final String REL_111 = "11.1";
    public static final String REL_112 = "11.2";
    public static final String REL_121 = "12.1";
    public static final String STR_FILE_TYPE_SOFTWARE = "software";
    public static final String STR_FILE_TYPE_DATA = "data";
    public static final String STR_FILE_TYPE_OCR_VDISK = "ocr_vdisk";
    public static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvp");
    public static MessageBundle s_fMsgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static final String USAGE_TEXT = LSEP + s_msgBundle.getMessage("3000", false) + LSEP;
    public static final String DESCRIPTION_TEXT = s_msgBundle.getMessage("3001", false) + LSEP;
    private static final String OPT_COMMON = " [" + STR_VERBOSE + "]";
    public static String CLUVFY_TEXT = "cluvfy ";
    static final String RUN_CLUVFY_TEXT = "runcluvfy";
    private static List<CLCommand> m_commands = null;
    private static boolean m_exitOnError = true;

    public static void testValidate(String release, String command) {
        try {
            m_exitOnError = false;
            System.out.println(release + ":" + command + "=>");
            System.out.println(CLSyntax.validate(release, command.split("\\s+")) + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        String release = "";
        String command = "";
        command = "stage -pre crsinst";
        CLSyntax.testValidate(release, command);
    }

    public static CLCommand validate(String release, String[] commandTokens) {
        Trace.out((int)5, (String)"Method entry. release=%s, commandStr=%s", (Object[])new Object[]{release, VerificationUtil.strArr2String(commandTokens)});
        ArrayList<String> tokens = new ArrayList<String>();
        for (String token : commandTokens) {
            tokens.add(token);
        }
        try {
            CLSyntaxXMLParser parser = new CLSyntaxXMLParser();
            m_commands = parser.getCommands(release);
        }
        catch (XmlParserException e) {
            System.out.println(LSEP + s_fMsgBundle.getMessage("8504", false).trim());
            String errorMsg = e.getMessage();
            System.out.println(errorMsg);
            System.out.println(CLSyntax.getUsageText(commandTokens));
            CLSyntax.exitOnError(1);
            return null;
        }
        InvalidCLException exception = new InvalidCLException(s_msgBundle.getMessage("1001", true));
        boolean valid = false;
        CLCommand matchedCommand = null;
        if (tokens.contains(STR_HELP) || tokens.contains(STR_LIST) || tokens.contains(STR_VERSION)) {
            matchedCommand = CLSyntax.matchCommand(tokens);
            if (tokens.size() == 1 && ((String)tokens.get(0)).equals(STR_HELP)) {
                System.out.println(CLSyntax.getUsageText(commandTokens));
                CLSyntax.exitOnError(0);
                valid = true;
            } else if (tokens.size() == 1 && ((String)tokens.get(0)).equals(STR_VERSION)) {
                System.out.println(CLSyntax.getVersionText());
                CLSyntax.exitOnError(0);
                valid = true;
            } else if (matchedCommand != null) {
                if (tokens.contains(STR_LIST) && tokens.size() != 2) {
                    valid = false;
                    exception = new InvalidCLException(s_msgBundle.getMessage("1001", true));
                } else {
                    System.out.println(CLSyntax.getUsageText(commandTokens));
                    CLSyntax.exitOnError(0);
                    valid = true;
                }
            } else {
                valid = false;
                exception = new InvalidCLException(s_msgBundle.getMessage("1001", true));
            }
        } else {
            try {
                for (CLCommand cLCommand : m_commands) {
                    if (!cLCommand.isValid(tokens)) continue;
                    valid = true;
                    matchedCommand = cLCommand;
                    break;
                }
            }
            catch (InvalidCLException e) {
                exception = e;
            }
        }
        if (!valid) {
            System.out.println(LSEP + s_fMsgBundle.getMessage("8504", false).trim());
            System.out.println(exception.getMessage());
            System.out.println(CLSyntax.getUsageText(commandTokens));
            CLSyntax.exitOnError(1);
        } else {
            HashMap<String, String> clVariables = matchedCommand.getDiscoveredSymbols();
            for (String variableName : clVariables.keySet()) {
                CVUVariables.setValue(variableName, clVariables.get(variableName));
            }
            try {
                valid = matchedCommand.isSemanticsValid(Arrays.asList(commandTokens));
            }
            catch (InvalidCLException invalidCLException) {
                System.out.println(LSEP + s_fMsgBundle.getMessage("8504", false).trim());
                System.out.println(invalidCLException.getMessage());
                System.out.println(CLSyntax.getUsageText(commandTokens));
                CLSyntax.exitOnError(1);
                valid = false;
            }
        }
        if (valid) {
            return matchedCommand;
        }
        return null;
    }

    public static String getVersionText() {
        StringBuffer sb = new StringBuffer();
        sb.append("12.2.0.1.0");
        sb.append(" Build ");
        sb.append("02_11_17_nt".replaceAll("_", ""));
        return sb.toString();
    }

    public static String getUsageText(String[] commandTokens) {
        StringBuffer sb = new StringBuffer(USAGE_TEXT);
        if (commandTokens == null || commandTokens.length == 0 || m_commands == null) {
            sb.append(CLSyntax.getUsageText_generic());
            return sb.toString();
        }
        CLCommand matchedCommand = CLSyntax.matchCommand(Arrays.asList(commandTokens));
        if (matchedCommand != null) {
            sb.append(matchedCommand.getUsageText(commandTokens));
        } else {
            sb.append(CLSyntax.getUsageText_generic());
        }
        return sb.toString();
    }

    public static CLCommand matchCommand(List<String> commandTokens) {
        if (m_commands == null || commandTokens == null || commandTokens.size() == 0) {
            return null;
        }
        CLCommand matchCommand = null;
        for (CLCommand command : m_commands) {
            if (!command.getName().equals(commandTokens.get(0))) continue;
            matchCommand = command;
            break;
        }
        return matchCommand;
    }

    static String getUsageText_generic() {
        StringBuffer sb = new StringBuffer();
        sb.append(CLUVFY_TEXT + "[-help|-version]" + LSEP);
        sb.append(CLSyntax.getUsageText_stage_help());
        sb.append(CLSyntax.getUsageText_stage_usage());
        sb.append(CLSyntax.getUsageText_comp_help());
        sb.append(CLSyntax.getUsageText_comp_usage());
        sb.append(LSEP);
        return sb.toString();
    }

    public static String getUsageText_comp_help() {
        StringBuffer sb = new StringBuffer();
        sb.append(CLUVFY_TEXT + "comp  {-list|-help}" + LSEP);
        return sb.toString();
    }

    public static String getUsageText_comp_usage() {
        StringBuffer sb = new StringBuffer();
        sb.append(CLUVFY_TEXT + "comp  <component-name> ");
        sb.append("<component-specific options> " + OPT_COMMON + LSEP);
        return sb.toString();
    }

    public static String getUsageText_stage_help() {
        StringBuffer sb = new StringBuffer();
        sb.append(CLUVFY_TEXT + "stage {-list|-help}" + LSEP);
        return sb.toString();
    }

    public static String getUsageText_stage_usage() {
        StringBuffer sb = new StringBuffer();
        sb.append(CLUVFY_TEXT + "stage {-pre|-post} <stage-name> ");
        sb.append("<stage-specific options> " + OPT_COMMON + LSEP);
        return sb.toString();
    }

    public static void setRunCluvfyTxt() {
        Trace.out((String)"Method Entry.");
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        CLUVFY_TEXT = nativeSys.isUnixSystem() ? "runcluvfy.sh " : nativeSys.getScriptFileName(RUN_CLUVFY_TEXT) + " ";
    }

    public static boolean isExitOnError() {
        return m_exitOnError;
    }

    public static void setExitOnError(boolean exitOnError) {
        m_exitOnError = exitOnError;
    }

    private static void exitOnError(int exitStatus) {
        if (m_exitOnError) {
            Trace.close();
            System.exit(exitStatus);
        }
    }
}

