/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import oracle.cluster.cmdtools.OIFCFGResult;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.common.CVUException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.GlobalVerificationContext;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.network.CommandHandler;
import oracle.ops.verification.framework.network.CommandHandlerFactory;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class NetworkDataDiscovery
implements NetworkConstants,
VerificationConstants {
    private static NetworkDataDiscovery s_instance = null;
    public static HashMap<String, Set<NetworkInfo>> m_nodeNetworksMap = null;
    public static Set<NetworkInfo> m_localNodeClusterNetworks = null;
    public static HashMap<String, Set<NetworkInfo>> m_subnetNetworksMap = null;
    private static HashMap<String, Set<ErrorDescription>> m_failedNodesErrorMap = new HashMap();
    private static CommandHandler s_commandHandler = CommandHandlerFactory.createCommandHandler();
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");

    private NetworkDataDiscovery(String[] nodeList, ResultSet resultSet) throws NodelistNotFoundException {
        m_nodeNetworksMap = NetworkDataDiscovery.discoverAllNetworks(nodeList, resultSet);
        if (NetworkUtility.isNetworksMapGood(m_nodeNetworksMap) && !resultSet.anyFailure()) {
            m_subnetNetworksMap = NetworkDataDiscovery.getSubnetNetworksMap(m_nodeNetworksMap, resultSet);
        }
    }

    public static synchronized NetworkDataDiscovery getInstance(String[] nodeList, ResultSet resultSet) throws NodelistNotFoundException {
        if (null == s_instance) {
            s_instance = new NetworkDataDiscovery(nodeList, resultSet);
        }
        return s_instance;
    }

    public static synchronized void clearCache() {
        s_instance = null;
        m_nodeNetworksMap = null;
        m_subnetNetworksMap = null;
        m_failedNodesErrorMap = new HashMap();
        m_localNodeClusterNetworks = null;
        NetworkUtility.clearCache();
    }

    public static HashMap<String, Set<NetworkInfo>> getNodeNetworksMap(ResultSet resultSet) throws NodelistNotFoundException {
        return NetworkDataDiscovery.getNodeNetworksMap(VerificationUtil.getNodelist(), resultSet);
    }

    public static HashMap<String, Set<NetworkInfo>> discoverAllNetworks(String[] nodeList, ResultSet resultSet) {
        return NetworkDataDiscovery.discoverAllNetworks(nodeList, resultSet, false);
    }

    public static HashMap<String, Set<NetworkInfo>> discoverAllNetworks(String[] nodeList, ResultSet resultSet, boolean includeLoopback) {
        if (GlobalVerificationContext.getInstance().isNodeAdd()) {
            String localNode = VerificationUtil.getLocalNode();
            Trace.out((String)"Node add operation. Adding local node to the nodelist");
            if (s_instance == null) {
                nodeList = VerificationUtil.addLocalNodeToNodeList(nodeList);
            } else if (!m_nodeNetworksMap.keySet().isEmpty() && !m_nodeNetworksMap.keySet().contains(localNode)) {
                nodeList = VerificationUtil.addLocalNodeToNodeList(nodeList);
            }
        }
        int nodeCount = nodeList.length;
        VerificationCommand[] cmdArray = new VerificationCommand[nodeCount];
        HashMap<String, Set<NetworkInfo>> nodeNetworksMapToBeReturned = new HashMap<String, Set<NetworkInfo>>();
        Trace.out((String)("Discover the networks for given nodelist " + VerificationUtil.strArr2List(nodeList)));
        for (int j = 0; j < nodeCount; ++j) {
            cmdArray[j] = s_commandHandler.generateGetIfInfoCommand(nodeList[j]);
        }
        ResultSet getIfInfoResultSet = new ResultSet();
        new GlobalHandler().submit((Command[])cmdArray, 0, getIfInfoResultSet);
        if (!getIfInfoResultSet.anySuccess()) {
            Trace.out((String)"GlobalHandler failed");
            String errorMessage = s_msgBundle.getMessage("4080", true);
            ResultSet.updateResultSetWithErrorDescription(errorMessage, resultSet, nodeList, false, true);
            resultSet.addResultSetData(getIfInfoResultSet);
            return nodeNetworksMapToBeReturned;
        }
        for (int nodeIndex = 0; nodeIndex < nodeCount; ++nodeIndex) {
            Object errorDescription;
            String errorMessage;
            VerificationCommand verificationCommand = cmdArray[nodeIndex];
            Result result = verificationCommand.getResult();
            Trace.out((String)"Trying to parse getifInfo");
            HashSet<NetworkInfo> networks = new HashSet();
            String node = nodeList[nodeIndex];
            if (result.getStatus() == 1) {
                Object errorDescriptionsOnNode;
                ResultSet parsingResultSet = new ResultSet();
                Trace.out((String)"Result is Successfull..Trying to parse getifInfo");
                networks = s_commandHandler.parseGetIfInfoCommandOutput(verificationCommand, parsingResultSet, includeLoopback);
                if (!NetworkUtility.isNetworksSetGood(networks) && !parsingResultSet.anyFailure()) {
                    errorDescriptionsOnNode = new HashSet();
                    Trace.out((String)("This should not happen.  Parsing is successful but networks are empty on the node " + node));
                    errorMessage = s_msgBundle.getMessage("6003", true, (Object[])new String[]{node});
                    Trace.out((String)errorMessage);
                    errorDescription = new ErrorDescription(errorMessage);
                    resultSet.addResult(node, 3);
                    resultSet.addErrorDescription((ErrorDescription)errorDescription);
                    errorDescriptionsOnNode.add(errorDescription);
                    m_failedNodesErrorMap.put(node, (Set<ErrorDescription>)errorDescriptionsOnNode);
                    continue;
                }
                if (parsingResultSet.anyFailure()) {
                    errorDescriptionsOnNode = new HashSet();
                    Trace.out((String)("Parsing failed for network information from getifinfo output for the node " + node));
                    for (VerificationError error : parsingResultSet.getErrors()) {
                        String errorMsg = error.getErrorMessage();
                        Trace.out((String)("Error message " + errorMsg));
                        ErrorDescription errorDescription2 = new ErrorDescription(errorMsg);
                        errorDescriptionsOnNode.add(errorDescription2);
                    }
                    resultSet.addResultSetData(parsingResultSet);
                    m_failedNodesErrorMap.put(node, (Set<ErrorDescription>)errorDescriptionsOnNode);
                    continue;
                }
                nodeNetworksMapToBeReturned.put(verificationCommand.getNode(), networks);
                for (NetworkInfo network : nodeNetworksMapToBeReturned.get(verificationCommand.getNode())) {
                    Trace.out((String)("Network Details" + network.toString()));
                }
                continue;
            }
            HashSet<ErrorDescription> errorDescriptionsOnNode = new HashSet<ErrorDescription>();
            String errorString = verificationCommand.getExceptionError();
            if (errorString != null && errorString.length() > 0) {
                errorMessage = s_msgBundle.getMessage("6003", true, (Object[])new String[]{node}) + s_msgBundle.getMessage("8504", false) + errorString;
                Trace.out((String)errorMessage);
            } else {
                errorMessage = s_msgBundle.getMessage("6003", true, (Object[])new String[]{node});
                Trace.out((String)errorMessage);
            }
            errorDescription = new ErrorDescription(errorMessage);
            ReportUtil.printError(errorMessage);
            errorDescriptionsOnNode.add((ErrorDescription)errorDescription);
            for (ErrorDescription errorDescriptionToBeAdded : errorDescriptionsOnNode) {
                resultSet.addErrorDescription(node, errorDescriptionToBeAdded);
            }
            resultSet.addResult(node, 3);
            m_failedNodesErrorMap.put(node, errorDescriptionsOnNode);
        }
        if (NetworkUtility.isNetworksMapGood(m_nodeNetworksMap)) {
            m_nodeNetworksMap.putAll(nodeNetworksMapToBeReturned);
        } else {
            m_nodeNetworksMap = nodeNetworksMapToBeReturned;
        }
        return nodeNetworksMapToBeReturned;
    }

    public static HashMap<String, Set<NetworkInfo>> getNodeNetworksMap(String[] nodeList, ResultSet resultSet) {
        HashMap<String, Set<NetworkInfo>> nodeNetworksMap = new HashMap<String, Set<NetworkInfo>>();
        if (null != s_instance && NetworkUtility.isNetworksMapGood(m_nodeNetworksMap)) {
            Set<String> nodesAlreadyDiscovered = m_nodeNetworksMap.keySet();
            Trace.out((String)("Networks discovery was already done for nodes: " + VerificationUtil.strCollection2String(nodesAlreadyDiscovered)));
            HashSet<String> newNodesToBeDiscovered = new HashSet<String>();
            for (String node : nodeList) {
                if (!nodesAlreadyDiscovered.contains(node)) {
                    newNodesToBeDiscovered.add(node);
                    continue;
                }
                nodeNetworksMap.put(node, m_nodeNetworksMap.get(node));
            }
            if (!newNodesToBeDiscovered.isEmpty()) {
                String[] newNodes = newNodesToBeDiscovered.toArray(new String[0]);
                Trace.out((String)("Networks discovery is being done for new nodes: " + VerificationUtil.strArr2List(newNodes)));
                HashMap<String, Set<NetworkInfo>> newNodesNetworksMap = new HashMap();
                newNodesNetworksMap = NetworkDataDiscovery.discoverAllNetworks(newNodes, resultSet);
                if (!NetworkUtility.isNetworksMapGood(newNodesNetworksMap)) {
                    String errorMessage = s_msgBundle.getMessage("6011", true, (Object[])new String[]{VerificationUtil.strArr2List(newNodes)});
                    ResultSet.updateResultSetWithErrorDescription(errorMessage, resultSet, newNodes, false, false);
                } else {
                    nodeNetworksMap.putAll(newNodesNetworksMap);
                }
            }
            return nodeNetworksMap;
        }
        Trace.out((String)("discovering networks on all the nodes " + VerificationUtil.strArr2List(nodeList)));
        if (s_instance == null) {
            try {
                NetworkDataDiscovery.getInstance(nodeList, resultSet);
                nodeNetworksMap = m_nodeNetworksMap;
            }
            catch (NodelistNotFoundException nfe) {
                Trace.out((String)("NodelistNotFoundException occured while trying to get interfaces info on " + VerificationUtil.strArr2List(nodeList)));
                ResultSet.updateResultSetWithErrorDescription(nfe.getMessage(), resultSet, nodeList, true, false);
                return null;
            }
        } else if (!NetworkUtility.isNetworksMapGood(m_nodeNetworksMap)) {
            nodeNetworksMap = NetworkDataDiscovery.discoverAllNetworks(nodeList, resultSet);
        }
        if (!NetworkUtility.isNetworksMapGood(nodeNetworksMap)) {
            Trace.out((String)"Networks discovered are empty");
            String errorMessage = s_gMsgBundle.getMessage("11090", true, (Object[])new String[]{VerificationUtil.strArr2List(nodeList)});
            ResultSet.updateResultSetWithErrorDescription(errorMessage, resultSet, nodeList, false, false);
            return null;
        }
        return nodeNetworksMap;
    }

    public static Set<NetworkInfo> getNetworksOnNode(String node, boolean upOnly, ResultSet resultSet) {
        HashMap<String, Set<NetworkInfo>> nodeNetworksMap = new HashMap();
        nodeNetworksMap = NetworkDataDiscovery.getNodeNetworksMap(new String[]{node}, resultSet);
        if (!NetworkUtility.isNetworksMapGood(nodeNetworksMap) || !nodeNetworksMap.containsKey(node)) {
            return null;
        }
        Set<NetworkInfo> networksMatchingStatus = NetworkDataDiscovery.getNetworksOnNodes(nodeNetworksMap, new String[]{node}, upOnly).get(node);
        if (upOnly && !NetworkUtility.isNetworksSetGood(networksMatchingStatus)) {
            VerificationUtil.traceAndLogError("Could not find any network with status UP");
            String errorMessage = s_gMsgBundle.getMessage("11086", true, (Object[])new String[]{node});
            ResultSet.updateResultSetWithErrorDescription(errorMessage, resultSet, new String[]{node}, true, true);
        }
        return networksMatchingStatus;
    }

    public static Set<NetworkInfo> getNetworksOnNode(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, String node) {
        return NetworkDataDiscovery.getNetworksOnNodes(nodeNetworksMap, new String[]{node}, false).get(node);
    }

    public static Set<NetworkInfo> getNetworksOnNode(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, String node, boolean upOnly) {
        return NetworkDataDiscovery.getNetworksOnNodes(nodeNetworksMap, new String[]{node}, upOnly).get(node);
    }

    public static HashMap<String, Set<NetworkInfo>> getNetworksOnNodes(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, String[] nodeList) {
        return NetworkDataDiscovery.getNetworksOnNodes(nodeNetworksMap, nodeList, true);
    }

    public static HashMap<String, Set<NetworkInfo>> getNetworksOnNodes(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, String[] nodeList, boolean upOnly) {
        HashMap<String, Set<NetworkInfo>> nodeNetworksMapToBeReturned = new HashMap<String, Set<NetworkInfo>>();
        if (NetworkUtility.isNetworksMapGood(nodeNetworksMap)) {
            for (String node : nodeList) {
                Set<NetworkInfo> networks;
                if (!nodeNetworksMap.containsKey(node) || !NetworkUtility.isNetworksSetGood(networks = nodeNetworksMap.get(node))) continue;
                if (upOnly) {
                    if (!NetworkUtility.isNetworksSetGood(networks = NetworkDataDiscovery.getNetworksWithStatusUp(networks))) continue;
                    nodeNetworksMapToBeReturned.put(node, networks);
                    continue;
                }
                nodeNetworksMapToBeReturned.put(node, networks);
            }
        }
        return nodeNetworksMapToBeReturned;
    }

    public static Set<NetworkInfo> getNetworksWithStatusUp(Set<NetworkInfo> networks) {
        HashSet<NetworkInfo> upNetworks = new HashSet<NetworkInfo>();
        for (NetworkInfo network : networks) {
            if (network.getStatus() != 22) continue;
            upNetworks.add(network);
        }
        return upNetworks;
    }

    public static HashMap<String, Set<NetworkInfo>> getNodeNetworksMap(Set<NetworkInfo> networks) {
        HashMap<String, Set<NetworkInfo>> matchingNetworksMap = new HashMap<String, Set<NetworkInfo>>();
        HashSet<String> nodes = new HashSet<String>();
        for (NetworkInfo network : networks) {
            nodes.add(network.getNodeName());
        }
        for (String node : nodes) {
            HashSet<NetworkInfo> networksOnThisNode = new HashSet<NetworkInfo>();
            for (NetworkInfo network : networks) {
                if (!node.equalsIgnoreCase(network.getNodeName())) continue;
                networksOnThisNode.add(network);
            }
            matchingNetworksMap.put(node, networksOnThisNode);
        }
        return matchingNetworksMap;
    }

    public static HashMap<String, Set<NetworkInfo>> getNetworksBySubnet(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, String subnet) {
        HashMap<String, Set<NetworkInfo>> matchingNetworksMap = new HashMap<String, Set<NetworkInfo>>();
        for (String node : nodeNetworksMap.keySet()) {
            matchingNetworksMap.put(node, NetworkDataDiscovery.getNetworksBySubnet(nodeNetworksMap, subnet, node));
        }
        return matchingNetworksMap;
    }

    public static Set<NetworkInfo> getNetworksBySubnet(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, String subnet, String node) {
        HashSet<NetworkInfo> matchingNetworks = new HashSet<NetworkInfo>();
        Set<NetworkInfo> networks = nodeNetworksMap.get(node);
        for (NetworkInfo networkInfo : networks) {
            if (!NetworkUtility.checkSameIPAddresses(subnet, networkInfo.getSubnetAsString())) continue;
            matchingNetworks.add(networkInfo);
        }
        return matchingNetworks;
    }

    public static HashMap<String, Set<NetworkInfo>> getNetworksBySubnet(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, String subnet, String[] nodeList) {
        HashMap<String, Set<NetworkInfo>> matchingNetworksMap = new HashMap<String, Set<NetworkInfo>>();
        for (String node : nodeList) {
            matchingNetworksMap.put(node, NetworkDataDiscovery.getNetworksBySubnet(nodeNetworksMap, subnet, node));
        }
        return matchingNetworksMap;
    }

    public static HashMap<String, Set<NetworkInfo>> getSubnetNetworksMap(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, ResultSet resultSet) {
        HashMap<String, Set<NetworkInfo>> matchingNetworksMap = new HashMap<String, Set<NetworkInfo>>();
        if (!NetworkUtility.isNetworksMapGood(nodeNetworksMap)) {
            return matchingNetworksMap;
        }
        HashSet<String> subnets = new HashSet<String>();
        for (String node : nodeNetworksMap.keySet()) {
            for (NetworkInfo network : nodeNetworksMap.get(node)) {
                subnets.add(network.getSubnetAsString());
            }
        }
        for (String subnet : subnets) {
            HashSet<NetworkInfo> matchingNetworks = new HashSet<NetworkInfo>();
            for (String node : nodeNetworksMap.keySet()) {
                matchingNetworks.addAll(NetworkDataDiscovery.getNetworksBySubnet(nodeNetworksMap, subnet, node));
            }
            matchingNetworksMap.put(subnet, matchingNetworks);
        }
        if (!NetworkUtility.isNetworksMapGood(matchingNetworksMap)) {
            String errorMessage = s_msgBundle.getMessage("6005", true);
            ResultSet.updateResultSetWithErrorDescription(errorMessage, resultSet, nodeNetworksMap.keySet().toArray(new String[0]), false, false);
        }
        return matchingNetworksMap;
    }

    public static HashMap<String, Set<NetworkInfo>> getSubnetNetworksMap(Set<NetworkInfo> networks) {
        HashMap<String, Set<NetworkInfo>> matchingNetworksMap = new HashMap<String, Set<NetworkInfo>>();
        for (NetworkInfo network : networks) {
            String subnet = network.getSubnetAsString();
            Set<NetworkInfo> matchingNetworks = new HashSet<NetworkInfo>();
            if (matchingNetworksMap.containsKey(subnet)) {
                matchingNetworks = matchingNetworksMap.get(subnet);
            }
            matchingNetworks.add(network);
            matchingNetworksMap.put(subnet, matchingNetworks);
        }
        return matchingNetworksMap;
    }

    public static HashMap<String, Set<NetworkInfo>> getMatchingNodeNetworksMapOnNodes(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, Set<NetworkInfo> networks, String[] nodeList) {
        HashMap<String, Set<NetworkInfo>> nodeNetworksMapToBeReturned = new HashMap<String, Set<NetworkInfo>>();
        List<String> networkNames = NetworkDataDiscovery.getClusterNetworkNames(networks);
        List<String> subnets = NetworkDataDiscovery.getClusterNetworkSubnets(networks);
        List<Integer> networkTypes = NetworkDataDiscovery.getClusterNetworkTypes(networks);
        for (int i = 0; i < networkNames.size(); ++i) {
            String subnet = subnets.get(i);
            HashMap<String, Set<NetworkInfo>> tempNetworksMapToBeReturned = new HashMap();
            Trace.out((String)("Finding matching networks for network name " + networkNames.get(i)));
            if (VerificationUtil.isStringGood(subnet)) {
                Trace.out((String)("Finding matching networks for subnet " + subnets.get(i)));
                tempNetworksMapToBeReturned = NetworkDataDiscovery.getNetworksBySubnetAndName(nodeNetworksMap, nodeList, subnets.get(i), networkNames.get(i));
            } else {
                tempNetworksMapToBeReturned = NetworkDataDiscovery.getNetworksBySubnetAndName(nodeNetworksMap, nodeList, null, networkNames.get(i));
            }
            if (NetworkUtility.isNetworksMapGood(tempNetworksMapToBeReturned)) {
                Trace.out((String)"Found matching networks.");
                tempNetworksMapToBeReturned = NetworkDataDiscovery.updateNetworkType(tempNetworksMapToBeReturned, (int)networkTypes.get(i));
            }
            for (String node : tempNetworksMapToBeReturned.keySet()) {
                if (nodeNetworksMapToBeReturned.containsKey(node)) {
                    Set<NetworkInfo> updatedValues = nodeNetworksMapToBeReturned.get(node);
                    updatedValues.addAll((Collection<NetworkInfo>)tempNetworksMapToBeReturned.get(node));
                    nodeNetworksMapToBeReturned.put(node, updatedValues);
                    continue;
                }
                nodeNetworksMapToBeReturned.put(node, tempNetworksMapToBeReturned.get(node));
            }
        }
        return nodeNetworksMapToBeReturned;
    }

    public static Set<NetworkInfo> getMatchingNetworksOnNode(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, Set<NetworkInfo> networks, String node, ResultSet resultSet) {
        HashSet<NetworkInfo> nodeNetworksToBeReturned = new HashSet<NetworkInfo>();
        if (!NetworkUtility.isNetworksMapGood(nodeNetworksMap)) {
            nodeNetworksMap = NetworkDataDiscovery.getNodeNetworksMap(new String[]{node}, resultSet);
        }
        if (!NetworkUtility.isNetworksMapGood(nodeNetworksMap)) {
            Trace.out((String)("Node-Networks is empty for this node " + node));
            return nodeNetworksToBeReturned;
        }
        List<String> networkNames = NetworkDataDiscovery.getClusterNetworkNames(networks);
        List<String> subnets = NetworkDataDiscovery.getClusterNetworkSubnets(networks);
        List<Integer> networkTypes = NetworkDataDiscovery.getClusterNetworkTypes(networks);
        for (int i = 0; i < networkNames.size(); ++i) {
            Set<NetworkInfo> matchingNetworksForInterface = new HashSet<NetworkInfo>();
            String subnet = subnets.get(i);
            if (VerificationUtil.isStringGood(subnet)) {
                matchingNetworksForInterface.addAll(NetworkDataDiscovery.getNetworksBySubnetAndName(nodeNetworksMap, node, subnets.get(i), networkNames.get(i)));
            } else {
                matchingNetworksForInterface.addAll(NetworkDataDiscovery.getNetworksBySubnetAndName(nodeNetworksMap, node, null, networkNames.get(i)));
            }
            if (NetworkUtility.isNetworksSetGood(matchingNetworksForInterface)) {
                VerificationUtil.traceAndLog("Found matching networks for the interface " + networkNames.get(i));
                VerificationUtil.traceAndLog("Updating the network type to " + networkTypes.get(i));
                matchingNetworksForInterface = NetworkDataDiscovery.updateNetworkType(matchingNetworksForInterface, (int)networkTypes.get(i));
                nodeNetworksToBeReturned.addAll(matchingNetworksForInterface);
                continue;
            }
            Trace.out((String)("No matching networks for the interface " + networkNames.get(i)));
        }
        return nodeNetworksToBeReturned;
    }

    public static HashMap<String, Set<NetworkInfo>> updateNetworkType(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, int networkType) {
        HashMap<String, Set<NetworkInfo>> updatedNodeNetworksMap = new HashMap<String, Set<NetworkInfo>>();
        for (String node : nodeNetworksMap.keySet()) {
            HashSet<NetworkInfo> networks = new HashSet<NetworkInfo>();
            for (NetworkInfo network : nodeNetworksMap.get(node)) {
                network.setNetworkType(networkType);
                networks.add(network);
            }
            updatedNodeNetworksMap.put(node, networks);
        }
        return updatedNodeNetworksMap;
    }

    public static Set<NetworkInfo> updateNetworkType(Set<NetworkInfo> nodeNetworks, int networkType) {
        HashSet<NetworkInfo> updatedNodeNetworks = new HashSet<NetworkInfo>();
        for (NetworkInfo network : nodeNetworks) {
            network.setNetworkType(networkType);
            updatedNodeNetworks.add(network);
        }
        return updatedNodeNetworks;
    }

    public static Set<NetworkInfo> getNetworksBySubnetAndName(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, String node, String subnet, String networkName) {
        HashSet<NetworkInfo> matchingNetworks = new HashSet<NetworkInfo>();
        if (!NetworkUtility.isNetworksMapGood(nodeNetworksMap)) {
            Trace.out((String)"Node-networks map is empty");
            return matchingNetworks;
        }
        Set<NetworkInfo> networks = nodeNetworksMap.get(node);
        if (!NetworkUtility.isNetworksSetGood(networks)) {
            Trace.out((String)("There are no matching networks for the node " + node));
            return matchingNetworks;
        }
        if (!VerificationUtil.isStringGood(networkName) && !VerificationUtil.isStringGood(subnet)) {
            return matchingNetworks;
        }
        if (!VerificationUtil.isStringGood(networkName) && VerificationUtil.isStringGood(subnet)) {
            networkName = "*";
        }
        String regexp = networkName.replaceAll("\\*", "(.*)");
        Pattern p = Pattern.compile(regexp);
        for (NetworkInfo network : networks) {
            String ifName = network.getInterfaceName();
            if (p.matcher(ifName).matches()) {
                networkName = ifName;
            }
            if (!network.getInterfaceName().equalsIgnoreCase(networkName)) continue;
            if (VerificationUtil.isStringGood(subnet)) {
                if (!NetworkUtility.checkSameIPAddresses(subnet, network.getSubnetAsString())) continue;
                matchingNetworks.add(network);
                continue;
            }
            matchingNetworks.add(network);
        }
        return matchingNetworks;
    }

    public static HashMap<String, Set<NetworkInfo>> getNetworksBySubnetAndName(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, String[] nodeList, String subnet, String networkName) {
        HashMap<String, Set<NetworkInfo>> nodeNetworksMapToBeReturned = new HashMap<String, Set<NetworkInfo>>();
        if (!NetworkUtility.isNetworksMapGood(nodeNetworksMap)) {
            return nodeNetworksMapToBeReturned;
        }
        for (String node : nodeList) {
            HashSet<NetworkInfo> networks = new HashSet<NetworkInfo>();
            Set<NetworkInfo> matchingNetworks = NetworkDataDiscovery.getNetworksBySubnetAndName(nodeNetworksMap, node, subnet, networkName);
            if (!NetworkUtility.isNetworksSetGood(matchingNetworks)) continue;
            networks.addAll(matchingNetworks);
            nodeNetworksMapToBeReturned.put(node, networks);
        }
        return nodeNetworksMapToBeReturned;
    }

    public static Set<NetworkInfo> getNetworksByType(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, String netType, String node) {
        return NetworkDataDiscovery.getNetworksByType(nodeNetworksMap, NetworkUtility.getNetworkTypeFromString(netType), node);
    }

    public static Set<NetworkInfo> getNetworksByType(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, NetworkConstants.NetworkType netType, String node) {
        HashSet<NetworkInfo> matchingNetworks = new HashSet<NetworkInfo>();
        Set<NetworkInfo> networks = nodeNetworksMap.get(node);
        for (NetworkInfo networkInfo : networks) {
            if (!NetworkUtility.isSameType(netType.getValue(), networkInfo.getNetworkType())) continue;
            matchingNetworks.add(networkInfo);
        }
        return matchingNetworks;
    }

    public static HashMap<String, Set<NetworkInfo>> getNetworksByType(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, String netType) {
        return NetworkDataDiscovery.getNetworksByType(nodeNetworksMap, NetworkUtility.getNetworkTypeFromString(netType));
    }

    public static HashMap<String, Set<NetworkInfo>> getNetworksByType(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, NetworkConstants.NetworkType netType) {
        HashMap<String, Set<NetworkInfo>> nodeNetworksMapToBeReturned = new HashMap<String, Set<NetworkInfo>>();
        for (String node : nodeNetworksMap.keySet()) {
            HashSet<NetworkInfo> NetworkInfo2 = new HashSet<NetworkInfo>();
            NetworkInfo2.addAll(NetworkDataDiscovery.getNetworksByType(nodeNetworksMap, netType, node));
            nodeNetworksMapToBeReturned.put(node, NetworkInfo2);
        }
        return nodeNetworksMapToBeReturned;
    }

    public static HashMap<String, Set<NetworkInfo>> getNetworksByType(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, String netType, String[] nodeList) {
        return NetworkDataDiscovery.getNetworksByType(nodeNetworksMap, NetworkUtility.getNetworkTypeFromString(netType), nodeList);
    }

    public static HashMap<String, Set<NetworkInfo>> getNetworksByType(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, NetworkConstants.NetworkType netType, String[] nodeList) {
        HashMap<String, Set<NetworkInfo>> nodeNetworksMapToBeReturned = new HashMap<String, Set<NetworkInfo>>();
        for (String node : nodeList) {
            HashSet<NetworkInfo> NetworkInfo2 = new HashSet<NetworkInfo>();
            NetworkInfo2.addAll(NetworkDataDiscovery.getNetworksByType(nodeNetworksMap, netType, node));
            nodeNetworksMapToBeReturned.put(node, NetworkInfo2);
        }
        return nodeNetworksMapToBeReturned;
    }

    public static Set<NetworkInfo> getNetworksByTypeAndName(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, NetworkConstants.NetworkType netType, String networkName, String node) {
        HashSet<NetworkInfo> matchingNetworks = new HashSet<NetworkInfo>();
        Set<NetworkInfo> networks = nodeNetworksMap.get(node);
        for (NetworkInfo network : networks) {
            if (!network.getInterfaceName().equals(networkName) || !NetworkUtility.isSameType(netType.getValue(), network.getNetworkType())) continue;
            matchingNetworks.add(network);
        }
        return matchingNetworks;
    }

    public static HashMap<String, Set<NetworkInfo>> getNetworksByTypeAndName(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, NetworkConstants.NetworkType netType, String networkName, String[] nodeList) {
        HashMap<String, Set<NetworkInfo>> nodeNetworksMapToBeReturned = new HashMap<String, Set<NetworkInfo>>();
        for (String node : nodeList) {
            HashSet<NetworkInfo> NetworkInfo2 = new HashSet<NetworkInfo>();
            NetworkInfo2.addAll(NetworkDataDiscovery.getNetworksByTypeAndName(nodeNetworksMap, netType, networkName, node));
            nodeNetworksMapToBeReturned.put(node, NetworkInfo2);
        }
        return nodeNetworksMapToBeReturned;
    }

    public static HashMap<String, Set<NetworkInfo>> removeLogicalInterfaceSyntax(HashMap<String, Set<NetworkInfo>> networksMap) {
        HashMap<String, Set<NetworkInfo>> modifiedNetworksMap = new HashMap<String, Set<NetworkInfo>>();
        for (String key : networksMap.keySet()) {
            modifiedNetworksMap.put(key, NetworkDataDiscovery.removeLogicalInterfaceSyntax(networksMap.get(key)));
        }
        return modifiedNetworksMap;
    }

    public static Set<NetworkInfo> removeLogicalInterfaceSyntax(Set<NetworkInfo> networks) {
        HashSet<NetworkInfo> modifiedNetworks = new HashSet<NetworkInfo>();
        for (NetworkInfo network : networks) {
            int index = network.getInterfaceName().indexOf(58);
            if (-1 != index) {
                network.setInterfaceName(network.getInterfaceName().substring(0, index));
            }
            modifiedNetworks.add(network);
        }
        return modifiedNetworks;
    }

    public static Set<NetworkInfo> getClusterNetworksPreCrsInstall(String node, ResultSet resultSet) throws NetworkException, NodelistNotFoundException {
        HashSet<NetworkInfo> networks = new HashSet();
        try {
            networks = NetworkDataDiscovery.getClusterNetworksFromCVUVariable(resultSet);
        }
        catch (CVUException cvuEx) {
            String errorMessage = cvuEx.getMessage();
            Trace.out((String)"Exception occured while getting network information");
            ResultSet.updateResultSetWithErrorDescription(errorMessage, resultSet, new String[]{node}, true, false);
            throw new NetworkException(errorMessage);
        }
        if (!NetworkUtility.isNetworksSetGood(networks)) {
            VerificationUtil.traceAndLogError("Failed to retrieve the list of network networks and subnets");
        }
        return networks;
    }

    public static Set<NetworkInfo> getClusterNetworks(ResultSet resultSet) throws NodelistNotFoundException, CVUException, NetworkException {
        if (m_localNodeClusterNetworks == null) {
            m_localNodeClusterNetworks = NetworkDataDiscovery.getClusterNetworks(VerificationUtil.getLocalNode(), resultSet);
        }
        return m_localNodeClusterNetworks;
    }

    public static Set<NetworkInfo> getClusterNetworks(String node, ResultSet resultSet) {
        HashSet<NetworkInfo> clusterNetworks = new HashSet();
        if (VerificationUtil.isCLIMode() && CVUVariables.getValue(CVUVariableConstants.NETWORK_LIST) != null) {
            String argInterfaceList = CVUVariables.getValue(CVUVariableConstants.NETWORK_LIST);
            return NetworkDataDiscovery.getClusterNetworksFromPMArgument(argInterfaceList, node, resultSet);
        }
        try {
            clusterNetworks = NetworkDataDiscovery.getClusterNetworksFromCVUVariable(resultSet);
            if (NetworkUtility.isNetworksSetGood(clusterNetworks)) {
                return clusterNetworks;
            }
        }
        catch (CVUException cvuEx) {
            Trace.out((String)("Exception occured while getting network information" + cvuEx.getMessage()));
        }
        String crsHome = VerificationUtil.getCRSHome();
        boolean isCRSRunning = false;
        if (VerificationUtil.isStringGood(crsHome)) {
            try {
                ClusterwareInfo clustInfo = new ClusterwareInfo();
                isCRSRunning = clustInfo.isCRSRunning(crsHome);
            }
            catch (InstallException e) {
                Trace.out((String)("Install exception occurred while check CRS running state " + e.getMessage()));
            }
        }
        Trace.out((String)("CRS stack running state was :" + isCRSRunning));
        if (VerificationUtil.isCRSConfigured() && isCRSRunning && !VerificationUtil.isOPC()) {
            try {
                clusterNetworks = NetworkDataDiscovery.getClusterNetworksFromOifcfg(resultSet);
            }
            catch (CVUException cvuEx) {
                String errorMessage = cvuEx.getMessage();
                Trace.out((String)"Exception occured while getting network information");
                ResultSet.updateResultSetWithErrorDescription(errorMessage, resultSet, new String[]{node}, true, true);
                return null;
            }
            return clusterNetworks;
        }
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            VerificationUtil.traceAndLogError("Failed to retrieve the list of networks and subnets");
        }
        return clusterNetworks;
    }

    public static Set<NetworkInfo> getClusterNetworksFromOifcfg(ResultSet resultSet) throws CVUException {
        Trace.out((String)"trying to get CRS Home..");
        Set<NetworkInfo> clusterNetworks = new HashSet<NetworkInfo>();
        if (VerificationUtil.isOPC()) {
            return clusterNetworks;
        }
        String crsHome = VerificationUtil.getCRSHome();
        if (crsHome == null) {
            Trace.out((String)"CRSHOME is null");
            throw new CVUException(s_msgBundle, "5301", new Object[0]);
        }
        String oifcfgLoc = crsHome + FSEP + "bin";
        Trace.out((String)("OIFCFG loc:" + oifcfgLoc));
        Version crsVer = VerificationUtil.getCRSActiveVersionObj();
        Trace.out((String)("Acrive CRS version is " + crsVer));
        List<OIFCFGResult> oifcfgList = null;
        try {
            oifcfgList = new ClusterwareInfo().listClusterInterfaces(oifcfgLoc, crsVer);
            if (oifcfgList != null && !oifcfgList.isEmpty()) {
                oifcfgList = NetworkDataDiscovery.updateNetMaskFromOifcfg(oifcfgList, oifcfgLoc, crsVer);
            }
        }
        catch (InstallException ie) {
            Trace.out((String)("INSTALLEXCEPTION: occured while getting cluster network info. message" + ie.getMessage()));
            throw new CVUException(ie);
        }
        catch (IPAddressException ioException) {
            Trace.out((String)("IPAddressException: occured while getting cluster network info. message" + ioException.getMessage()));
            throw new CVUException(ioException);
        }
        if (oifcfgList.size() == 0) {
            Trace.out((String)"OIFCFG list is EMPTY");
            throw new CVUException(s_msgBundle, "7615", oifcfgLoc, crsHome);
        }
        if (oifcfgList.size() > 0) {
            Trace.out((String)"Network details from OIFCFG: ");
        }
        for (OIFCFGResult oifcfgRes : oifcfgList) {
            NetworkInfo network = new NetworkInfo();
            network.setInterfaceName(oifcfgRes.getInterfaceName());
            network.setSubnet(oifcfgRes.getSubnet());
            network.setNetworkType(oifcfgRes.getInterfaceType());
            String scope = oifcfgRes.getNodeScope();
            scope = scope == null ? "" : scope.trim();
            network.setIfNameGlobalLogicalInterface(scope.equalsIgnoreCase("global"));
            network.setInterfaceScope(scope);
            Trace.out((String)("ifName=" + network.getInterfaceName() + ",subnet=" + network.getSubnetAsString() + ",netType=" + network.getNetworkType() + ",isIfNameGlobals=" + network.isIfNameGlobalLogicalInterface() + ", Scope=" + network.getInterfaceScope()));
            clusterNetworks.add(network);
        }
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            VerificationUtil.traceAndLogError("Failed to retrieve the list of network networks and subnets");
            Object[] args = new String[]{"error-empty-or-null-interconnect-list-1"};
            throw new CVUException(s_gMsgBundle.getMessage("13201", true, args));
        }
        clusterNetworks = NetworkDataDiscovery.getMissingNetworksDetailsForClusterNetworks(clusterNetworks, resultSet);
        return clusterNetworks;
    }

    public static List<OIFCFGResult> updateNetMaskFromOifcfg(List<OIFCFGResult> getIfResult, String oifcfgLoc, Version version) throws InstallException, IPAddressException {
        List ifListResult = null;
        ArrayList<OIFCFGResult> updatedIfListResult = new ArrayList<OIFCFGResult>();
        ifListResult = new ClusterwareInfo().listInterfaces(oifcfgLoc);
        block0: for (OIFCFGResult getIfRes : getIfResult) {
            if (getIfRes.getSubnetMask() != null && VerificationUtil.isStringGood(getIfRes.getSubnetMask().getHostAddress())) {
                updatedIfListResult.add(getIfRes);
                continue;
            }
            String interfaceName = getIfRes.getInterfaceName();
            for (OIFCFGResult ifListRes : ifListResult) {
                if (!ifListRes.getInterfaceName().equals(interfaceName) || !IPAddressUtil.sameIPAddresses((String)ifListRes.getSubnet().getHostAddress(), (String)getIfRes.getSubnet().getHostAddress())) continue;
                getIfRes.setSubnetMask(ifListRes.getSubnetMask(), ifListRes.getSubnetMaskPrefix());
                updatedIfListResult.add(getIfRes);
                continue block0;
            }
        }
        return updatedIfListResult;
    }

    public static Set<NetworkInfo> getAllNetworksFromOifcfg(String node) throws CVUException, NodelistNotFoundException, NetworkException {
        Trace.out((String)"trying to get CRS Home..");
        String crsHome = VerificationUtil.getCRSHome();
        if (crsHome == null) {
            Trace.out((String)"CRSHOME is null");
            throw new CVUException(s_msgBundle, "5301", new Object[0]);
        }
        String oifcfgLoc = crsHome + FSEP + "bin";
        Trace.out((String)("OIFCFG loc:" + oifcfgLoc));
        List oifcfgList = null;
        try {
            oifcfgList = new ClusterwareInfo().listInterfaces(node, oifcfgLoc);
        }
        catch (InstallException ie) {
            Trace.out((String)("INSTALLEXCEPTION: occured while getting network info. message" + ie.getMessage()));
            throw new CVUException(ie);
        }
        if (oifcfgList.size() == 0) {
            Trace.out((String)"OIFCFG list is EMPTY");
            throw new CVUException(s_msgBundle, "7615", oifcfgLoc, crsHome);
        }
        HashSet<NetworkInfo> networksOnTheNode = new HashSet<NetworkInfo>();
        if (oifcfgList.size() > 0) {
            Trace.out((String)"Network details from OIFCFG: ");
        }
        for (OIFCFGResult oifcfgRes : oifcfgList) {
            NetworkInfo network = new NetworkInfo();
            network.setInterfaceName(oifcfgRes.getInterfaceName());
            network.setSubnet(oifcfgRes.getSubnet());
            network.setNetworkType(oifcfgRes.getInterfaceType());
            String scope = oifcfgRes.getNodeScope();
            scope = scope == null ? "" : scope.trim();
            network.setIfNameGlobalLogicalInterface(scope.equalsIgnoreCase("global"));
            network.setInterfaceScope(scope);
            Trace.out((String)("ifName=" + network.getInterfaceName() + ",subnet=" + network.getSubnetAsString() + ",netType=" + network.getNetworkType() + ",isIfNameGlobals=" + network.isIfNameGlobalLogicalInterface() + ", Scope=" + network.getInterfaceScope()));
            networksOnTheNode.add(network);
        }
        if (!NetworkUtility.isNetworksSetGood(networksOnTheNode)) {
            Trace.out((String)"This should not happen");
            VerificationUtil.traceAndLogError("Failed to retrieve the list of networks and subnets on the node " + node + "from oifcfg result");
        }
        return networksOnTheNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<NetworkInfo> getClusterNetworksFromPMArgument(String arg, String node, ResultSet resultSet) {
        String[] networkNames = arg.split("/");
        StringBuilder sbInterConnectList = new StringBuilder();
        String[] stringArray = networkNames;
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            block29: {
                Iterator<Object> iterator;
                boolean bSubnetFound;
                Pattern p;
                boolean foundFromOifCfg;
                String subnetIdType;
                String subnetId;
                String iName;
                block28: {
                    block27: {
                        int n3;
                        String[] errorMessage5;
                        String networkName;
                        block26: {
                            block23: {
                                Set<Object> networks;
                                block22: {
                                    block24: {
                                        block25: {
                                            if (n2 >= n) break block23;
                                            networkName = stringArray[n2];
                                            Trace.out((String)("start processing NetworkInfo=" + networkName));
                                            iName = null;
                                            subnetId = null;
                                            subnetIdType = null;
                                            int start = 0;
                                            int end = 0;
                                            networkName = networkName.trim();
                                            if (!VerificationUtil.isStringGood(networkName)) {
                                                Trace.out((String)"Interface name is empty");
                                                String errorMessage2 = new CVUException(s_gMsgBundle, "11051", arg).getMessage();
                                                ResultSet.updateResultSetWithErrorDescription(errorMessage2, resultSet, new String[]{node}, true, true);
                                                return null;
                                            }
                                            boolean bSubnetId = false;
                                            boolean bSubnetType = false;
                                            if (networkName.charAt(0) == '\"') {
                                                start = 1;
                                                end = networkName.indexOf(34, 1);
                                                if (end == -1) {
                                                    Trace.out((String)("interface name is not enclosed with in double quotes properly in:" + networkName));
                                                    String errorMessage3 = new CVUException(s_gMsgBundle, "11052", new Object[0]).getMessage();
                                                    ResultSet.updateResultSetWithErrorDescription(errorMessage3, resultSet, new String[]{node}, true, true);
                                                    return null;
                                                }
                                                iName = networkName.substring(start, end);
                                                if (networkName.length() > end + 1) {
                                                    if (networkName.charAt(end + 1) != ':') {
                                                        Trace.out((String)("interface name is not seperated by a ':' in NetworkInfo:" + networkName));
                                                        String errorMessage4 = new CVUException(s_gMsgBundle, "11051", arg).getMessage();
                                                        ResultSet.updateResultSetWithErrorDescription(errorMessage4, resultSet, new String[]{node}, true, true);
                                                        return null;
                                                    }
                                                    bSubnetId = true;
                                                    ++end;
                                                }
                                            } else {
                                                start = 0;
                                                end = networkName.indexOf(58);
                                                if (end == -1) {
                                                    iName = networkName;
                                                } else {
                                                    iName = networkName.substring(start, end);
                                                    bSubnetId = true;
                                                }
                                            }
                                            Trace.out((String)("Interface name '" + iName + "' is extracted from " + networkName));
                                            if (!bSubnetId) break block24;
                                            start = end + 1;
                                            end = networkName.lastIndexOf(":");
                                            if (end + 1 == start) {
                                                subnetId = networkName.substring(start);
                                                Trace.out((String)("subnet id = '" + subnetId + "' is extracted from " + "NetworkInfo:" + networkName));
                                            } else if (end < start) {
                                                Trace.out((String)("subnet id is not specified properly. NetworkInfo:" + networkName));
                                                String errorMessage5 = new CVUException(s_gMsgBundle, "11051", arg).getMessage();
                                                ResultSet.updateResultSetWithErrorDescription(errorMessage5, resultSet, new String[]{node}, true, true);
                                            } else {
                                                bSubnetType = true;
                                                subnetId = networkName.substring(start, end);
                                                if (!VerificationUtil.isStringGood(subnetId)) {
                                                    subnetId = "*";
                                                }
                                            }
                                            Trace.out((String)("Subnet ID '" + subnetId + "' is extracted from " + networkName));
                                            if (!bSubnetType) break block25;
                                            subnetIdType = networkName.substring(end + 1);
                                            errorMessage5 = subnetIdType.split(",");
                                            n3 = errorMessage5.length;
                                            break block26;
                                        }
                                        subnetIdType = "UNKNOWN";
                                        break block27;
                                    }
                                    Trace.out((String)"Subnet not found in cluster networks.  Trying to derive from oifcfg");
                                    foundFromOifCfg = false;
                                    networks = new HashSet();
                                    try {
                                        Trace.out((String)"Try getting all networks from oifcfg command");
                                        networks = NetworkDataDiscovery.getAllNetworksFromOifcfg(node);
                                        if (NetworkUtility.isNetworksSetGood(networks)) {
                                            foundFromOifCfg = true;
                                        }
                                    }
                                    catch (Exception anyException) {
                                        Trace.out((String)("Exception thrown.  Subnet could not be derived from oifcfg. msg=" + anyException.getMessage()));
                                        Trace.out((String)"Subnet not found in cluster networks.  Trying to derive from exectask -getIfInfo");
                                        networks = NetworkDataDiscovery.getNetworksOnNode(node, true, resultSet);
                                        if (NetworkUtility.isNetworksSetGood(networks)) break block22;
                                        Trace.out((String)"Could not fetch networks from exectask -getifInfo command");
                                        return networks;
                                    }
                                }
                                String regexp = networkName.replaceAll("\\*", "(.*)");
                                p = Pattern.compile(regexp);
                                bSubnetFound = false;
                                iterator = networks.iterator();
                                break block28;
                            }
                            try {
                                return NetworkDataDiscovery.getClusterNetworksFromInterConnectList(sbInterConnectList.toString(), resultSet);
                            }
                            catch (CVUException cvuException) {
                                String errorMessage6 = cvuException.getMessage();
                                ResultSet.updateResultSetWithErrorDescription(errorMessage6, resultSet, new String[]{node}, true, true);
                                return null;
                            }
                        }
                        for (int i = 0; i < n3; ++i) {
                            String strSubnetType = errorMessage5[i];
                            if ("PUBLIC".equalsIgnoreCase(strSubnetType) || "CLUSTER_INTERCONNECT".equalsIgnoreCase(strSubnetType) || "ASM".equalsIgnoreCase(strSubnetType)) continue;
                            Trace.out((String)("got invalid subnet id type = " + subnetIdType + "form NetworkInfo=" + networkName));
                            String errorMessage7 = new CVUException(s_gMsgBundle, "11053", new Object[0]).getMessage();
                            ResultSet.updateResultSetWithErrorDescription(errorMessage7, resultSet, new String[]{node}, true, true);
                        }
                        subnetIdType = subnetIdType.replace(',', '-');
                    }
                    NetworkDataDiscovery.appendInterConnectList(sbInterConnectList, iName, subnetId, subnetIdType);
                    break block29;
                }
                while (iterator.hasNext()) {
                    NetworkInfo networkInfo = (NetworkInfo)iterator.next();
                    String ifName = networkInfo.getInterfaceName();
                    if (!p.matcher(ifName).matches()) continue;
                    bSubnetFound = true;
                    subnetId = networkInfo.getSubnetAsString();
                    subnetIdType = !foundFromOifCfg ? "UNKNOWN" : networkInfo.getNetworkTypeAsString();
                    NetworkDataDiscovery.appendInterConnectList(sbInterConnectList, ifName, subnetId, subnetIdType);
                }
                if (!bSubnetFound) {
                    String errorMessage = new CVUException(s_gMsgBundle, "11049", iName, node).getMessage();
                    Trace.out((String)("Failed to locate interface '" + iName + "' on node '" + node + "'"));
                    ResultSet.updateResultSetWithErrorDescription(errorMessage, resultSet, new String[]{node}, true, true);
                    return null;
                }
            }
            ++n2;
        }
    }

    public static Set<NetworkInfo> getClusterNetworksFromCVUVariable(ResultSet resultSet) throws CVUException {
        String niList = CVUVariables.getValue(CVUVariableConstants.INTERCONNECT_LIST);
        if (niList == null) {
            Trace.out((String)"INTERCONNECT_LIST list is EMPTY");
            Object[] args = new String[]{"error-empty-or-null-interconnect-list-2"};
            throw new CVUException(s_gMsgBundle.getMessage("13201", true, args));
        }
        return NetworkDataDiscovery.getClusterNetworksFromInterConnectList(niList, resultSet);
    }

    public static Set<NetworkInfo> getClusterNetworksFromInterConnectList(String niList, ResultSet resultSet) throws CVUException {
        Set<NetworkInfo> clusterNetworks = new HashSet<NetworkInfo>();
        String strNetTypes = null;
        int netType = 0;
        Trace.out((String)("niList '" + niList + "'"));
        String[] interconnectLst = VerificationUtil.string2strArr(niList);
        for (String interConnectListElement : interconnectLst) {
            Object[] args;
            NetworkInfo network = new NetworkInfo();
            String ifName = null;
            netType = 0;
            Trace.out((String)("Interconnect list element: " + interConnectListElement));
            int start = interConnectListElement.indexOf(34) + 1;
            int end = interConnectListElement.indexOf(34, start);
            if (start == 0 || end == -1) {
                args = new String[]{"error-invalid-interconnect-list-1"};
                throw new CVUException(s_gMsgBundle.getMessage("13201", true, args));
            }
            ifName = interConnectListElement.substring(start, end);
            start = interConnectListElement.indexOf(58) + 1;
            end = interConnectListElement.lastIndexOf(58);
            if (ifName.indexOf(":") != -1) {
                Trace.out((String)("NIC name contains ':', indicating logical interface number." + ifName));
                ifName = ifName.split(":")[0];
                start = interConnectListElement.indexOf(":", start) + 1;
            }
            network.setInterfaceName(ifName);
            if (start == 0 || end == -1) {
                args = new String[]{"error-invalid-interconnect-list-2"};
                throw new CVUException(s_gMsgBundle.getMessage("13201", true, args));
            }
            String subnet = interConnectListElement.substring(start, end);
            if (!IPAddressUtil.isIPAddressString((String)subnet)) {
                VerificationUtil.traceAndLogWarning("Invalid subnet Id " + subnet + " found in interconnect list for the interface " + ifName);
                String errorMessage = s_gMsgBundle.getMessage("11087", true, (Object[])new String[]{subnet, ifName});
                Result result = new Result(errorMessage);
                result.setStatus(4);
                ReportUtil.printWarning(errorMessage);
                resultSet.addResult(VerificationUtil.getLocalNode());
                continue;
            }
            network.setSubnet(subnet);
            strNetTypes = interConnectListElement.substring(end + 1);
            for (String strNetType : strNetTypes.split("-")) {
                Trace.out((String)("Found network Type " + strNetType));
                if ("PUBLIC".equalsIgnoreCase(strNetType) || "PUB".equalsIgnoreCase(strNetType)) {
                    Trace.out((String)("Setting network type PUBLIC " + (netType |= 2)));
                } else if ("PVT".equalsIgnoreCase(strNetType) || "PRIVATE".equalsIgnoreCase(strNetType) || "CLUSTER_INTERCONNECT".equalsIgnoreCase(strNetType)) {
                    Trace.out((String)("Setting network type PRIVATE " + (netType |= 1)));
                } else if ("ASM".equalsIgnoreCase(strNetType)) {
                    Trace.out((String)("Setting network type ASM " + (netType |= 0x80)));
                }
                if (netType != 0) continue;
                Trace.out((String)("got strNetType " + strNetType + " for interface " + ifName + " asuming NETTYPE_UNKNOWN"));
                netType = 4;
            }
            network.setIfNameGlobalLogicalInterface(true);
            network.setInterfaceScope("global");
            network.setNetworkType(netType);
            clusterNetworks.add(network);
        }
        if (NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            Trace.out((String)"Found the following interfaces: ");
            for (NetworkInfo network : clusterNetworks) {
                Trace.out((String)("<Name: " + network.getInterfaceName() + ">"));
                Trace.out((String)("<Subnet: " + network.getSubnetAsString() + ">"));
                Trace.out((String)("<NetType: " + network.getNetworkTypeAsString() + ">"));
                Trace.out((String)("<Interface Global Status: " + network.isIfNameGlobalLogicalInterface() + ">"));
                Trace.out((String)("<Interface Scope: " + network.getInterfaceScope() + ">"));
            }
        } else {
            VerificationUtil.traceAndLogError("Failed to retrieve the list of network networks and subnets from the interconnect list");
            throw new CVUException(s_gMsgBundle, "11089", niList);
        }
        ResultSet networkResultSet = new ResultSet();
        clusterNetworks = NetworkDataDiscovery.getMissingNetworksDetailsForClusterNetworks(clusterNetworks, networkResultSet);
        if (networkResultSet.anyFailure()) {
            resultSet.addResultSetData(networkResultSet);
        }
        return clusterNetworks;
    }

    public static Set<NetworkInfo> getClusterNetworksASMAsPrivate(Set<NetworkInfo> clusterNetworks) {
        HashSet<NetworkInfo> networks = new HashSet<NetworkInfo>();
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            return networks;
        }
        for (NetworkInfo network : clusterNetworks) {
            if ((network.getNetworkType() & NetworkConstants.NetworkType.ASM.getValue()) != 0) {
                network.setNetworkType(NetworkConstants.NetworkType.PRIVATE);
                networks.add(network);
                continue;
            }
            networks.add(network);
        }
        return networks;
    }

    public static Set<NetworkInfo> getClusterNetworksByType(Set<NetworkInfo> clusterNetworks, NetworkConstants.NetworkType netType) {
        HashSet<NetworkInfo> networks = new HashSet<NetworkInfo>();
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            return networks;
        }
        for (NetworkInfo network : clusterNetworks) {
            if ((network.getNetworkType() & netType.getValue()) == 0) continue;
            Trace.out((String)"Found matching network and adding it to the list");
            networks.add(network);
        }
        return networks;
    }

    public static Set<NetworkInfo> getPrivateClusterNetworks(Set<NetworkInfo> clusterNetworks, boolean asmAsPrivate) {
        HashSet<NetworkInfo> networks = new HashSet<NetworkInfo>();
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            return networks;
        }
        for (NetworkInfo network : clusterNetworks) {
            if ((network.getNetworkType() & NetworkConstants.NetworkType.PRIVATE.getValue()) == 0 && (network.getNetworkType() & NetworkConstants.NetworkType.ASM.getValue()) == 0) continue;
            networks.add(network);
        }
        return networks;
    }

    public static HashMap<String, Set<NetworkInfo>> getClusterSubnetNetworksMap(Set<NetworkInfo> clusterNetworks) {
        HashMap<String, Set<NetworkInfo>> matchingNetworksMap = new HashMap<String, Set<NetworkInfo>>();
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            return matchingNetworksMap;
        }
        List<String> subnets = NetworkDataDiscovery.getClusterNetworkSubnets(clusterNetworks);
        for (String subnet : subnets) {
            matchingNetworksMap.put(subnet, NetworkDataDiscovery.getClusterNetworksBySubnet(clusterNetworks, subnet));
        }
        return matchingNetworksMap;
    }

    public static Set<NetworkInfo> getClusterNetworksBySubnet(Set<NetworkInfo> clusterNetworks, String subnet) {
        HashSet<NetworkInfo> networks = new HashSet<NetworkInfo>();
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            return networks;
        }
        for (NetworkInfo network : clusterNetworks) {
            if (!network.getSubnetAsString().equals(subnet)) continue;
            networks.add(network);
        }
        return networks;
    }

    public static String getClusterInterConnectList(Set<NetworkInfo> clusterNetworks) {
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            return null;
        }
        StringBuilder sbInterConnectList = new StringBuilder();
        for (NetworkInfo network : clusterNetworks) {
            NetworkDataDiscovery.appendInterConnectList(sbInterConnectList, network.getInterfaceName(), network.getSubnetAsString(), network.getNetworkTypeAsString());
        }
        return sbInterConnectList.toString();
    }

    public static String getClusterInterConnectList(ResultSet resultSet) throws CVUException, NetworkException, NodelistNotFoundException {
        Set<Object> clusterNetworks = new HashSet();
        clusterNetworks = NetworkDataDiscovery.getClusterNetworks(VerificationUtil.getLocalNode(), resultSet);
        if (clusterNetworks == null) {
            return null;
        }
        StringBuilder sbInterConnectList = new StringBuilder();
        for (NetworkInfo networkInfo : clusterNetworks) {
            NetworkDataDiscovery.appendInterConnectList(sbInterConnectList, networkInfo.getInterfaceName(), networkInfo.getSubnetAsString(), networkInfo.getNetworkTypeAsString());
        }
        return sbInterConnectList.toString();
    }

    public static Hashtable<String, String> getPrivateInterConnectList(Set<NetworkInfo> clusterNetworks, boolean asmAsPrivate) {
        Hashtable<String, String> subnetInterfaceNameTable = new Hashtable<String, String>();
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            return null;
        }
        for (NetworkInfo network : clusterNetworks) {
            if (1 != network.getNetworkType() && (!Utils.isDevelopmentEnv() || network.getNetworkType() != 3) && (!asmAsPrivate || (network.getNetworkType() & 0x80) == 0)) continue;
            subnetInterfaceNameTable.put(network.getSubnetAsString(), network.getInterfaceName());
        }
        return subnetInterfaceNameTable;
    }

    public static List<String> getClusterNetworkNames(Set<NetworkInfo> clusterNetworks) {
        ArrayList<String> clusterNetworkNames = new ArrayList<String>();
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            return null;
        }
        for (NetworkInfo network : clusterNetworks) {
            clusterNetworkNames.add(network.getInterfaceName());
        }
        return clusterNetworkNames;
    }

    public static Set<String> getClusterNetworkNodeNames(Set<NetworkInfo> clusterNetworks) {
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            return null;
        }
        HashSet<String> nodeNames = new HashSet<String>();
        for (NetworkInfo network : clusterNetworks) {
            nodeNames.add(network.getNodeName());
        }
        return nodeNames;
    }

    public static List<String> getClusterNetworkSubnets(Set<NetworkInfo> clusterNetworks) {
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            return null;
        }
        ArrayList<String> clusterNetworkSubnets = new ArrayList<String>();
        for (NetworkInfo network : clusterNetworks) {
            clusterNetworkSubnets.add(network.getSubnetAsString());
        }
        return clusterNetworkSubnets;
    }

    public static List<String> getClusterNetworkSubnetMasks(Set<NetworkInfo> clusterNetworks) {
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            return null;
        }
        ArrayList<String> clusterNetworkSubnetMasks = new ArrayList<String>();
        for (NetworkInfo network : clusterNetworks) {
            clusterNetworkSubnetMasks.add(network.getSubnetMaskAsString());
        }
        return clusterNetworkSubnetMasks;
    }

    public List<String> getClusterNetworkScopes(Set<NetworkInfo> clusterNetworks) {
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            return null;
        }
        ArrayList<String> clusterNetworkScopes = new ArrayList<String>();
        for (NetworkInfo network : clusterNetworks) {
            clusterNetworkScopes.add(network.getInterfaceScope());
        }
        return clusterNetworkScopes;
    }

    public static List<Integer> getClusterNetworkTypes(Set<NetworkInfo> clusterNetworks) {
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            return null;
        }
        ArrayList<Integer> clusterNetworkTypes = new ArrayList<Integer>();
        for (NetworkInfo network : clusterNetworks) {
            clusterNetworkTypes.add(network.getNetworkType());
        }
        return clusterNetworkTypes;
    }

    public static List<NetworkConstants.NetworkType> getClusterNetworkTypes(Set<NetworkInfo> clusterNetworks, boolean considerASMAsPrivate) {
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            return null;
        }
        ArrayList<NetworkConstants.NetworkType> clusterNetworkTypes = new ArrayList<NetworkConstants.NetworkType>();
        for (NetworkInfo network : clusterNetworks) {
            if (!considerASMAsPrivate || (network.getNetworkType() & 0x80) == 0) continue;
            clusterNetworkTypes.add(NetworkConstants.NetworkType.PRIVATE);
        }
        return clusterNetworkTypes;
    }

    public List<Boolean> getClusterNetworkGlobals(Set<NetworkInfo> clusterNetworks) {
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            return null;
        }
        ArrayList<Boolean> clusterNetworkGlobals = new ArrayList<Boolean>();
        for (NetworkInfo network : clusterNetworks) {
            clusterNetworkGlobals.add(network.isIfNameGlobalLogicalInterface());
        }
        return clusterNetworkGlobals;
    }

    public static boolean hasNetworkTypeInClusterNetworks(Set<NetworkInfo> clusterNetworks, int netType) {
        boolean found = false;
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            return false;
        }
        for (NetworkInfo network : clusterNetworks) {
            if ((network.getNetworkType() & netType) == 0) continue;
            found = true;
            break;
        }
        return found;
    }

    public static Set<NetworkInfo> getMissingNetworksDetailsForClusterNetworks(Set<NetworkInfo> clusterNetworks, ResultSet resultSet) {
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            return null;
        }
        HashSet<NetworkInfo> matchingNetworks = new HashSet<NetworkInfo>();
        String localNode = VerificationUtil.getLocalNode();
        Set<NetworkInfo> networks = NetworkDataDiscovery.getNetworksOnNode(localNode, true, resultSet);
        if (!NetworkUtility.isNetworksSetGood(networks)) {
            Trace.out((String)("Could not discover valid network details on the node " + localNode));
            return null;
        }
        for (NetworkInfo clusterNetwork : clusterNetworks) {
            String regexp = clusterNetwork.getInterfaceName().replaceAll("\\*", "(.*)");
            Pattern p = Pattern.compile(regexp);
            boolean networkFoundOnNode = false;
            Trace.out((String)("Network from cluster: " + clusterNetwork.getInterfaceName() + ", " + clusterNetwork.getSubnetAsString() + ", " + clusterNetwork.getNetworkTypeAsString()));
            for (NetworkInfo network : networks) {
                Trace.out((String)("Network from node: " + network.getInterfaceName() + ", " + network.getSubnetAsString() + ", " + network.getNetworkTypeAsString()));
                if (!p.matcher(network.getInterfaceName()).matches() || !NetworkUtility.checkSameIPAddresses(network.getSubnetAsString(), clusterNetwork.getSubnetAsString()) || network.getStatus() != 22) continue;
                Trace.out((String)"Matching network found");
                networkFoundOnNode = true;
                network.setNetworkType(clusterNetwork.getNetworkType());
                if (VerificationUtil.isStringGood(clusterNetwork.getSubnetMaskAsString())) {
                    network.setSubnetMask(clusterNetwork.getSubnetMaskAsString());
                }
                Trace.out((String)"Update scope of the network from the cluster configuration");
                network.setIfNameGlobalLogicalInterface(clusterNetwork.isIfNameGlobalLogicalInterface());
                network.setInterfaceScope(clusterNetwork.getInterfaceScope());
                matchingNetworks.add(network);
            }
            if (networkFoundOnNode) continue;
            matchingNetworks.add(clusterNetwork);
        }
        if (!NetworkUtility.isNetworksSetGood(matchingNetworks)) {
            Trace.out((String)("Could not find the missing attributes for the cluster nodes  on the node" + localNode));
            List<String> interfaceNames = NetworkDataDiscovery.getClusterNetworkNames(clusterNetworks);
            List<String> subnetIds = NetworkDataDiscovery.getClusterNetworkSubnets(clusterNetworks);
            String errorMessage = s_gMsgBundle.getMessage("11081", true, (Object[])new String[]{VerificationUtil.strList2List(new ArrayList<String>(interfaceNames)), VerificationUtil.strList2List(new ArrayList<String>(subnetIds)), localNode});
            ErrorDescription errDesc = new ErrorDescription(errorMessage);
            resultSet.addResult(localNode, 3);
            resultSet.addErrorDescription(errDesc);
            return clusterNetworks;
        }
        Trace.out((String)("Matching networks with updated attributes " + localNode));
        VerificationUtil.logNetworkInterfaces(matchingNetworks);
        return matchingNetworks;
    }

    private static void appendInterConnectList(StringBuilder sbInterConnectList, String networkName, String subnetId, String networkType) {
        if (VerificationUtil.isStringGood(subnetId) && sbInterConnectList.indexOf(subnetId) != -1) {
            Trace.out((String)"Subnet already exists..no need to add it again");
            return;
        }
        if (sbInterConnectList.length() != 0) {
            sbInterConnectList.append(',');
        }
        sbInterConnectList.append('\"');
        sbInterConnectList.append(networkName);
        sbInterConnectList.append('\"');
        sbInterConnectList.append(':');
        sbInterConnectList.append(subnetId);
        sbInterConnectList.append(':');
        boolean hasElement = false;
        for (String networkTypeStr : VerificationUtil.string2strArr(networkType)) {
            if (hasElement) {
                sbInterConnectList.append("-");
                sbInterConnectList.append(networkTypeStr);
                continue;
            }
            sbInterConnectList.append(networkTypeStr);
            hasElement = true;
        }
        Trace.out((String)("Appending " + sbInterConnectList.toString()));
    }

    public static HashMap<String, Set<ErrorDescription>> getfailedNodesErrorDescriptionsMap() {
        return m_failedNodesErrorMap;
    }

    public static Set<String> getSuccessfulNodes(HashMap<String, Set<ErrorDescription>> failedNodesErrorMap, String[] nodes) {
        HashSet<String> successfulNodes = new HashSet<String>();
        if (failedNodesErrorMap == null || failedNodesErrorMap.isEmpty()) {
            return null;
        }
        for (String node : nodes) {
            if (failedNodesErrorMap.containsKey(node)) continue;
            successfulNodes.add(node);
        }
        return successfulNodes;
    }

    public static Set<String> getFailedNodes(HashMap<String, Set<ErrorDescription>> failedNodesErrorMap, String[] nodes) {
        HashSet<String> failedNodes = new HashSet<String>();
        if (failedNodesErrorMap == null || failedNodesErrorMap.isEmpty()) {
            return null;
        }
        for (String node : nodes) {
            if (!failedNodesErrorMap.containsKey(node)) continue;
            failedNodes.add(node);
        }
        return failedNodes;
    }

    public static boolean isNodeNetworkDiscoverySuccessful(HashMap<String, Set<ErrorDescription>> failedNodesErrorMap, String node) {
        if (failedNodesErrorMap == null || failedNodesErrorMap.isEmpty()) {
            return false;
        }
        return failedNodesErrorMap.containsKey(node);
    }

    public static Set<ErrorDescription> getErrorDescriptionsOnFailedNode(HashMap<String, Set<ErrorDescription>> failedNodesErrorMap, String node) {
        if (!NetworkDataDiscovery.isNodeNetworkDiscoverySuccessful(failedNodesErrorMap, node)) {
            return failedNodesErrorMap.get(node);
        }
        return null;
    }

    public static void addFailedNodesErrorDescriptions(HashMap<String, Set<ErrorDescription>> failedNodesErrorMap, Set<String> failedNodes, ResultSet resultSet) {
        for (String node : failedNodes) {
            Set<ErrorDescription> errorDescriptions;
            if (NetworkDataDiscovery.isNodeNetworkDiscoverySuccessful(failedNodesErrorMap, node) || (errorDescriptions = NetworkDataDiscovery.getErrorDescriptionsOnFailedNode(failedNodesErrorMap, node)) == null) continue;
            for (ErrorDescription errorDescription : errorDescriptions) {
                Trace.out((String)("Network Discovery failed on node " + node + "Error Message = " + errorDescription.getErrorMessage()));
                resultSet.addErrorDescription(errorDescription);
            }
        }
    }

    public static boolean checkForNetworkExistenceOnAllNodes(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, Set<NetworkInfo> networksToConsider, String[] nodeList, Set<String> validNodeList, ResultSet resultSet, String taskType) {
        boolean retVal = false;
        HashMap<String, Set<ErrorDescription>> failedNodesErrorDescriptions = new HashMap();
        HashMap<String, HashSet<NetworkInfo>> missingNodeNetworksMap = new HashMap<String, HashSet<NetworkInfo>>();
        HashSet<String> failedNodeList = new HashSet<String>();
        Trace.out((String)("Checking for network existence started for task " + taskType));
        if (NetworkUtility.isNetworksSetGood(networksToConsider)) {
            Trace.out((String)"Network existence to be checked for the following interfaces: ");
            for (NetworkInfo network : networksToConsider) {
                if (!VerificationUtil.isStringGood(network.getInterfaceName())) continue;
                Trace.out((String)network.getInterfaceName());
            }
        }
        try {
            if (NetworkDataDiscovery.getInstance(nodeList, resultSet) == null) {
                return false;
            }
            failedNodesErrorDescriptions = m_failedNodesErrorMap;
            if (!NetworkUtility.isNetworksMapGood(nodeNetworksMap)) {
                nodeNetworksMap = NetworkDataDiscovery.getNodeNetworksMap(nodeList, resultSet);
            }
            if (NetworkUtility.isNetworksSetGood(networksToConsider)) {
                nodeNetworksMap = NetworkDataDiscovery.getMatchingNodeNetworksMapOnNodes(nodeNetworksMap, networksToConsider, nodeList);
            }
        }
        catch (NodelistNotFoundException nodelistNotFoundException) {
            Trace.out((String)("NodelistNotFoundException occured while trying to get interfaces info on " + VerificationUtil.strArr2List(nodeList)));
            ResultSet.updateResultSetWithErrorDescription(nodelistNotFoundException.getMessage(), resultSet, failedNodeList.toArray(new String[0]), true, false);
            return false;
        }
        for (String node : nodeList) {
            HashSet<NetworkInfo> missingNetworks;
            if (!nodeNetworksMap.containsKey(node) || nodeNetworksMap.get(node).isEmpty()) {
                Trace.out((String)("Could not find network details for the node " + node));
                failedNodeList.add(node);
                if (!NetworkUtility.isNetworksSetGood(networksToConsider)) continue;
                missingNetworks = new HashSet();
                missingNetworks.addAll(networksToConsider);
                missingNodeNetworksMap.put(node, missingNetworks);
                continue;
            }
            if (NetworkUtility.isNetworksSetGood(networksToConsider)) {
                missingNetworks = new HashSet<NetworkInfo>();
                Set<NetworkInfo> foundNetworks = nodeNetworksMap.get(node);
                for (NetworkInfo network : networksToConsider) {
                    String interfaceName = network.getInterfaceName();
                    String subnetId = network.getSubnetAsString();
                    boolean found = false;
                    for (NetworkInfo foundNetwork : foundNetworks) {
                        String foundInterfaceName = foundNetwork.getInterfaceName();
                        String foundSubnetId = foundNetwork.getSubnetAsString();
                        if (VerificationUtil.isStringGood(interfaceName) && VerificationUtil.isStringGood(subnetId)) {
                            if (!NetworkDataDiscovery.isInterfaceNameMatching(interfaceName, foundInterfaceName) || !foundSubnetId.equalsIgnoreCase(subnetId)) continue;
                            Trace.out((String)("Specified interface " + interfaceName + " and subnet " + subnetId + " are found on the node " + node));
                            found = true;
                            break;
                        }
                        if (VerificationUtil.isStringGood(interfaceName)) {
                            if (!NetworkDataDiscovery.isInterfaceNameMatching(interfaceName, foundInterfaceName)) continue;
                            Trace.out((String)("Specified interface " + interfaceName + " found "));
                            found = true;
                            break;
                        }
                        if (!VerificationUtil.isStringGood(network.getSubnetAsString()) || !foundNetwork.getSubnetAsString().equalsIgnoreCase(network.getSubnetAsString())) continue;
                        Trace.out((String)("Specified subnet " + subnetId + " found "));
                        found = true;
                        break;
                    }
                    if (found) continue;
                    missingNetworks.add(network);
                }
                if (NetworkUtility.isNetworksSetGood(missingNetworks)) {
                    missingNodeNetworksMap.put(node, missingNetworks);
                    failedNodeList.add(node);
                    continue;
                }
                validNodeList.add(node);
                continue;
            }
            validNodeList.add(node);
        }
        String[] failedNodes = failedNodeList.toArray(new String[0]);
        if (failedNodes.length > 0) {
            String errorMessage = "";
            if (!NetworkUtility.isNetworksSetGood(networksToConsider)) {
                Trace.out((String)"Could not find valid interfaces on one or more nodes.");
                errorMessage = s_msgBundle.getMessage("6011", true, (Object[])new String[]{VerificationUtil.strArr2List(failedNodes)});
            } else {
                HashSet<String> interfaceNames = new HashSet<String>();
                HashSet<String> subnetIds = new HashSet<String>();
                for (String node : missingNodeNetworksMap.keySet()) {
                    if (!NetworkUtility.isNetworksSetGood((Set)missingNodeNetworksMap.get(node))) continue;
                    interfaceNames.addAll(NetworkDataDiscovery.getClusterNetworkNames((Set)missingNodeNetworksMap.get(node)));
                    subnetIds.addAll(NetworkDataDiscovery.getClusterNetworkSubnets((Set)missingNodeNetworksMap.get(node)));
                }
                if (interfaceNames.isEmpty()) {
                    interfaceNames.add("*");
                }
                if (subnetIds.isEmpty()) {
                    subnetIds.add("*");
                }
                Trace.out((String)"Could not find matching interfaces on one or more nodes");
                errorMessage = s_gMsgBundle.getMessage("11081", true, (Object[])new String[]{VerificationUtil.strList2List(new ArrayList<String>(interfaceNames)), VerificationUtil.strList2List(new ArrayList<String>(subnetIds)), VerificationUtil.strArr2List(failedNodes)});
            }
            ResultSet.updateResultSetWithErrorDescription(errorMessage, resultSet, failedNodes, true, true);
            retVal = false;
            NetworkDataDiscovery.addFailedNodesErrorDescriptions(failedNodesErrorDescriptions, failedNodeList, resultSet);
            if (failedNodes.length < nodeList.length) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                ReportUtil.sureprintNodelist(nodeNetworksMap.keySet());
            }
            Trace.out((String)("Checking for network existence failed for the task " + taskType));
        } else {
            retVal = true;
            Trace.out((String)("Checking for network existence passed for the task " + taskType));
        }
        String[] validNodes = validNodeList.toArray(new String[0]);
        if (validNodes == null || validNodes.length == 0) {
            Trace.out((String)("Could not find any valid node to continue " + taskType + " checks"));
            resultSet.addResult(nodeList, 3);
            return false;
        }
        if (!retVal) {
            Trace.out((String)("Could not find the network details on one or more nodes during " + taskType + " checks"));
            resultSet.addResult(nodeList, 3);
            return false;
        }
        return retVal;
    }

    public static boolean isInterfaceNameMatching(String interfaceName1, String interfaceName2) {
        String regexp = interfaceName1.replaceAll("\\*", "(.*)");
        Pattern p = Pattern.compile(regexp);
        return p.matcher(interfaceName2).matches();
    }
}

