/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Arrays;
import java.util.Vector;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskUSMDriverChecks {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static final int OPT_INSTALLED = 0;
    private static final int OPT_LOADED = 1;
    private static final int OPT_VERSION = 2;
    private static final String STR_OPT_INSTALLED = "installed";
    private static final String STR_OPT_LOADED = "loaded";
    private static final String STR_OPT_VERSION = "version";
    private static final String[] m_strCmdOption = new String[]{"installed", "loaded", "version"};
    private static final String STR_USM_VERSION_OUTPUT_TYPE1 = "OS/ADVM,ACFS installed version";
    private static final String STR_USM_VERSION_OUTPUT_TYPE2 = "Driver OS kernel version";
    private static final String STR_TRUE = "true";

    public String parseDriverOutput(String rsltOutput) {
        StringBuffer parseOutput = null;
        Trace.out((int)2, (String)"Entry");
        Trace.out((int)5, (String)("String to be parsed: >" + rsltOutput + "<"));
        if (rsltOutput != null && rsltOutput.contains(STR_USM_VERSION_OUTPUT_TYPE1)) {
            int sp;
            parseOutput = new StringBuffer(rsltOutput);
            int eq = parseOutput.indexOf("=");
            int slash = parseOutput.indexOf("/", eq);
            String tmp1 = parseOutput.substring(eq + 1, slash);
            parseOutput = new StringBuffer(tmp1);
            while ((sp = parseOutput.indexOf(" ")) >= 0) {
                parseOutput.deleteCharAt(sp);
            }
            Trace.out((int)5, (String)("Parsed output of usm driver version is >" + parseOutput + "<"));
            return new String(parseOutput);
        }
        if (rsltOutput != null && rsltOutput.contains(STR_USM_VERSION_OUTPUT_TYPE2)) {
            parseOutput = new StringBuffer(rsltOutput);
            int osRelVerStartIndex = parseOutput.indexOf("ACFS-9325");
            int osRelVerEndIndex = parseOutput.indexOf("ACFS-9326");
            if (osRelVerEndIndex == -1 || osRelVerStartIndex == -1) {
                Trace.out((int)5, (String)"Output of usm driver version is not correct, ASFC code string missing in output. hence returning null");
                return null;
            }
            String driverOsReleaseVersionOutput = parseOutput.substring(osRelVerStartIndex, osRelVerEndIndex);
            int eq = driverOsReleaseVersionOutput.indexOf("=");
            if (eq == -1 || eq == driverOsReleaseVersionOutput.length() - 1) {
                Trace.out((int)5, (String)"Output of usm driver version is not correct, equal sign absent. hence returning null");
                return null;
            }
            String releaseVersion = driverOsReleaseVersionOutput.substring(eq + 1);
            parseOutput = new StringBuffer(releaseVersion);
            while (parseOutput != null && parseOutput.length() > 0 && parseOutput.charAt(0) == ' ') {
                parseOutput.deleteCharAt(0);
            }
            if (parseOutput.length() == 0) {
                return null;
            }
            int newLineIndex = parseOutput.indexOf("\n");
            if (newLineIndex != -1) {
                parseOutput.deleteCharAt(newLineIndex);
            }
            if (parseOutput.lastIndexOf(".") == parseOutput.length() - 1) {
                parseOutput.deleteCharAt(parseOutput.lastIndexOf("."));
            }
            if ((releaseVersion = new String(parseOutput)) != null && releaseVersion.length() > 0) {
                releaseVersion = releaseVersion.trim();
            }
            Trace.out((int)5, (String)("Parsed output of usm driver version is >" + releaseVersion + "<"));
            return releaseVersion;
        }
        return null;
    }

    private boolean runDriverCommand(String[] nodeList, ResultSet resultSet, int cmdOption) {
        Trace.out((int)2, (String)"Entry");
        boolean ret = false;
        VerificationCommand[] driverCmdArray = new VerificationCommand[nodeList.length];
        Trace.out((int)5, (String)("Node List to runDriverCommand " + Arrays.asList(nodeList)));
        String stateCmd = VerificationUtil.getUSMDriverStatePath();
        for (int j = 0; j < nodeList.length; ++j) {
            String[] arg = new String[]{"-rungencmd", stateCmd, m_strCmdOption[cmdOption]};
            Trace.out((int)5, (String)("Driver command args: " + Arrays.asList(arg)));
            String[] env = null;
            driverCmdArray[j] = new VerificationCommand(nodeList[j], arg, env);
        }
        new GlobalHandler().submit((Command[])driverCmdArray, 0, resultSet);
        if (!resultSet.anySuccess()) {
            Trace.out((int)5, (String)("Global failure executing driver command " + m_strCmdOption[cmdOption]));
            String message = s_msgBundle.getMessage("5177", false, (Object[])new String[]{m_strCmdOption[cmdOption]});
            ErrorDescription errorDesc = new ErrorDescription(message);
            resultSet.addErrorDescription(nodeList, errorDesc);
            ReportUtil.printError(message);
            return false;
        }
        block5: for (int nodeIndex = 0; nodeIndex < nodeList.length; ++nodeIndex) {
            VerificationCommand driverCmd = driverCmdArray[nodeIndex];
            Result result = driverCmd.getResult();
            if (result.getStatus() != 1) continue;
            String node = driverCmd.getNode();
            String output = driverCmd.getOutput();
            result.addResultInfo(output);
            result.addCommandInfo(driverCmd.getExecCommand());
            Trace.out((int)5, (String)("Output from driver command " + m_strCmdOption[cmdOption] + " is =" + output));
            switch (cmdOption) {
                case 0: 
                case 1: {
                    if (output.contains(STR_TRUE)) continue block5;
                    result.setStatus(3);
                    continue block5;
                }
                case 2: {
                    if (output.contains(STR_USM_VERSION_OUTPUT_TYPE1) || output.contains(STR_USM_VERSION_OUTPUT_TYPE2)) continue block5;
                    result.setStatus(3);
                    continue block5;
                }
                default: {
                    result.setStatus(3);
                }
            }
        }
        return true;
    }

    public boolean checkDriversInstalled(String[] nodeList, ResultSet resultSet) {
        Trace.out((int)2, (String)"Entry");
        return this.runDriverCommand(nodeList, resultSet, 0);
    }

    public boolean checkDriversLoaded(Vector<String> nodeVect, ResultSet resultSet) {
        Trace.out((int)2, (String)"Entry");
        return this.runDriverCommand(nodeVect.toArray(new String[nodeVect.size()]), resultSet, 1);
    }

    public boolean getDriverVersion(Vector<String> nodeVect, ResultSet resultSet) {
        Trace.out((int)2, (String)"Entry");
        return this.runDriverCommand(nodeVect.toArray(new String[nodeVect.size()]), resultSet, 2);
    }

    public String getLocalOSVersion() {
        Trace.out((int)2, (String)"Entry");
        String osversion = null;
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet knlvResultSet = new ResultSet();
        globalExec.getKernelVersion(new String[]{"localnode"}, knlvResultSet);
        Result result = (Result)knlvResultSet.getResultTable().get("localnode");
        if (result.getStatus() == 1) {
            osversion = (String)result.getResultInfoSet().firstElement();
            Trace.out((int)5, (String)("Result.OPERATION_SUCCESSFUL:: available kernel version=" + osversion));
        }
        return osversion;
    }
}

