/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.ServiceConfiguration;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskCheckOraFenceService
extends Task {
    private String ORAFENCE_SERVICE = new String("orafenceservice");
    private String ORAFENCE_SERVICE_FILE = new String("orafenceservice.sys");
    private String SYSTEM32_DIR = "System32";
    private String DRIVERS_DIR = "Drivers";

    public sTaskCheckOraFenceService(String[] nodeList) {
        super(nodeList);
        this.setSeverity(SeverityType.IGNORABLE);
    }

    public sTaskCheckOraFenceService(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    public boolean performTask() {
        boolean retVal = true;
        Trace.out((String)"Checking the status of oracle fence service and availability of orafenceservice.sys file");
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("12912", false));
        this.m_resultSet.addResult(this.m_nodeList, 1);
        retVal &= this.checkOraFenceServiceFileExistence();
        if (retVal &= this.checkOraFenceServiceStatus()) {
            Trace.out((String)"oracle fence service check passed");
            ReportUtil.sureprint(s_gMsgBundle.getMessage("12913", false));
        }
        return retVal;
    }

    private boolean checkOraFenceServiceFileExistence() {
        boolean status = true;
        ResultSet resultSet = new ResultSet();
        ArrayList<String> verificationFailedNodes = new ArrayList<String>();
        String oraFenceDestDir = System.getenv("SystemRoot") + VerificationConstants.FSEP + this.SYSTEM32_DIR + VerificationConstants.FSEP + this.DRIVERS_DIR;
        String oraFenceExecLocation = new String(oraFenceDestDir + VerificationConstants.FSEP + this.ORAFENCE_SERVICE_FILE);
        Trace.out((String)"checking the existence of orafenceservice.sys file");
        VerificationLogData.log("checking the existence of orafenceservice.sys file");
        VerificationUtil.checkFileExistence(this.m_nodeList, oraFenceExecLocation, resultSet);
        this.m_resultSet.uploadResultSet(resultSet);
        Hashtable ht = resultSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result != null && result.getStatus() == 3) {
                Trace.out((String)("orafenceservice.sys file does not exist on node " + node));
                verificationFailedNodes.add(node);
                status = false;
                continue;
            }
            if (result == null || result.getStatus() != 2) continue;
            Trace.out((String)("Failed to check the existence of orafenceservice.sys file on node " + node));
            status = false;
        }
        if (verificationFailedNodes.size() > 0) {
            String failedNodeListStr = VerificationUtil.strList2List(verificationFailedNodes);
            Trace.out((String)("orafenceservice.sys file does not exist on nodes " + failedNodeListStr));
            VerificationLogData.logError("orafenceservice.sys file does not exist on nodes " + failedNodeListStr);
            String errMsg = s_gMsgBundle.getMessage("12914", true, (Object[])new String[]{oraFenceExecLocation, failedNodeListStr});
            this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
            ReportUtil.printError(errMsg);
        }
        return status;
    }

    private boolean checkOraFenceServiceStatus() {
        ErrorDescription errorDesc;
        String errMsg;
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet oraFenceRsltSet = new ResultSet();
        boolean retVal = true;
        ArrayList<String> incorrectServiceTypeNodes = new ArrayList<String>();
        ArrayList<String> incorrectStartTypeNodes = new ArrayList<String>();
        ArrayList<String> serviceNotRunningNodes = new ArrayList<String>();
        ArrayList<String> serviceNotExistNodes = new ArrayList<String>();
        Trace.out((String)"checking the aliveness of oracle fence service");
        VerificationLogData.log("checking the aliveness of oracle fence service");
        globalExec.checkService(this.m_nodeList, this.ORAFENCE_SERVICE, oraFenceRsltSet);
        this.m_resultSet.uploadResultSet(oraFenceRsltSet);
        Hashtable ht = oraFenceRsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            Vector servList = result.getResultInfoSet();
            Trace.out((String)("exectask checkservice result for node " + node + "  " + ((Object)servList).toString()));
            if (result.getStatus() == 1) {
                if (!servList.contains((Object)ServiceConfiguration.ServiceKernelDriver)) {
                    Trace.out((String)"service orafenceservice has not the required configuration for service type");
                    incorrectServiceTypeNodes.add(node);
                    retVal = false;
                }
                if (!servList.contains((Object)ServiceConfiguration.ServiceAutoStart)) {
                    Trace.out((String)("service orafenceservice has not the required configuration for start type on node " + node));
                    incorrectStartTypeNodes.add(node);
                    retVal = false;
                }
                if (servList.contains((Object)ServiceConfiguration.ServiceRunning)) continue;
                Trace.out((String)("service orafenceservice is not running on node " + node));
                serviceNotRunningNodes.add(node);
                retVal = false;
                continue;
            }
            StringBuilder errString = new StringBuilder();
            List<VerificationError> errList = result.getErrors();
            for (VerificationError err : errList) {
                errString.append(err.getErrorMessage());
                errString.append(LSEP);
            }
            if (errString.indexOf("1060") != -1) {
                Trace.out((String)"the service orafenceservice does not exist");
                serviceNotExistNodes.add(node);
            } else {
                ReportUtil.printError(errString.toString());
                Trace.out((String)("checkservice command has failed with error " + errString.toString()));
            }
            retVal = false;
        }
        if (incorrectServiceTypeNodes.size() > 0) {
            errMsg = s_gMsgBundle.getMessage("12915", true, (Object[])new String[]{this.ORAFENCE_SERVICE, VerificationUtil.strList2List(incorrectServiceTypeNodes)});
            errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(incorrectServiceTypeNodes, errorDesc);
            this.m_resultSet.addResult(incorrectServiceTypeNodes, 3);
            ReportUtil.printError(errMsg);
        }
        if (incorrectStartTypeNodes.size() > 0) {
            errMsg = s_gMsgBundle.getMessage("12916", true, (Object[])new String[]{this.ORAFENCE_SERVICE, VerificationUtil.strList2List(incorrectStartTypeNodes)});
            errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(incorrectStartTypeNodes, errorDesc);
            this.m_resultSet.addResult(incorrectStartTypeNodes, 3);
            ReportUtil.printError(errMsg);
        }
        if (serviceNotRunningNodes.size() > 0) {
            errMsg = s_gMsgBundle.getMessage("12917", true, (Object[])new String[]{this.ORAFENCE_SERVICE, VerificationUtil.strList2List(serviceNotRunningNodes)});
            errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(serviceNotRunningNodes, errorDesc);
            this.m_resultSet.addResult(serviceNotRunningNodes, 3);
            ReportUtil.printError(errMsg);
        }
        if (serviceNotExistNodes.size() > 0) {
            errMsg = s_gMsgBundle.getMessage("12918", true, (Object[])new String[]{this.ORAFENCE_SERVICE, VerificationUtil.strList2List(serviceNotExistNodes)});
            errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(serviceNotExistNodes, errorDesc);
            this.m_resultSet.addResult(serviceNotExistNodes, 2);
            ReportUtil.printError(errMsg);
        }
        return retVal;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("12910", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("12911", false);
    }
}

