/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskCheckFirewallSetting {
    private String m_regKey = "HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\SharedAccess\\Parameters\\FirewallPolicy\\";
    private final String[] profiles = new String[]{"StandardProfile", "DomainProfile"};
    private String m_regValName = "EnableFirewall";
    private String[] m_nodeList = null;
    private ClusterWindows clusterWindows = null;
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static MessageBundle s_fMsgBundle = VerificationUtil.getMessageBundle("Prvf");

    public sTaskCheckFirewallSetting(String[] nodeList) {
        this.m_nodeList = nodeList;
    }

    public boolean performTask(ResultSet fwResultSet) {
        boolean result = false;
        int keyValueData = 0;
        String errMsg = null;
        Trace.out((String)"Performing Firewall status verification task for Windows... ");
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("5902", false));
        try {
            this.clusterWindows = new ClusterWindows();
        }
        catch (ClusterException e) {
            Trace.out((String)("Failed to create ClusterWindows " + e.getMessage()));
            errMsg = s_gMsgBundle.getMessage("5904", true);
            fwResultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(errMsg + e.getMessage()));
            fwResultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        Trace.out((String)"Performing Firewall status verification ...");
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            boolean firewallEnabled = false;
            for (String profile : this.profiles) {
                if (firewallEnabled) continue;
                String keyPath = this.m_regKey + profile;
                try {
                    result = this.clusterWindows.regKeyExistsOnNode(keyPath, this.m_nodeList[i]);
                }
                catch (ClusterException ce) {
                    Trace.out((String)("Could not read Registry subkey " + keyPath + " error : " + ce.getMessage()));
                    errMsg = s_gMsgBundle.getMessage("5909", true, (Object[])new String[]{keyPath, this.m_nodeList[i]});
                    fwResultSet.addErrorDescription(this.m_nodeList[i], new ErrorDescription(errMsg));
                    fwResultSet.addResult(this.m_nodeList[i], 2);
                    continue;
                }
                if (result) {
                    try {
                        keyValueData = this.clusterWindows.getRegIntegerDataOnNode(keyPath, this.m_regValName, this.m_nodeList[i]);
                    }
                    catch (ClusterException e) {
                        Trace.out((String)("Registry Value " + this.m_regValName + " not found under subkey " + keyPath + " error : " + e.getMessage()));
                        errMsg = s_gMsgBundle.getMessage("5910", true, (Object[])new String[]{keyPath, this.m_nodeList[i]});
                        fwResultSet.addErrorDescription(this.m_nodeList[i], new ErrorDescription(errMsg));
                        fwResultSet.addResult(this.m_nodeList[i], 2);
                        continue;
                    }
                    if (keyValueData == 1) {
                        firewallEnabled = true;
                        errMsg = s_gMsgBundle.getMessage("5906", true, (Object[])new String[]{this.m_nodeList[i]});
                        fwResultSet.addErrorDescription(this.m_nodeList[i], new ErrorDescription(errMsg));
                        fwResultSet.addResult(this.m_nodeList[i], 3);
                        continue;
                    }
                    if (keyValueData != 0 || firewallEnabled) continue;
                    fwResultSet.addResult(this.m_nodeList[i], 1);
                    continue;
                }
                Trace.out((String)("Could not read Registry subkey " + keyPath));
                errMsg = s_gMsgBundle.getMessage("5909", true, (Object[])new String[]{keyPath, this.m_nodeList[i]});
                fwResultSet.addErrorDescription(this.m_nodeList[i], new ErrorDescription(errMsg));
                fwResultSet.addResult(this.m_nodeList[i], 2);
            }
        }
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, s_fMsgBundle.getMessage("5207", false), ReportUtil.COMMENT);
        Hashtable ht = fwResultSet.getResultTable();
        Enumeration e = ht.keys();
        Vector<String> verFailedNodes = new Vector<String>();
        Vector<String> opFailedNodes = new Vector<String>();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result msResult = (Result)ht.get(node);
            if (msResult.getStatus() == 1) {
                fwResultSet.getResult(node).setHasResultValues(true);
                fwResultSet.getResult(node).setExpectedValue(s_fMsgBundle.getMessage("8134", false));
                fwResultSet.getResult(node).setActualValue(s_fMsgBundle.getMessage("8134", false));
                Trace.out((String)("Result.OPERATION_SUCCESSFUL:: Firewall is Disabled on Node " + node));
                ReportUtil.writeRecord(node, ReportUtil.NO, ReportUtil.PASSED);
                continue;
            }
            if (msResult.getStatus() == 3) {
                fwResultSet.getResult(node).setHasResultValues(true);
                fwResultSet.getResult(node).setExpectedValue(s_fMsgBundle.getMessage("8134", false));
                fwResultSet.getResult(node).setActualValue(s_fMsgBundle.getMessage("8133", false));
                Trace.out((String)("Result.VERIFICATION_FAILED:: Firewall is Enabled on Node " + node));
                ReportUtil.writeRecord(node, ReportUtil.YES, ReportUtil.FAILED);
                verFailedNodes.add(node);
                continue;
            }
            Trace.out((String)"Result.OPERATION FAILED:: cannot perform Firewall status check");
            ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, ReportUtil.FAILED);
            opFailedNodes.add(node);
        }
        if (fwResultSet.allSuccess()) {
            ReportUtil.printResult(s_gMsgBundle.getMessage("5903", false));
            return true;
        }
        if (verFailedNodes.size() > 0) {
            ReportUtil.printErrorWithNodes(s_gMsgBundle.getMessage("5905", true), verFailedNodes);
        }
        if (opFailedNodes.size() > 0) {
            ReportUtil.printErrorWithNodes(s_gMsgBundle.getMessage("5907", true), opFailedNodes);
        }
        ReportUtil.printResult(s_gMsgBundle.getMessage("5904", false));
        return false;
    }

    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("5900", false);
    }

    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("5901", false);
    }
}

