/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.ServiceConfiguration;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskCheckAntivirus
extends Task {
    public sTaskCheckAntivirus(VerificationTaskContext ctx) {
        super(ctx);
        this.setSeverity(SeverityType.IGNORABLE);
    }

    public sTaskCheckAntivirus(String[] nodeList) {
        super(nodeList);
        this.setSeverity(SeverityType.IGNORABLE);
    }

    @Override
    public boolean performTask() {
        this.m_resultSet.addResult(this.m_nodeList, 1);
        return this.checkAntivirusSettings();
    }

    private boolean checkAntivirusSettings() {
        GlobalExecution globalExec = new GlobalExecution();
        ArrayList<String> verificationFailedNodes = new ArrayList<String>();
        String errMsg = null;
        Trace.out((String)"Checking if there is any antivirus software running on the nodes");
        ReportUtil.println(s_gMsgBundle.getMessage("12899", false));
        String avCSV = VerificationUtil.getAntiVirusList();
        if (!VerificationUtil.isStringGood(avCSV)) {
            errMsg = s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"def_antivirus_service_names-expected"});
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
            ReportUtil.printError(errMsg);
            return false;
        }
        Trace.out((String)("The list of antivirus service names is: " + avCSV));
        String[] avList = avCSV.split(",");
        boolean retVal = true;
        for (String avID : avList) {
            ResultSet avrs = new ResultSet();
            boolean avVal = true;
            Trace.out((String)("Checking if the antivirus service <" + avID + "> is running on any the nodes"));
            globalExec.checkService(this.m_nodeList, avID, avrs);
            Hashtable ht = avrs.getResultTable();
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                String node = (String)e.nextElement();
                Result result = (Result)ht.get(node);
                Vector servList = result.getResultInfoSet();
                Trace.out((String)("result for node " + node + "  " + ((Object)servList).toString()));
                if (result.getStatus() == 1) {
                    Trace.out((String)("execution of checkservice command on node " + node + " results " + ((Object)servList).toString()));
                    if (servList.contains((Object)ServiceConfiguration.ServiceRunning)) {
                        Trace.out((String)("The antivirus with the service id <" + avID + "> is running on node " + node));
                        VerificationLogData.logError("The antivirus with the service id <" + avID + "> is running on node " + node);
                        if (!verificationFailedNodes.contains(node)) {
                            verificationFailedNodes.add(node);
                        }
                        avVal = false;
                        retVal = false;
                        continue;
                    }
                    Trace.out((String)("The antivirus with the service id <" + avID + "> is not running on node " + node));
                    continue;
                }
                Trace.out((String)("checkservice command execution failed on node " + node));
                StringBuilder errString = new StringBuilder();
                List<VerificationError> errList = result.getErrors();
                for (VerificationError err : errList) {
                    errString.append(err.getErrorMessage());
                    errString.append(VerificationConstants.LSEP);
                }
                if (errString.indexOf("1060") != -1) {
                    Trace.out((String)("The antivirus service " + avID + " does not exists"));
                    continue;
                }
                Trace.out((String)("The command exectask -checkservice " + avID + ", has failed on node " + node + " with error " + errString.toString()));
                ReportUtil.printError(errString.toString());
                this.m_resultSet.addResult(node, 2);
                avVal = false;
                retVal = false;
            }
            if (!avVal) continue;
            Trace.out((String)("The antivirus with the service id <" + avID + "> is not running on any node"));
        }
        if (retVal) {
            Trace.out((String)"None of the listed antivirus was found running on any node");
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("12900", false));
        } else if (verificationFailedNodes.size() > 0) {
            String[] failedNodes = verificationFailedNodes.toArray(new String[verificationFailedNodes.size()]);
            this.m_resultSet.addResult(failedNodes, 4);
            errMsg = s_msgBundle.getMessage("9990", true);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(failedNodes, errDesc);
            ReportUtil.printError(errMsg);
            ReportUtil.printErrorWithNodes(errMsg, failedNodes);
        }
        return retVal;
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("12901", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("12902", false);
    }
}

