/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.Home;
import oracle.cluster.winsecurity.WinSecurityFactory;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskVerifyServiceUser;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskVerifyServiceUser
extends Task {
    private Credentials m_credentials = null;
    private sTaskVerifyServiceUser m_sTaskServiceUser = null;
    private boolean m_isPostDBInst = false;

    public TaskVerifyServiceUser(VerificationTaskContext ctx) {
        super(ctx);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void init() {
        this.m_isPostDBInst = this.m_globalContext.getVerificationType().equals((Object)VerificationType.PREREQ_DB_CONFIG);
        String username = null;
        String password = null;
        if (this.m_isPostDBInst) {
            boolean isUserSpecifiedPwd = false;
            if (VerificationUtil.isCLIMode() && this.m_globalContext.isServicePwdSpecifiedOnCLI()) {
                Trace.out((String)"cmd line mode with passwd");
                password = CVUVariables.getValue(CVUVariableConstants.SERVICEPWD);
                isUserSpecifiedPwd = true;
            }
            if (VerificationUtil.isAPIMode() && (password = CVUVariables.getValue(CVUVariableConstants.ORACLE_SERVICE_USER_PASSWORD)) != null) {
                Trace.out((String)"API line mode with passwd");
                isUserSpecifiedPwd = true;
            }
            String destloc = VerificationUtil.getDestLoc();
            String srcloc = VerificationUtil.getCVHome();
            try {
                String oracleHome = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
                if (oracleHome == null) return;
                if (oracleHome.length() == 0) {
                    return;
                }
                WinSecurityFactory wsecFac = WinSecurityFactory.getInstance((String)srcloc, (String)destloc);
                Home home = wsecFac.getHome(oracleHome, new Version());
                this.m_credentials = home.isServiceUserLocalService() ? new Credentials(Credentials.BuiltinUser.LOCALSERVICE) : (home.isServiceUserLocalSystem() ? new Credentials(Credentials.BuiltinUser.LOCALSYSTEM) : home.getServiceUserFromHomePath());
                if (!isUserSpecifiedPwd) return;
                this.m_credentials.setPassword(password);
                return;
            }
            catch (WindowsSecurityException e) {
                Trace.out((String)("WSE while creating verify service user task" + e.getMessage()));
                return;
            }
        }
        if (VerificationUtil.isCLIMode()) {
            if (!this.m_globalContext.isServiceUserSpecifiedOnCLI()) {
                Trace.out((String)"Commmand line mode with no service user credentials.");
                return;
            }
            username = CVUVariables.getValue(CVUVariableConstants.SERVICE_USER);
            if (this.m_globalContext.isServicePwdSpecifiedOnCLI()) {
                password = CVUVariables.getValue(CVUVariableConstants.SERVICEPWD);
            }
        } else if (VerificationUtil.isAPIMode()) {
            String strBuiltinUser = CVUVariables.getValue(CVUVariableConstants.IS_BUILTIN_ACCOUNT);
            String strVirtualUser = CVUVariables.getValue(CVUVariableConstants.IS_VIRTUAL_ACCOUNT);
            if ("TRUE".equalsIgnoreCase(strVirtualUser)) {
                Trace.out((String)"virtual account. Home name will not be available. So skipping the check");
                return;
            }
            if ("TRUE".equalsIgnoreCase(strBuiltinUser)) {
                try {
                    this.m_credentials = new Credentials(Credentials.BuiltinUser.LOCALSYSTEM);
                    return;
                }
                catch (WindowsSecurityException e) {
                    Trace.out((String)("Exception while creating credential store for LOCALSYSTEM user. Shouldn't have happened:" + e.getMessage()));
                }
                return;
            }
            String strSvcUserExists = CVUVariables.getValue(CVUVariableConstants.IS_ORACLE_SERVICE_USER_EXISTS);
            if ("FALSE".equalsIgnoreCase(strSvcUserExists)) {
                Trace.out((String)"user does not exist. So nothing to check currently");
                return;
            }
            username = CVUVariables.getValue(CVUVariableConstants.WINSEC_SERVICE_USERNAME);
            password = CVUVariables.getValue(CVUVariableConstants.WINSEC_SERVICE_PASSWORD);
            if (username == null) {
                Trace.out((String)"API Mode with no service user credentials. returning");
                return;
            }
        }
        try {
            if (!VerificationUtil.isStringGood(password)) {
                this.m_credentials = new Credentials(username);
                return;
            }
            this.m_credentials = new Credentials(username, password);
            return;
        }
        catch (WindowsSecurityException e) {
            Trace.out((String)e.getMessage());
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        String reqRel = VerificationUtil.getRequestedRelease();
        if (reqRel != null && (reqRel.equalsIgnoreCase("10gR1") || reqRel.equalsIgnoreCase("10gR2") || reqRel.equalsIgnoreCase("11gR1") || reqRel.equalsIgnoreCase("11gR2"))) {
            Trace.out((String)"DB version earlier than 12.1, Not adding service user verification");
            return false;
        }
        return this.m_credentials != null;
    }

    public TaskVerifyServiceUser(String[] nodeList, Credentials credentials, boolean isPostDBInst) {
        super(nodeList);
        this.setSeverity(SeverityType.IGNORABLE);
        this.m_credentials = credentials;
        this.m_isPostDBInst = isPostDBInst;
    }

    @Override
    public boolean performTask() {
        this.m_sTaskServiceUser = new sTaskVerifyServiceUser(this.m_nodeList, this.m_credentials, this.m_resultSet, this.m_isPostDBInst);
        return this.m_sTaskServiceUser.performTask();
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("4501", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("4502", false);
    }
}

