/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskUserMask
extends Task {
    private String m_umask;
    private String[] m_curnodelist;

    public TaskUserMask(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        this.m_umask = VerificationUtil.getDefaultUmask();
        this.m_curnodelist = this.m_nodeList;
        VerificationType vfyType = this.m_globalContext.getVerificationType();
        if (vfyType != null) {
            switch (vfyType) {
                case PREREQ_NODE_ADD: 
                case PREREQ_RACNODE_ADD: {
                    this.m_curnodelist = VerificationUtil.addLocalNodeToNodeList(this.m_nodeList);
                }
            }
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (VerificationType.PREREQ_CRS_INST.equals((Object)this.m_globalContext.getVerificationType()) && VerificationUtil.isBaselineCollectionMode()) {
            return false;
        }
        return !VerificationUtil.isCVUTestEnv();
    }

    public TaskUserMask(String[] nodeList, String umask) {
        this.m_umask = umask;
        this.m_curnodelist = nodeList;
    }

    @Override
    public boolean performTask() {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet umaskRsltSet = new ResultSet();
        globalExec.checkUserMask(this.m_curnodelist, this.m_umask, umaskRsltSet);
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1071", false));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.COMMENT);
        Hashtable t = umaskRsltSet.getResultTable();
        Enumeration e = t.keys();
        String orclUser = VerificationUtil.getDefaultOracleUser();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String avl;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            CollectionElement collectionElement = new CollectionElement(this.getElementName(), null, this.m_umask, null, this.getDefaultDescription(), 5);
            this.m_resultSet.addCollectionElement(node, collectionElement);
            if (m_localNode.equalsIgnoreCase(node)) {
                String localNodeUmaskFromCVUSysProp = VerificationUtil.getLocalNodeUmaskFromCVUSystemProperty();
                if (VerificationUtil.isStringGood(localNodeUmaskFromCVUSysProp)) {
                    avl = localNodeUmaskFromCVUSysProp;
                    Trace.out((String)("Found local node user mask property set via CVU's OS setting variable as (" + avl + ") and hence using it."));
                    VerificationLogData.log("Found local node user mask property set via CVU's OS setting variable as (" + avl + ") and hence using it.");
                    result = new Result(node);
                    result.addResultInfo(avl);
                    if (Integer.valueOf(avl).equals(Integer.valueOf(this.m_umask))) {
                        result.setStatus(1);
                    } else {
                        result.setStatus(3);
                    }
                } else {
                    Trace.out((String)"Local node user mask property was NOT found set via CVU's OS setting variable by installer or caller, Using the retrieved value to proceed with check.");
                    VerificationLogData.log("Local node user mask property was NOT found set via CVU's OS setting variable by installer or caller, Using the retrieved value from node to proceed with check.");
                }
            }
            this.m_resultSet.addResult(node, result.getStatus());
            collectionElement.setStatus(result.getStatus());
            if (result.getStatus() == 1) {
                avl = (String)result.getResultInfoSet().firstElement();
                Trace.out((String)("Result.OPERATION_SUCCESSFUL:: available umask=" + avl));
                ReportUtil.writeRecord(node, avl, this.m_umask, ReportUtil.PASSED);
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(this.m_umask);
                this.m_resultSet.getResult(node).setActualValue(avl);
                collectionElement.setValue(avl);
                continue;
            }
            if (result.getStatus() == 2) {
                Trace.out((String)("FAILED:: result.getStatus()=" + result.getStatus()));
                ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, this.m_umask, ReportUtil.FAILED);
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7612", true, (Object[])new String[]{orclUser, node}), s_msgBundle, "7612");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                collectionElement.addErrorDescription(errDesc);
                continue;
            }
            if (result.getStatus() != 3) continue;
            avl = (String)result.getResultInfoSet().firstElement();
            Trace.out((String)("Result.VERIFICATION_FAILED:: retrieved umask=" + avl));
            ReportUtil.writeRecord(node, avl, this.m_umask, ReportUtil.FAILED);
            errDesc = new ErrorDescription(s_msgBundle.getMessage("7611", true, (Object[])new String[]{orclUser, node, this.m_umask, avl}), s_msgBundle, "7611");
            this.m_resultSet.getResult(node).setHasResultValues(true);
            this.m_resultSet.getResult(node).setExpectedValue(this.m_umask);
            this.m_resultSet.getResult(node).setActualValue(avl);
            this.m_resultSet.getResult(node).addErrorDescription(errDesc);
            collectionElement.setValue(avl);
            collectionElement.addErrorDescription(errDesc);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1072", false));
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1073", false));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    @Override
    public String getTaskID() {
        return "CHECK_USER_MASK";
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4565", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4564", false, (Object[])new String[]{this.m_umask});
    }

    public String getElementDisplayName() {
        return s_msgBundle.getMessage("1071", false);
    }
}

