/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.fixup.FixupData;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.ContainerTaskInterface;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskPeerCompatibility;
import oracle.ops.verification.framework.engine.task.TaskUsersWithSameID;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.UnixGroup;
import oracle.ops.verification.framework.util.UnixUser;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskUserExistence
extends TaskPeerCompatibility
implements ContainerTaskInterface,
PeerCompatibleTask {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1059", false);
    private static TaskUserExistence m_containerObj = null;
    private List<Task> m_subTaskList = new ArrayList<Task>();
    private boolean m_returnVal = true;
    private boolean m_isInitialized = false;
    private String m_user;
    private Hashtable<Object, Vector<Object>> usrIdTable;
    private boolean m_isUIDInconsistent = false;
    private Hashtable<String, UnixUser> m_nodeUserInfoTable;

    public TaskUserExistence(VerificationTaskContext ctx) {
        super(ctx);
        if (m_containerObj == null) {
            m_containerObj = new TaskUserExistence();
        }
    }

    @Override
    protected void init() {
        if (!this.m_isInitialized) {
            if (this.m_ctx != null) {
                VerificationType vType = this.m_globalContext.getVerificationType();
                switch (vType) {
                    case PREREQ_NODE_ADD: 
                    case PREREQ_RACNODE_ADD: {
                        Trace.out((String)"Node add scenario, considering the newly being added nodes for the user existence check");
                        this.m_ctx.setNodeList(VerificationUtil.addLocalNodeToNodeList(this.m_nodeList));
                    }
                }
                ExecutableInfo execInfo = this.m_ctx.getExecInfo();
                if (execInfo != null) {
                    String userListStr = null;
                    for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
                        String argName = arg.getArgName();
                        String argVal = arg.getArgVal(true);
                        if ("USERS".equals(argName)) {
                            userListStr = argVal;
                            continue;
                        }
                        Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
                    }
                    if (VerificationUtil.isStringGood(userListStr)) {
                        String[] userList;
                        for (String user : userList = VerificationUtil.string2strArr(userListStr)) {
                            Trace.out((String)("Adding user existence check for user (" + user + ")"));
                            m_containerObj.addTaskToContainer(new TaskUserExistence(this.m_ctx, user));
                        }
                    }
                }
            } else {
                this.m_ctx = new VerificationTaskContext(this.m_nodeList);
            }
            this.m_isInitialized = true;
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (!this.m_subTaskList.isEmpty()) {
            ArrayList<Task> applicableList = new ArrayList<Task>();
            for (Task t : this.m_subTaskList) {
                if (t.isApplicable()) {
                    Trace.out((String)(t.getTaskName() + " is applicable from this container."));
                    applicableList.add(t);
                    continue;
                }
                Trace.out((String)(t.getTaskName() + " is NOT applicable from this container."));
            }
            this.m_subTaskList.clear();
            this.m_subTaskList.addAll(applicableList);
            return !this.m_subTaskList.isEmpty();
        }
        return VerificationUtil.isStringGood(this.m_user);
    }

    private TaskUserExistence() {
    }

    private TaskUserExistence(Collection<Task> subTaskList) {
        this.m_subTaskList.addAll(subTaskList);
    }

    private TaskUserExistence(String user, String[] nodeList) {
        this(new VerificationTaskContext(nodeList), user);
    }

    public static TaskUserExistence generate(String user, String[] nodeList) {
        return TaskUserExistence.generate(user, nodeList, true);
    }

    public static TaskUserExistence generate(String user, String[] nodeList, boolean addToContainer) {
        if (!VerificationUtil.isStringGood(user)) {
            VerificationUtil.traceAndLogError("An attempt was made to instantiate user existence check with null user (" + user + ") name");
            return null;
        }
        if (!addToContainer) {
            return new TaskUserExistence(user, nodeList);
        }
        if (m_containerObj == null) {
            m_containerObj = new TaskUserExistence();
        }
        return (TaskUserExistence)m_containerObj.addTaskToContainer(new TaskUserExistence(user, nodeList));
    }

    @Override
    public void setNodeList(String[] nodeList) {
        this.m_nodeList = nodeList;
        for (Task t : this.m_subTaskList) {
            t.setNodeList(this.m_nodeList);
        }
    }

    private TaskUserExistence(VerificationTaskContext ctx, String user) {
        super(ctx);
        this.m_user = user;
    }

    @Override
    public boolean performTask() {
        if (this.m_resultSet.getStatus() == 5) {
            this.m_returnVal = this.performTaskInternal();
        } else {
            Trace.out((String)"This task was performed earlier, returning based on earlier result");
            this.m_resultSet.traceResultSet("RESULT From earlier execution of this task");
        }
        return this.m_returnVal;
    }

    private boolean performTaskInternal() {
        boolean oraDevEnv;
        ErrorDescription errDesc;
        this.usrIdTable = new Hashtable();
        this.m_nodeUserInfoTable = new Hashtable();
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet usrRsltSet = new ResultSet();
        globalExec.checkUser(this.m_nodeList, this.m_user, usrRsltSet);
        this.m_resultSet.addResultSetData(usrRsltSet);
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_user}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.COMMENT);
        String usrID = new String("");
        Hashtable ht = usrRsltSet.getResultTable();
        Enumeration<Object> e = ht.keys();
        while (e.hasMoreElements()) {
            String comment;
            String usrStatus;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            result.setHasResultValues(true);
            result.setExpectedValue(Boolean.toString(true));
            if (result.getStatus() == 1) {
                usrStatus = ReportUtil.PASSED;
                usrID = (String)result.getResultInfoSet().elementAt(1);
                comment = ReportUtil.EXIST + "(" + usrID + ")";
                VerificationUtil.updateResultMap(this.usrIdTable, usrID, node);
                result.setActualValue(Boolean.toString(true));
                UnixUser userInfo = new UnixUser(this.m_user, usrID);
                if (result.getResultInfoSet().size() > 2) {
                    String grpName = (String)result.getResultInfoSet().elementAt(2);
                    String grpID = (String)result.getResultInfoSet().elementAt(3);
                    UnixGroup group = new UnixGroup(grpName, grpID);
                    userInfo.setPrimaryGroup(group);
                }
                this.m_nodeUserInfoTable.put(node, userInfo);
            } else if (result.getStatus() == 3) {
                comment = ReportUtil.NOTEXIST;
                usrStatus = ReportUtil.FAILED;
                errDesc = new ErrorDescription(VerificationUtil.getMsgWithExecutionDetails(s_msgBundle.getMessage("7537", true, (Object[])new String[]{this.m_user, node}), result));
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                result.setActualValue(Boolean.toString(false));
            } else {
                usrStatus = ReportUtil.UNKNOWN;
                comment = ReportUtil.UNKNOWN;
                errDesc = new ErrorDescription(VerificationUtil.getMsgWithExecutionDetails(s_msgBundle.getMessage("7538", true, (Object[])new String[]{node}), result));
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
            }
            ReportUtil.writeRecord(node, usrStatus, comment);
        }
        if (this.usrIdTable.size() > 1) {
            this.m_isUIDInconsistent = true;
            String errorMsg = s_msgBundle.getMessage("4123", true, (Object[])new String[]{this.m_user});
            ReportUtil.printError(errorMsg);
            errDesc = new ErrorDescription(errorMsg, s_msgBundle, "4123");
            this.m_resultSet.addErrorDescription(errDesc);
            e = this.usrIdTable.keys();
            StringBuffer usrIdsDisplayString = new StringBuffer();
            boolean first = true;
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Vector<Object> nodeVector = this.usrIdTable.get(key);
                String nodes = VerificationUtil.strVect2List(nodeVector);
                if (first) {
                    first = false;
                    usrIdsDisplayString.append("[");
                } else {
                    usrIdsDisplayString.append("; ");
                }
                usrIdsDisplayString.append(key + ":" + nodes);
                String errorMessage = s_msgBundle.getMessage("4124", false, (Object[])new String[]{key, nodes});
                ReportUtil.sureprintln(errorMessage);
            }
            usrIdsDisplayString.append("]");
            ErrorDescription usrIdsED = new ErrorDescription(errorMsg + " " + usrIdsDisplayString.toString(), s_msgBundle, "4123");
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, usrIdsED);
        } else if (this.usrIdTable.size() == 1 && !(oraDevEnv = VerificationUtil.isCVUTestEnv())) {
            TaskUsersWithSameID taskUsers = new TaskUsersWithSameID(this.m_nodeList, usrID);
            this.addChildTask(taskUsers);
            taskUsers.perform();
            this.m_resultSet.addResultSetData(taskUsers.getResultSet());
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_user}));
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0306", false, (Object[])new String[]{this.m_user}));
            return true;
        }
        if (this.isFixupReqd() && !this.m_isUIDInconsistent) {
            this.generateFixups();
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_user}));
        this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0307", false, (Object[])new String[]{this.m_user, VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        ReportUtil.reportAllerrors(this.m_resultSet);
        return false;
    }

    @Override
    public String getTaskID() {
        return "CHECK_USER_EXISTENCE";
    }

    @Override
    public String getTaskName() {
        return VerificationUtil.isStringGood(this.m_user) ? this.getTaskID() + "_" + this.m_user : this.getTaskID();
    }

    @Override
    public String getDefaultElementName() {
        if (VerificationUtil.isStringGood(this.m_user)) {
            return s_msgBundle.getMessage("4421", false) + ": " + this.m_user;
        }
        return s_msgBundle.getMessage("4421", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4472", false, (Object[])new String[]{this.m_user});
    }

    private void generateFixups() {
        FixupData fixData;
        if (!new SystemFactory().CreateSystem().isUnixSystem()) {
            return;
        }
        String uniqueIDOfInterest = null;
        if (this.usrIdTable.size() > 0) {
            Set<Object> idSet = this.usrIdTable.keySet();
            int maxNumOfnodesWithID = 0;
            for (Object id : idSet) {
                if (this.usrIdTable.get(id).size() <= maxNumOfnodesWithID) continue;
                maxNumOfnodesWithID = this.usrIdTable.get(id).size();
                uniqueIDOfInterest = (String)id;
            }
        }
        if (null != (fixData = this.createFixupData(uniqueIDOfInterest))) {
            this.setFixupData(fixData);
        }
    }

    private FixupData createFixupData(String userID) {
        FixupData fixUserData = new FixupData(null);
        ArrayList<String> createUserNodeList = new ArrayList<String>();
        ArrayList<String> updateUserNodeList = new ArrayList<String>();
        ArrayList userExistsNodeList = new ArrayList();
        if (VerificationUtil.isStringGood(userID) && this.usrIdTable.size() > 0 && this.usrIdTable.containsKey(userID)) {
            userExistsNodeList.addAll(this.usrIdTable.get(userID));
        }
        for (String node : this.m_nodeList) {
            if (userExistsNodeList.contains(node)) continue;
            if (this.usrIdTable.containsValue(node)) {
                updateUserNodeList.add(node);
                continue;
            }
            createUserNodeList.add(node);
        }
        if (!VerificationUtil.isStringGood(userID)) {
            GlobalExecution global = new GlobalExecution();
            ResultSet getIDResultSet = new ResultSet();
            List<String> uniqueIDList = global.getUniqueUID(createUserNodeList.toArray(new String[0]), 1, getIDResultSet);
            if (uniqueIDList.size() > 0) {
                userID = uniqueIDList.get(0);
            }
            if (!VerificationUtil.isStringGood(userID)) {
                List<String> failedNodesList = getIDResultSet.getFailedNodes();
                if (failedNodesList.size() == 0) {
                    failedNodesList.addAll(createUserNodeList);
                }
                for (String node : failedNodesList) {
                    fixUserData.addFixupGenerationFailedNode(node, new ErrorDescription(s_gMsgBundle.getMessage("9040", true, (Object[])new String[]{node})));
                }
                return fixUserData;
            }
        }
        fixUserData.addParticipatingNodes(createUserNodeList);
        fixUserData.addParticipatingNodes(updateUserNodeList);
        fixUserData.addFixupInstruction("USER", this.m_user);
        fixUserData.addFixupInstruction("UID", userID);
        if (!this.m_nodeUserInfoTable.isEmpty()) {
            UnixUser userForPrimaryGrpInfo = null;
            if (this.m_nodeUserInfoTable.containsKey(m_localNode) && this.m_nodeUserInfoTable.get(m_localNode).getUid().equals(userID)) {
                userForPrimaryGrpInfo = this.m_nodeUserInfoTable.get(m_localNode);
            } else {
                for (String node : this.m_nodeUserInfoTable.keySet()) {
                    if (!this.m_nodeUserInfoTable.get(node).getUid().equals(userID)) continue;
                    userForPrimaryGrpInfo = this.m_nodeUserInfoTable.get(node);
                    break;
                }
            }
            if (userForPrimaryGrpInfo != null && userForPrimaryGrpInfo.getPrimaryGroup() != null && userForPrimaryGrpInfo.getUid().equals(userID)) {
                UnixGroup group = userForPrimaryGrpInfo.getPrimaryGroup();
                fixUserData.addFixupInstruction("GROUP", group.getName());
                fixUserData.addFixupInstruction("GID", group.getId());
            }
        }
        String message = "Created fixup with \n User name (" + this.m_user + ")" + "\n User ID (" + userID + ")" + (createUserNodeList.size() > 0 ? "\n to create the user on nodes " + createUserNodeList : "") + (updateUserNodeList.size() > 0 ? "\n to update the user on nodes " + updateUserNodeList : "");
        Trace.out((String)message);
        VerificationLogData.logInfo(message);
        return fixUserData;
    }

    @Override
    public ResultSet performPeer() throws VerificationException {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet usrRsltSet = new ResultSet();
        globalExec.checkUser(this.m_nodeList, this.m_user, usrRsltSet);
        Hashtable ht = usrRsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                String userID = (String)result.getResultInfoSet().elementAt(1);
                result.getResultInfoSet().add(0, this.m_user + "(" + userID + ")");
                continue;
            }
            if (result.getStatus() != 3) continue;
            result.getResultInfoSet().add(0, ReportUtil.NOTEXIST);
            result.setStatus(1);
        }
        return usrRsltSet;
    }

    @Override
    public String getElementDisplayName() {
        return s_msgBundle.getMessage("9977", false, (Object[])new String[]{this.m_user});
    }

    @Override
    public Task addTaskToContainer(Task t) {
        Task taskObj = t;
        boolean addTask = true;
        for (Task uet : this.m_subTaskList) {
            if (!TaskUserExistence.compare((TaskUserExistence)t, (TaskUserExistence)uet)) continue;
            Trace.out((String)("Found an existing instance of user existence check for user (" + ((TaskUserExistence)t).getUserName() + ") on nodes " + VerificationUtil.strArr2List(uet.getNodeList())));
            taskObj = uet;
            addTask = false;
        }
        if (addTask) {
            this.m_subTaskList.add(t);
        }
        return taskObj;
    }

    public String getUserName() {
        return this.m_user;
    }

    @Override
    public boolean hasSubtasks() {
        return !this.m_subTaskList.isEmpty();
    }

    @Override
    public List<VerificationTask> getSubtasks() throws SubtasksUnavailableException {
        ArrayList<VerificationTask> listOfSubtasks = new ArrayList<VerificationTask>();
        if (this.m_subTaskList.isEmpty()) {
            throw new SubtasksUnavailableException(s_msgBundle.getMessage("7504", false));
        }
        for (Task t : this.m_subTaskList) {
            listOfSubtasks.add(t);
        }
        return listOfSubtasks;
    }

    @Override
    public boolean isContainerTask() {
        if (m_containerObj != null) {
            this.init();
            return true;
        }
        return false;
    }

    private static boolean compare(TaskUserExistence t1, TaskUserExistence t2) {
        return t1.getUserName().trim().equalsIgnoreCase(t2.getUserName().trim()) && VerificationUtil.compareStringCollections(t1.getNodeList(), t2.getNodeList(), true, true);
    }

    private Collection<Task> getSubtaskList() {
        HashMap<String, Task> finalSubTaskList = new HashMap<String, Task>();
        for (Task t : this.m_subTaskList) {
            String userName = ((TaskUserExistence)t).getUserName();
            if (finalSubTaskList.containsKey(userName)) {
                String[] addedTaskNodeList = ((Task)finalSubTaskList.get(userName)).getNodeList();
                String[] currentTaskNodeList = t.getNodeList();
                Trace.out((String)("The user existence check for user (" + userName + ") has multiple instances with node set as following:\n" + VerificationUtil.strArr2List(addedTaskNodeList) + "\n" + VerificationUtil.strArr2List(currentTaskNodeList) + "\n Consolidating the multiple instances with their node list" + " to generate one instance of the user existence."));
                HashSet<String> consolidatesNodes = new HashSet<String>();
                consolidatesNodes.addAll(Arrays.asList(addedTaskNodeList));
                consolidatesNodes.addAll(Arrays.asList(currentTaskNodeList));
                finalSubTaskList.put(userName, new TaskUserExistence(userName, consolidatesNodes.toArray(new String[0])));
                continue;
            }
            finalSubTaskList.put(userName, t);
        }
        return finalSubTaskList.values();
    }

    @Override
    public Task getContainerObject() {
        return m_containerObj;
    }

    @Override
    public Task finalizeContainer() {
        Trace.out((String)"Finalizing the container.");
        TaskUserExistence container = new TaskUserExistence(m_containerObj.getSubtaskList());
        m_containerObj = null;
        return container;
    }
}

