/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.ShellLimitType;
import oracle.cluster.verification.ShellResourceType;
import oracle.cluster.verification.ShellType;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.fixup.FixupData;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskShellLimits;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.RangeOperator;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskShellLimits
extends Task {
    private ShellLimitType m_limitType;
    private ShellResourceType m_resourceType;
    private ShellLimitValue m_defaultLimitValue;
    private String ULIMIT_USER_NAME = null;
    private static HashMap<String, String> m_nodeLoginShellMap = new HashMap();
    private ResultSet m_loginShellRetrievalResultSet = null;
    private Hashtable<String, ShellLimitData> m_nodeExpectedLimitTable = null;
    private String m_localNodeResourceLimit = null;
    private static List<String> m_shellListForExplicitLimits = new ArrayList<String>();
    String ULIMIT_SOFTLIMIT_FILES = "SOFT_FILES";
    String ULIMIT_SOFTLIMIT_PROCESS = "SOFT_PROCESS";
    String ULIMIT_SOFTLIMIT_STACK = "SOFT_STACK";
    String ULIMIT_HARDLIMIT_FILES = "HARD_FILES";
    String ULIMIT_HARDLIMIT_PROCESS = "HARD_PROCESS";
    String ULIMIT_HARDLIMIT_STACK = "HARD_STACK";
    String ULIMIT_USER_ATTR = "USER";

    public TaskShellLimits(String[] nodeList, ShellType shellType, ShellResourceType resourceType, ShellLimitType limitType, long limit) {
        super(nodeList);
        ArrayList<ShellLimitData> shellSpecificLimits = new ArrayList<ShellLimitData>();
        shellSpecificLimits.add(new ShellLimitData(shellType.toString(), limit, SeverityType.CRITICAL, true));
        this.m_defaultLimitValue = new ShellLimitValue(limit, SeverityType.CRITICAL);
        this.initInternal(limitType, resourceType, shellSpecificLimits);
    }

    public TaskShellLimits(String[] nodeList, ShellLimitType limitType, ShellResourceType resourceType, ShellLimitValue defaultLimit, List<ShellLimitData> shellSpecificLimits) {
        super(nodeList);
        this.m_defaultLimitValue = defaultLimit;
        this.initInternal(limitType, resourceType, shellSpecificLimits);
    }

    @Override
    protected void init() {
        if (this.m_nodeList != null && this.m_nodeList.length > 0 && Arrays.asList(this.m_nodeList).contains(m_localNode)) {
            Result localNodeResLimitResult;
            String remoteNodeToUse = null;
            for (String node : this.m_nodeList) {
                if (m_localNode.equals(node)) continue;
                remoteNodeToUse = node;
                break;
            }
            Trace.out((String)"Attempting to obtain the local node Shell limits using SSH to local node approach.");
            if (VerificationUtil.isStringGood(remoteNodeToUse)) {
                Trace.out((String)("Remote node (" + remoteNodeToUse + ") will be used to SSH " + "local node if needed."));
            }
            if ((localNodeResLimitResult = new GlobalExecution().getLocalNodeResourceLimit(remoteNodeToUse, this.ULIMIT_USER_NAME, this.m_limitType.toString().toLowerCase(), this.m_resourceType.getItemName())).getStatus() == 1) {
                Vector resultInfo = localNodeResLimitResult.getResultInfoSet();
                if (resultInfo != null && !resultInfo.isEmpty()) {
                    this.m_localNodeResourceLimit = (String)resultInfo.elementAt(0);
                }
                if (VerificationUtil.isStringGood(this.m_localNodeResourceLimit)) {
                    this.m_localNodeResourceLimit = this.m_localNodeResourceLimit.trim();
                    Trace.out((String)("The (" + this.m_resourceType.getItemName() + ") resource (" + this.m_limitType.toString().toLowerCase() + ") limit on local node is (" + this.m_localNodeResourceLimit + ""));
                } else {
                    Trace.out((String)"Could not retrieve the resource limit for local node.");
                }
            }
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (VerificationUtil.isCVUResource() && ShellLimitType.SOFT == this.m_limitType && (this.m_resourceType == ShellResourceType.MAX_STACK_SIZE || this.m_resourceType == ShellResourceType.MAX_FILEDESC)) {
            Trace.out((String)("Skipping the soft " + this.m_resourceType.getItemName() + " shell limit check in CVU resource mode."));
            return false;
        }
        if (this.m_loginShellRetrievalResultSet.anyFailure() || this.m_nodeExpectedLimitTable != null && !this.m_nodeExpectedLimitTable.isEmpty()) {
            if (this.m_nodeList != null && Arrays.asList(this.m_nodeList).contains(m_localNode)) {
                if (VerificationUtil.isStringGood(this.m_localNodeResourceLimit)) {
                    return true;
                }
                Trace.out((String)"Actual resource limit could not be retrieved for the local node. Skipping the check...");
                return false;
            }
            return true;
        }
        return false;
    }

    private void initInternal(ShellLimitType limitType, ShellResourceType resourceType, List<ShellLimitData> shellSpecificLimits) {
        this.m_resourceType = resourceType;
        this.m_limitType = limitType;
        this.m_loginShellRetrievalResultSet = this.retrieveLoginShell(this.m_nodeList);
        this.m_resultSet.addResultSetData(this.m_loginShellRetrievalResultSet);
        this.m_nodeExpectedLimitTable = new Hashtable();
        for (String node : this.m_nodeList) {
            ShellLimitData data = this.getLimitForNode(node, shellSpecificLimits);
            if (data == null) continue;
            this.m_nodeExpectedLimitTable.put(node, data);
        }
        this.setSeverity();
        this.ULIMIT_USER_NAME = System.getProperty("user.name");
    }

    @Override
    public String getDefaultElementName() {
        if (ShellLimitType.HARD.equals((Object)this.m_limitType)) {
            return s_msgBundle.getMessage("4419", false) + ": " + (Object)((Object)this.m_resourceType);
        }
        return s_msgBundle.getMessage("4443", false) + ": " + (Object)((Object)this.m_resourceType);
    }

    @Override
    public boolean performTask() {
        String[] participatingNodeList;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Performing shell limit verification task... ");
        }
        if (!VerificationUtil.isPlatformLinux()) {
            this.setRebootRequiredForFixup(true);
        }
        ReportUtil.blankln();
        ReportUtil.println(this.getNLSMessage(MsgType.START));
        if (this.m_nodeExpectedLimitTable == null) {
            this.m_nodeExpectedLimitTable = new Hashtable();
            for (String node : this.m_nodeList) {
                if (!m_nodeLoginShellMap.containsKey(node)) continue;
                this.m_nodeExpectedLimitTable.put(node, new ShellLimitData(m_nodeLoginShellMap.get(node), this.m_defaultLimitValue, false));
            }
        }
        if ((participatingNodeList = this.m_nodeExpectedLimitTable.keySet().toArray(new String[0])) != null && participatingNodeList.length > 0) {
            if (participatingNodeList.length != this.m_nodeList.length) {
                VerificationUtil.traceAndLog("The original node list for " + this.getTaskID() + " was " + VerificationUtil.strArr2List(this.m_nodeList) + " but after the retrieval of login shell and applicable limit. " + "the participating nodes are " + VerificationUtil.strArr2List(participatingNodeList));
            }
            this.performShellLimitChecks(participatingNodeList);
        }
        if (this.m_resultSet.allSuccess()) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"Successful on all nodes. Retruning true");
            }
            ReportUtil.printResult(this.getNLSMessage(MsgType.PASSED));
            return true;
        }
        if (this.m_loginShellRetrievalResultSet.anyFailure()) {
            String errMsg = s_gMsgBundle.getMessage("0341", true, (Object[])new String[]{VerificationUtil.strCollection2String(this.m_loginShellRetrievalResultSet.getFailedNodes())});
            ReportUtil.printError(errMsg);
            ErrorDescription errDec = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDec);
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"Atleast on one node failed. Returning fail");
        }
        ReportUtil.printResult(this.getNLSMessage(MsgType.ERROR));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    private void performShellLimitChecks(String[] participatingNodeList) {
        CollectionElement collectionElement = null;
        FixupData fixupData = null;
        if (this.isFixupReqd() && sTaskShellLimits.isLimitFixable(this.m_resourceType, this.m_limitType)) {
            fixupData = new FixupData(null);
        }
        if (VerificationUtil.isPlatformLinux()) {
            ResultSet checkContainerResultSet = new ResultSet();
            List<String> linuxContainerNodes = VerificationUtil.filterLinuxContainerNodes(this.m_nodeList, checkContainerResultSet);
            if (checkContainerResultSet.anyFailure()) {
                VerificationUtil.traceAndLogWarning("Failed to check if the nodes are linux container");
                VerificationUtil.traceAndLogError(checkContainerResultSet.getAllErrorsStr());
            }
            if (!linuxContainerNodes.isEmpty()) {
                VerificationUtil.traceAndLog("This is a linux container environment. The fix-ups for Shell limits is being skipped...");
                fixupData = null;
            }
        }
        if (this.isLoginShellConsistent()) {
            ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.SHELL_LIMIT_TYPE, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.STATUS);
        } else {
            ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.LOGIN_SHELL, ReportUtil.SHELL_LIMIT_TYPE, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.STATUS);
        }
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet limitChkRS = new ResultSet();
        globalExec.getRLimit(participatingNodeList, this.ULIMIT_USER_NAME, this.m_limitType.toString().toLowerCase(), this.m_resourceType.getItemName(), limitChkRS);
        this.m_resultSet.addResultSetData(limitChkRS);
        Hashtable t = limitChkRS.getResultTable();
        for (String node : participatingNodeList) {
            String nstatus;
            double shellLimitOnNode;
            Result result = (Result)t.get(node);
            ShellLimitValue expectedLimitOnNode = this.m_nodeExpectedLimitTable.get(node);
            RangeOperator rangeOperator = expectedLimitOnNode.getOperator();
            long expectedLimitValueOnNode = expectedLimitOnNode.getExpectedValue();
            collectionElement = new CollectionElement(this.getElementName(), null, new String(rangeOperator.getSymbol() + " " + Long.toString(expectedLimitValueOnNode)), null, this.getDefaultDescription(), 5);
            this.m_resultSet.addCollectionElement(node, collectionElement);
            if (result.getStatus() != 1) {
                String[] msgParams = new String[]{node};
                String errMsg = this.getNLSMessage(MsgType.ERROR_NODE, msgParams);
                this.m_resultSet.addResult(node, 2);
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
                collectionElement.setStatus(2);
                collectionElement.setValue(ReportUtil.UNKNOWN);
                collectionElement.addErrorDescription(new ErrorDescription(errMsg));
                continue;
            }
            String shellLimitOnNodeStr = (String)result.getResultInfoSet().firstElement();
            if (m_localNode.equalsIgnoreCase(node) && VerificationUtil.isStringGood(this.m_localNodeResourceLimit)) {
                shellLimitOnNodeStr = this.m_localNodeResourceLimit;
                VerificationUtil.traceAndLog("Considering the LOCAL node value obtained by issuing ssh command from the remote node. for limit " + this.m_resourceType.toString() + ":" + this.m_limitType.toString() + " Value is (" + shellLimitOnNodeStr + ")");
            }
            if ("unlimited".equals(shellLimitOnNodeStr)) {
                shellLimitOnNode = Double.MAX_VALUE;
            } else {
                shellLimitOnNode = VerificationUtil.parseStringToNumber(shellLimitOnNodeStr);
                shellLimitOnNodeStr = VerificationUtil.parseObjectToString(shellLimitOnNode);
            }
            result.setHasResultValues(true);
            result.setExpectedValue(rangeOperator.getSymbol() + " " + Long.toString(expectedLimitValueOnNode));
            result.setActualValue(shellLimitOnNodeStr);
            this.m_resultSet.addResult(node, result);
            collectionElement.setValue(shellLimitOnNodeStr);
            if (VerificationUtil.compareByOperator(rangeOperator, expectedLimitValueOnNode, (long)shellLimitOnNode, false)) {
                Trace.out((String)("Sufficient shell limit on node: " + node + ", shell resource type = " + (Object)((Object)this.m_resourceType) + ", shell limit type = " + (Object)((Object)this.m_limitType) + " [Required=" + rangeOperator.getSymbol() + " " + expectedLimitValueOnNode + ", Available=" + shellLimitOnNode + "]"));
                nstatus = ReportUtil.PASSED;
                result.setStatus(1);
                collectionElement.setStatus(1);
            } else {
                Trace.out((String)("Incorrect shell limit on node: " + node + ", shell resource type = " + (Object)((Object)this.m_resourceType) + ", shell limit type = " + (Object)((Object)this.m_limitType) + " [Required=" + rangeOperator.getSymbol() + " " + expectedLimitValueOnNode + ", Available=" + shellLimitOnNode + "]"));
                String errorMessage = null;
                errorMessage = this.getNLSMessage(MsgType.FAILED_NODE, new String[]{node, rangeOperator.getSymbol() + " \"" + Long.toString(expectedLimitValueOnNode) + "\"", shellLimitOnNodeStr});
                ErrorDescription errDesc = new ErrorDescription(errorMessage);
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                this.m_resultSet.addResult(node, 3);
                nstatus = ReportUtil.FAILED;
                collectionElement.setStatus(3);
                collectionElement.addErrorDescription(errDesc);
                if (null != fixupData) {
                    VerificationUtil.traceAndLog("Generating fixup data for shell limit (" + (Object)((Object)this.m_resourceType) + ") on node '" + node + "'");
                    fixupData.addParticipatingNode(node);
                    fixupData.setActualValue(node, shellLimitOnNodeStr);
                    fixupData.setExpectedValue(node, Long.toString(expectedLimitValueOnNode));
                }
            }
            if (null != fixupData && fixupData.getParticipatingNodes().size() > 0) {
                VerificationUtil.traceAndLog("Adding the generated fixup data for shell limit (" + (Object)((Object)this.m_resourceType) + ")");
                String chkType = "";
                if (this.m_limitType.equals((Object)ShellLimitType.SOFT)) {
                    if (this.m_resourceType.equals((Object)ShellResourceType.MAX_FILEDESC)) {
                        chkType = this.ULIMIT_SOFTLIMIT_FILES;
                    } else if (this.m_resourceType.equals((Object)ShellResourceType.MAX_PROC)) {
                        chkType = this.ULIMIT_SOFTLIMIT_PROCESS;
                    } else if (this.m_resourceType.equals((Object)ShellResourceType.MAX_STACK_SIZE)) {
                        chkType = this.ULIMIT_SOFTLIMIT_STACK;
                    }
                } else if (this.m_resourceType.equals((Object)ShellResourceType.MAX_FILEDESC)) {
                    chkType = this.ULIMIT_HARDLIMIT_FILES;
                } else if (this.m_resourceType.equals((Object)ShellResourceType.MAX_PROC)) {
                    chkType = this.ULIMIT_HARDLIMIT_PROCESS;
                } else if (this.m_resourceType.equals((Object)ShellResourceType.MAX_STACK_SIZE)) {
                    chkType = this.ULIMIT_HARDLIMIT_STACK;
                }
                fixupData.addFixupInstruction(this.ULIMIT_USER_ATTR, this.ULIMIT_USER_NAME);
                fixupData.addFixupInstruction(chkType, Long.toString(expectedLimitValueOnNode));
                this.setFixupData(fixupData);
            }
            String limitTypeText = null;
            limitTypeText = this.m_limitType.equals((Object)ShellLimitType.SOFT) ? s_msgBundle.getMessage("8219", false) : s_msgBundle.getMessage("8220", false);
            if (this.isLoginShellConsistent()) {
                ReportUtil.writeRecord(node, limitTypeText, shellLimitOnNodeStr, Long.toString(expectedLimitValueOnNode), nstatus);
                continue;
            }
            ReportUtil.writeRecord(node, m_nodeLoginShellMap.get(node), limitTypeText, shellLimitOnNodeStr, Long.toString(expectedLimitValueOnNode), nstatus);
        }
        if (this.m_loginShellRetrievalResultSet.anyFailure()) {
            for (String node : this.m_loginShellRetrievalResultSet.getFailureNodes()) {
                if (this.isLoginShellConsistent()) {
                    ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, ReportUtil.UNKNOWN, ReportUtil.UNKNOWN, ReportUtil.FAILED);
                    continue;
                }
                ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, ReportUtil.UNKNOWN, ReportUtil.UNKNOWN, ReportUtil.UNKNOWN, ReportUtil.FAILED);
            }
        }
    }

    public boolean isLimitApplicable() {
        try {
            return this.isApplicable();
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            return false;
        }
    }

    private ResultSet retrieveLoginShell(String[] nodeList) {
        Trace.out((String)("Retrieving login shell from nodes " + VerificationUtil.strArr2List(nodeList)));
        ResultSet loginShellResultSet = new ResultSet();
        ArrayList<String> nodesForLoginShellRetrieval = new ArrayList<String>();
        if (nodeList != null && nodeList.length > 0) {
            if (m_nodeLoginShellMap != null && !m_nodeLoginShellMap.isEmpty()) {
                for (String node : nodeList) {
                    if (!m_nodeLoginShellMap.containsKey(node)) {
                        Trace.out((String)("Login shell is yet to be retrieved from node " + node));
                        nodesForLoginShellRetrieval.add(node);
                        continue;
                    }
                    Trace.out((String)("Login shell is already retrieved from node (" + node + ") skipping this node..."));
                    loginShellResultSet.addResult(node, 1);
                }
            } else {
                nodesForLoginShellRetrieval.addAll(Arrays.asList(nodeList));
            }
        }
        if (!nodesForLoginShellRetrieval.isEmpty()) {
            GlobalExecution globalExec = new GlobalExecution();
            ResultSet loginShellCmdResultSet = new ResultSet();
            globalExec.getLoginShell(nodesForLoginShellRetrieval.toArray(new String[0]), loginShellCmdResultSet);
            Hashtable ht = loginShellCmdResultSet.getResultTable();
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                String node = (String)e.nextElement();
                Result nodeResult = (Result)ht.get(node);
                if (nodeResult.getStatus() == 1) {
                    String[] shellPathArr;
                    String loginShellPath = (String)nodeResult.getResultInfoSet().firstElement();
                    String loginShellStr = null;
                    if (VerificationUtil.isStringGood(loginShellPath) && VerificationUtil.isStringGood(loginShellStr = (shellPathArr = loginShellPath.split(File.separator))[shellPathArr.length - 1].toUpperCase())) {
                        loginShellStr = loginShellStr.trim();
                    }
                    VerificationUtil.traceAndLog("The login shell on node " + node + " is " + loginShellStr);
                    m_nodeLoginShellMap.put(node, loginShellStr);
                    loginShellResultSet.addResult(node, 1);
                    continue;
                }
                String errMsg = s_gMsgBundle.getMessage("0341", true, (Object[])new String[]{node});
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                loginShellResultSet.addErrorDescription(node, errDesc);
                loginShellResultSet.addResult(node, 2);
                VerificationUtil.traceAndLogError("The login shell could not be retrieved from node " + node);
            }
        }
        return loginShellResultSet;
    }

    private boolean isLoginShellConsistent() {
        boolean isConsistent = true;
        String refShell = null;
        for (String node : m_nodeLoginShellMap.keySet()) {
            String nodeShell = m_nodeLoginShellMap.get(node);
            if (refShell == null) {
                refShell = nodeShell;
            }
            if (nodeShell.equalsIgnoreCase(refShell)) continue;
            isConsistent = false;
            break;
        }
        return isConsistent;
    }

    private void setSeverity() {
        SeverityType type = SeverityType.CRITICAL;
        boolean isIgnorable = true;
        for (String node : m_nodeLoginShellMap.keySet()) {
            if (this.m_nodeExpectedLimitTable.get(node) == null || this.m_nodeExpectedLimitTable.get(node).getSeverity() != SeverityType.CRITICAL) continue;
            isIgnorable = false;
        }
        if (isIgnorable) {
            type = SeverityType.IGNORABLE;
        }
        this.setSeverity(type);
    }

    private ShellLimitData getLimitForNode(String node, List<ShellLimitData> shellLimitsList) {
        ShellLimitData data = null;
        if (m_nodeLoginShellMap.containsKey(node)) {
            for (ShellLimitData shd : shellLimitsList) {
                if (!shd.getShell().equalsIgnoreCase(m_nodeLoginShellMap.get(node))) continue;
                data = shd;
                break;
            }
            if (!m_shellListForExplicitLimits.contains(m_nodeLoginShellMap.get(node)) && data == null && this.m_defaultLimitValue != null) {
                Trace.out((String)("The explicit values are provided only for shells (" + m_shellListForExplicitLimits + ") Current login shell on node (" + node + ") is (" + m_nodeLoginShellMap.get(node) + ") and hence considering default shell limits for this node"));
                VerificationUtil.traceAndLog("Using the default shell limit values for \nresource type (" + this.m_resourceType.toString() + ") \nlimit type (" + this.m_limitType.toString() + ") \nThe login shell on node (" + node + ") is " + m_nodeLoginShellMap.get(node));
                data = new ShellLimitData(m_nodeLoginShellMap.get(node), this.m_defaultLimitValue, false);
            }
        }
        return data;
    }

    @Override
    public String getDefaultDescription() {
        return this.getNLSMessage(MsgType.DESC);
    }

    @Override
    public String getTaskID() {
        return "CHECK_SHELL_LIMIT_" + (Object)((Object)this.m_limitType) + "_" + (Object)((Object)this.m_resourceType);
    }

    private String getNLSMessage(MsgType type) {
        return this.getNLSMessage(type, null);
    }

    private String getNLSMessage(MsgType type, String[] msgParam) {
        String msg = null;
        block0 : switch (this.m_resourceType) {
            case MAX_FILEDESC: {
                switch (type) {
                    case DESC: {
                        msg = this.m_limitType == ShellLimitType.HARD ? s_gMsgBundle.getMessage("0451", false) : s_gMsgBundle.getMessage("0452", false);
                        break;
                    }
                    case START: {
                        msg = this.m_limitType == ShellLimitType.HARD ? s_gMsgBundle.getMessage("0421", false) : s_gMsgBundle.getMessage("0424", false);
                        break;
                    }
                    case PASSED: {
                        msg = this.m_limitType == ShellLimitType.HARD ? s_gMsgBundle.getMessage("0427", false) : s_gMsgBundle.getMessage("0430", false);
                        break;
                    }
                    case ERROR: {
                        msg = this.m_limitType == ShellLimitType.HARD ? s_gMsgBundle.getMessage("0433", false) : s_gMsgBundle.getMessage("0436", false);
                        break;
                    }
                    case ERROR_NODE: {
                        msg = this.m_limitType == ShellLimitType.HARD ? s_gMsgBundle.getMessage("0439", true, (Object[])msgParam) : s_gMsgBundle.getMessage("0442", true, (Object[])msgParam);
                        break;
                    }
                    case FAILED_NODE: {
                        msg = this.m_limitType == ShellLimitType.HARD ? s_gMsgBundle.getMessage("0446", true, (Object[])msgParam) : s_gMsgBundle.getMessage("0445", true, (Object[])msgParam);
                    }
                }
                break;
            }
            case MAX_PROC: {
                switch (type) {
                    case DESC: {
                        msg = this.m_limitType == ShellLimitType.HARD ? s_gMsgBundle.getMessage("0453", false) : s_gMsgBundle.getMessage("0454", false);
                        break;
                    }
                    case START: {
                        msg = this.m_limitType == ShellLimitType.HARD ? s_gMsgBundle.getMessage("0422", false) : s_gMsgBundle.getMessage("0425", false);
                        break;
                    }
                    case PASSED: {
                        msg = this.m_limitType == ShellLimitType.HARD ? s_gMsgBundle.getMessage("0428", false) : s_gMsgBundle.getMessage("0431", false);
                        break;
                    }
                    case ERROR: {
                        msg = this.m_limitType == ShellLimitType.HARD ? s_gMsgBundle.getMessage("0434", false) : s_gMsgBundle.getMessage("0437", false);
                        break;
                    }
                    case ERROR_NODE: {
                        msg = this.m_limitType == ShellLimitType.HARD ? s_gMsgBundle.getMessage("0440", true, (Object[])msgParam) : s_gMsgBundle.getMessage("0443", true, (Object[])msgParam);
                        break;
                    }
                    case FAILED_NODE: {
                        msg = this.m_limitType == ShellLimitType.HARD ? s_gMsgBundle.getMessage("0448", true, (Object[])msgParam) : s_gMsgBundle.getMessage("0447", true, (Object[])msgParam);
                    }
                }
                break;
            }
            case MAX_STACK_SIZE: {
                switch (type) {
                    case DESC: {
                        msg = this.m_limitType == ShellLimitType.HARD ? s_gMsgBundle.getMessage("0455", false) : s_gMsgBundle.getMessage("0456", false);
                        break block0;
                    }
                    case START: {
                        msg = this.m_limitType == ShellLimitType.HARD ? s_gMsgBundle.getMessage("0423", false) : s_gMsgBundle.getMessage("0426", false);
                        break block0;
                    }
                    case PASSED: {
                        msg = this.m_limitType == ShellLimitType.HARD ? s_gMsgBundle.getMessage("0429", false) : s_gMsgBundle.getMessage("0432", false);
                        break block0;
                    }
                    case ERROR: {
                        msg = this.m_limitType == ShellLimitType.HARD ? s_gMsgBundle.getMessage("0435", false) : s_gMsgBundle.getMessage("0438", false);
                        break block0;
                    }
                    case ERROR_NODE: {
                        msg = this.m_limitType == ShellLimitType.HARD ? s_gMsgBundle.getMessage("0441", true, (Object[])msgParam) : s_gMsgBundle.getMessage("0444", true, (Object[])msgParam);
                        break block0;
                    }
                    case FAILED_NODE: {
                        msg = this.m_limitType == ShellLimitType.HARD ? s_gMsgBundle.getMessage("0450", true, (Object[])msgParam) : s_gMsgBundle.getMessage("0449", true, (Object[])msgParam);
                    }
                }
            }
        }
        return msg;
    }

    public static class ShellLimitData
    extends ShellLimitValue {
        private String m_shellName;

        public ShellLimitData(String shell, ShellLimitValue value, boolean isExplicit) {
            super(value.getExpectedValue(), value.getOperator(), value.getSeverity());
            this.m_shellName = shell;
            if (isExplicit && VerificationUtil.isStringGood(this.m_shellName) && !m_shellListForExplicitLimits.contains(this.m_shellName)) {
                m_shellListForExplicitLimits.add(this.m_shellName);
            }
        }

        public ShellLimitData(String shell, long expectedValue) {
            this(shell, expectedValue, null, false);
        }

        public ShellLimitData(String shellType, long expectedValue, SeverityType severity, boolean isExplicit) {
            this(shellType, new ShellLimitValue(expectedValue, severity), isExplicit);
        }

        public String getShell() {
            return this.m_shellName;
        }

        @Override
        public String toString() {
            return this.m_shellName + " : " + super.toString();
        }
    }

    public static class ShellLimitValue {
        private SeverityType m_severity;
        private long m_expectedValue;
        private RangeOperator m_operator = RangeOperator.GE;

        public ShellLimitValue(long expectedValue) {
            this(expectedValue, null);
        }

        public ShellLimitValue(long expectedValue, SeverityType severity) {
            this.m_expectedValue = expectedValue;
            this.m_severity = severity != null ? severity : SeverityType.CRITICAL;
        }

        public ShellLimitValue(long expectedValue, RangeOperator operator, SeverityType severity) {
            this.m_expectedValue = expectedValue;
            this.m_severity = severity != null ? severity : SeverityType.CRITICAL;
            if (operator != null) {
                this.m_operator = operator;
            }
        }

        public long getExpectedValue() {
            return this.m_expectedValue;
        }

        public RangeOperator getOperator() {
            return this.m_operator;
        }

        public SeverityType getSeverity() {
            return this.m_severity;
        }

        public String toString() {
            return this.m_expectedValue + " : " + (Object)((Object)this.m_operator) + " : " + this.m_severity.toString();
        }
    }

    private static enum MsgType {
        DESC,
        START,
        PASSED,
        ERROR_NODE,
        ERROR,
        FAILED_NODE;

    }
}

