/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.ParamPreReqNodeAddDel;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.engine.task.TaskCRSIntegrity;
import oracle.ops.verification.framework.engine.task.TaskCRSVersionConsistency;
import oracle.ops.verification.framework.engine.task.TaskNodeAppCreation;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.SharedStorageSet;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.VerifyStorage;
import oracle.ops.verification.framework.util.InvalidOUIInventoryDataException;
import oracle.ops.verification.framework.util.OUIData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.MultiNodeException;

public class TaskNodeAddDelete
extends Task {
    public static final int NODEADD = 0;
    public static final int NODEDELETE = 1;
    private int m_taskType = 0;
    private String[] m_newClusterNodes;
    private String[] m_clusterNodes;
    private ResultSet m_stageResultSet;
    private boolean m_racHome = false;

    public TaskNodeAddDelete(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        VerificationType vType = this.m_globalContext.getVerificationType();
        ParamPreReqNodeAddDel param = (ParamPreReqNodeAddDel)this.m_globalContext.getParamPrereq();
        switch (vType) {
            case PREREQ_NODE_ADD: 
            case POSTREQ_NODE_ADD: {
                if (param != null) {
                    this.setClusterNodes(param.getValidClusterNodes());
                    this.setNewClusterNodes(param.getValidNewClusterNodes());
                }
                this.setTaskType(0);
                break;
            }
            case PREREQ_RACNODE_ADD: {
                if (param != null) {
                    this.setClusterNodes(param.getValidClusterNodes());
                    this.setNewClusterNodes(param.getValidNewClusterNodes());
                }
                this.setTaskType(0);
                this.setRACHome(true);
                break;
            }
            case POSTREQ_NODE_DEL: {
                if (param != null) {
                    this.setClusterNodes(param.getValidClusterNodes());
                }
                this.setTaskType(1);
            }
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        VerificationType vType = this.m_globalContext.getVerificationType();
        switch (vType) {
            case PREREQ_NODE_ADD: 
            case POSTREQ_NODE_ADD: 
            case PREREQ_RACNODE_ADD: {
                if (this.m_newClusterNodes != null && this.m_newClusterNodes.length > 0 && this.m_clusterNodes != null && this.m_clusterNodes.length > 0) {
                    return true;
                }
                VerificationUtil.traceAndLog("Either node list, cluster nodes or new nodes being added are not set, Skipping this task");
                return false;
            }
            case POSTREQ_NODE_DEL: {
                if (this.m_clusterNodes != null && this.m_clusterNodes.length > 0) {
                    return true;
                }
                VerificationUtil.traceAndLog("Either node list, cluster nodes or new nodes being added are not set, Skipping this task");
                return false;
            }
        }
        return true;
    }

    public TaskNodeAddDelete(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskNodeAddDelete(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskNodeAddDelete(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void setTaskType(int type) {
        this.m_taskType = type;
    }

    public void setNewClusterNodes(String[] newClusterNodes) {
        this.m_newClusterNodes = newClusterNodes;
    }

    public void setClusterNodes(String[] clusterNodes) {
        this.m_clusterNodes = clusterNodes;
    }

    public void setStageResultSet(ResultSet stageResultSet) {
        this.m_stageResultSet = stageResultSet;
    }

    public void setRACHome(boolean racHome) {
        this.m_racHome = racHome;
    }

    @Override
    public boolean performTask() {
        String errMsg = null;
        Object action = null;
        Object cause = null;
        ErrorDescription errDesc = null;
        ArrayList<String> newNodesWithCRS = new ArrayList<String>();
        ArrayList<String> nodeOperationList = new ArrayList<String>(Arrays.asList(this.m_clusterNodes));
        Object previousTaskReference = null;
        String remoteOlsNodesClustername = null;
        Trace.out((Object)"\nnodeList: ", (String)(VerificationUtil.strArr2List(this.m_nodeList) + "\nm_newClusterNodes: " + VerificationUtil.strArr2List(this.m_newClusterNodes) + "\nm_clusterNodes: " + VerificationUtil.strArr2List(this.m_clusterNodes)));
        this.m_resultSet.addResult(this.m_nodeList, 1);
        TaskCRSIntegrity taskCRSIntegrity = new TaskCRSIntegrity(new String[]{m_localNode});
        taskCRSIntegrity.setToPerformConsistencyCheck(false);
        this.addChildTask(taskCRSIntegrity);
        boolean retval = taskCRSIntegrity.perform();
        if (!retval) {
            this.m_resultSet.addResult(this.m_nodeList, 3);
            this.m_resultSet.uploadResultSet(taskCRSIntegrity.getResultSet());
        }
        TaskCRSVersionConsistency taskCRSVerConsis = new TaskCRSVersionConsistency(this.m_clusterNodes);
        taskCRSVerConsis.setConsistenyMandatory(true);
        taskCRSVerConsis.setNonRollingUpgrade(false);
        taskCRSVerConsis.setVerificationType(VerificationType.PREREQ_NODE_ADD);
        this.addChildTask(taskCRSVerConsis);
        retval = taskCRSVerConsis.perform();
        if (!retval) {
            this.m_resultSet.addResult(this.m_nodeList, 3);
        }
        if (Trace.isLevelEnabled((int)5)) {
            if (this.m_taskType == 0) {
                Trace.out((String)"Performing NODE ADD checks.");
            } else if (this.m_taskType == 1) {
                Trace.out((String)"Performing NODE DELETE checks.");
            } else {
                Trace.out((String)("Task Type: " + this.m_taskType));
            }
        }
        if (this.m_taskType == 0) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4861", false));
            String softCRSVer = VerificationUtil.getCRSSoftwareVersion(m_localNode);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\n Checking cluster nodes for CRS version '" + softCRSVer + "', local node: '" + m_localNode + "'."));
            }
            String localnodeCRSHome = VerificationUtil.getCRSHome();
            String existOlsNodesClustername = VerificationUtil.getClusternameFromOlsnodes(m_localNode, localnodeCRSHome);
            Trace.out((String)("OLSNODES: Cluster name from existing cluster: '" + m_localNode + "':'" + existOlsNodesClustername + "'"));
            for (String node : this.m_nodeList) {
                try {
                    ClusterwareInfo cwInfo = new ClusterwareInfo();
                    String newNodeCRSVer = VerificationUtil.getCRSSoftwareVersion(node);
                    if (cwInfo.isCRSConfiguredOnNode(node) && VerificationUtil.isStringGood(newNodeCRSVer)) {
                        Trace.out((String)("Node: '" + node + "' has CRS configured with version '" + newNodeCRSVer + "'."));
                        newNodesWithCRS.add(node);
                        String newNodeCRSHome = cwInfo.getCRSHome(node, new Version());
                        if (newNodeCRSHome == null) continue;
                        Trace.out((String)("New node: '" + node + "' has CRS configured, " + "checking to make sure it is not part of another cluster."));
                        remoteOlsNodesClustername = VerificationUtil.getClusternameFromOlsnodes(node, newNodeCRSHome);
                        Trace.out((String)("OLSNODES: Cluster name from new node: '" + node + "' : '" + remoteOlsNodesClustername + "'"));
                        if (!VerificationUtil.isStringGood(remoteOlsNodesClustername) || existOlsNodesClustername.contentEquals(remoteOlsNodesClustername)) continue;
                        errMsg = s_gMsgBundle.getMessage("1026", true, (Object[])new String[]{node, remoteOlsNodesClustername});
                        ErrorDescription erD = new ErrorDescription(errMsg);
                        this.m_resultSet.addErrorDescription(erD);
                        this.m_resultSet.addResult(node, 2);
                        ReportUtil.printError(erD.getErrorMessage());
                        Trace.out((String)("Cluster names are different!!\n" + errMsg));
                        continue;
                    }
                    Trace.out((String)("Node: '" + node + "' does NOT have CRS configured."));
                }
                catch (InstallException ie) {
                    VerificationUtil.traceAndLog("INSTALLEXCEPTION:\n" + (Object)((Object)ie));
                }
            }
            if (newNodesWithCRS.size() != 0) {
                nodeOperationList.addAll(newNodesWithCRS);
            }
            for (String node : nodeOperationList) {
                String nodeCRSVer;
                if (node.contentEquals(m_localNode) || (nodeCRSVer = VerificationUtil.getCRSSoftwareVersion(node)) != null && softCRSVer.contentEquals(nodeCRSVer)) continue;
                this.m_resultSet.addResult(node, 3);
                errDesc = new ErrorDescription("1011", new String[]{m_localNode, node}, s_gMsgBundle);
                this.m_resultSet.addErrorDescription(node, errDesc);
                ReportUtil.printError(errDesc.getErrorMessage());
                Trace.out((String)("\n Node: '" + node + "' has CRS version '" + nodeCRSVer + "' installed, m_localNode: '" + m_localNode + "' has CRS version '" + softCRSVer + "' installed."));
            }
            nodeOperationList.retainAll(Arrays.asList(this.m_clusterNodes));
            if (!this.m_racHome) {
                String crsHome = VerificationUtil.getCRSHome();
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\n Checking CRSHome '" + crsHome + "' for sharedness."));
                }
                ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4871", false));
                this.checkSharedPath(crsHome, true, OracleFileType.RAC_SOFTWARE, softCRSVer);
            }
        } else if (this.m_taskType == 1) {
            TaskNodeAppCreation taskNAC = new TaskNodeAppCreation(this.m_nodeList);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\n Checking for remnants of NODEAPPS for nodes: " + VerificationUtil.strArr2List(this.m_nodeList) + " \n Expecting cluster nodes to be: " + VerificationUtil.strArr2List(this.m_clusterNodes) + "\n"));
            }
            boolean saveMode = ReportUtil.getMode();
            ReportUtil.setMode(false);
            taskNAC.setNodesWithCRS(this.m_clusterNodes);
            taskNAC.setDeletedResource(true);
            retval = taskNAC.performCommonTask(this.m_nodeList, false);
            ReportUtil.setMode(saveMode);
            ResultSet nacRS = taskNAC.getResultSet();
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"\n Finished with NODEAPP check, reporting results");
            }
            if (nacRS.anySuccess()) {
                Object errorDesc = null;
                Hashtable t = nacRS.getResultTable();
                Enumeration e = t.keys();
                while (e.hasMoreElements()) {
                    String node = (String)e.nextElement();
                    Result result = (Result)t.get(node);
                    TaskNodeAppCreation.TaskNACData nodeappData = (TaskNodeAppCreation.TaskNACData)result.getResultInfoSet().firstElement();
                    if (Trace.isLevelEnabled((int)5)) {
                        String nodeappStatus = nodeappData.getStatus() == 1 ? "ONLINE" : (nodeappData.getStatus() == 0 ? "EXIST_OFFLINE" : (nodeappData.getStatus() == 210 ? "NOTEXIST" : "UNKNOWN"));
                        Trace.out((String)("\nNodeapp: '" + nodeappData.getName() + "' Status: " + nodeappStatus));
                    }
                    if (nodeappData.getStatus() != 1 && nodeappData.getStatus() != 0) continue;
                    this.m_resultSet.addResult(node, 3);
                    errDesc = new ErrorDescription("4868", new String[]{nodeappData.getName(), node}, s_msgBundle);
                    this.m_resultSet.addErrorDescription(node, errDesc);
                    ReportUtil.printError(errDesc.getErrorMessage());
                }
            } else {
                OUIData ouiData = null;
                try {
                    ouiData = OUIData.getInstance(VerificationUtil.getInventoryFileLocation());
                }
                catch (InvalidOUIInventoryDataException e) {
                    VerificationUtil.traceAndLog("Error Instantiating OUIData" + e.getMessage());
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
                    ReportUtil.printError(e.getMessage());
                }
                if (ouiData != null) {
                    boolean nodeNotExists = true;
                    for (String crsNode : ouiData.getCRSNodes()) {
                        if (crsNode.indexOf(".") != -1) {
                            crsNode = crsNode.substring(0, crsNode.indexOf("."));
                        }
                        for (String node : this.m_nodeList) {
                            if (node.indexOf(".") != -1) {
                                node = node.substring(0, node.indexOf("."));
                            }
                            if (node.toLowerCase().compareTo(crsNode.toLowerCase()) != 0) continue;
                            Trace.out((String)("Node " + node + " exists in inventory"));
                            String errMessage = s_msgBundle.getMessage("10002", true, (Object[])new String[]{node});
                            this.m_resultSet.addResult(node, 3);
                            this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMessage));
                            ReportUtil.printError(errMessage);
                            nodeNotExists = false;
                        }
                    }
                    if (nodeNotExists) {
                        this.m_resultSet.addResult(this.m_nodeList, 1);
                    } else {
                        this.m_resultSet.addResult(this.m_nodeList, 3);
                    }
                }
            }
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        if (this.m_resultSet.allSuccess()) {
            if (this.m_taskType == 0) {
                ReportUtil.printResult(s_msgBundle.getMessage("4852", false) + LSEP);
            } else {
                ReportUtil.printResult(LSEP + s_msgBundle.getMessage("4855", false));
            }
            return true;
        }
        this.m_resultSet.traceResultSet("Node Add/Delete ResultSet trace.\n");
        if (this.m_taskType == 0) {
            ReportUtil.printResult(s_msgBundle.getMessage("4853", false) + LSEP);
        } else {
            ReportUtil.printResult(s_msgBundle.getMessage("4856", false) + LSEP);
        }
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    private void checkSharedPath(String path, boolean crsHome, OracleFileType fileType, String release) {
        block39: {
            String writablePath;
            VerifyStorage checkPathSt = new VerifyStorage();
            Vector<String> succNodes = new Vector<String>();
            Vector<String> failNodes = new Vector<String>();
            String basePath = null;
            boolean pExistOnNew = false;
            boolean pWritableOnNew = false;
            boolean pSharedOnCluster = false;
            boolean pSharedOnNewCluster = false;
            String parentPath = null;
            String binOracle = null;
            String strFailNodes = null;
            ErrorDescription errDesc = null;
            ResultSet sharedPathResultSet = new ResultSet();
            Trace.out((String)("path: '" + path + "' fileType: '" + (Object)((Object)fileType) + "' release: '" + release + "' crsHome: '" + crsHome + "'"));
            TaskAnonymousProxy anonymousTask = new TaskAnonymousProxy("'" + path + "'", this.m_nodeList, this);
            String drvPath = path.substring(0, path.indexOf(FSEP) + 1);
            if (crsHome) {
                writablePath = path + FSEP + "cv" + FSEP + "cvdata";
                binOracle = path + FSEP + "bin" + FSEP + "oracle";
            } else {
                writablePath = path;
            }
            parentPath = writablePath.substring(0, writablePath.lastIndexOf(FSEP));
            Trace.out((String)(LSEP + " Path    : " + path + LSEP + " parentPath: " + parentPath + LSEP + " Writable Path: " + writablePath));
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            pWritableOnNew = VerificationUtil.pathExists(this.m_nodeList, writablePath, 4, succNodes, failNodes);
            strFailNodes = VerificationUtil.strArr2List(failNodes.toArray(new String[failNodes.size()]));
            pExistOnNew = VerificationUtil.pathExists(this.m_nodeList, path, 1, succNodes, failNodes);
            Trace.out((String)(LSEP + "pWritableOnNew[" + writablePath + "]: " + pWritableOnNew + LSEP + "pExistOnNew[" + path + ": " + pExistOnNew));
            if (!pWritableOnNew) {
                Trace.out((String)("Path: '" + writablePath + "' does not exit on new nodes."));
                Trace.out((String)("Checking path: '" + parentPath + "' on new nodes."));
                while (!VerificationUtil.pathExists(this.m_nodeList, parentPath, 4, succNodes, failNodes) && !parentPath.contentEquals(FSEP) && parentPath.length() != 0) {
                    Trace.out((String)("parentPath did not exist: '" + parentPath + "'"));
                    basePath = parentPath;
                    int fsepLoc = basePath.lastIndexOf(FSEP);
                    if (fsepLoc == -1 || (parentPath = basePath.substring(0, fsepLoc == 0 ? 1 : fsepLoc)).contentEquals(FSEP) || parentPath.length() == 0) break;
                    Trace.out((String)("Setting parentPath to: '" + parentPath + "'"));
                    Trace.out((String)("Checking parent path: '" + parentPath + "' on new nodes."));
                }
            }
            Trace.out((String)("Parent path: '" + parentPath + "'"));
            if (parentPath.length() == 0) {
                Trace.out((String)("The path '" + path + "' does not exist on the new nodes " + "and the parent paths either don't exist or are not writable"));
                errDesc = pExistOnNew ? new ErrorDescription(s_msgBundle.getMessage("4864", true, (Object[])new String[]{path, strFailNodes})) : new ErrorDescription(s_gMsgBundle.getMessage("1013", true, (Object[])new String[]{path}));
                sharedPathResultSet.addResult(this.m_nodeList, 3);
                sharedPathResultSet.addErrorDescription(this.m_nodeList, errDesc);
                ReportUtil.sureprintln(errDesc.getErrorMessage());
                Trace.out((String)errDesc.getErrorMessage());
                anonymousTask.performAnonymousTask(sharedPathResultSet);
                return;
            }
            boolean clusterMultinode = this.m_clusterNodes.length > 1;
            String errMsg = s_msgBundle.getMessage("4853", false);
            String cause = s_msgBundle.getMessage("4859", false, (Object[])new String[]{path});
            String action = s_msgBundle.getMessage("4860", false, (Object[])new String[]{path});
            try {
                pSharedOnCluster = checkPathSt.isShared(writablePath, this.m_clusterNodes, fileType, release);
                if (pWritableOnNew) {
                    pSharedOnNewCluster = checkPathSt.isShared(writablePath, this.m_newClusterNodes, fileType, release);
                } else if (!crsHome && pExistOnNew) {
                    pSharedOnNewCluster = checkPathSt.isShared(path, this.m_newClusterNodes, fileType, release);
                } else if (!crsHome && !pExistOnNew) {
                    pSharedOnNewCluster = checkPathSt.isShared(parentPath, this.m_newClusterNodes, fileType, release);
                } else if (pExistOnNew) {
                    pSharedOnNewCluster = VerificationUtil.pathExists(this.m_nodeList, binOracle, 2, succNodes, failNodes);
                }
            }
            catch (StorageException se) {
                sharedPathResultSet.addResult(this.m_nodeList, 2);
                cause = se.getMessage();
                action = s_msgBundle.getMessage("4866", true, (Object[])new String[]{path});
                errDesc = new ErrorDescription(errMsg, cause, action);
                sharedPathResultSet.addErrorDescription(this.m_nodeList, errDesc);
                ReportUtil.sureprintln(errDesc.getErrorMessage());
                VerificationUtil.traceAndLog("STORAGEEXCEPTION: " + errDesc.getErrorMessage());
                anonymousTask.performAnonymousTask(sharedPathResultSet);
                return;
            }
            catch (MultiNodeException mne) {
                sharedPathResultSet.addResult(this.m_nodeList, 2);
                cause = mne.getMessage();
                action = s_msgBundle.getMessage("4866", true, (Object[])new String[]{path});
                errDesc = new ErrorDescription(errMsg, cause, action);
                sharedPathResultSet.addErrorDescription(this.m_nodeList, errDesc);
                ReportUtil.sureprintln(errDesc.getErrorMessage());
                VerificationUtil.traceAndLog("MULTINODEEXCEPTION: " + errDesc.getErrorMessage());
                anonymousTask.performAnonymousTask(sharedPathResultSet);
                return;
            }
            if (pExistOnNew) {
                if (clusterMultinode) {
                    if (pSharedOnCluster && !pSharedOnNewCluster) {
                        try {
                            if (!nativeSystem.isUnixSystem() && checkPathSt.isOCFS(this.m_clusterNodes[0], path) && checkPathSt.isSharedDevice(this.m_clusterNodes[0], this.m_nodeList, drvPath) && !VerificationUtil.pathExists(this.m_nodeList, parentPath, 4, succNodes, failNodes) && VerificationUtil.isAutoMountEnabled(this.m_nodeList)) {
                                Trace.out((String)(LSEP + "Path: '" + path + "' is on OCFS, " + "device is shared, path does not exist " + "on node(s) to be added, and automount is enabled."));
                                sharedPathResultSet.addResult(this.m_nodeList, 1);
                                ReportUtil.sureprintln(s_msgBundle.getMessage("4061", false, (Object[])new String[]{path}));
                                anonymousTask.performAnonymousTask(sharedPathResultSet);
                                break block39;
                            }
                            Trace.out((String)(LSEP + "Path: '" + path + "' is shared on existing " + "cluster but NOT shared on node(s) to be added."));
                            sharedPathResultSet.addResult(this.m_nodeList, 3);
                            sharedPathResultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(errMsg, cause, action));
                            ReportUtil.sureprintln(s_msgBundle.getMessage("4866", false, (Object[])new String[]{path}));
                            anonymousTask.performAnonymousTask(sharedPathResultSet);
                        }
                        catch (StorageException se) {
                            sharedPathResultSet.addResult(this.m_nodeList, 2);
                            errDesc = new ErrorDescription("4866", new String[]{path}, s_msgBundle);
                            sharedPathResultSet.addErrorDescription(this.m_nodeList, errDesc);
                            ReportUtil.sureprintln(errDesc.getErrorMessage() + LSEP + se.getMessage());
                            anonymousTask.performAnonymousTask(sharedPathResultSet);
                            VerificationUtil.traceAndLog("STORAGEEXCEPTION: " + LSEP + se.getMessage() + LSEP + LSEP + "  Path: " + path + " NOT shared.");
                        }
                    } else if (crsHome) {
                        if (!pSharedOnCluster && pSharedOnNewCluster) {
                            Trace.out((String)(LSEP + "CRSHOME Path: '" + path + "' exists on new nodes, is NOT shared on existing" + " cluster but IS shared on new."));
                            errDesc = new ErrorDescription("1012", new String[]{path}, s_gMsgBundle);
                            sharedPathResultSet.addResult(this.m_nodeList, 3);
                            sharedPathResultSet.addErrorDescription(this.m_nodeList, errDesc);
                            ReportUtil.sureprintln(errDesc.getErrorMessage());
                            anonymousTask.performAnonymousTask(sharedPathResultSet);
                        } else if (!pSharedOnCluster && !pSharedOnNewCluster) {
                            Trace.out((String)(LSEP + "CRShome path: '" + path + "' not shared on" + " existing cluster, and not shared on new cluster."));
                            sharedPathResultSet.addResult(this.m_nodeList, 1);
                            ReportUtil.sureprintln(s_msgBundle.getMessage("4062", false, (Object[])new String[]{path}));
                            anonymousTask.performAnonymousTask(sharedPathResultSet);
                        }
                    } else if (pSharedOnCluster && pSharedOnNewCluster) {
                        Trace.out((String)(LSEP + "non-CRShome path: '" + path + "' not shared on" + " existing cluster, but shared on new cluster."));
                        sharedPathResultSet.addResult(this.m_nodeList, 1);
                        ReportUtil.sureprintln(s_msgBundle.getMessage("4061", false, (Object[])new String[]{path}));
                        anonymousTask.performAnonymousTask(sharedPathResultSet);
                    } else {
                        sharedPathResultSet.addResult(this.m_nodeList, 1);
                        ReportUtil.sureprintln(s_msgBundle.getMessage("4062", false, (Object[])new String[]{path}));
                        anonymousTask.performAnonymousTask(sharedPathResultSet);
                    }
                } else {
                    Trace.out((String)(LSEP + "Path: '" + path + "' exists on new nodes " + " and cluster is single node."));
                    sharedPathResultSet.addResult(this.m_nodeList, 1);
                    ReportUtil.sureprintln(s_gMsgBundle.getMessage("0600", false, (Object[])new String[]{path, VerificationUtil.strArr2List(this.m_nodeList)}));
                    anonymousTask.performAnonymousTask(sharedPathResultSet);
                }
            } else if (clusterMultinode) {
                if (pSharedOnCluster && pSharedOnNewCluster) {
                    Trace.out((String)(LSEP + "Path: '" + path + "' shared on new cluster..."));
                    sharedPathResultSet.addResult(this.m_nodeList, 1);
                    ReportUtil.sureprintln(s_msgBundle.getMessage("4061", false, (Object[])new String[]{path}));
                    anonymousTask.performAnonymousTask(sharedPathResultSet);
                } else if (crsHome && !pSharedOnCluster && pSharedOnNewCluster || pSharedOnCluster && !pSharedOnNewCluster) {
                    Trace.out((String)(LSEP + "CRSHOME Path: '" + path + "' exists on new nodes, " + "is NOT shared on existing cluster but IS shared on new."));
                    errDesc = new ErrorDescription("1012", new String[]{path}, s_gMsgBundle);
                    sharedPathResultSet.addResult(this.m_nodeList, 3);
                    sharedPathResultSet.addErrorDescription(this.m_nodeList, errDesc);
                    ReportUtil.sureprintln(errDesc.getErrorMessage());
                    anonymousTask.performAnonymousTask(sharedPathResultSet);
                } else if (pSharedOnCluster && !pSharedOnNewCluster) {
                    Trace.out((String)(LSEP + "Path: '" + path + "' NOT shared on new nodes..."));
                    errMsg = s_msgBundle.getMessage("4853", false);
                    cause = s_msgBundle.getMessage("4859", false, (Object[])new String[]{path});
                    action = s_msgBundle.getMessage("4860", false, (Object[])new String[]{path});
                    sharedPathResultSet.addResult(this.m_nodeList, 3);
                    sharedPathResultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(errMsg, cause, action));
                    ReportUtil.sureprintln(s_msgBundle.getMessage("4866", false, (Object[])new String[]{path}));
                    anonymousTask.performAnonymousTask(sharedPathResultSet);
                } else {
                    Trace.out((String)(LSEP + "Path: '" + path + "' NOT shared on cluster and NOT shared on new nodes..."));
                    sharedPathResultSet.addResult(this.m_nodeList, 1);
                    ReportUtil.sureprintln(s_msgBundle.getMessage("4863", false, (Object[])new String[]{path}));
                    anonymousTask.performAnonymousTask(sharedPathResultSet);
                }
            } else {
                Trace.out((String)(LSEP + "Path: '" + path + "' does not exist but can be created."));
                sharedPathResultSet.addResult(this.m_nodeList, 1);
                ReportUtil.sureprintln(s_msgBundle.getMessage("4863", false, (Object[])new String[]{path}));
                anonymousTask.performAnonymousTask(sharedPathResultSet);
            }
        }
    }

    private String[] getSharedPaths(Vector sharedSets, int minNodesReq) {
        Vector<String> returnPathList = new Vector<String>();
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        Enumeration setEnum = sharedSets.elements();
        while (setEnum.hasMoreElements()) {
            SharedStorageSet sharedSet = (SharedStorageSet)setEnum.nextElement();
            if (sharedSet.getNumNodes() < minNodesReq) continue;
            Enumeration storageEnum = sharedSet.getSharedSet().elements();
            Hashtable<String, Vector<String>> pathTable = new Hashtable<String, Vector<String>>();
            Vector<String> pathList = new Vector<String>();
            Vector<String> nodeList = null;
            while (storageEnum.hasMoreElements()) {
                StorageInfo stInfo = (StorageInfo)storageEnum.nextElement();
                String key = stInfo.getName();
                nodeList = (Vector<String>)pathTable.get(key);
                if (null == nodeList) {
                    pathList.add(key);
                    nodeList = new Vector<String>();
                    pathTable.put(key, nodeList);
                }
                if (nodeList.contains(stInfo.getNode())) continue;
                nodeList.add(stInfo.getNode());
            }
            String path = null;
            Enumeration pathEnum = pathList.elements();
            Object line = null;
            while (pathEnum.hasMoreElements()) {
                path = (String)pathEnum.nextElement();
                if (returnPathList.contains(path)) continue;
                returnPathList.add(path);
                if (!Trace.isLevelEnabled((int)5)) continue;
                Trace.out((String)("\n Adding path: " + path));
            }
        }
        String[] returnArrayList = new String[returnPathList.size()];
        for (int i = 0; i < returnPathList.size(); ++i) {
            returnArrayList[i] = (String)returnPathList.get(i);
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\n Storage paths to be check for sharedness: \n" + VerificationUtil.strArr2List(returnArrayList)));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return returnArrayList;
    }

    @Override
    public String getDefaultElementName() {
        if (this.m_taskType == 0) {
            return s_msgBundle.getMessage("4439", false);
        }
        return s_msgBundle.getMessage("4440", false);
    }

    @Override
    public String getDefaultDescription() {
        if (this.m_taskType == 0) {
            return s_msgBundle.getMessage("4492", false);
        }
        return s_msgBundle.getMessage("4493", false);
    }
}

