/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskNameService;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskNameService
extends Task {
    private sTaskNameService m_staskNS = null;

    public TaskNameService(VerificationTaskContext ctx) {
        super(ctx);
    }

    public TaskNameService() {
    }

    @Override
    protected void init() {
        String scanName = CVUVariables.getValue(CVUVariableConstants.SCAN_NAME);
        if (VerificationUtil.isStringGood(scanName) && !this.m_globalContext.isDHCPConfigured()) {
            String scanNameValue = null;
            if (VerificationUtil.isCVUTestEnv()) {
                Trace.out((String)"CVU test environment");
                scanNameValue = "bigip-bug.us.oracle.com";
            } else {
                scanNameValue = scanName;
            }
            this.m_staskNS = new sTaskNameService(this.m_nodeList, scanNameValue, this);
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (VerificationType.PREREQ_CRS_INST.equals((Object)this.m_globalContext.getVerificationType()) && VerificationUtil.isBaselineCollectionMode()) {
            return false;
        }
        if (VerificationUtil.skipTask(this)) {
            VerificationUtil.traceAndLog("This task " + this.getDefaultTaskID() + " is requested to be skipped" + " and hence not added to the taskList");
            return false;
        }
        VerificationType vType = this.m_globalContext.getVerificationType();
        switch (vType) {
            case PREREQ_CRS_INST: {
                if (!this.m_globalContext.isCRSSoftwareOnlyInstall()) break;
                VerificationUtil.traceAndLog("Skipping Name service check as this is a software only install.");
                return false;
            }
        }
        return this.m_staskNS != null;
    }

    public TaskNameService(String[] nodeList, String scanName) {
        super(nodeList);
        this.m_staskNS = new sTaskNameService(nodeList, scanName, this);
    }

    @Override
    public boolean performTask() {
        boolean retVal = this.m_staskNS.performTask();
        this.m_resultSet.overwriteResultSet(this.m_staskNS.getResultSet());
        return retVal;
    }

    public String getElementDisplayName() {
        return s_msgBundle.getMessage("1070", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("9503", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("9604", false);
    }
}

