/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Vector;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.engine.task.TaskPeerCompatibility;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskKernelVersion
extends TaskPeerCompatibility
implements PeerCompatibleTask {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1062", false);
    private String m_version;
    private String m_rimVersion;

    public TaskKernelVersion(String version) {
        this.m_version = version;
    }

    @Override
    public boolean performTask() {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet knlverRsltSet = new ResultSet();
        globalExec.checkKernelVersion(this.m_nodeList, "", knlverRsltSet);
        this.m_resultSet.addResultSetData(knlverRsltSet);
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1000", false, (Object[])new String[]{CONSTRAINT_NAME}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.STATUS);
        Hashtable t = knlverRsltSet.getResultTable();
        Enumeration e = t.keys();
        Hashtable<Object, Vector<Object>> version = new Hashtable<Object, Vector<Object>>();
        LinkedHashMap<Object, String> nodeWiseExecFailures = new LinkedHashMap<Object, String>();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            String requiredVersion = this.m_version;
            CollectionElement collectionElement = new CollectionElement(this.getElementName(), null, requiredVersion, null, this.getDefaultDescription(), 5);
            this.m_resultSet.addCollectionElement(node, collectionElement);
            if (result.getStatus() == 1) {
                String avl = (String)result.getResultInfoSet().firstElement();
                Trace.out((String)("Result.OPERATION_SUCCESSFUL:: available kernel version=" + avl));
                this.m_resultSet.getResult(node).setStatus(1);
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(requiredVersion);
                this.m_resultSet.getResult(node).setActualValue(avl);
                collectionElement.setValue(avl);
                VerificationUtil.updateResultMap(version, avl, node);
                if (VerificationUtil.compareVersions(avl, requiredVersion, "-") >= 0) {
                    ReportUtil.writeRecord(node, avl, this.m_version, ReportUtil.PASSED);
                    collectionElement.setStatus(1);
                    continue;
                }
                Trace.out((String)("Result.VERIFICATION_FAILED:: available kernel version=" + avl));
                ReportUtil.writeRecord(node, avl, this.m_version, ReportUtil.FAILED);
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7541", false, (Object[])new String[]{node, this.m_version, avl}));
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                this.m_resultSet.addResult(node, 3);
                collectionElement.setStatus(3);
                continue;
            }
            Trace.out((String)("FAILED:: result.getStatus()=" + result.getStatus()));
            ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, requiredVersion, ReportUtil.FAILED);
            String errMsg = VerificationUtil.getMsgWithExecutionDetails(s_msgBundle.getMessage("7542", true, (Object[])new String[]{node}), result);
            errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.getResult(node).addErrorDescription(errDesc);
            collectionElement.setStatus(2);
            nodeWiseExecFailures.put(node, errMsg);
        }
        if (nodeWiseExecFailures.size() > 0) {
            ReportUtil.sureblankln();
            for (String node : ((HashMap)nodeWiseExecFailures).keySet()) {
                String nodeExecError = (String)((HashMap)nodeWiseExecFailures).get(node);
                ReportUtil.sureprintln(nodeExecError);
            }
            ReportUtil.sureblankln();
        }
        if (version.size() > 1) {
            StringBuilder completeErrMsg = new StringBuilder();
            String errMsg = s_msgBundle.getMessage("7524", true);
            ReportUtil.printWarning(errMsg);
            completeErrMsg.append(errMsg);
            Enumeration keys1 = version.keys();
            while (keys1.hasMoreElements()) {
                String key = (String)keys1.nextElement();
                String nodeAryStr = VerificationUtil.strVect2List((Vector)version.get(key));
                errMsg = s_msgBundle.getMessage("7525", false, (Object[])new String[]{key, nodeAryStr});
                ReportUtil.sureprintln(errMsg);
                completeErrMsg.append(LSEP + errMsg);
                this.m_resultSet.addResult((Vector)version.get(key), 4);
            }
            this.m_resultSet.addErrorDescription(new ErrorDescription(completeErrMsg.toString()));
            for (String node : this.m_nodeList) {
                this.m_resultSet.getResult(node).setHasResultValues(false);
            }
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0324", false, (Object[])new String[]{this.m_version}));
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
        this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0325", false, (Object[])new String[]{this.m_version, VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    @Override
    public String getTaskID() {
        return "CHECK_KERNEL_VERSION";
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4412", false);
    }

    @Override
    public String getDefaultDescription() {
        Object[] msgParams = new String[]{this.m_version};
        return s_msgBundle.getMessage("4463", false, msgParams);
    }

    @Override
    public ResultSet performPeer() throws VerificationException {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet knlverRsltSet = new ResultSet();
        globalExec.checkKernelVersion(this.m_nodeList, "", knlverRsltSet);
        return knlverRsltSet;
    }

    @Override
    public String getElementDisplayName() {
        return s_msgBundle.getMessage("1062", false);
    }

    @Override
    protected boolean matchesReferenceNode(Object nodeValue, Object referenceNodeValue) {
        if (nodeValue == referenceNodeValue) {
            return true;
        }
        if (nodeValue == null || referenceNodeValue == null) {
            return false;
        }
        return VerificationUtil.compareVersions(String.valueOf(nodeValue), String.valueOf(referenceNodeValue), "-") >= 0;
    }

    public void setRimValue(String rim) {
        this.m_rimVersion = rim;
    }
}

