/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskDaemonLiveliness
extends Task {
    private String m_daemonTag;
    private String m_daemonDispName;
    private String m_daemonIntlName;
    private Vector<String> m_dmnOkVec = null;

    public TaskDaemonLiveliness(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskDaemonLiveliness(String[] nodeList, Vector<String> dmnOkVec) {
        this(nodeList);
        this.m_dmnOkVec = dmnOkVec;
    }

    public TaskDaemonLiveliness(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskDaemonLiveliness(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public TaskDaemonLiveliness(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("NAME".equals(argName)) {
                this.m_daemonTag = argVal;
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (this.m_daemonTag == null) {
            Trace.out((String)"The task is not applicable because the daemon name is unavailable");
            return false;
        }
        if ("rpc.mountd".equalsIgnoreCase(this.m_daemonTag) && !VerificationUtil.isPlatformAix()) {
            Trace.out((String)"This daemon check is only applicable on AIX platform. returning false");
            return false;
        }
        return true;
    }

    public void setDaemonName(String daemonTag) {
        this.m_daemonTag = daemonTag;
    }

    public String getDaemonName() {
        return this.m_daemonTag;
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Performing Daemon Liveliness verification task... ");
        this.displayDaemonCheckStartMessage();
        ResultSet resultSet = new ResultSet();
        this.m_daemonDispName = VerificationUtil.getDaemonDisplayName(this.m_daemonTag);
        if (this.m_daemonDispName == null) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        this.m_daemonIntlName = VerificationUtil.getDaemonInternalName(this.m_daemonTag);
        if (this.m_daemonIntlName == null) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        boolean livelinessResult = new GlobalExecution().checkDaemonLiveliness(this.m_nodeList, this.m_daemonIntlName, resultSet);
        Trace.out((String)"TaskDaemonLiveliness:   checkDaemonLiveliness() performed!!");
        livelinessResult = this.displayDaemonLivelinessOutput(resultSet, true, null);
        this.m_resultSet.traceResultSet("\n====ResultSet returned by TaskDaemonLiveliness verification task====\n");
        return livelinessResult;
    }

    public void displayDaemonCheckStartMessage() {
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4028", false));
    }

    public boolean displayDaemonLivelinessOutput(ResultSet resultSet, boolean updateResultSet, TaskAnonymousProxy anonTask) {
        ErrorDescription errDesc;
        boolean isAddToAnonTask;
        Task previousTaskReference = null;
        boolean bl = isAddToAnonTask = anonTask != null && ReportUtil.isVerbose();
        if (anonTask != null) {
            previousTaskReference = ReportUtil.setTaskReference(anonTask);
        }
        ReportUtil.println(LSEP + s_msgBundle.getMessage("4029", false, (Object[])new String[]{this.m_daemonDispName}));
        if (ReportUtil.getOldFormat()) {
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8003", false));
        }
        if (isAddToAnonTask) {
            ReportUtil.reportwriteColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8003", false));
        }
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        String errMsg = null;
        ArrayList<String> failureMsg = new ArrayList<String>();
        while (e.hasMoreElements()) {
            String running;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                if (updateResultSet) {
                    if (this.m_dmnOkVec != null) {
                        this.m_dmnOkVec.add(node);
                    }
                    Trace.out((String)("Daemon '" + this.m_daemonDispName + "' is running on node: '" + node + "'"));
                    this.m_resultSet.addResult(node, 1);
                }
                running = ReportUtil.YES;
            } else if (result.getStatus() == 3) {
                errMsg = s_msgBundle.getMessage("7590", true, (Object[])new String[]{this.m_daemonDispName, node});
                failureMsg.add(errMsg);
                if (updateResultSet) {
                    Trace.out((String)("Daemon '" + this.m_daemonDispName + "' is not running on node: '" + node + "'"));
                    this.m_resultSet.addResult(node, 3);
                    errDesc = new ErrorDescription(errMsg);
                    this.m_resultSet.addErrorDescription(node, errDesc);
                }
                running = ReportUtil.NO;
            } else {
                errMsg = s_msgBundle.getMessage("7591", true, (Object[])new String[]{this.m_daemonDispName, node});
                failureMsg.add(errMsg);
                if (updateResultSet) {
                    Trace.out((String)("Daemon Liveliness result not available on node: '" + node + "'"));
                    errDesc = new ErrorDescription(errMsg);
                    this.m_resultSet.addErrorDescription(node, errDesc);
                    this.m_resultSet.addResult(node, 2);
                }
                running = ReportUtil.UNKNOWN;
            }
            if (ReportUtil.getOldFormat()) {
                ReportUtil.writeRecord(node, running);
            }
            if (!isAddToAnonTask) continue;
            ReportUtil.reportwriteRecord(node, running);
        }
        if (previousTaskReference != null) {
            ReportUtil.setTaskReference(previousTaskReference);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("4030", false, (Object[])new String[]{this.m_daemonDispName}));
            return true;
        }
        ReportUtil.reportErrors(failureMsg);
        if (updateResultSet) {
            errMsg = s_msgBundle.getMessage("4031", false, (Object[])new String[]{this.m_daemonDispName});
            errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(this.m_resultSet.getFailureNodes(), errDesc);
        }
        return false;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4432", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4483", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        return sb.toString();
    }
}

