/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.cluster.verification.VerificationException;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskDBUserConsistent
extends Task {
    private String m_dbHome = null;

    public TaskDBUserConsistent(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        this.m_dbHome = CVUVariables.getValue(CVUVariableConstants.SRC_RAC_HOME);
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return VerificationUtil.isStringGood(this.m_dbHome);
    }

    public TaskDBUserConsistent(String[] nodeList) {
        super(nodeList);
    }

    @Override
    public boolean performTask() {
        String errMsg = null;
        String currentUser = VerificationUtil.getDefaultOracleUser();
        ReportUtil.println(LSEP + s_gMsgBundle.getMessage("1182", false));
        Result nodeRslt = new Result(m_localNode);
        String DBUserNode = VerificationUtil.getOracleUser(this.m_dbHome, m_localNode, nodeRslt);
        if (nodeRslt.getStatus() == 1 && DBUserNode != null && DBUserNode.trim().length() > 0) {
            DBUserNode = DBUserNode.trim();
            nodeRslt.setHasResultValues(true);
            nodeRslt.setActualValue(currentUser);
            nodeRslt.setExpectedValue(DBUserNode);
            if (DBUserNode.equals(currentUser)) {
                ReportUtil.printResult(s_gMsgBundle.getMessage("1183", false));
                this.m_resultSet.addResult(m_localNode, nodeRslt);
                return true;
            }
            ReportUtil.printResult(s_gMsgBundle.getMessage("1184", true, (Object[])new String[]{this.m_dbHome}));
            errMsg = s_gMsgBundle.getMessage("1185", true, (Object[])new String[]{DBUserNode, currentUser});
            ReportUtil.printError(errMsg);
            nodeRslt.addErrorDescription(new ErrorDescription(errMsg));
            nodeRslt.setStatus(3);
            this.m_resultSet.addResult(m_localNode, nodeRslt);
            return false;
        }
        ReportUtil.printResult(s_gMsgBundle.getMessage("1184", true, (Object[])new String[]{this.m_dbHome}));
        errMsg = s_gMsgBundle.getMessage("1186", true, (Object[])new String[]{this.m_dbHome});
        ReportUtil.printError(errMsg);
        nodeRslt.addErrorDescription(new ErrorDescription(errMsg));
        this.m_resultSet.addResult(m_localNode, nodeRslt);
        return false;
    }

    public void setDBHome(String dbHome) {
        this.m_dbHome = dbHome;
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("1181", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("1180", false);
    }
}

