/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskCoreFileNameConsistency;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCoreFileNameConsistency
extends Task {
    public TaskCoreFileNameConsistency(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        VerificationType vType = this.m_globalContext.getVerificationType();
        if (vType != null) {
            switch (vType) {
                case PREREQ_CRS_INST: 
                case BESTPRACTICE_PRE_CRS_INST: {
                    return true;
                }
                case POSTREQ_CRS_INST: 
                case BESTPRACTICE_POSTREQ_CRS_INST: {
                    return true;
                }
                case PREREQ_DB_INST: {
                    String reqRel = this.m_globalContext.getRequestedRelease();
                    return reqRel != null && (reqRel.equalsIgnoreCase("10gR1") || reqRel.equalsIgnoreCase("10.1") || reqRel.equalsIgnoreCase("10gR2") || reqRel.equalsIgnoreCase("10.2") || reqRel.equalsIgnoreCase("11gR1") || reqRel.equalsIgnoreCase("11.1"));
                }
            }
        } else {
            VerificationUtil.traceAndLog("Verification Type is unknown, returning false");
        }
        return false;
    }

    public TaskCoreFileNameConsistency(String[] nodeList) {
        super(nodeList, null, 1);
        this.setSeverity(SeverityType.IGNORABLE);
    }

    @Override
    public boolean performTask() {
        ErrorDescription errDesc = null;
        String errMsg = null;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        ReportUtil.println(s_msgBundle.getMessage("6400", false));
        Vector<String> failNodes = new Vector<String>();
        ResultSet rsltSet = new ResultSet();
        Hashtable node_pattern = new Hashtable();
        sTaskCoreFileNameConsistency sTask = new sTaskCoreFileNameConsistency();
        sTask.checkCoreFileNameConsitency(this.m_nodeList, rsltSet, node_pattern);
        this.m_resultSet.addResultSetData(rsltSet);
        Hashtable rsltTab = rsltSet.getResultTable();
        Enumeration e = rsltTab.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)rsltTab.get(node);
            if (result.getStatus() != 2) continue;
            Trace.out((String)("FAILED:: result.getStatus()=" + result.getStatus() + "on Node " + node));
            failNodes.add(node);
        }
        if (node_pattern.size() > 1) {
            errMsg = s_msgBundle.getMessage("6402", true);
            ReportUtil.printError(errMsg);
            e = node_pattern.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String nodeArrStr = VerificationUtil.strVect2List((Vector)node_pattern.get(key));
                ReportUtil.sureprintln(s_msgBundle.getMessage("6401", false, (Object[])new String[]{key, nodeArrStr}));
                errMsg = errMsg + LSEP + s_msgBundle.getMessage("6401", false, (Object[])new String[]{key, nodeArrStr});
                this.m_resultSet.addResult((Vector)node_pattern.get(key), 3);
            }
            errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
        }
        if (failNodes.size() > 0) {
            errMsg = s_msgBundle.getMessage("6407", false, (Object[])new String[]{VerificationUtil.strVect2List(failNodes)});
            errDesc = new ErrorDescription(errMsg);
            ReportUtil.sureprintln(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("6403", false));
            return true;
        }
        ReportUtil.sureprintln(s_msgBundle.getMessage("6404", false));
        return false;
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("6405", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("6406", false);
    }
}

